/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.transport;

import com.tucows.oxrs.epp0402.rtk.transport.EPPTransportBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_Result;

public class EPPTransportTCP
extends EPPTransportBase {
    protected Socket socket_to_server_;
    protected BufferedReader reader_from_server_;
    protected PrintWriter writer_to_server_;
    protected boolean preset_ = false;

    public EPPTransportTCP() {
    }

    public EPPTransportTCP(Socket socket, int timeout) {
        this.socket_to_server_ = socket;
        this.epp_timeout_ = timeout > 0 ? timeout : 20000;
        this.preset_ = true;
    }

    public EPPTransportTCP(String host_name, int host_port, int timeout) {
        super(host_name, host_port, timeout > 0 ? timeout : 20000);
    }

    @Override
    public void connect() throws SocketException, IOException, UnknownHostException {
        String method_name = "connect()";
        this.debug(3, method_name, "Entered");
        if (!this.preset_) {
            this.socket_to_server_ = null;
            this.socket_to_server_ = new Socket(this.epp_host_name_, this.epp_host_port_);
        }
        this.socket_to_server_.setSoTimeout(this.epp_timeout_);
        this.reader_from_server_ = new BufferedReader(new InputStreamReader(this.socket_to_server_.getInputStream()));
        this.writer_to_server_ = new PrintWriter((Writer)new OutputStreamWriter(this.socket_to_server_.getOutputStream()), true);
        this.debug(2, method_name, "Connected to [" + this.socket_to_server_.getInetAddress() + ":" + this.socket_to_server_.getPort() + "]");
        this.debug(3, method_name, "Leaving");
    }

    @Override
    public String readFromServer() throws epp_Exception {
        StringBuffer buf;
        String method_name = "readFromServer()";
        this.debug(3, method_name, "Entered");
        try {
            String line;
            buf = new StringBuffer();
            while ((line = this.reader_from_server_.readLine()) != null) {
                buf.append(line);
                if (!line.trim().endsWith("</epp>")) continue;
            }
            if (line == null) {
                this.debug(2, method_name, "Connection closed by server.");
                this.disconnect();
                epp_Result[] result = new epp_Result[]{new epp_Result()};
                result[0].m_code = (short)2601;
                result[0].m_msg = "Unexpected server disconnect";
                throw new epp_Exception(result);
            }
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to read from server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            throw new epp_Exception(result);
        }
        this.debug(3, method_name, "Leaving");
        return buf.toString();
    }

    @Override
    public void writeToServer(String xml_to_server) throws epp_Exception {
        String method_name = "writeToServer(String)";
        this.debug(3, method_name, "Entered");
        try {
            String line;
            BufferedReader reader_outbound_xml = new BufferedReader(new StringReader(xml_to_server));
            StringBuffer buf = new StringBuffer();
            while ((line = reader_outbound_xml.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                if (!line.startsWith("<")) {
                    buf.append(' ');
                }
                buf.append(line);
                if (line.endsWith("?>")) {
                    buf.append("\r\n");
                }
                if (!line.trim().endsWith("</epp>")) continue;
            }
            String final_xml = buf.toString();
            this.writer_to_server_.print(final_xml);
            this.writer_to_server_.print("\r\n");
            this.writer_to_server_.flush();
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to write to server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            throw new epp_Exception(result);
        }
        this.debug(3, method_name, "Leaving");
    }

    @Override
    public void disconnect() throws IOException {
        String method_name = "disconnect()";
        this.debug(3, method_name, "Entered");
        try {
            if (this.socket_to_server_ != null) {
                this.socket_to_server_.close();
            }
            this.socket_to_server_ = null;
            if (this.reader_from_server_ != null) {
                this.reader_from_server_.close();
            }
            this.reader_from_server_ = null;
            if (this.writer_to_server_ != null) {
                this.writer_to_server_.close();
            }
            this.writer_to_server_ = null;
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
    }
}

