/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk.example;

import com.tucows.oxrs.epp0402.rtk.EPPClient;
import com.tucows.oxrs.epp0402.rtk.RTKBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import org.openrtk.idl.epp0402.epp_Command;
import org.openrtk.idl.epp0402.epp_Exception;
import org.openrtk.idl.epp0402.epp_Greeting;
import org.openrtk.idl.epp0402.epp_PollRsp;
import org.openrtk.idl.epp0402.epp_Response;
import org.openrtk.idl.epp0402.epp_Result;
import org.openrtk.idl.epp0402.epp_XMLException;

public class PollExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp0402.rtk.example.PollExample epp_host_name epp_host_port epp_client_id epp_password";

    public static void main(String[] args) {
        Date current_time = new Date();
        System.out.println("Start of the Poll example");
        try {
            epp_Command command_data = null;
            if (args.length < 5) {
                System.err.println(USAGE);
                System.exit(1);
            }
            RTKBase.setDebugLevel();
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.getServerId() + "]");
            System.out.println("greeting's server-date: [" + greeting.getServerDate() + "]");
            if (greeting.getVersions() != null && greeting.getVersions().length > 0) {
                System.out.println("greeting's version: [" + greeting.getVersions()[0] + "]");
            }
            if (greeting.getLangs() != null && greeting.getLangs().length > 0) {
                System.out.println("greeting's lang: [" + greeting.getLangs()[0] + "]");
            }
            String client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
            command_data = new epp_Command();
            command_data.setClientTrid(client_trid);
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            boolean keep_polling = true;
            while (keep_polling) {
                String message_id = "";
                int response_code = 1000;
                System.out.println("Polling the server...");
                current_time = new Date();
                client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                epp_PollRsp poll_response = epp_client.poll(client_trid);
                epp_Response response = poll_response.getRsp();
                System.out.println("Poll results: " + response);
                System.out.println("Poll ResData type: " + poll_response.getResData().getType());
                System.out.println("Poll ResData: " + poll_response.getResData());
                message_id = response.getResults()[0].getId();
                response_code = response.getResults()[0].getCode();
                if (response_code != 1300) {
                    BufferedReader buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.print("Do you wish to acknowledge this poll message [y]? ");
                    String answer = buffed_reader.readLine();
                    while (answer != null && answer.length() != 0 && !answer.equalsIgnoreCase("y") && !answer.equalsIgnoreCase("n")) {
                        answer = buffed_reader.readLine();
                    }
                    if (!answer.equalsIgnoreCase("n")) {
                        System.out.println("Going to acknowledge poll message id [" + message_id + "]");
                        System.out.println("Polling the server...");
                        current_time = new Date();
                        client_trid = "ABC:" + epp_client_id + ":" + current_time.getTime();
                        poll_response = epp_client.poll(client_trid, message_id);
                        response = poll_response.getRsp();
                        System.out.println("Poll results: " + response);
                        System.out.println("Poll ResData: " + poll_response.getResData());
                        continue;
                    }
                    System.out.println("Going to reject the transfer");
                    keep_polling = false;
                    continue;
                }
                keep_polling = false;
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(client_trid);
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.getErrorMessage() + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.getDetails();
            System.err.println("\tresult: [" + results[0] + "]");
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }
}

