/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp0402.rtk;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.omg.CORBA.portable.ObjectImpl;

public abstract class RTKBase
extends ObjectImpl {
    public static final String RTK_VERSION = "0.7.5-0402";
    protected static final String CRLF = "\r\n";
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_LEVEL_ONE = 1;
    public static final int DEBUG_LEVEL_TWO = 2;
    public static final int DEBUG_LEVEL_THREE = 3;
    private static int debug_level_ = 0;
    private static PrintStream debug_print_stream_ = System.err;
    private static Properties rtk_properties_ = null;
    private static Logger logger_ = null;
    public static final DateFormat UTC_FMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.0'Z'");
    public static final DateFormat DATE_FMT = new SimpleDateFormat("yyyy-MM-dd");

    public static void setDebugLevel(int value) {
        debug_level_ = value;
    }

    public static void setDebugLevel() {
        int rtk_debuglevel = 1;
        try {
            String rtk_debuglevel_str = RTKBase.getRTKProperties().getProperty("rtk.debug.level");
            rtk_debuglevel = Integer.parseInt(rtk_debuglevel_str);
        }
        catch (Exception xcp) {
            System.err.println("couldn't parse the rtk.debug.level property ... maybe it wasn't a number");
        }
        RTKBase.setDebugLevel(rtk_debuglevel);
    }

    public static int getDebugLevel() {
        return debug_level_;
    }

    public static void setDebugPrintStream(PrintStream stream) {
        if (stream != null) {
            debug_print_stream_ = stream;
        }
    }

    public static PrintStream getDebugPrintStream() {
        return debug_print_stream_;
    }

    public void debug(int level, String method_name, String message) {
        if (debug_level_ >= level) {
            String advancedLogging;
            try {
                advancedLogging = RTKBase.getRTKProperties().getProperty("rtk.debug.advancedLogging");
            }
            catch (Exception prop_xcp) {
                advancedLogging = "false";
            }
            if (advancedLogging.equalsIgnoreCase("false") || RTKBase.getLogger() == null) {
                debug_print_stream_.println(((Object)((Object)this)).getClass().getName() + "." + method_name + " {" + new Date() + "}[" + level + "] : " + message);
            } else {
                RTKBase.getLogger().debug((Object)(((Object)((Object)this)).getClass().getName() + "." + method_name + " {" + new Date() + "}[" + level + "] : " + message));
            }
        }
    }

    public void debug(int level, String method_name, Exception xcp) {
        if (debug_level_ >= level) {
            String advancedLogging;
            try {
                advancedLogging = RTKBase.getRTKProperties().getProperty("rtk.debug.advancedLogging");
            }
            catch (Exception prop_xcp) {
                advancedLogging = "false";
            }
            if (advancedLogging.equalsIgnoreCase("false") || RTKBase.getLogger() == null) {
                debug_print_stream_.println(((Object)((Object)this)).getClass().getName() + "." + method_name + " {" + new Date() + "}[" + level + "] : [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace(debug_print_stream_);
            } else {
                RTKBase.getLogger().error((Object)(((Object)((Object)this)).getClass().getName() + "." + method_name + " {" + new Date() + "}[" + level + "] : [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]"));
                RTKBase.getLogger().error((Object)xcp);
            }
        }
    }

    public String[] _ids() {
        return null;
    }

    public static Properties getRTKProperties() throws FileNotFoundException, IOException {
        if (rtk_properties_ == null) {
            Properties system_props = System.getProperties();
            String rtk_props_file = system_props.getProperty("rtk.props.file");
            rtk_properties_ = new Properties();
            if (rtk_props_file != null && rtk_props_file.length() != 0) {
                rtk_properties_.load(new FileInputStream(rtk_props_file));
            }
        }
        return rtk_properties_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized Logger getLogger() {
        if (logger_ != null) return logger_;
        String string = RTK_VERSION;
        synchronized (RTK_VERSION) {
            try {
                PropertyConfigurator.configure((Properties)RTKBase.getRTKProperties());
                logger_ = Logger.getLogger((String)"epprtk");
            }
            catch (Exception xcp) {
                System.err.println("LOGGER: disabled using stderr");
            }
            return logger_;
        }
    }
}

