/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.xml;

import com.tucows.oxrs.epp02.rtk.xml.EPPXMLBase;
import java.util.Hashtable;
import org.openrtk.idl.epp02.host.epp_HostAddressType;
import org.openrtk.idl.epp02.host.epp_HostStatusType;
import org.w3c.dom.Element;

public abstract class EPPHostBase
extends EPPXMLBase {
    protected static Hashtable host_status_hash_;
    protected static String[] status_to_string_array_;
    protected static Hashtable host_ip_to_type_hash_;
    protected static String[] host_ip_to_string_array_;

    protected EPPHostBase() {
        EPPHostBase.initHashes();
    }

    protected EPPHostBase(String xml) {
        super(xml);
        EPPHostBase.initHashes();
    }

    public static void initHashes() {
        EPPHostBase.initHostIpToTypeHash();
        EPPHostBase.initHostStatusHash();
    }

    protected static void initHostIpToTypeHash() {
        if (host_ip_to_type_hash_ == null) {
            host_ip_to_type_hash_ = new Hashtable();
            host_ip_to_type_hash_.put("v4", epp_HostAddressType.IPV4);
            host_ip_to_type_hash_.put("v6", epp_HostAddressType.IPV6);
        }
    }

    protected static void initHostStatusHash() {
        if (host_status_hash_ == null) {
            host_status_hash_ = new Hashtable();
            host_status_hash_.put("lock", epp_HostStatusType.LOCK);
            host_status_hash_.put("ok", epp_HostStatusType.OK);
            host_status_hash_.put("pendingDelete", epp_HostStatusType.PENDING_DELETE);
            host_status_hash_.put("clientLock", epp_HostStatusType.CLIENT_LOCK);
        }
    }

    protected void setCommonAttributes(Element command) {
        command.setAttribute("xmlns:host", "urn:iana:xml:ns:host");
        command.setAttribute("xsi:schemaLocation", "urn:iana:xml:ns:host host.xsd");
    }

    public static String hostStatusToString(epp_HostStatusType status_type) {
        return status_to_string_array_[status_type.value()];
    }

    public static String hostAddressTypeToString(epp_HostAddressType address_type) {
        return host_ip_to_string_array_[address_type.value()];
    }

    public static epp_HostStatusType hostStatusFromString(String s) {
        EPPHostBase.initHostStatusHash();
        return (epp_HostStatusType)host_status_hash_.get(s);
    }

    static {
        status_to_string_array_ = new String[]{"lock", "ok", "pendingDelete", "clientLock"};
        host_ip_to_string_array_ = new String[]{"v4", "v6"};
    }
}

