/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.xml;

import com.tucows.oxrs.epp02.rtk.xml.EPPXMLBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_Greeting;
import org.openrtk.idl.epp02.epp_Hello;
import org.openrtk.idl.epp02.epp_Service;
import org.openrtk.idl.epp02.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPGreeting
extends EPPXMLBase
implements epp_Hello {
    private epp_Greeting greeting_;

    public EPPGreeting() {
    }

    public EPPGreeting(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPGreeting(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public epp_Greeting getResponseData() {
        return this.greeting_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element hello = doc.createElement("hello");
        root.appendChild(hello);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            this.greeting_ = new epp_Greeting();
            Element epp_node = this.getDocumentElement();
            NodeList greeting_nodes = epp_node.getElementsByTagName("greeting").item(0).getChildNodes();
            if (greeting_nodes == null || greeting_nodes.getLength() == 0) {
                throw new epp_XMLException("unparsable or missing greeting");
            }
            Node service_menu = null;
            for (int count = 0; count < greeting_nodes.getLength(); ++count) {
                Node a_node = greeting_nodes.item(count);
                if (a_node.getNodeName().equals("svID")) {
                    this.greeting_.m_server_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("svDate")) {
                    this.greeting_.m_server_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("svcMenu")) continue;
                service_menu = a_node;
            }
            if (service_menu != null) {
                NodeList inner_nodes = service_menu.getChildNodes();
                ArrayList<epp_Service> service_list = new ArrayList<epp_Service>();
                ArrayList<String> version_list = new ArrayList<String>();
                ArrayList<String> lang_list = new ArrayList<String>();
                for (int count = 0; count < inner_nodes.getLength(); ++count) {
                    Node a_node = inner_nodes.item(count);
                    if (a_node.getNodeName().equals("version")) {
                        version_list.add(a_node.getFirstChild().getNodeValue());
                    }
                    if (a_node.getNodeName().equals("lang")) {
                        lang_list.add(a_node.getFirstChild().getNodeValue());
                    }
                    if (!a_node.getNodeName().endsWith(":svc")) continue;
                    epp_Service service = new epp_Service();
                    String name = a_node.getNodeName();
                    int index_of_colon = name.indexOf(58);
                    service.m_name = name.substring(0, index_of_colon);
                    service.m_xmlns = ((Element)a_node).getAttribute("xmlns:" + service.m_name);
                    service.m_schema_location = ((Element)a_node).getAttribute("xsi:schemaLocation");
                    service_list.add(service);
                }
                this.greeting_.m_versions = EPPGreeting.convertListToStringArray(version_list);
                this.greeting_.m_langs = EPPGreeting.convertListToStringArray(lang_list);
                this.greeting_.m_services = (epp_Service[])EPPGreeting.convertListToArray(new epp_Service().getClass(), service_list);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

