/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.xml;

import com.tucows.oxrs.epp02.rtk.xml.EPPDomainBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp02.domain.epp_DomainContact;
import org.openrtk.idl.epp02.domain.epp_DomainContactType;
import org.openrtk.idl.epp02.domain.epp_DomainInfo;
import org.openrtk.idl.epp02.domain.epp_DomainInfoReq;
import org.openrtk.idl.epp02.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epp02.domain.epp_DomainStatus;
import org.openrtk.idl.epp02.domain.epp_DomainStatusType;
import org.openrtk.idl.epp02.epp_AuthInfo;
import org.openrtk.idl.epp02.epp_AuthInfoType;
import org.openrtk.idl.epp02.epp_Command;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPDomainInfo
extends EPPDomainBase
implements epp_DomainInfo {
    private epp_DomainInfoReq action_request_;
    private epp_DomainInfoRsp action_response_;

    public EPPDomainInfo() {
    }

    public EPPDomainInfo(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPDomainInfo(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_DomainInfoReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_DomainInfoRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "buildRequestXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_name == null) {
            throw new epp_XMLException("missing request data or domain name");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        Element info = doc.createElement("info");
        epp_Command command_data = this.action_request_.m_cmd;
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element domain_info = doc.createElement("domain:info");
        this.setCommonAttributes(domain_info);
        this.addXMLElement((Document)doc, domain_info, "domain:name", this.action_request_.m_name);
        info.appendChild(domain_info);
        command.appendChild(info);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_DomainInfoRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList domain_info_result_list = response_data_element.getElementsByTagName("domain:infData").item(0).getChildNodes();
            this.debug(2, method_name, "domain:infData's node count [" + domain_info_result_list.getLength() + "]");
            if (domain_info_result_list.getLength() == 0) {
                throw new epp_XMLException("missing info results");
            }
            ArrayList<epp_DomainStatus> statuses = new ArrayList<epp_DomainStatus>();
            ArrayList<epp_DomainContact> contacts = new ArrayList<epp_DomainContact>();
            ArrayList<String> name_servers = new ArrayList<String>();
            ArrayList<String> hosts = new ArrayList<String>();
            for (int count = 0; count < domain_info_result_list.getLength(); ++count) {
                Node a_node = domain_info_result_list.item(count);
                if (a_node.getNodeName().equals("domain:name")) {
                    this.action_response_.m_name = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:registrant")) {
                    this.action_response_.m_registrant = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:contact")) {
                    epp_DomainContact domain_contact = new epp_DomainContact();
                    domain_contact.m_roid = a_node.getFirstChild().getNodeValue();
                    domain_contact.m_type = (epp_DomainContactType)contact_type_hash_.get(((Element)a_node).getAttribute("type"));
                    contacts.add(domain_contact);
                }
                if (a_node.getNodeName().equals("domain:status")) {
                    String lang;
                    epp_DomainStatus status = new epp_DomainStatus();
                    Node status_value_node = a_node.getFirstChild();
                    if (status_value_node != null) {
                        status.m_value = status_value_node.getNodeValue();
                    }
                    if ((lang = ((Element)a_node).getAttribute("lang")) != null && lang.length() > 0) {
                        status.m_lang = lang;
                    }
                    if (!domain_status_hash_.containsKey(((Element)a_node).getAttribute("s"))) {
                        status.m_value = "invalid domain status from server";
                        status.m_lang = "en-US";
                        status.m_type = null;
                    } else {
                        status.m_type = (epp_DomainStatusType)domain_status_hash_.get(((Element)a_node).getAttribute("s"));
                    }
                    statuses.add(status);
                }
                if (a_node.getNodeName().equals("domain:ns")) {
                    name_servers.add(a_node.getFirstChild().getNodeValue());
                }
                if (a_node.getNodeName().equals("domain:host")) {
                    hosts.add(a_node.getFirstChild().getNodeValue());
                }
                if (a_node.getNodeName().equals("domain:clID")) {
                    this.action_response_.m_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:crID")) {
                    this.action_response_.m_created_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:crDate")) {
                    this.action_response_.m_created_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:upID")) {
                    this.action_response_.m_updated_by = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:upDate")) {
                    this.action_response_.m_updated_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:trDate")) {
                    this.action_response_.m_transfer_date = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("domain:exDate")) {
                    this.action_response_.m_expiration_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("domain:authInfo")) continue;
                this.action_response_.m_auth_info = new epp_AuthInfo();
                this.action_response_.m_auth_info.m_value = a_node.getFirstChild().getNodeValue();
                this.action_response_.m_auth_info.m_type = (epp_AuthInfoType)auth_type_string_to_type_hash_.get(((Element)a_node).getAttribute("type"));
                this.action_response_.m_auth_info.m_roid = ((Element)a_node).getAttribute("roid");
            }
            if (name_servers.size() > 0) {
                this.action_response_.m_name_servers = EPPDomainInfo.convertListToStringArray(name_servers);
            }
            if (hosts.size() > 0) {
                this.action_response_.m_hosts = EPPDomainInfo.convertListToStringArray(hosts);
            }
            if (contacts.size() > 0) {
                this.action_response_.m_contacts = (epp_DomainContact[])EPPDomainInfo.convertListToArray(new epp_DomainContact().getClass(), contacts);
            }
            if (statuses.size() > 0) {
                this.action_response_.m_status = (epp_DomainStatus[])EPPDomainInfo.convertListToArray(new epp_DomainStatus().getClass(), statuses);
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

