/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.xml;

import com.tucows.oxrs.epp02.rtk.xml.EPPXMLBase;
import java.util.Hashtable;
import org.openrtk.idl.epp02.domain.epp_DomainContactType;
import org.openrtk.idl.epp02.domain.epp_DomainStatusType;
import org.w3c.dom.Element;

public abstract class EPPDomainBase
extends EPPXMLBase {
    protected static Hashtable domain_status_hash_;
    protected static String[] status_to_string_array_;
    protected static Hashtable contact_type_hash_;
    protected static String[] contact_type_to_string_array_;
    public static String[] period_unit_to_string_array_;

    public EPPDomainBase() {
        EPPDomainBase.initHashes();
    }

    public EPPDomainBase(String xml) {
        super(xml);
        EPPDomainBase.initHashes();
    }

    public static void initHashes() {
        EPPDomainBase.initDomainStatusHash();
        EPPDomainBase.initContactTypeHash();
    }

    protected static void initDomainStatusHash() {
        if (domain_status_hash_ == null) {
            domain_status_hash_ = new Hashtable();
            domain_status_hash_.put("hold", epp_DomainStatusType.HOLD);
            domain_status_hash_.put("inactive", epp_DomainStatusType.INACTIVE);
            domain_status_hash_.put("lock", epp_DomainStatusType.LOCK);
            domain_status_hash_.put("new", epp_DomainStatusType.NEW);
            domain_status_hash_.put("ok", epp_DomainStatusType.OK);
            domain_status_hash_.put("pendingDelete", epp_DomainStatusType.PENDING_DELETE);
            domain_status_hash_.put("pendingTransfer", epp_DomainStatusType.PENDING_TRANSFER);
            domain_status_hash_.put("pendingVerification", epp_DomainStatusType.PENDING_VERIFICATION);
            domain_status_hash_.put("clientHold", epp_DomainStatusType.CLIENT_HOLD);
            domain_status_hash_.put("clientLock", epp_DomainStatusType.CLIENT_LOCK);
            domain_status_hash_.put("clientTransferProhibited", epp_DomainStatusType.CLIENT_TRANSFER_PROHIBITED);
            domain_status_hash_.put("active", epp_DomainStatusType.ACTIVE);
        }
    }

    protected static void initContactTypeHash() {
        if (contact_type_hash_ == null) {
            contact_type_hash_ = new Hashtable();
            contact_type_hash_.put("admin", epp_DomainContactType.ADMIN);
            contact_type_hash_.put("billing", epp_DomainContactType.BILLING);
            contact_type_hash_.put("tech", epp_DomainContactType.TECH);
        }
    }

    protected void setCommonAttributes(Element command) {
        command.setAttribute("xmlns:domain", "urn:iana:xml:ns:domain");
        command.setAttribute("xsi:schemaLocation", "urn:iana:xml:ns:domain domain.xsd");
    }

    public static String domainStatusToString(epp_DomainStatusType status_type) {
        return status_to_string_array_[status_type.value()];
    }

    public static String domainContactTypeToString(epp_DomainContactType contact_type) {
        return contact_type_to_string_array_[contact_type.value()];
    }

    public static epp_DomainStatusType domainStatusFromString(String s) {
        EPPDomainBase.initDomainStatusHash();
        return (epp_DomainStatusType)domain_status_hash_.get(s);
    }

    static {
        status_to_string_array_ = new String[]{"hold", "inactive", "lock", "new", "ok", "pendingDelete", "pendingTransfer", "pendingVerification", "clientHold", "clientLock", "clientTransferProhibited", "active"};
        contact_type_to_string_array_ = new String[]{"admin", "billing", "tech"};
        period_unit_to_string_array_ = new String[]{"y", "m"};
    }
}

