/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.xml;

import com.tucows.oxrs.epp02.rtk.xml.EPPContactBase;
import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.openrtk.idl.epp02.contact.epp_ContactTransfer;
import org.openrtk.idl.epp02.contact.epp_ContactTransferReq;
import org.openrtk.idl.epp02.contact.epp_ContactTransferRsp;
import org.openrtk.idl.epp02.epp_Command;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_TransferOpType;
import org.openrtk.idl.epp02.epp_TransferRequest;
import org.openrtk.idl.epp02.epp_TransferStatusType;
import org.openrtk.idl.epp02.epp_XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPPContactTransfer
extends EPPContactBase
implements epp_ContactTransfer {
    private epp_ContactTransferReq action_request_;
    private epp_ContactTransferRsp action_response_;

    public EPPContactTransfer() {
    }

    public EPPContactTransfer(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "EPPContactTransfer(String)";
        this.debug(2, method_name, "xml is [" + xml + "]");
        this.fromXML(xml);
    }

    @Override
    public void setRequestData(epp_ContactTransferReq value) {
        this.action_request_ = value;
    }

    @Override
    public epp_ContactTransferRsp getResponseData() {
        return this.action_response_;
    }

    @Override
    public String toXML() throws epp_XMLException {
        String request_xml;
        String method_name = "toXML()";
        this.debug(3, method_name, "Entered");
        if (this.action_request_ == null || this.action_request_.m_cmd == null || this.action_request_.m_trans == null || this.action_request_.m_roid == null) {
            throw new epp_XMLException("missing request data or contact roid");
        }
        epp_Command command_data = this.action_request_.m_cmd;
        epp_TransferRequest transfer_request_data = this.action_request_.m_trans;
        if (transfer_request_data.m_op == null) {
            this.debug(2, method_name, "transfer op is null, so assuming query");
            transfer_request_data.m_op = epp_TransferOpType.QUERY;
        } else if (transfer_request_data.m_op.value() >= transfer_op_to_string_array_.length) {
            throw new epp_XMLException("invalid transfer op value");
        }
        DocumentImpl doc = new DocumentImpl();
        Element root = this.createDocRoot((Document)doc);
        Element command = doc.createElement("command");
        if (command_data.m_creds != null) {
            command.appendChild(this.prepareCreds((Document)doc, command_data.m_creds));
        }
        Element transfer = doc.createElement("transfer");
        transfer.setAttribute("op", transfer_op_to_string_array_[transfer_request_data.m_op.value()]);
        Element contact_transfer = doc.createElement("contact:transfer");
        this.setCommonAttributes(contact_transfer);
        this.addXMLElement((Document)doc, contact_transfer, "contact:roid", this.action_request_.m_roid);
        transfer.appendChild(contact_transfer);
        if (transfer_request_data.m_auth_info == null) {
            throw new epp_XMLException("missing request auth id");
        }
        contact_transfer.appendChild(this.prepareAuthInfo((Document)doc, "contact:authInfo", transfer_request_data.m_auth_info));
        command.appendChild(transfer);
        command.appendChild(this.prepareUnspecElement((Document)doc, command_data.m_unspec));
        if (command_data.m_client_trid != null) {
            this.addXMLElement((Document)doc, command, "clTRID", command_data.m_client_trid);
        }
        root.appendChild(command);
        doc.appendChild(root);
        try {
            request_xml = this.createXMLFromDoc((Document)doc);
        }
        catch (IOException xcp) {
            throw new epp_XMLException("IOException in building XML [" + xcp.getMessage() + "]");
        }
        this.debug(3, method_name, "Leaving");
        return request_xml;
    }

    @Override
    public void fromXML(String xml) throws epp_XMLException, epp_Exception {
        String method_name = "fromXML()";
        this.debug(3, method_name, "Entered");
        this.xml_ = xml;
        try {
            Element epp_node = this.getDocumentElement();
            Node response_node = epp_node.getElementsByTagName("response").item(0);
            if (response_node == null) {
                throw new epp_XMLException("unparsable or missing response");
            }
            this.action_response_ = new epp_ContactTransferRsp();
            this.action_response_.m_rsp = this.parseGenericResult(response_node);
            if (this.action_response_.m_rsp.m_results[0].m_code >= 2000) {
                throw new epp_Exception(this.action_response_.m_rsp.m_results);
            }
            Element response_data_element = this.getElement(response_node.getChildNodes(), "resData");
            NodeList contact_transfer_data_list = response_data_element.getElementsByTagName("contact:trnData").item(0).getChildNodes();
            this.debug(2, method_name, "contact:trnData's node count [" + contact_transfer_data_list.getLength() + "]");
            if (contact_transfer_data_list.getLength() == 0) {
                throw new epp_XMLException("missing contact transfer data");
            }
            for (int count = 0; count < contact_transfer_data_list.getLength(); ++count) {
                Node a_node = contact_transfer_data_list.item(count);
                if (a_node.getNodeName().equals("contact:roid")) {
                    this.action_response_.m_roid = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:reID")) {
                    this.action_response_.m_request_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:acID")) {
                    this.action_response_.m_action_client_id = a_node.getFirstChild().getNodeValue();
                }
                if (a_node.getNodeName().equals("contact:trStatus")) {
                    String status_value = a_node.getFirstChild().getNodeValue();
                    if (!transfer_status_to_type_hash_.containsKey(status_value)) {
                        throw new epp_XMLException("unknown returned transfer status [" + status_value + "]");
                    }
                    this.action_response_.m_transfer_status = (epp_TransferStatusType)transfer_status_to_type_hash_.get(status_value);
                }
                if (a_node.getNodeName().equals("contact:reDate")) {
                    this.action_response_.m_request_date = a_node.getFirstChild().getNodeValue();
                }
                if (!a_node.getNodeName().equals("contact:acDate")) continue;
                this.action_response_.m_action_date = a_node.getFirstChild().getNodeValue();
            }
        }
        catch (SAXException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            throw new epp_XMLException("unable to parse xml [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
        }
    }
}

