/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.example;

import com.tucows.oxrs.epp02.rtk.EPPClient;
import com.tucows.oxrs.epp02.rtk.RTKBase;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp02.rtk.xml.EPPHostCheck;
import com.tucows.oxrs.epp02.rtk.xml.EPPHostCreate;
import com.tucows.oxrs.epp02.rtk.xml.EPPHostDelete;
import com.tucows.oxrs.epp02.rtk.xml.EPPHostInfo;
import com.tucows.oxrs.epp02.rtk.xml.EPPHostUpdate;
import com.tucows.oxrs.epp02.rtk.xml.EPPXMLBase;
import java.util.ArrayList;
import org.openrtk.idl.epp02.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp02.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp02.epp_CheckResult;
import org.openrtk.idl.epp02.epp_Command;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_Greeting;
import org.openrtk.idl.epp02.epp_Response;
import org.openrtk.idl.epp02.epp_Result;
import org.openrtk.idl.epp02.epp_XMLException;
import org.openrtk.idl.epp02.host.epp_HostAddress;
import org.openrtk.idl.epp02.host.epp_HostAddressType;
import org.openrtk.idl.epp02.host.epp_HostCheckReq;
import org.openrtk.idl.epp02.host.epp_HostCheckRsp;
import org.openrtk.idl.epp02.host.epp_HostCreateReq;
import org.openrtk.idl.epp02.host.epp_HostCreateRsp;
import org.openrtk.idl.epp02.host.epp_HostDeleteReq;
import org.openrtk.idl.epp02.host.epp_HostDeleteRsp;
import org.openrtk.idl.epp02.host.epp_HostInfoReq;
import org.openrtk.idl.epp02.host.epp_HostInfoRsp;
import org.openrtk.idl.epp02.host.epp_HostUpdateAddRemove;
import org.openrtk.idl.epp02.host.epp_HostUpdateChange;
import org.openrtk.idl.epp02.host.epp_HostUpdateReq;
import org.openrtk.idl.epp02.host.epp_HostUpdateRsp;

public class HostExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp02.rtk.example.HostExample epp_host_name epp_host_port epp_client_id epp_password";

    public static void main(String[] args) {
        System.out.println("Start of the Host example");
        int current_expiration_year = 2002;
        epp_Command command_data = null;
        try {
            epp_Result[] results;
            epp_Response response;
            epp_Result[] results2;
            epp_Result[] results3;
            epp_Response response2;
            if (args.length != 4) {
                System.err.println(USAGE);
                System.exit(1);
            }
            RTKBase.setDebugLevel(2);
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            epp_client.setProtocol(1);
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.m_server_id + "]");
            System.out.println("greeting's server-date: [" + greeting.m_server_date + "]");
            if (greeting.m_versions != null && greeting.m_versions.length > 0) {
                System.out.println("greeting's version: [" + greeting.m_versions[0] + "]");
            }
            if (greeting.m_langs != null && greeting.m_langs.length > 0) {
                System.out.println("greeting's lang: [" + greeting.m_langs[0] + "]");
            }
            String client_trid = "ABC:" + epp_client_id + ":123";
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Creating the Host Check command");
                epp_HostCheckReq host_check_request = new epp_HostCheckReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                host_check_request.m_cmd = command_data;
                ArrayList<String> host_list = new ArrayList<String>();
                host_list.add("ns1." + epp_client_id + ".info");
                host_list.add("ns2." + epp_client_id + ".info");
                host_list.add("dns.host.info");
                host_check_request.m_names = EPPXMLBase.convertListToStringArray(host_list);
                EPPHostCheck host_check = new EPPHostCheck();
                host_check.setRequestData(host_check_request);
                host_check = (EPPHostCheck)epp_client.processAction(host_check);
                epp_HostCheckRsp host_check_response = host_check.getResponseData();
                response2 = host_check_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("HostCheck results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                epp_CheckResult[] check_results = host_check_response.m_results;
                System.out.println("HostCheck results: host [ns1." + epp_client_id + ".info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, "ns1." + epp_client_id + ".info") + "]");
                System.out.println("HostCheck results: host [ns2." + epp_client_id + ".info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, "ns2." + epp_client_id + ".info") + "]");
                System.out.println("HostCheck results: host [dns.host.info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, "dns.host.info") + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Check failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Create command");
                epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_create_request.m_cmd = command_data;
                domain_create_request.m_name = epp_client_id + "-host-test.info";
                EPPDomainCreate domain_create = new EPPDomainCreate();
                domain_create.setRequestData(domain_create_request);
                domain_create = (EPPDomainCreate)epp_client.processAction(domain_create);
                epp_DomainCreateRsp domain_create_response = domain_create.getResponseData();
                response = domain_create_response.m_rsp;
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                if (results2[0].m_code != 2302) {
                    System.err.println("Failed to create domain required for host example");
                    System.exit(1);
                }
            }
            catch (Exception xcp) {
                System.err.println("Failed to create domain required for host example");
                System.exit(1);
            }
            try {
                System.out.println("Creating the Host Create command");
                epp_HostCreateReq host_create_request = new epp_HostCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                host_create_request.m_cmd = command_data;
                host_create_request.m_name = "ns1." + epp_client_id + "-host-test.info";
                ArrayList<epp_HostAddress> ip_list = new ArrayList<epp_HostAddress>();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, "100.103.44.151"));
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV6, "1080:0:0:0:8:800:200C:417A"));
                host_create_request.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                EPPHostCreate host_create = new EPPHostCreate();
                host_create.setRequestData(host_create_request);
                host_create = (EPPHostCreate)epp_client.processAction(host_create);
                epp_HostCreateRsp host_create_response = host_create.getResponseData();
                response2 = host_create_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("HostCreate results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("HostCreate results: host roid [" + host_create_response.m_roid + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Info command");
                epp_HostInfoReq host_info_request = new epp_HostInfoReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                host_info_request.m_cmd = command_data;
                host_info_request.m_name = "ns1." + epp_client_id + "-host-test.info";
                EPPHostInfo host_info = new EPPHostInfo();
                host_info.setRequestData(host_info_request);
                host_info = (EPPHostInfo)epp_client.processAction(host_info);
                epp_HostInfoRsp host_info_response = host_info.getResponseData();
                response = host_info_response.m_rsp;
                results = response.m_results;
                System.out.println("HostInfo results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
                System.out.println("HostInfo results: clID [" + host_info_response.m_client_id + "] crID [" + host_info_response.m_created_by + "]");
                System.out.println("HostInfo results: crDate [" + host_info_response.m_created_date + "] upDate [" + host_info_response.m_updated_date + "]");
                System.out.println("HostInfo results: number of ipaddresses [" + (host_info_response.m_addresses == null ? 0 : host_info_response.m_addresses.length) + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Info failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Update command");
                epp_HostUpdateReq host_update_request = new epp_HostUpdateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                host_update_request.m_cmd = command_data;
                host_update_request.m_name = "ns1." + epp_client_id + "-host-test.info";
                epp_HostUpdateAddRemove add = new epp_HostUpdateAddRemove();
                ArrayList<epp_HostAddress> ip_list = new ArrayList<epp_HostAddress>();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV4, "101.22.55.99"));
                add.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                host_update_request.m_add = add;
                epp_HostUpdateAddRemove remove = new epp_HostUpdateAddRemove();
                ip_list = new ArrayList();
                ip_list.add(new epp_HostAddress(epp_HostAddressType.IPV6, "1080:0:0:0:8:800:200C:417A"));
                remove.m_addresses = (epp_HostAddress[])EPPXMLBase.convertListToArray(new epp_HostAddress().getClass(), ip_list);
                host_update_request.m_remove = remove;
                host_update_request.m_change = new epp_HostUpdateChange();
                host_update_request.m_change.m_name = "ns99." + epp_client_id + "-host-test.info";
                EPPHostUpdate host_update = new EPPHostUpdate();
                host_update.setRequestData(host_update_request);
                host_update = (EPPHostUpdate)epp_client.processAction(host_update);
                epp_HostUpdateRsp host_update_response = host_update.getResponseData();
                epp_Response response3 = host_update_response.m_rsp;
                epp_Result[] results4 = response3.m_results;
                System.out.println("HostUpdate results: [" + results4[0].m_code + "] [" + results4[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Host Update failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Host Delete command");
                epp_HostDeleteReq host_delete_request = new epp_HostDeleteReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                host_delete_request.m_cmd = command_data;
                host_delete_request.m_name = "ns1." + epp_client_id + "-host-test.info";
                EPPHostDelete host_delete = new EPPHostDelete();
                host_delete.setRequestData(host_delete_request);
                host_delete = (EPPHostDelete)epp_client.processAction(host_delete);
                epp_HostDeleteRsp host_delete_response = host_delete.getResponseData();
                response = host_delete_response.m_rsp;
                results = response.m_results;
                System.out.println("HostDelete results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Host Delete failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(client_trid);
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tcode: [" + results[0].m_code + "] lang: [" + results[0].m_lang + "] msg: [" + results[0].m_msg + "]");
            if (results[0].m_values != null && results[0].m_values.length > 0) {
                System.err.println("\tvalue: [" + results[0].m_values[0] + "]");
            }
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }
}

