/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk.example;

import com.tucows.oxrs.epp02.rtk.EPPClient;
import com.tucows.oxrs.epp02.rtk.RTKBase;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainCheck;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainCreate;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainDelete;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainInfo;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainRenew;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainTransfer;
import com.tucows.oxrs.epp02.rtk.xml.EPPDomainUpdate;
import com.tucows.oxrs.epp02.rtk.xml.EPPPoll;
import com.tucows.oxrs.epp02.rtk.xml.EPPXMLBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import org.openrtk.idl.epp02.domain.epp_DomainCheckReq;
import org.openrtk.idl.epp02.domain.epp_DomainCheckRsp;
import org.openrtk.idl.epp02.domain.epp_DomainCreateReq;
import org.openrtk.idl.epp02.domain.epp_DomainCreateRsp;
import org.openrtk.idl.epp02.domain.epp_DomainDeleteReq;
import org.openrtk.idl.epp02.domain.epp_DomainDeleteRsp;
import org.openrtk.idl.epp02.domain.epp_DomainInfoReq;
import org.openrtk.idl.epp02.domain.epp_DomainInfoRsp;
import org.openrtk.idl.epp02.domain.epp_DomainPeriod;
import org.openrtk.idl.epp02.domain.epp_DomainPeriodUnitType;
import org.openrtk.idl.epp02.domain.epp_DomainRenewReq;
import org.openrtk.idl.epp02.domain.epp_DomainRenewRsp;
import org.openrtk.idl.epp02.domain.epp_DomainStatus;
import org.openrtk.idl.epp02.domain.epp_DomainStatusType;
import org.openrtk.idl.epp02.domain.epp_DomainTransferReq;
import org.openrtk.idl.epp02.domain.epp_DomainTransferRsp;
import org.openrtk.idl.epp02.domain.epp_DomainUpdateAddRemove;
import org.openrtk.idl.epp02.domain.epp_DomainUpdateChange;
import org.openrtk.idl.epp02.domain.epp_DomainUpdateReq;
import org.openrtk.idl.epp02.domain.epp_DomainUpdateRsp;
import org.openrtk.idl.epp02.epp_AuthInfo;
import org.openrtk.idl.epp02.epp_AuthInfoType;
import org.openrtk.idl.epp02.epp_CheckResult;
import org.openrtk.idl.epp02.epp_Command;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_Greeting;
import org.openrtk.idl.epp02.epp_PollOpType;
import org.openrtk.idl.epp02.epp_PollReq;
import org.openrtk.idl.epp02.epp_PollRsp;
import org.openrtk.idl.epp02.epp_Response;
import org.openrtk.idl.epp02.epp_Result;
import org.openrtk.idl.epp02.epp_TransferOpType;
import org.openrtk.idl.epp02.epp_TransferRequest;
import org.openrtk.idl.epp02.epp_XMLException;

public class DomainExample {
    private static String USAGE = "Usage: com.tucows.oxrs.epp02.rtk.example.DomainExample epp_host_name epp_host_port epp_client_id epp_password";

    public static void main(String[] args) {
        System.out.println("Start of the Domain example");
        epp_Command command_data = null;
        epp_AuthInfo domain_auth_info = null;
        Date domain_exp_date = null;
        try {
            epp_Result[] results;
            epp_Response response;
            epp_Result[] results2;
            epp_Result[] results3;
            epp_Response response2;
            if (args.length != 4) {
                System.err.println(USAGE);
                System.exit(1);
            }
            RTKBase.setDebugLevel(1);
            String epp_host_name = args[0];
            String epp_host_port_string = args[1];
            String epp_client_id = args[2];
            String epp_password = args[3];
            int epp_host_port = Integer.parseInt(epp_host_port_string);
            EPPClient epp_client = new EPPClient(epp_host_name, epp_host_port, epp_client_id, epp_password);
            epp_client.setLang("en");
            epp_client.setProtocol(1);
            System.out.println("Connecting to the EPP Server and getting the greeting");
            epp_Greeting greeting = epp_client.connectAndGetGreeting();
            System.out.println("greeting's server: [" + greeting.m_server_id + "]");
            System.out.println("greeting's server-date: [" + greeting.m_server_date + "]");
            if (greeting.m_versions != null && greeting.m_versions.length > 0) {
                System.out.println("greeting's version: [" + greeting.m_versions[0] + "]");
            }
            if (greeting.m_langs != null && greeting.m_langs.length > 0) {
                System.out.println("greeting's lang: [" + greeting.m_langs[0] + "]");
            }
            String client_trid = "ABC:" + epp_client_id + ":123";
            System.out.println("Logging into the EPP Server");
            epp_client.login(client_trid);
            try {
                System.out.println("Creating the Poll command");
                epp_PollReq poll_request = new epp_PollReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                poll_request.m_cmd = command_data;
                poll_request.m_op = epp_PollOpType.REQ;
                EPPPoll poll = new EPPPoll();
                poll.setRequestData(poll_request);
                poll = (EPPPoll)epp_client.processAction(poll);
                epp_PollRsp poll_response = poll.getResponseData();
                response2 = poll_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("Poll results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("EPP Poll failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Check command");
                epp_DomainCheckReq domain_check_request = new epp_DomainCheckReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_check_request.m_cmd = command_data;
                ArrayList<String> domain_list = new ArrayList<String>();
                domain_list.add(epp_client_id + "1.info");
                domain_list.add(epp_client_id + "2.info");
                domain_list.add("domain.info");
                domain_check_request.m_names = EPPXMLBase.convertListToStringArray(domain_list);
                EPPDomainCheck domain_check = new EPPDomainCheck();
                domain_check.setRequestData(domain_check_request);
                domain_check = (EPPDomainCheck)epp_client.processAction(domain_check);
                epp_DomainCheckRsp domain_check_response = domain_check.getResponseData();
                response = domain_check_response.m_rsp;
                results = response.m_results;
                System.out.println("DomainCheck results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
                epp_CheckResult[] check_results = domain_check_response.m_results;
                System.out.println("DomainCheck results: domain [" + epp_client_id + "1.info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, epp_client_id + "1.info") + "]");
                System.out.println("DomainCheck results: domain [" + epp_client_id + "2.info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, epp_client_id + "2.info") + "]");
                System.out.println("DomainCheck results: domain [domain.info] exists? [" + EPPXMLBase.getCheckResultFor(check_results, "domain.info") + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Check failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Create command");
                epp_DomainCreateReq domain_create_request = new epp_DomainCreateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_create_request.m_cmd = command_data;
                domain_create_request.m_name = epp_client_id + "1.info";
                domain_create_request.m_period = new epp_DomainPeriod();
                domain_create_request.m_period.m_unit = epp_DomainPeriodUnitType.YEAR;
                domain_create_request.m_period.m_value = (short)2;
                ArrayList<String> name_server_list = new ArrayList<String>();
                name_server_list.add("ns1.domain.info");
                name_server_list.add("ns2.domain.info");
                domain_create_request.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                BufferedReader buffed_reader = new BufferedReader(new InputStreamReader(System.in));
                domain_auth_info = new epp_AuthInfo();
                System.out.print("Dear registrant, please enter a passphrase for your new domain: ");
                while (domain_auth_info.m_value == null || domain_auth_info.m_value.length() == 0) {
                    domain_auth_info.m_value = buffed_reader.readLine();
                }
                domain_auth_info.m_type = epp_AuthInfoType.PW;
                domain_create_request.m_auth_info = domain_auth_info;
                EPPDomainCreate domain_create = new EPPDomainCreate();
                domain_create.setRequestData(domain_create_request);
                domain_create = (EPPDomainCreate)epp_client.processAction(domain_create);
                epp_DomainCreateRsp domain_create_response = domain_create.getResponseData();
                epp_Response response3 = domain_create_response.m_rsp;
                epp_Result[] results4 = response3.m_results;
                System.out.println("DomainCreate results: [" + results4[0].m_code + "] [" + results4[0].m_msg + "]");
                System.out.println("DomainCreate results: domain roid [" + domain_create_response.m_roid + "] exp date [" + domain_create_response.m_expiration_date + "]");
                domain_exp_date = RTKBase.UTC_FMT.parse(domain_create_response.m_expiration_date);
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Create failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Info command");
                epp_DomainInfoReq domain_info_request = new epp_DomainInfoReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_info_request.m_cmd = command_data;
                domain_info_request.m_name = epp_client_id + "1.info";
                EPPDomainInfo domain_info = new EPPDomainInfo();
                domain_info.setRequestData(domain_info_request);
                domain_info = (EPPDomainInfo)epp_client.processAction(domain_info);
                epp_DomainInfoRsp domain_info_response = domain_info.getResponseData();
                response2 = domain_info_response.m_rsp;
                results3 = response2.m_results;
                domain_auth_info = domain_info_response.m_auth_info;
                System.out.println("DomainInfo results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("DomainInfo results: clID [" + domain_info_response.m_client_id + "] crID [" + domain_info_response.m_created_by + "]");
                System.out.println("DomainInfo results: crDate [" + domain_info_response.m_created_date + "] upDate [" + domain_info_response.m_updated_date + "]");
                System.out.println("DomainInfo results: exDate [" + domain_info_response.m_expiration_date + "]");
                domain_exp_date = RTKBase.UTC_FMT.parse(domain_info_response.m_expiration_date);
                if (domain_auth_info != null) {
                    System.out.println("Domain's authID [" + domain_auth_info.m_value + "]");
                }
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Info failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Update command");
                epp_DomainUpdateReq domain_update_request = new epp_DomainUpdateReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_update_request.m_cmd = command_data;
                domain_update_request.m_name = epp_client_id + "1.info";
                epp_DomainUpdateAddRemove add = new epp_DomainUpdateAddRemove();
                ArrayList<String> name_server_list = new ArrayList<String>();
                name_server_list.add("ns3.domain.info");
                name_server_list.add("ns4.domain.info");
                add.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                add.m_status = new epp_DomainStatus[1];
                add.m_status[0] = new epp_DomainStatus();
                add.m_status[0].m_type = epp_DomainStatusType.CLIENT_TRANSFER_PROHIBITED;
                add.m_status[0].m_lang = "fr";
                add.m_status[0].m_value = "Le client n'as pas envoy\ufffd de l'argent";
                domain_update_request.m_add = add;
                epp_DomainUpdateAddRemove remove = new epp_DomainUpdateAddRemove();
                name_server_list = new ArrayList();
                name_server_list.add("ns1.domain.info");
                name_server_list.add("ns2.domain.info");
                remove.m_name_servers = EPPXMLBase.convertListToStringArray(name_server_list);
                domain_update_request.m_remove = remove;
                domain_update_request.m_change = new epp_DomainUpdateChange();
                domain_update_request.m_change.m_registrant = "C100-LRMS";
                EPPDomainUpdate domain_update = new EPPDomainUpdate();
                domain_update.setRequestData(domain_update_request);
                domain_update = (EPPDomainUpdate)epp_client.processAction(domain_update);
                epp_DomainUpdateRsp domain_update_response = domain_update.getResponseData();
                epp_Response response4 = domain_update_response.m_rsp;
                epp_Result[] results5 = response4.m_results;
                System.out.println("DomainUpdate results: [" + results5[0].m_code + "] [" + results5[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Update failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Renew command");
                epp_DomainRenewReq domain_renew_request = new epp_DomainRenewReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_renew_request.m_cmd = command_data;
                domain_renew_request.m_name = epp_client_id + "1.info";
                domain_renew_request.m_period = new epp_DomainPeriod();
                domain_renew_request.m_period.m_unit = epp_DomainPeriodUnitType.YEAR;
                domain_renew_request.m_period.m_value = (short)2;
                domain_renew_request.m_current_expiration_date = RTKBase.DATE_FMT.format(domain_exp_date);
                EPPDomainRenew domain_renew = new EPPDomainRenew();
                domain_renew.setRequestData(domain_renew_request);
                domain_renew = (EPPDomainRenew)epp_client.processAction(domain_renew);
                epp_DomainRenewRsp domain_renew_response = domain_renew.getResponseData();
                response2 = domain_renew_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("DomainRenew results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
                System.out.println("DomainRenew results: new exDate [" + domain_renew_response.m_expiration_date + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Renew failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Transfer command");
                epp_DomainTransferReq domain_transfer_request = new epp_DomainTransferReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_transfer_request.m_cmd = command_data;
                epp_TransferRequest transfer_request = new epp_TransferRequest();
                transfer_request.m_op = epp_TransferOpType.QUERY;
                transfer_request.m_auth_info = domain_auth_info;
                domain_transfer_request.m_trans = transfer_request;
                domain_transfer_request.m_name = epp_client_id + "1.info";
                EPPDomainTransfer domain_transfer = new EPPDomainTransfer();
                domain_transfer.setRequestData(domain_transfer_request);
                domain_transfer = (EPPDomainTransfer)epp_client.processAction(domain_transfer);
                epp_DomainTransferRsp domain_transfer_response = domain_transfer.getResponseData();
                response = domain_transfer_response.m_rsp;
                results = response.m_results;
                System.out.println("DomainTransfer results: [" + results[0].m_code + "] [" + results[0].m_msg + "]");
                System.out.println("DomainTransfer Results: transfer status [" + domain_transfer_response.m_transfer_status + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Transfer (Query) failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            try {
                System.out.println("Creating the Domain Delete command");
                epp_DomainDeleteReq domain_delete_request = new epp_DomainDeleteReq();
                command_data = new epp_Command();
                command_data.m_client_trid = client_trid;
                domain_delete_request.m_cmd = command_data;
                domain_delete_request.m_name = epp_client_id + "1.info";
                EPPDomainDelete domain_delete = new EPPDomainDelete();
                domain_delete.setRequestData(domain_delete_request);
                domain_delete = (EPPDomainDelete)epp_client.processAction(domain_delete);
                epp_DomainDeleteRsp domain_delete_response = domain_delete.getResponseData();
                response2 = domain_delete_response.m_rsp;
                results3 = response2.m_results;
                System.out.println("DomainDelete results: [" + results3[0].m_code + "] [" + results3[0].m_msg + "]");
            }
            catch (epp_XMLException xcp) {
                System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
            }
            catch (epp_Exception xcp) {
                System.err.println("epp_Exception!");
                results2 = xcp.m_details;
                System.err.println("\tcode: [" + results2[0].m_code + "] lang: [" + results2[0].m_lang + "] msg: [" + results2[0].m_msg + "]");
                if (results2[0].m_values != null && results2[0].m_values.length > 0) {
                    System.err.println("\tvalue: [" + results2[0].m_values[0] + "]");
                }
            }
            catch (Exception xcp) {
                System.err.println("Domain Delete failed! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
                xcp.printStackTrace();
            }
            System.out.println("Logging out from the EPP Server");
            epp_client.logout(client_trid);
            System.out.println("Disconnecting from the EPP Server");
            epp_client.disconnect();
        }
        catch (epp_XMLException xcp) {
            System.err.println("epp_XMLException! [" + xcp.m_error_message + "]");
        }
        catch (epp_Exception xcp) {
            System.err.println("epp_Exception!");
            epp_Result[] results = xcp.m_details;
            System.err.println("\tcode: [" + results[0].m_code + "] lang: [" + results[0].m_lang + "] msg: [" + results[0].m_msg + "]");
            if (results[0].m_values != null && results[0].m_values.length > 0) {
                System.err.println("\tvalue: [" + results[0].m_values[0] + "]");
            }
        }
        catch (Exception xcp) {
            System.err.println("Exception! [" + xcp.getClass().getName() + "] [" + xcp.getMessage() + "]");
            xcp.printStackTrace();
        }
    }
}

