/*
 * Decompiled with CFR 0.152.
 */
package com.tucows.oxrs.epp02.rtk;

import com.tucows.oxrs.epp02.rtk.RTKBase;
import com.tucows.oxrs.epp02.rtk.xml.EPPGreeting;
import com.tucows.oxrs.epp02.rtk.xml.EPPLogin;
import com.tucows.oxrs.epp02.rtk.xml.EPPLogout;
import com.tucows.oxrs.epp02.rtk.xml.EPPPoll;
import com.tucows.oxrs.epp02.rtk.xml.unspec.RTKVersion;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openrtk.idl.epp02.epp_Action;
import org.openrtk.idl.epp02.epp_Command;
import org.openrtk.idl.epp02.epp_Credentials;
import org.openrtk.idl.epp02.epp_Exception;
import org.openrtk.idl.epp02.epp_Greeting;
import org.openrtk.idl.epp02.epp_LoginReq;
import org.openrtk.idl.epp02.epp_LogoutReq;
import org.openrtk.idl.epp02.epp_Options;
import org.openrtk.idl.epp02.epp_PollOpType;
import org.openrtk.idl.epp02.epp_PollReq;
import org.openrtk.idl.epp02.epp_PollRsp;
import org.openrtk.idl.epp02.epp_Result;
import org.openrtk.idl.epp02.epp_Service;
import org.openrtk.idl.epp02.epp_Session;
import org.openrtk.idl.epp02.epp_XMLException;

public class EPPClient
extends RTKBase
implements epp_Session {
    public static final String VERSION = "1.0";
    public static final String DEFAULT_LANG = "en_US";
    public static final int DEFAULT_EPP_TIMEOUT = 20000;
    public static final int PROTOCOL_TCP = 0;
    public static final int PROTOCOL_TCP_TLS = 1;
    public static final int PROTOCOL_BXXP = 2;
    private String epp_host_name_;
    private int epp_host_port_;
    private int epp_timeout_ = 20000;
    private String epp_client_id_;
    private String epp_password_;
    private String version_ = "1.0";
    private String lang_ = "en_US";
    private Socket socket_to_epp_server_;
    private BufferedReader reader_from_server_;
    private PrintWriter writer_to_server_;
    private SSLContext ctx_ = null;
    private KeyStore ks_ = null;
    private KeyManagerFactory kmf_ = null;
    private SecureRandom rnd_ = null;
    private long lastNetTransaction = 0L;
    private boolean isValid = false;
    private int protocol_ = 1;
    private boolean sendver_ = true;

    public EPPClient() {
    }

    public EPPClient(String epp_client_id, String epp_password) {
        this();
        this.epp_client_id_ = epp_client_id;
        this.epp_password_ = epp_password;
    }

    public EPPClient(String epp_host_name, int epp_host_port, String epp_client_id, String epp_password) {
        this(epp_client_id, epp_password);
        this.epp_host_name_ = epp_host_name;
        this.epp_host_port_ = epp_host_port;
    }

    public void setVersion(String value) {
        this.version_ = value;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setLang(String value) {
        this.lang_ = value;
    }

    public String getLang() {
        return this.lang_;
    }

    public void setProtocol(int value) {
        this.protocol_ = value;
    }

    public int getProtocol() {
        return this.protocol_;
    }

    public void setEPPHostName(String value) {
        this.epp_host_name_ = value;
    }

    public String getEPPHostName() {
        return this.epp_host_name_;
    }

    public void setEPPHostPort(int value) {
        this.epp_host_port_ = value;
    }

    public int getEPPHostPort() {
        return this.epp_host_port_;
    }

    public void setEPPTimeout(int value) {
        this.epp_timeout_ = value;
    }

    public int getEPPTimeout() {
        return this.epp_timeout_;
    }

    public void setEPPClientID(String value) {
        this.epp_client_id_ = value;
    }

    public String getEPPClientID() {
        return this.epp_client_id_;
    }

    public void setEPPPassword(String value) {
        this.epp_password_ = value;
    }

    public String getEPPPassword() {
        return this.epp_password_;
    }

    public long getLastNetTransaction() {
        return this.lastNetTransaction;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setSocketToEPPServer(Socket value) throws epp_Exception, UnknownHostException, SocketException, IOException {
        String method_name = "setSocketToEPPServer";
        this.debug(3, method_name, "Enterd");
        this.socket_to_epp_server_ = value;
        this.socket_to_epp_server_.setSoTimeout(this.epp_timeout_);
        this.reader_from_server_ = new BufferedReader(new InputStreamReader(this.socket_to_epp_server_.getInputStream()));
        this.writer_to_server_ = new PrintWriter((Writer)new OutputStreamWriter(this.socket_to_epp_server_.getOutputStream()), true);
        this.debug(3, method_name, "Leaving");
    }

    public void connect(String epp_host_name, int epp_host_port) throws epp_Exception, UnknownHostException, SocketException, IOException {
        this.setEPPHostName(epp_host_name);
        this.setEPPHostPort(epp_host_port);
        this.connect();
    }

    public void connect(String epp_client_id, String epp_password) throws epp_Exception, UnknownHostException, SocketException, IOException {
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.connect();
    }

    public void connect(String epp_host_name, int epp_host_port, String epp_client_id, String epp_password) throws epp_Exception, UnknownHostException, SocketException, IOException {
        this.setEPPHostName(epp_host_name);
        this.setEPPHostPort(epp_host_port);
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.connect();
    }

    public void connect() throws epp_Exception, UnknownHostException, SocketException, IOException {
        String method_name = "connect()";
        this.debug(3, method_name, "Entered");
        this.socket_to_epp_server_ = null;
        if (this.protocol_ == 1) {
            this.debug(2, method_name, "Using SSL/TLS");
            Properties system_props = System.getProperties();
            String ssl_props_location = system_props.getProperty("ssl.props.location");
            if (ssl_props_location == null || ssl_props_location.length() == 0) {
                this.isValid = false;
                throw new IOException("No ssl props location specified");
            }
            Properties ssl_props = new Properties();
            ssl_props.load(new FileInputStream(ssl_props_location + "/ssl.properties"));
            SSLSocketFactory ssl_factory = null;
            try {
                char[] passphrase1 = ((String)ssl_props.get("ssl.keystore.passphrase")).toCharArray();
                char[] passphrase2 = ((String)ssl_props.get("ssl.signedcert.passphrase")).toCharArray();
                if (this.ctx_ == null) {
                    this.ctx_ = SSLContext.getInstance((String)ssl_props.get("ssl.protocol"));
                }
                if (this.ks_ == null) {
                    if (ssl_props.get("ssl.keystore.provider") == null) {
                        this.ks_ = KeyStore.getInstance((String)ssl_props.get("ssl.keystore.format"));
                    } else {
                        if (ssl_props.get("ssl.keystore.provider").equals("BC")) {
                            Security.addProvider((Provider)new BouncyCastleProvider());
                        }
                        this.ks_ = KeyStore.getInstance((String)ssl_props.get("ssl.keystore.format"), (String)ssl_props.get("ssl.keystore.provider"));
                    }
                    this.ks_.load(new FileInputStream(ssl_props_location + "/" + (String)ssl_props.get("ssl.keystore.file")), passphrase1);
                }
                if (this.kmf_ == null) {
                    this.kmf_ = KeyManagerFactory.getInstance((String)ssl_props.get("ssl.keymanagerfactory.format"));
                    this.kmf_.init(this.ks_, passphrase2);
                }
                try {
                    byte[] seed = new byte[1024];
                    FileInputStream is = new FileInputStream("/dev/urandom");
                    is.read(seed);
                    is.close();
                    this.rnd_ = SecureRandom.getInstance("SHA1PRNG");
                    this.rnd_.setSeed(seed);
                    this.debug(2, method_name, "SecureRandom seed set.");
                }
                catch (Exception xcp) {
                    this.debug(2, method_name, "Error initializing SecureRandom [" + xcp.getMessage() + "], using default initialization.");
                    this.rnd_ = null;
                }
                this.ctx_.init(this.kmf_.getKeyManagers(), null, this.rnd_);
                ssl_factory = this.ctx_.getSocketFactory();
            }
            catch (Exception xcp) {
                this.isValid = false;
                throw new IOException(xcp.getMessage());
            }
            this.socket_to_epp_server_ = ssl_factory.createSocket(this.epp_host_name_, this.epp_host_port_);
        } else if (this.protocol_ == 0) {
            this.debug(2, method_name, "Using plain TCP");
            this.socket_to_epp_server_ = new Socket(this.epp_host_name_, this.epp_host_port_);
        } else {
            this.debug(2, method_name, "Wanted to use something not supported [" + this.protocol_ + "]");
            throw new IOException("Protocol not supported");
        }
        this.socket_to_epp_server_.setSoTimeout(this.epp_timeout_);
        this.reader_from_server_ = new BufferedReader(new InputStreamReader(this.socket_to_epp_server_.getInputStream()));
        this.writer_to_server_ = new PrintWriter((Writer)new OutputStreamWriter(this.socket_to_epp_server_.getOutputStream()), true);
        this.debug(2, method_name, "Connected to [" + this.socket_to_epp_server_.getInetAddress() + ":" + this.socket_to_epp_server_.getPort() + "]");
        this.debug(3, method_name, "Leaving");
    }

    public String readFromServer() throws epp_Exception {
        StringBuffer buf;
        String method_name = "readFromServer()";
        this.debug(3, method_name, "Entered");
        try {
            String line;
            buf = new StringBuffer();
            while ((line = this.reader_from_server_.readLine()) != null) {
                buf.append(line);
                if (!line.trim().endsWith("</epp>")) continue;
            }
            if (line == null) {
                this.debug(2, method_name, "Connection closed by server.");
                this.disconnect();
                epp_Result[] result = new epp_Result[]{new epp_Result()};
                result[0].m_code = (short)2601;
                result[0].m_msg = "Unexpected server disconnect";
                this.isValid = false;
                throw new epp_Exception(result);
            }
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to read from server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            this.isValid = false;
            throw new epp_Exception(result);
        }
        this.lastNetTransaction = System.currentTimeMillis();
        this.debug(3, method_name, "Leaving");
        return buf.toString();
    }

    @Override
    public String processXML(String request_xml) throws epp_Exception {
        String method_name = "processXML(String)";
        this.debug(3, method_name, "Entered");
        this.debug(2, method_name, "Request XML is [" + request_xml + "]");
        this.writeToServer(request_xml);
        String response_xml = this.readFromServer();
        this.debug(2, method_name, "Response XML is [" + response_xml + "]");
        this.debug(3, method_name, "Leaving");
        return response_xml;
    }

    @Override
    public epp_Action processAction(epp_Action request) throws epp_XMLException, epp_Exception {
        String method_name = "processAction(epp_Action)";
        this.debug(3, method_name, "Entered");
        String request_xml = request.toXML();
        epp_Action response = request;
        String response_xml = this.processXML(request_xml);
        response.fromXML(response_xml);
        this.debug(3, method_name, "Leaving");
        return response;
    }

    public void writeToServer(String outbound_xml) throws epp_Exception {
        String method_name = "writeToServer(String)";
        this.debug(3, method_name, "Entered");
        try {
            String line;
            BufferedReader reader_outbound_xml = new BufferedReader(new StringReader(outbound_xml));
            StringBuffer buf = new StringBuffer();
            while ((line = reader_outbound_xml.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                if (!line.startsWith("<")) {
                    buf.append(' ');
                }
                buf.append(line);
                if (line.endsWith("?>")) {
                    buf.append("\r\n");
                }
                if (!line.trim().endsWith("</epp>")) continue;
            }
            String final_xml = buf.toString();
            this.writer_to_server_.print(final_xml);
            this.writer_to_server_.print("\r\n");
            this.writer_to_server_.flush();
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            epp_Result[] result = new epp_Result[]{new epp_Result()};
            result[0].m_code = (short)2600;
            result[0].m_msg = "Failed to write to server [" + xcp.getClass().toString() + "] [" + xcp.getMessage() + "]";
            this.isValid = false;
            throw new epp_Exception(result);
        }
        this.debug(3, method_name, "Leaving");
    }

    public epp_Greeting connectAndGetGreeting() throws epp_Exception, IOException, epp_XMLException {
        epp_Greeting hello_from_server;
        String method_name = "connectAndGetGreeting()";
        this.debug(3, method_name, "Entered");
        try {
            this.connect();
            hello_from_server = this.getGreeting();
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            this.isValid = false;
            throw xcp;
        }
        catch (epp_XMLException xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            this.isValid = false;
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
        return hello_from_server;
    }

    public epp_Greeting getGreeting() throws epp_Exception, epp_XMLException {
        EPPGreeting hello_from_server;
        String method_name = "connectAndGetGreeting()";
        this.debug(3, method_name, "Entered");
        try {
            String xml_from_server = this.readFromServer();
            this.debug(2, method_name, "Greeting from server: [" + xml_from_server + "]");
            hello_from_server = new EPPGreeting();
            hello_from_server.fromXML(xml_from_server);
        }
        catch (epp_XMLException xcp) {
            this.debug(1, method_name, (Exception)((Object)xcp));
            this.isValid = false;
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
        this.isValid = true;
        return hello_from_server.getResponseData();
    }

    public epp_Greeting hello() throws epp_Exception, epp_XMLException {
        String method_name = "hello()";
        this.debug(3, method_name, "Entered");
        EPPGreeting hello_from_server = new EPPGreeting();
        hello_from_server = (EPPGreeting)this.processAction(hello_from_server);
        this.debug(3, method_name, "Leaving");
        return hello_from_server.getResponseData();
    }

    public void disconnect() throws IOException {
        String method_name = "disconnect()";
        this.debug(3, method_name, "Entered");
        try {
            if (this.socket_to_epp_server_ != null) {
                this.socket_to_epp_server_.close();
            }
            this.socket_to_epp_server_ = null;
            if (this.reader_from_server_ != null) {
                this.reader_from_server_.close();
            }
            this.reader_from_server_ = null;
            if (this.writer_to_server_ != null) {
                this.writer_to_server_.close();
            }
            this.writer_to_server_ = null;
            this.isValid = false;
        }
        catch (IOException xcp) {
            this.debug(1, method_name, xcp);
            this.isValid = false;
            throw xcp;
        }
        this.debug(3, method_name, "Leaving");
    }

    public void login(String client_tr_id) throws epp_XMLException, epp_Exception {
        this.login(client_tr_id, null);
    }

    public void login(String client_tr_id, String epp_client_id, String epp_password) throws epp_XMLException, epp_Exception {
        this.setEPPClientID(epp_client_id);
        this.setEPPPassword(epp_password);
        this.login(client_tr_id, null);
    }

    public void login(String client_tr_id, String client_id, String password, String new_password) throws epp_XMLException, epp_Exception {
        this.setEPPClientID(client_id);
        this.setEPPPassword(password);
        this.login(client_tr_id, new_password);
    }

    public void login(String client_tr_id, String new_password) throws epp_XMLException, epp_Exception {
        String method_name = "login()";
        this.debug(3, method_name, "Entered");
        epp_LoginReq login_req = new epp_LoginReq();
        epp_Credentials creds = new epp_Credentials(this.epp_client_id_, this.epp_password_, new_password, null);
        creds.setOptions(new epp_Options(this.version_, this.lang_));
        epp_Command command_data = new epp_Command(creds, null, client_tr_id);
        if (this.sendver_) {
            command_data.setUnspec(new RTKVersion());
        }
        epp_Service[] services = new epp_Service[]{new epp_Service("domain", "urn:iana:xml:ns:domain", "urn:iana:xml:ns:domain domain.xsd"), new epp_Service("host", "urn:iana:xml:ns:host", "urn:iana:xml:ns:host host.xsd"), new epp_Service("contact", "urn:iana:xml:ns:contact", "urn:iana:xml:ns:contact contact.xsd")};
        login_req.setServices(services);
        login_req.setCmd(command_data);
        EPPLogin login_action = new EPPLogin();
        login_action.setRequestData(login_req);
        try {
            this.processAction(login_action);
        }
        catch (epp_XMLException e) {
            this.isValid = false;
            throw e;
        }
        catch (epp_Exception e) {
            this.isValid = false;
            throw e;
        }
        this.debug(3, method_name, "Leaving");
    }

    public void logout(String client_trid) throws epp_XMLException, epp_Exception {
        String method_name = "logout()";
        this.debug(3, method_name, "Entered");
        EPPLogout logout_action = new EPPLogout();
        epp_LogoutReq logout_request = new epp_LogoutReq();
        logout_request.m_client_trid = client_trid;
        logout_action.setRequestData(logout_request);
        this.processAction(logout_action);
        this.debug(3, method_name, "Leaving");
    }

    public boolean isVersionSentOnLogin() {
        return this.sendver_;
    }

    public void setVersionSentOnLogin(boolean send) {
        this.sendver_ = send;
    }

    public epp_PollRsp poll(String client_tr_id) throws epp_XMLException, epp_Exception {
        return this.poll(client_tr_id, null);
    }

    public epp_PollRsp poll(String client_tr_id, String message_id) throws epp_XMLException, epp_Exception {
        epp_Command command_data;
        String method_name = "Poll()";
        this.debug(3, method_name, "Entered");
        epp_PollReq poll_request = new epp_PollReq();
        poll_request.m_cmd = command_data = new epp_Command(null, null, client_tr_id);
        if (message_id == null) {
            poll_request.m_op = epp_PollOpType.REQ;
        } else {
            poll_request.m_op = epp_PollOpType.ACK;
            poll_request.m_msgID = message_id;
        }
        EPPPoll poll = new EPPPoll();
        poll.setRequestData(poll_request);
        poll = (EPPPoll)this.processAction(poll);
        epp_PollRsp poll_response = poll.getResponseData();
        this.debug(3, method_name, "Leaving");
        return poll_response;
    }
}

