# Week 12

- [Lecture slides](https://docs.google.com/presentation/d/1RaGjc9JqDTyibkh8hqIemJYtj2ckCXYlPG7345Xqakw/edit?usp=sharing)
- [Seminar](Seminar_AntiSpoofing.ipynb)
- Recording on YouTube (in Russian): Not available. Please, look at the previous year recordings for weeks [10](https://youtu.be/ZNv4gh9pR1g) and [11](https://youtu.be/VGpcQVWE3Eg). They cover this year material.

There is an English version from the [LauzHack Deep Learning Bootcamp](https://github.com/LauzHack/deep-learning-bootcamp). See [here](https://youtu.be/oim5h1_4T5I).

## Literature

Here is some useful literature:

- CM for replay attack: [The DKU-CMRI System for the ASVspoof 2021 Challenge: Vocoder based Replay Channel Response Estimation](https://www.isca-speech.org/archive/pdfs/asvspoof_2021/wang21_asvspoof.pdf)

- VAE for anomaly detection: [Variational Autoencoder based Anomaly Detection using Reconstruction Probability](http://dm.snu.ac.kr/static/docs/TR/SNUDM-TR-2015-03.pdf)

- Artifacts in Sub-bands: [An explainability study of the constant Q cepstral coefficient spoofing countermeasure for automatic speaker verification](https://www.isca-speech.org/archive/pdfs/odyssey_2020/tak20_odyssey.pdf)

- Fusion: [Spoofing Attack Detection using the Non-linear Fusion of Sub-band Classifiers](https://arxiv.org/abs/2005.10393)

- LCNN: [A Light CNN for Deep Face Representation with Noisy Labels](https://arxiv.org/abs/1511.02683),

- RawNet2: [End-to-end anti-spoofing with RawNet2](https://arxiv.org/abs/2011.01108)

- AASIST: [AASIST: AUDIO ANTI-SPOOFING USING INTEGRATED SPECTRO-TEMPORAL GRAPH ATTENTION NETWORKS](https://arxiv.org/pdf/2110.01200.pdf)

- SSL + AASIST: [Automatic speaker verification spoofing and deepfake detection using wav2vec 2.0 and data augmentation](https://arxiv.org/pdf/2202.12233)

- ASVspoof: [ASVspoof 2019: Automatic Speaker Verification Spoofing and Countermeasures Challenge Evaluation Plan](https://www.asvspoof.org/asvspoof2019/asvspoof2019_evaluation_plan.pdf), [ASVspoof 2019: A large-scale public database of synthesized, converted and replayed speech](https://arxiv.org/pdf/1911.01601.pdf)
