# Week 03

- [Lecture slides](https://docs.google.com/presentation/d/1cBXdNIbowwYNp42WhJmd1Pp85oeslOrKNmGyZa5HKBQ/edit?usp=sharing)
- [Recording on YouTube (in Russian)](https://youtu.be/6xLgfM9ixY4)

### Practice & homework

- **Seminar:**

  - Augmentations: [Notebook](./seminar03_1.ipynb)
  - CTC Decoding, WER, CER, CTC Beam Search: [Notebook](./seminar03_2.ipynb)

- **Q&A Session:**

  - [Project Template](https://github.com/Blinorot/pytorch_project_template)
  - [Notebook about R&D Coding](Seminar_RandD_Coding.ipynb)
  - [Examples from the notebook](./notebook_problems_examples/)
  - Also check seminar materials from [Week 01](https://github.com/markovka17/dla/tree/2024/week01)
  - [Q&A recording on YouTube (in Russian)](https://youtu.be/Apb-m5iteP8)

  Q&A Materials are based on the [LauzHack Deep Learning Bootcamp](https://github.com/LauzHack/deep-learning-bootcamp).

### Additional Materials

- [Sequence Modeling With CTC](https://distill.pub/2017/ctc/), a blog post explaining and visualizing CTC loss.
- The original CTC Loss paper can be found [here](https://www.cs.toronto.edu/~graves/icml_2006.pdf).
- [Groups, Depthwise, and Depthwise-Separable Convolution](https://www.youtube.com/watch?v=vVaRhZXovbw), a video explaining why depthwise separable convolutions are needed and what their advantages are over regular convolutions.
- This [tutorial](https://pytorch.org/audio/main/tutorials/asr_inference_with_ctc_decoder_tutorial.html) from Torch shows how to use CTC Beam Search with language model support.
- Recording in English with a brief explanation of the CTC Loss can be found [here](https://youtu.be/YuImUy6vPFs).
