module FFI.SQLite3
  ( Mode (..)
  , Database
  , Row
  , Result
  , connect
  , close
  , all
  ) where

import Prelude

import Effect.Aff (Aff)
import Effect.Aff.Compat (EffectFnAff, fromEffectFnAff)

import Foreign as Foreign

data Mode = OpenReadOnly | OpenCreate | OpenReadWrite

instance showMode :: Show Mode where
  show OpenReadOnly  = "OPEN_READONLY"
  show OpenCreate    = "OPEN_CREATE | OPEN_READWRITE"
  show OpenReadWrite = "OPEN_READWRITE"

mode' :: Mode -> Int
mode' OpenReadOnly = 1
mode' OpenCreate = 6
mode' OpenReadWrite = 2 

foreign import data Database :: Type

type Row = Foreign.Foreign

type Result a = Foreign.F a

foreign import connectImpl :: String -> Int -> EffectFnAff Database

foreign import closeImpl :: Database -> EffectFnAff Unit

foreign import allImpl :: String -> Database -> EffectFnAff (Array Row)

connect :: String -> Mode -> Aff Database
connect filename mode = fromEffectFnAff $ connectImpl filename (mode' mode)

close :: Database -> Aff Unit
close = fromEffectFnAff <<< closeImpl

all :: String -> Database -> Aff (Array Row)
all query db = fromEffectFnAff $ allImpl query db

instance showDatabase :: Show Database where
  show _ = "Database"
