unit uInstagram;

//  *************************************************
//    Generated By: JsonToDelphiClass - 0.65
//    Project link: https://github.com/PKGeorgiev/Delphi-JsonToDelphiClass
//    Generated On: 2024-04-14 19:41:33
//  *************************************************
//    Created By  : Petar Georgiev - 2014
//    WebSite     : http://pgeorgiev.com
//  *************************************************

interface

uses Generics.Collections, Rest.Json;

type

TReactionClass = class
private
  FAction: String;
  FEmoji: String;
  FMid: String;
  FReaction: String;
public
  property action: String read FAction write FAction;
  property emoji: String read FEmoji write FEmoji;
  property mid: String read FMid write FMid;
  property reaction: String read FReaction write FReaction;
  //function ToJsonString: string;
  //class function FromJsonString(AJsonString: string): TReactionClass;
end;

TMessageClass = class
private
  FMid: String;
  FText: String;
public
  property mid: String read FMid write FMid;
  property text: String read FText write FText;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TMessageClass;
end;

TReadClass = class
private
  Fmid: String;
public
  property mid: String read Fmid write Fmid;

end;

TRecipientClass = class
private
  FId: String;
public
  property id: String read FId write FId;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TRecipientClass;
end;

TSenderClass = class
private
  FId: String;
public
  property id: String read FId write FId;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TSenderClass;
end;

TMessagingClass = class
private
  FMessage: TMessageClass;
  FRecipient: TRecipientClass;
  FSender: TSenderClass;
  FTimestamp: String;
  FReaction: TReactionClass;
  FRead: TReadClass;
public
  property message: TMessageClass read FMessage write FMessage;
  property recipient: TRecipientClass read FRecipient write FRecipient;
  property sender: TSenderClass read FSender write FSender;
  property timestamp: String read FTimestamp write FTimestamp;
  property reaction: TReactionClass read FReaction write FReaction;
  property read: TReadClass read FRead write FRead;
  constructor Create;
  destructor Destroy; override;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TMessagingClass;
end;

TEntryClass = class
private
  FId: String;
  FMessaging: TArray<TMessagingClass>;
  FTime: Extended;
public
  property id: String read FId write FId;
  property messaging: TArray<TMessagingClass> read FMessaging write FMessaging;
  property time: Extended read FTime write FTime;
  destructor Destroy; override;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TEntryClass;
end;

TResultClass = class
private
  FEntry: TArray<TEntryClass>;
  FObject: String;
public
  property entry: TArray<TEntryClass> read FEntry write FEntry;
  property &object: String read FObject write FObject;
  destructor Destroy; override;
  function ToJsonString: string;
  class function FromJsonString(AJsonString: string): TResultClass;
end;

implementation

{TMessageClass}


function TMessageClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TMessageClass.FromJsonString(AJsonString: string): TMessageClass;
begin
  result := TJson.JsonToObject<TMessageClass>(AJsonString)
end;

{TRecipientClass}


function TRecipientClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TRecipientClass.FromJsonString(AJsonString: string): TRecipientClass;
begin
  result := TJson.JsonToObject<TRecipientClass>(AJsonString)
end;

{TSenderClass}


function TSenderClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TSenderClass.FromJsonString(AJsonString: string): TSenderClass;
begin
  result := TJson.JsonToObject<TSenderClass>(AJsonString)
end;

{TMessagingClass}

constructor TMessagingClass.Create;
begin
  inherited;
  FSender := TSenderClass.Create();
  FRecipient := TRecipientClass.Create();
  FMessage := TMessageClass.Create();
end;

destructor TMessagingClass.Destroy;
begin
  FSender.free;
  FRecipient.free;
  FMessage.free;
  inherited;
end;

function TMessagingClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TMessagingClass.FromJsonString(AJsonString: string): TMessagingClass;
begin
  result := TJson.JsonToObject<TMessagingClass>(AJsonString)
end;

{TEntryClass}

destructor TEntryClass.Destroy;
var
  LmessagingItem: TMessagingClass;
begin

 for LmessagingItem in FMessaging do
   LmessagingItem.free;

  inherited;
end;

function TEntryClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TEntryClass.FromJsonString(AJsonString: string): TEntryClass;
begin
  result := TJson.JsonToObject<TEntryClass>(AJsonString)
end;

{TResultClass}

destructor TResultClass.Destroy;
var
  LentryItem: TEntryClass;
begin

 for LentryItem in FEntry do
   LentryItem.free;

  inherited;
end;

function TResultClass.ToJsonString: string;
begin
  result := TJson.ObjectToJsonString(self);
end;

class function TResultClass.FromJsonString(AJsonString: string): TResultClass;
begin
  result := TJson.JsonToObject<TResultClass>(AJsonString)
end;

end.
