{##
  This file contains a Jinja2 front-matter template that adds version and authorship information.
  Changing the Jinja2 templates in this file may cause incompatibility with Manubot updates.
  Pandoc automatically inserts title from metadata.yaml, so it is not included in this template.
##}

{## Uncomment & edit the following line to reference to a preprinted or published version of the manuscript.
_A DOI-citable version of this manuscript is available at <https://doi.org/DOI_HERE>_.
##}

{## Template to insert build date and source ##}
<small><em>
test edit - hello world. This manuscript
{% if manubot.ci_source is defined and manubot.ci_source.provider == "appveyor" -%}
([permalink]({{manubot.ci_source.artifact_url}}))
{% elif manubot.html_url_versioned is defined -%}
([permalink]({{manubot.html_url_versioned}}))
{% endif -%}
was automatically generated
{% if manubot.ci_source is defined -%}
from [{{manubot.ci_source.repo_slug}}@{{manubot.ci_source.commit | truncate(length=7, end='', leeway=0)}}](https://github.com/{{manubot.ci_source.repo_slug}}/tree/{{manubot.ci_source.commit}})
{% endif -%}
on {{manubot.generated_date_long}}.
</em></small>

{% if manubot.date_long != manubot.generated_date_long -%}
Published: {{manubot.date_long}}
{% endif %}

## Authors

{## Template for listing authors ##}
{% for author in manubot.authors %}
+ **{{author.name}}**
  {% if author.corresponding is defined and author.corresponding == true -%}^[✉](#correspondence)^{%- endif -%}
  <br>
  {%- set has_ids = false %}
  {%- if author.orcid is defined and author.orcid is not none %}
    {%- set has_ids = true %}
    ![ORCID icon](images/orcid.svg){.inline_icon width=16 height=16}
    [{{author.orcid}}](https://orcid.org/{{author.orcid}})
  {%- endif %}
  {%- if author.github is defined and author.github is not none %}
    {%- set has_ids = true %}
    · ![GitHub icon](images/github.svg){.inline_icon width=16 height=16}
    [{{author.github}}](https://github.com/{{author.github}})
  {%- endif %}
  {%- if author.twitter is defined and author.twitter is not none %}
    {%- set has_ids = true %}
    · ![Twitter icon](images/twitter.svg){.inline_icon width=16 height=16}
    [{{author.twitter}}](https://twitter.com/{{author.twitter}})
  {%- endif %}
  {%- if author.mastodon is defined and author.mastodon is not none and author["mastodon-server"] is defined and author["mastodon-server"] is not none %}
    {%- set has_ids = true %}
    · ![Mastodon icon](images/mastodon.svg){.inline_icon width=16 height=16}
    [\@{{author.mastodon}}@{{author["mastodon-server"]}}](https://{{author["mastodon-server"]}}/@{{author.mastodon}})
  {%- endif %}
  {%- if has_ids %}
    <br>
  {%- endif %}
  <small>
  {%- if author.affiliations is defined and author.affiliations|length %}
     {{author.affiliations | join('; ')}}
  {%- endif %}
  {%- if author.funders is defined and author.funders|length %}
     · Funded by {{author.funders | join('; ')}}
  {%- endif %}
  </small>
{% endfor %}

::: {#correspondence}
✉ — Correspondence possible via {% if manubot.ci_source is defined -%}[GitHub Issues](https://github.com/{{manubot.ci_source.repo_slug}}/issues){% else %}GitHub Issues{% endif %}
{% if manubot.authors|map(attribute='corresponding')|select|max -%}
or email to
{% for author in manubot.authors|selectattr("corresponding") -%}
{{ author.name }} \<{{ author.email }}\>{{ ", " if not loop.last else "." }}
{% endfor %}
{% endif %}
:::
