/*
 URL: https://leetcode.com/problems/rotate-array/description/
 
 Given an array, rotate the array to the right by k steps, where k is non-negative.

Example 1:

Input: [1,2,3,4,5,6,7] and k = 3
Output: [5,6,7,1,2,3,4]
Explanation:
rotate 1 steps to the right: [7,1,2,3,4,5,6]
rotate 2 steps to the right: [6,7,1,2,3,4,5]
rotate 3 steps to the right: [5,6,7,1,2,3,4]

Example 2:

Input: [-1,-100,3,99] and k = 2
Output: [3,99,-1,-100]
Explanation: 
rotate 1 steps to the right: [99,-1,-100,3]
rotate 2 steps to the right: [3,99,-1,-100]

Note:

    Try to come up as many solutions as you can, there are at least 3 different ways to solve this problem.
    Could you do it in-place with O(1) extra space?
*/

public class RotateArray {
	public void rotate(int[] nums, int k) {
		if (nums == null || nums.length == 0 || k == 0) {
			return;
		}
		int n = nums.length;
		k = k % n;
		rotateRange(0, n - k - 1, nums);
		rotateRange(n - k, n - 1, nums);
		rotateRange(0, n - 1, nums);
	}
	
	private void rotateRange(int start, int end, int[] array) {
		for (int i = start, j = end; i < j; i++, j--) {
			swap(array, i, j);
		}
	}
	private void swap(int[] array, int i, int j) {
		int t = array[i];
		array[i] = array[j];
		array[j] = t;
	}
}