const Ape = {
  symbol: 'ape',
  color: '#000',
  colorIcon() {
    return `<g fill="none" fill-rule="evenodd"><circle fill="#0054F9" fill-rule="nonzero" cx="16" cy="16" r="16"/><path d="M28.445 14.517c.036.268.063.538.082.811l-.028-.336-.06.336a8.527 8.527 0 01-.077.339l-.09.338-.046.155a6.785 6.785 0 01-1.027 1.986 6.664 6.664 0 01-1.335 1.399 1.031 1.031 0 00-.262.31 1.493 1.493 0 00-.12.488l-.02.253-.01.108-.01.099-.012.092-.013.089-.016.087-.04.21c-.203 1.028-.571 1.784-1.147 2.656l-.612.885c-.929 1.222-2.022 2.01-3.332 2.393l-.276.083-.283.04a7.065 7.065 0 01-1.13.1h-.502l-.31.02c-.209 0-.402.037-.626.117-.91.286-1.997.425-3.335.425h-.169l-.254-.005-.173-.004-.27-.01-.19-.008-.304-.015-.21-.01a12.552 12.552 0 01-.583-.198l.8.048.303.015.28.012.264.008.17.004.252.003h.23c1.255-.01 2.28-.148 3.137-.416.237-.086.45-.125.672-.125l.31-.02h.508c.339 0 .714-.035 1.106-.1l.272-.037.367-.112c1.23-.384 2.262-1.141 3.144-2.302l.608-.88c.587-.887.953-1.651 1.147-2.717l.008-.044.016-.086.014-.085.012-.088.01-.094.011-.101.015-.173.014-.205a1.66 1.66 0 01.13-.467c.066-.13.174-.258.306-.368a6.51 6.51 0 001.306-1.367c.446-.6.785-1.254 1.003-1.94.141-.457.242-.913.301-1.36v-.04l.007-.03zm-.574-2.398c.042.12.083.243.122.366l-.019.143-.02.15-.005.028-.03.184v.053a6.62 6.62 0 01-.414 1.383l-.013.025v.022c0 .02-.001.035-.007.059l-.01.045-.003.016v.068a5.651 5.651 0 01-.268 1.178 6.226 6.226 0 01-.862 1.683l-.077.106a5.888 5.888 0 01-1.181 1.195c-.183.126-.34.31-.465.536a1.397 1.397 0 00-.173.685c0 .302-.035.599-.103.936a6.058 6.058 0 01-.613 1.715l-.05.092-.048.088-.078.134-.09.147-.149.237-.448.643c-.814 1.112-1.745 1.811-2.86 2.131l-.07.023a.675.675 0 00-.016.003l-.033.008-.079.022-.045.012a.627.627 0 01-.065.012l-.05.003-.058.02c-.254.05-.533.075-.835.08l-.114.001h-.525l-.053.002-.307.015-.07.003h-.094a1.376 1.376 0 00-.199.02l-.074.013-.083.018-.045.011-.1.025-.115.03c-.94.274-1.93.404-3.17.404h-.23l-.154-.003-.234-.007-.246-.01-.264-.012-.29-.016-.836-.052-.117-.001-.097-.02-.096-.013-.116-.014-.064-.006-.06-.004-.058-.002h-.03c-.837-.083-1.45-.202-2.12-.469a14.089 14.089 0 01-.704-.532c.088.055.178.109.271.16l.097.058.12.06c.764.343 1.413.481 2.344.574h.028l.055.001.056.004.061.005.068.008.174.023.086.019h.106l.632.04.308.017.366.02.25.01.159.005.23.005.153.002h.153c1.225 0 2.202-.127 3.128-.397l.174-.046.098-.024.088-.018.079-.015c.088-.014.166-.02.251-.02h.029l.096-.003.237-.013.11-.004h.544c.336 0 .645-.025.91-.077l.061-.02.024-.003a.444.444 0 00.122-.02l.07-.02.039-.01.03-.007.063-.02c1.084-.312 1.988-.99 2.782-2.075l.445-.639.079-.124.099-.16.056-.093.052-.089.05-.086.047-.088.05-.092a5.912 5.912 0 00.573-1.628c.067-.329.1-.616.1-.907l.001-.068c.01-.247.074-.477.191-.69.135-.243.308-.445.508-.584.47-.358.881-.778 1.224-1.267l.07-.098c.324-.464.583-.983.772-1.544a5.53 5.53 0 00.26-1.14v-.06c0-.014.002-.028.005-.044l.014-.06a.08.08 0 00.002-.016v-.04l.008-.033.018-.035c.187-.452.324-.907.4-1.335l.001-.051.01-.06.04-.262c.025-.186.043-.366.053-.542zm-7.787-5.972c.834 0 1.537.095 2.154.284l.029.017.03.03.081.03c1.041.396 1.606.823 2.207 1.555l.202.25.107.13c.106.125.206.23.338.35l.16.156.033.032a.76.76 0 00.086.068l.094.074.11.09.115.099a3.635 3.635 0 01.668.79l.068.092.04.08c.42.827.436 1.522.252 2.536l-.001.05a5.258 5.258 0 01-.282 1.016l-.047.122-.017.04a.663.663 0 00-.062.252.524.524 0 00-.018.146v.106a3.736 3.736 0 01-.227.954 4.663 4.663 0 01-.72 1.381c-.461.662-1.002 1.126-1.658 1.409-.133.049-.245.146-.353.296a.884.884 0 00-.15.42v.155c.052.621.048 1.11-.042 1.622-.153.792-.413 1.337-.885 2.051l-.115.152-.084.106-.091.113a10.64 10.64 0 01-.739.813c-.457.452-.906.8-1.33 1.002a2.264 2.264 0 01-.32.125l-.151.042-.14.02c-.248.04-.496.06-.743.06h-.566l-.516.023-.336.018-.133.01-.052.006a.363.363 0 01-.016.005l-.036.009-.048.01-.034.007a.176.176 0 00-.053.021l-.019.01c-.936.27-1.882.403-3.066.403h-.147l-.22-.004-.148-.004-.232-.008-.163-.008-.173-.008-.38-.022-.71-.046h-.131l-.177-.023-.27-.038-.104-.011-.199-.023c-.708-.088-1.179-.2-1.751-.454l-.09-.044-.056-.038c-1.125-.632-1.716-1.383-2.32-2.686l-.083-.18a18.074 18.074 0 01-.083-.189l-.046-.092-.044-.09a1.572 1.572 0 01-.072-.177l-.041-.08a4.177 4.177 0 01-.202-.48l-.034-.094-.036-.107-.073-.223-.02-.04-.008-.03.003-.022c-.433-1.543-.287-2.526.557-3.745l.085-.125.022-.027.08-.102.1-.13.183-.232.148-.186.064-.078.06-.07.058-.066.056-.062.058-.061.06-.062.064-.064a.55.55 0 00.108-.223l.02-.357v-.243c.034-.81.315-1.434.813-2.15a.176.176 0 00.025-.033l.012-.02.022-.037.011-.017.043-.084.037-.052.067-.136c.081-.165.155-.326.213-.476l.071-.218.063-.185.029-.078.012-.038.008-.03.017-.097c.04-.41.137-.815.292-1.227l.038-.075.022-.058.058-.168.02-.05c.16-.509.344-.886.704-1.327l.13-.148.12-.098c.779-.7 1.626-.98 2.627-1.04h.203c.477 0 1.022.17 1.656.448l.036.015a.573.573 0 00.328.026l.041-.007.093-.02.097-.035c.138-.053.28-.115.427-.185l.11-.053.202-.112.15-.082c.08-.043.158-.083.236-.121.54-.267 1.057-.437 1.62-.496.02 0 .037-.002.064-.008l.042-.009.014-.002h.01l.02-.003.045-.007.026-.002.062-.006.196-.014.082-.008c.094-.012.202-.022.322-.03l.149-.01.16-.007.168-.006.176-.004.184-.003zm.136.14h-.324l-.182.003-.088.001-.17.006c-.029 0-.056.002-.083.003l-.157.007-.148.01-.136.01-.124.012-.057.007-.086.008-.16.012-.094.008-.049.005-.045.007-.015.002-.059.012a.303.303 0 01-.06.006c-.538.056-1.04.221-1.566.48a8.51 8.51 0 00-.314.164l-.066.037-.204.114a6.21 6.21 0 01-.665.285l-.102.021-.045.008a.922.922 0 01-.154.014.699.699 0 01-.293-.067c-.614-.269-1.145-.434-1.596-.434h-.199c-.967.057-1.785.328-2.539 1.005l-.113.093-.12.138c-.347.423-.523.786-.68 1.285l-.023.058-.038.11-.026.073-.018.045-.037.073a4.67 4.67 0 00-.281 1.19l-.014.079-.01.045-.011.041-.038.106-.03.089-.104.315a6.988 6.988 0 01-.269.59l-.023.044-.036.053-.04.08-.014.018-.036.063a.224.224 0 01-.037.048c-.476.686-.748 1.29-.78 2.065v.244l-.021.37a.69.69 0 01-.141.296l-.096.096-.058.061-.057.062-.056.063-.058.067-.093.113-.07.086-.257.327-.121.157-.08.1-.13.192c-.778 1.151-.904 2.085-.488 3.577v.024l.017.034.113.337.032.093.05.135c.058.148.118.28.186.407l.004.01c.018.053.042.11.071.174l.02.043.068.135.044.1.083.185.041.09.083.175c.565 1.17 1.138 1.862 2.183 2.45l.053.035.079.039c.555.245 1.015.355 1.713.441l.196.023.103.011.098.014.34.046h.126l.91.058.183.01.334.016.155.006.15.004.073.002.218.003.146.001c1.171 0 2.103-.131 3.018-.396l.011-.006a.337.337 0 01.075-.028l.03-.007.072-.015.032-.008.025-.004.07-.007.094-.008.197-.011.682-.031h.569c.24 0 .48-.02.72-.06l.134-.018.14-.04c.097-.028.196-.068.298-.116.408-.194.845-.533 1.293-.975.258-.256.504-.53.728-.803l.09-.111.043-.053.078-.1.073-.097c.461-.698.713-1.228.863-1.998.087-.498.091-.975.04-1.592v-.169c.025-.2.076-.356.175-.492.123-.17.256-.285.415-.344.627-.27 1.148-.717 1.597-1.36.304-.4.542-.856.702-1.348.106-.263.172-.552.218-.916v-.098c0-.07.006-.112.02-.162 0-.079.015-.141.056-.248l.03-.079.047-.12a5.18 5.18 0 00.274-.976v-.052c.182-1 .166-1.668-.237-2.462l-.034-.07-.064-.086a3.323 3.323 0 00-.647-.765 4.91 4.91 0 00-.17-.144l-.137-.11a.835.835 0 01-.097-.077l-.042-.04-.154-.151a3.584 3.584 0 01-.349-.36l-.045-.055-.266-.329C23.87 7.414 23.31 7 22.233 6.602l-.025-.016-.028-.027-.085-.025c-.545-.155-1.16-.238-1.875-.247zm8.178 11.83c-.024.147-.05.294-.08.44l-.18.254-.086.117c-.343.463-.708.86-1.105 1.2a1.096 1.096 0 00-.338.646l-.027.254-.015.115-.016.098-.017.09-.007.031c-.23 1.254-.685 2.209-1.313 3.139l-.14.206c-.199.205-.404.403-.617.594l.613-.895c.616-.912 1.06-1.848 1.287-3.078l.007-.029.017-.087.01-.063.01-.068.014-.12.022-.208c.046-.294.184-.566.395-.754a7.15 7.15 0 001.165-1.288l.086-.118c.111-.155.216-.315.316-.48zM19.922 7.169c.71 0 1.293.075 1.787.224l-.011-.004h.031l.025.005c.956.356 1.395.695 1.96 1.404l.151.184.08.096.037.043.07.078c.045.05.088.095.134.14l.072.067.038.035.083.073.04.04.034.032.035.031.086.073.124.099c.254.196.39.318.555.537.053.07.104.144.155.228l.04.08c.273.537.29 1.013.17 1.763l-.02.112v.05c-.039.282-.13.579-.271.903l-.024.05a1.063 1.063 0 00-.032.078l-.02.058-.019.063a2.683 2.683 0 00-.01.036l-.019.078-.033.142-.028.14-.008.042-.003.025v.104c-.02.237-.079.5-.166.757a3.96 3.96 0 01-.557 1.1c-.416.595-.895.964-1.517 1.169-.284.1-.53.276-.672.487l-.04.08-.014.018-.058.057c-.074.083-.101.326-.089.707l.002.036.007.155.01.163.022.438.01.224c.01.33-.002.576-.047.81-.122.616-.327 1.044-.743 1.689l-.028.04-.066.089-.08.104-.045.056c-.172.216-.36.432-.557.634-.347.353-.686.625-1.008.783-.09.044-.178.08-.262.104l-.066.021-.083.02a2.2 2.2 0 01-.486.042h-.387l-.043.002-.086.004a3.02 3.02 0 00-.151.015h-.038l-.073.002-.324.012-.266.012-.175.01-.148.012-.093.01-.056.006-.05.007-.115.02a1.66 1.66 0 00-.333.1c-.423.243-1.066.36-2.043.385l-.2.003-.21.002c-.695 0-1.426-.037-2.092-.1l-.09-.001-.486-.06-.176-.02-.162-.021-.15-.02a7.657 7.657 0 01-.206-.034l-.127-.023a3.693 3.693 0 01-.889-.29l-.084-.041c-.911-.505-1.39-1.138-1.903-2.274l-.166-.373-.085-.182-.048-.107a4.69 4.69 0 01-.332-.872l.002-.022c-.352-1.227-.263-1.868.404-2.813l.036-.034.061-.078a2.09 2.09 0 00.14-.201l.115-.15a8.37 8.37 0 011-1.095l.07-.065c.037-.037.06-.08.06-.112l.004-.022a.206.206 0 000-.136l-.104-.31-.02-.103-.009-.053-.006-.047-.004-.047-.003-.063v-.142c.013-.418.15-.794.4-1.22l.065-.11.157-.25a.43.43 0 01.008-.012l.059-.078.024-.033.006-.01.047-.09c.044-.058.104-.166.167-.296l.048-.101.048-.106.047-.11.023-.054.043-.107.039-.104.008-.031.04-.126.123-.37.013-.045.011-.047.006-.026.01-.057.012-.067.02-.125a5.35 5.35 0 01.22-.984l.002-.029.005-.027.013-.03.02-.05.061-.184.018-.05.009-.023.024-.066.065-.176.04-.101.038-.091.037-.082a1.99 1.99 0 01.116-.216L10.693 9a2.69 2.69 0 01.075-.105l.126-.162.063-.063c.563-.503 1.167-.702 1.957-.76h.142c.346 0 .65.085.995.244l.072.034.19.095.054.036.055.029.095.047.04.019.013.005a.783.783 0 00.498.055A8.125 8.125 0 0016.316 8l.076-.038c.634-.376 1.173-.603 1.79-.672l.018-.003.053-.013a.067.067 0 01.026-.002.622.622 0 01.082-.013l.057-.006.173-.013.087-.01.46-.032.211-.012c.203-.01.385-.016.573-.016zm0 .14c-.277 0-.544.011-.886.035l-.345.024-.038.004-.22.019-.053.005-.043.005-.04.007a.19.19 0 00-.044.008l-.022.005-.028.006a.12.12 0 01-.02 0c-.577.066-1.1.286-1.723.655l-.08.04a8.25 8.25 0 01-1.278.487c-.2.044-.42.02-.585-.062a.656.656 0 01-.106-.047l-.114-.061-.054-.036-.08-.04-.146-.07-.1-.047a2.08 2.08 0 00-.861-.196h-.137c-.756.055-1.331.244-1.865.72L11 8.824l-.062.082-.055.07-.025.035-.047.066-.021.032-.04.065-.038.066c-.03.057-.06.118-.09.187l-.036.088a5.624 5.624 0 00-.019.048l-.04.105-.067.183a.941.941 0 00-.008.02l-.017.048-.04.122-.022.064a1.76 1.76 0 01-.017.044l-.013.032v.025l-.003.02a5.2 5.2 0 00-.22.971l-.015.095-.013.082-.013.07-.013.06-.014.054c-.005.017-.01.035-.017.052l-.104.313-.044.137-.015.053a5.293 5.293 0 01-.038.103l-.043.107-.022.054-.046.107a6.772 6.772 0 01-.023.054l-.048.103-.047.097c-.061.125-.12.228-.163.284l-.04.08a.47.47 0 01-.032.05l-.073.096-.177.284-.041.07c-.24.408-.369.764-.38 1.153v.137l.001.058.004.041.006.043.008.05.019.094.1.296a.342.342 0 01.01.192l-.007.023-.001.016a.31.31 0 01-.08.159l-.022.023-.072.067a8.23 8.23 0 00-.984 1.078l-.11.143c-.043.07-.085.132-.146.21l-.068.084-.032.03c-.592.84-.704 1.418-.437 2.473l.041.154.022.08-.002.02c.088.305.19.574.322.834l.018.042.115.248.166.373c.502 1.112.964 1.722 1.84 2.208l.08.04c.35.16.632.244 1.05.312l.136.021.148.02.159.02.172.021.48.06h.087a22.421 22.421 0 002.29.099l.196-.004c.064-.002.127-.003.188-.006l.178-.008c.755-.042 1.271-.155 1.623-.356a1.73 1.73 0 01.442-.125l.073-.012.083-.01.096-.01.15-.012.178-.01.21-.01.461-.017h.032c.135-.016.22-.02.334-.02h.342c.2-.001.326-.01.453-.038l.076-.019.122-.04c.06-.02.12-.046.183-.077.305-.15.633-.412.97-.755a8.067 8.067 0 00.59-.678l.08-.102.036-.048.054-.075c.406-.63.604-1.043.722-1.639.046-.24.055-.498.04-.862v-.026l-.044-.833-.004-.135c-.01-.387.022-.627.129-.745l.052-.053.04-.077c.154-.228.4-.412.686-.525l.062-.023c.593-.196 1.048-.546 1.447-1.117.24-.335.42-.689.54-1.064.083-.248.14-.5.158-.72v-.06l.001-.03a.844.844 0 01.013-.104l.026-.131.027-.116.023-.094.022-.081.022-.071c.022-.067.045-.122.075-.181.134-.31.223-.595.258-.855l.001-.05.044-.28c.089-.635.057-1.055-.18-1.522l-.037-.076a2.477 2.477 0 00-.144-.212 2.2 2.2 0 00-.425-.428l-.142-.112-.092-.073-.048-.04-.06-.053-.036-.033-.055-.054-.085-.075a3.963 3.963 0 01-.076-.07l-.07-.07a3.993 3.993 0 01-.213-.232l-.082-.097-.252-.309c-.462-.558-.856-.86-1.591-1.158l-.2-.077h-.025l-.02-.002c-.481-.145-1.05-.218-1.747-.218zm.101-2.29c.66 0 1.255.055 1.789.167.171.09.347.185.52.285-.649-.2-1.418-.302-2.309-.302-.501 0-1.02.032-1.435.08l-.175.018-.1.013-.089.012-.04.006-.079.012-.064.013a.29.29 0 01-.06.006c-.918.111-1.61.403-2.536.935l-.037.018a.68.68 0 01-.28.07.903.903 0 01-.334-.066 4.288 4.288 0 00-1.657-.335h-.298l-.177.015a5.4 5.4 0 00-.885.146 5.02 5.02 0 00-1.588.693c-.193.127-.378.27-.556.43l-.175.151-.182.22c-.377.455-.573.824-.77 1.358l-.058.166-.03.087a.914.914 0 01-.088.26l-.038.073a5.655 5.655 0 00-.34 1.416v.02l-.006.03-.026.065-.026.077-.05.161-.035.103-.024.062-.02.05-.038.096-.038.086-.034.074-.016.031-.014.02-.009.005-.056.096-.007.016-.01.016-.035.05a.338.338 0 00-.015.026l-.085.125c-.515.779-.803 1.43-.878 2.309-.02.13-.055.264-.107.418l-.122.3a.884.884 0 01-.116.203l-.056.075-.039.045a3.752 3.752 0 00-.072.09l-.15.192-.046.057-.033.041-.135.156-.022.027-.13.171c-1.026 1.468-1.222 2.729-.702 4.543l.041.123c.12.401.263.777.442 1.13l.059.112.05.097c.023.05.042.093.055.134l.04.089.116.246.07.15.069.14.065.13.064.124.063.117.062.112.032.055.064.108.065.106.034.053-.01-.015a12.066 12.066 0 01-.67-.92l-.01-.022-.074-.158-.121-.26c-.017-.05-.039-.1-.07-.161l-.08-.155L5.088 22a7.042 7.042 0 01-.391-1.03l-.042-.124c-.533-1.86-.33-3.167.723-4.674l.122-.16.023-.03.026-.032.094-.107.04-.047.023-.028.056-.069.136-.176c.04-.05.075-.093.11-.133l.05-.068a.765.765 0 00.103-.175l.12-.297c.048-.141.081-.268.098-.383.08-.94.397-1.627.964-2.465l.019-.027a.37.37 0 01.03-.05l.023-.017.01-.039.073-.114.011-.011.025-.053.035-.077.018-.043.038-.093.039-.099.016-.045.084-.265c.014-.042.028-.079.043-.112l-.006.013v-.013c.062-.513.161-.957.316-1.372l.037-.095.04-.08a.81.81 0 00.078-.231c.237-.704.439-1.127.886-1.667l.191-.23.275-.24a5.172 5.172 0 012.116-1.076 5.38 5.38 0 01.826-.141l.173-.016.094-.008h.304c.59 0 1.169.119 1.714.346a.748.748 0 00.277.055c.064 0 .136-.02.215-.056l.031-.014c.937-.539 1.645-.837 2.598-.952a.27.27 0 00.062-.008l.032-.007.018-.003h.015l.067-.013.08-.012.095-.012.109-.012.122-.013c.42-.048.944-.08 1.451-.08zm.718 11.47l.034.008c.345.16.63.3.69.36.02 0 .02.02.02.04-.04.101-.101.161-.162.241-.081.1-.162.2-.264.361-.122.24-.162.461-.183 1.002-.02.641 0 1.022.02 1.283.02.26.02.42-.02.66-.101.502-.304.843-.589 1.263-.345.522-.71 1.083-1.3 1.263-.049.016-.058.02-.133.02h-.194c-.143.001-.348.005-.668.02-.772.02-1.178.04-1.503.1-.346.06-.528.14-.711.22-.163.06-.305.12-.61.181-.162.04-.426.08-1.3.08-.914 0-1.462 0-2.193-.08-.996-.12-1.503-.16-1.828-.34-.74-.393-1.072-1.065-1.56-2.147l-.106-.238c0-.02.02-.04.02-.02.02.02.061.02.082.04.02 0 .04.02.08.02h.204c.04.1.081.18.183.22.101.04.203.06.304.06.102 0 .224 0 .325-.02.061 0 .122.02.143.08.101.24.223.401.406.421h.04c.041 0 .082 0 .163-.06s.223-.02.284.06a.56.56 0 00.122.1c.183.18.65.281 1.016.281.203 0 .386-.02.508-.08.162-.08.162-.2.142-.24l-.04-.241s.02-.02.02 0c.02.04.04.12.121.12h.02c.102 0 .265.04.305.14.02.06.041.1.061.14.061.1.203.221.447.221h.02c.305 0 .529-.1.67-.28 0-.02.021-.02.021-.04.061-.08.224-.08.285-.02.08.08.182.1.284.1h.06a.436.436 0 00.326-.2.723.723 0 00.122-.281c0-.04.06-.04.081-.02.06.06.142.1.284.1.041 0 .061 0 .102-.02.264-.06.386-.26.447-.501 0 0 .02-.02.02 0 .061.08.183.16.386.16h.04a.35.35 0 00.265-.14.67.67 0 00.122-.401c0-.06.04-.1.101-.12a1.56 1.56 0 00.495-.348l.054-.073c.02-.04.06-.08.101-.08.163-.04.244-.06.305-.1.06-.02.101-.04.223-.06.996-.14 1.178-.18 1.402-.321.325-.22.345-.501.345-.782.02-.24.02-.5.224-.821.06-.12.142-.26.223-.421.142-.26.345-.621.487-.822.041-.04.102-.06.143-.04zm-7.746 4.216l.752.04.02.18c.02.201 0 .462-.142.642-.102.14-.264.2-.508.2-.163 0-.224-.06-.244-.1-.122-.2 0-.66.122-.962zm-1.056-1.583c0 .06-.02.14-.04.22 0 .101-.021.241-.041.422-.041.34-.061.781 0 1.382.02.16.04.341.06.521-.04.02-.182.06-.426.06-.366 0-.711-.1-.813-.2l-.02-.02c-.081-.06-.142-.12-.142-.24 0-.04.02-.08.06-.14a.45.45 0 01.082-.12c.061-.081.142-.181.203-.302.224-.38.305-.48.407-.64l.02-.04c.06-.081.142-.181.244-.362.08-.12.162-.22.203-.3.101-.12.162-.2.203-.24zm2.823 1.323c.02.2.02.761-.162.982-.04.06-.102.08-.142.1-.061 0-.102 0-.143-.04-.142-.125-.161-.468-.163-.736v-.206c.224-.06.488-.1.61-.1zm-5.26-.541c.195.105.5.149.94.158l.197.002c.02-.02.06-.02.101-.02-.02.14-.182.521-.446.882-.224.3-.346.38-.366.38-.102-.02-.203-.26-.284-.52-.041-.1-.061-.2-.082-.28-.06-.201-.06-.442-.06-.602zm3.107-.661a.76.76 0 01.266.042l.08.038c.06.02.142.1.142.26-.02.22-.122.541-.285.842-.162.32-.345.601-.467.761-.102-.26-.284-.881-.223-1.382v-.04c.02-.16.06-.301.142-.401.04-.08.183-.12.345-.12zm3.027 1.002v.38c-.02.2-.082.461-.285.501-.081.02-.142 0-.162-.04-.142-.12-.163-.5-.142-.761.08 0 .203-.02.345-.04.081-.02.162-.04.244-.04zm.772-.14c.02.22.04.52-.041.64-.02.02-.04.04-.081.04-.102 0-.183-.02-.224-.08-.101-.12-.081-.36-.06-.5zm-7.618-.462c.143.06.305.1.468.12-.041.261.02.642.06.762 0 .1.02.14.041.2l-.02.02h-.386c-.04 0-.081 0-.102-.04a.473.473 0 01-.04-.18 2.56 2.56 0 01-.02-.882zm-.589-.16l.102.04c.081.02.142.04.183.06-.02.2-.04.401-.04.601 0 .067.008.143.02.216l.02.105h-.122c-.02 0-.04 0-.061-.02l-.081-.08c-.061-.1-.061-.2-.061-.3 0-.201 0-.402.04-.622zm5.261-.1c.224-.06.488-.08.569-.02.081.1-.081.54-.163.721-.02.08-.06.14-.08.2-.062.02-.265 0-.468-.04zm.975-.02c.061-.04.183-.04.264.02.122.1.163.22.122.36-.02.06-.06.261-.081.381l-.569-.02c.04-.18.081-.34.122-.48.04-.141.102-.241.142-.261zm1.056-.1c.041.16.041.44.041.62l-.447.141c.02-.18.061-.42.061-.581 0-.12.04-.14.04-.16h.021zm-2.518-10.1c.203 0 .426.1.67.24.305.16.67.36 1.138.38.203 0 .487-.06.771-.14l.177-.021c.796-.093 1.95-.165 2.667.282.731.44.874 1.423.934 2.305.02.26 0 .58-.02.921l-.02.315c-.045.836-.025 1.631.589 1.81.284.08 1.137.34 2.051.741.082.04.082.14.02.2-.02.02-.04.02-.06.04-.061.04-.122.1-.183.16-.04.061-.102.061-.162.041-.183-.1-.468-.22-.772-.34h-.02c-.021-.02-.021-.02-.041-.02l-.172-.067a5.134 5.134 0 00-.722-.214c-.65-.12-1.117.24-1.28.36-.203.16-.243.24-.264.361-.02.06-.04.12-.162.3-.264.341-.406.442-.549.522a.814.814 0 00-.365.34c-.122.2-.122.401-.102.662v.5c0 .482-.02.702-.04.822 0 .06-.02.08-.02.1v.02l-.042.049c-.05.05-.126.107-.203.152-.06.04-.121 0-.142-.06l-.02-.06.014-.087c.006-.062.006-.134.006-.214v-.08c0-.04.02-.1.02-.16.02-.12.041-.28-.101-.341-.142-.06-.325-.04-.467 0-.04 0-.061.02-.102.02h-.02c-.081.02-.325.04-.406.04l-.305.02c-.081-.02-.142.02-.203.06l-.061.06c-.02.04-.061.04-.102.02-.162-.14-.406-.12-.548-.04 0 .02-.04.02-.061.06-.02.02-.04 0-.04 0-.224-.24-.793-.08-.894-.04l-.041.02c-.02 0-.04.02-.04.04v.04l-.062-.073a.492.492 0 00-.142-.107.957.957 0 00-.67-.08c-.081.02-.163-.04-.223-.1-.02-.02-.061-.04-.082-.06-.08-.04-.162-.02-.243.04-.082.06-.183.02-.224-.06-.06-.12-.122-.22-.223-.28-.061-.04-.142-.06-.203-.081a.848.848 0 00-.447-.02c-.02.02-.061.02-.082.04-.06.04-.162.04-.203-.02-.06-.04-.122-.1-.203-.12a.6.6 0 00-.325-.02c-.04 0-.081 0-.122-.04a.736.736 0 00-.365-.14.662.662 0 00-.346.02c-.04 0-.06 0-.08-.02-.102-.12-.265-.181-.427-.201h-.143c-.04 0-.06-.04-.04-.06a7.64 7.64 0 01.934-1.002c.67-.581.711-.762.69-1.102v-.04c0-.22-.08-.381-.162-.521-.06-.14-.122-.26-.142-.461-.02-.12.163-.521.244-.622.122-.14.203-.28.264-.38.04-.08.081-.16.122-.2.304-.402.406-.722.528-1.143.04-.14.101-.32.162-.501.102-.28.122-.46.143-.641.02-.2.06-.401.182-.762.264-.721.346-.882.407-.942.243-.24.528-.38 1.137-.42zm-5.14 9.92c.062.04.102.08.163.12l.061.06v.02c-.06.22-.101.46-.101.681 0 .02-.02.02-.02 0-.054-.245-.138-.614-.118-.81zm8.552.1c.02.02 0 .06 0 .1 0 .06-.02.12-.02.2v.3c-.122.04-.244.04-.386.04v-.34c0-.08 0-.2.02-.24l.122-.02c.081-.02.203-.04.264-.04zm-5.403-.461l.066.01c.047.014.097.036.137.05h.02c0 .02.02.02.02.02h.021l.02.02c.02 0 .02.02.02.02l.011.02.015.03.015.03c.041.1.061.22.082.34 0 .04.02.06.08.1-.02.04-.06.101-.1.161-.062.1-.122.18-.163.24h-.02c-.204 0-.407-.02-.59-.04-.101 0-.182-.02-.284-.04l-.122-.02.02-.02.102-.14c.061-.08.122-.18.183-.26.06-.1.142-.2.203-.301.02-.04.061-.08.081-.12l.015-.005c.006-.006.006-.015.006-.015l.02-.02.005-.014c.006-.006.015-.006.015-.006 0-.02.02-.02.02-.02 0-.02.02-.02.041-.02h.061zm-.813-.18c.012.001.02.006.02.02h.021l.04.02c-.02-.02.021.04.021.04.046.074.057.127.069.174l.012.046c-.101.14-.182.28-.284.42-.04.06-.101.14-.142.201l-.081.12a3.286 3.286 0 01-.224-.06l-.183-.06c-.02 0-.02 0-.04-.02 0-.013-.01-.027-.021-.04l-.02-.02c.02-.04.04-.08.061-.14l.122-.24c.081-.141.183-.281.325-.382 0 0 .02 0 .02-.02a.288.288 0 01.183-.06zm9.46-2.38l.148.014c.082.02.264.08.427.14.06.02.101.1.06.161-.121.18-.263.44-.426.742-.08.14-.162.3-.223.4-.224.381-.244.722-.264.982-.02.28-.02.401-.203.501-.142.1-.285.12-1.26.26-.162.02-.243.06-.304.081-.02 0-.02 0-.041.02-.06.02-.142-.02-.122-.1 0-.14.02-.3.02-.501v-.501c-.02-.24-.02-.34.061-.461.082-.12.143-.16.244-.24.142-.1.345-.221.65-.622.163-.22.183-.32.224-.42 0-.04.02-.06.142-.141.122-.1.508-.38 1.015-.3zm-10.434 2.28c.06-.04.122-.02.182-.02.061 0 .122 0 .183.02.04.02.061.02.061.02-.162.14-.284.32-.406.521l-.163.32-.02.04c-.06-.02-.101-.02-.162-.04l-.163-.06c-.02-.02-.04-.02-.06-.04.06-.1.121-.18.162-.28.081-.12.162-.24.264-.36.04-.04.081-.101.122-.121zm-.666-.21l.045.005.032.005a.43.43 0 01.264.14c-.095.107-.18.223-.258.341l-.108.18c-.04.08-.102.14-.122.22-.06-.02-.101-.04-.162-.06l-.122-.08s-.04-.02-.04-.04h-.021c.02-.04.04-.08.04-.1.02-.06.061-.12.102-.18.061-.1.142-.221.203-.321a.24.24 0 01.102-.1l.045-.01zm9.794-14.23c.183.033.365.07.546.112l-.219.019-.206.02-.115.01-.15.016-.123.015-.069.01-.058.01h-.01l-.094.016a.315.315 0 01-.05.003c-.75.084-1.414.3-2.185.653a1.673 1.673 0 01-1.194.127 5.896 5.896 0 00-1.322-.158h-.342c-.487.018-1 .107-1.544.257a6.13 6.13 0 00-2.324 1.305l-.237.213-.243.28c-.482.587-.701 1.001-.964 1.705l-.064.175-.033.092a1 1 0 01-.032.106l-.022.058-.093.272c-.172.51-.286.995-.338 1.458l-.005.02c-.04.097-.08.214-.099.29l-.008.03a.743.743 0 01-.037.093l-.032.067-.006.017-.007.016-.053.087-.003.012a.227.227 0 01-.037.073l-.01.011-.089.132c-.537.811-.866 1.513-1.015 2.457-.02.213-.093.419-.214.633l-.328.566a4.558 4.558 0 01-.022.033l-.04.055a.752.752 0 01-.084.098l-.16.196c-.5.717-.82 1.384-1 2.087a12.8 12.8 0 01-.047-.42l.09-.246c.193-.5.464-.996.827-1.517l.169-.207a.738.738 0 00.087-.103l.042-.06.324-.56c.11-.196.176-.381.194-.575.161-1.015.52-1.753 1.108-2.624l.036-.05.013-.02.012-.04.053-.085.006-.016.016-.037.034-.074a.426.426 0 00.024-.067l.01-.038.027-.087.032-.094.036-.092-.004.01.013-.108c.059-.438.17-.894.33-1.37l.045-.13.045-.134.035-.094.014-.047.008-.028.034-.094.065-.18c.27-.723.496-1.15.993-1.755l.25-.288.244-.22a6.295 6.295 0 012.389-1.34 6.942 6.942 0 011.586-.264h.345c.44 0 .913.057 1.362.163.369.095.754.055 1.082-.116.789-.361 1.47-.582 2.248-.669.02 0 .04-.002.075-.008l.054-.01h.018a1.32 1.32 0 01.026-.005l.061-.01.073-.01.086-.01.152-.015zm-6.65 10.071a1.35 1.35 0 00-.406.02c-.02 0-.061.02-.082.02-.02 0-.02.02-.04.02-.041.02-.061.04-.102.06l-.02.02-.02.02a.16.16 0 00-.082.08c-.122.181-.142.381-.183.622-.02.12-.04.26-.08.44-.021.061-.021.101-.021.141 0 .04 0 .1-.04.2l-.021.04c0 .04-.02.08-.04.12-.021.04-.021.061-.041.101l-.02.04-.062.12c-.142.321-.101.501-.06.662.02.02.02.04.02.06.04.1.101.2.183.28.121.12.284.2.406.24h.122c.65 0 2.092-1.021 2.295-1.923.04-.2.06-.521-.305-.842l-.02-.02s0-.02-.02-.02c-.04-.02-.061-.06-.102-.08-.081-.04-.162-.1-.264-.14h-.02c-.02-.02-.061-.02-.082-.04-.02 0-.04 0-.06-.02 0 0-.02-.02-.041-.02 0-.02-.02-.02-.02-.02-.082-.04-.183-.06-.305-.1a2.809 2.809 0 00-.467-.08zm.02.441c-.06.08-.101.14-.162.28-.163.381-.183.582-.183.762 0 .08 0 .16-.02.24a.706.706 0 01-.082.181c-.101.22-.223.521-.183.922-.08-.04-.203-.12-.223-.18 0-.02 0-.04-.02-.06-.02-.12-.041-.201.04-.381.203-.481.244-.602.264-.722 0-.02 0-.06.02-.08.041-.18.062-.36.082-.48.02-.201.04-.322.122-.422.02-.04.101-.06.203-.06zm7.17-6.092c.935-.1 1.747-.2 2.58.1.386.14 1.178.561 1.381.962.142.28.386.501.874.942.203.2.364.317.482.409l.066.052c.163.14.203.16.264.26.163.341.102.682.02 1.143-.05.25-.101.39-.152.533l-.03.088c-.082.18-.163.4-.244.802-.03.12-.038.217-.049.31l-.012.09c-.02.18-.04.28-.102.501-.06.16-.162.441-.386.742-.182.24-.507.661-.914.701h-.142c-1.178-.601-2.194-1.042-2.56-1.142-.405-.12-.365-1.002-.304-1.764.02-.34.04-.68.02-.961-.06-.982-.223-2.045-1.096-2.586-.508-.32-1.178-.4-1.828-.4.08-.04.162-.09.25-.141l.135-.08c.366-.22.833-.48 1.3-.52a3.23 3.23 0 01.447-.041zm-1.747 1.703c-.751-.22-1.36.22-1.482.321a.224.224 0 00-.041.32c.081.1.223.12.325.04.02 0 .122-.08.284-.16.102-.04.163.06.102.14-.02.04-.061.08-.081.12l-.02.021v.04l-.02.04c-.021 0-.021.02-.021.02-.02 0-.02.02-.02.02-.02.04-.082.12-.122.2 0 0-.02.02-.02.04-.021.02-.021.04-.041.06l-.127.22c-.063.109-.121.21-.158.282-.183.34-.203.902-.101 1.383.02.08-.061.16-.142.12a.396.396 0 01-.183-.18v-.099a4.15 4.15 0 00-.04-.503v-.02a.96.96 0 010-.34v-.02c.08-.421.1-.542.121-.582.06-.12 0-.24-.102-.3-.101-.06-.243 0-.304.1-.02.06-.061.14-.163.701v.02c-.04.2-.02.341 0 .481v.02c.03.2.038.32.04.4v.081c0 .08 0 .12.041.22.204.462.793.562 1.118.622.122.02.304.06.528.06.304 0 .67-.06.995-.32.163-.12.264-.301.447-.622.305-.52.467-.821.447-1.222 0-.521-.264-.902-.345-1.022-.102-.14-.386-.561-.915-.702zm-3.839-.26c-.142 0-.264.02-.386.06-.06.02-.121.04-.162.06l-.102.06c-.06.04-.101.08-.142.12-.183.16-.244.381-.325.622-.081.24-.183.56-.447 1.002-.04.06-.06.12-.101.18-.203.34-.325.521-.264.802.101.42.63.58.893.58h.02c.366 0 .488-.04 1.016-.16.549-.14.691-.64.752-1.022l.02-.16c.122-.801.183-1.162.183-1.343-.06-.38-.183-.52-.264-.58a1.18 1.18 0 00-.69-.221zm-.182.46a3.897 3.897 0 01-.143.321c-.121.281-.243.602-.304.722-.102.2-.183.32-.264.42-.082.12-.143.201-.183.341-.081.22-.102.481-.04.762-.143-.02-.366-.12-.407-.24-.02-.1.04-.18.203-.461.04-.06.061-.12.102-.18.284-.482.406-.843.487-1.103.102-.28.142-.4.285-.501.101-.02.182-.06.264-.08zm-9.604 5.528c.01-.447.045-.887.103-1.32l-.047.404.499-.793a.998.998 0 00.168-.447 6.893 6.893 0 01.66-1.917l.053-.104.051-.096.026-.046.05-.09.052-.088.055-.091.059-.095.1-.158.167-.253.051-.073.008-.013.013-.016.056-.163a8.623 8.623 0 01.375-1.58l.053-.152.018-.07V8.65c.09-.118.183-.233.278-.347l-.067.199a.73.73 0 01-.01.04l-.012.032-.016.027v.1l-.002.021-.023.088c-.2.55-.341 1.126-.426 1.722l-.058.171-.003.015a.09.09 0 01-.009.02l-.007.01v.013l-.025.025-.01.007-.04.06-.126.192-.105.163-.09.143-.028.045-.052.088-.05.087-.049.09-.05.094-.053.102c-.3.584-.52 1.2-.643 1.865a1.153 1.153 0 01-.195.515l-.53.845-.144.221c-.02.282-.03.567-.03.853z" fill="#FFF"/></g>`;
  },
  plainIcon: c => {
    return `<path fill-rule="evenodd" fill="${
      c ? c : this.color
    }" d="M16 0c8.837 0 16 7.163 16 16s-7.163 16-16 16S0 24.837 0 16 7.163 0 16 0zm12.445 14.517l-.067.166-.007.03v.04c-.06.447-.16.903-.3 1.36a6.629 6.629 0 01-1.004 1.94 6.51 6.51 0 01-1.306 1.367c-.132.11-.24.239-.306.368a1.66 1.66 0 00-.13.467l-.014.205-.015.173-.01.101-.011.094-.012.088-.014.085-.016.086-.008.044c-.194 1.066-.56 1.83-1.147 2.717l-.608.88c-.882 1.16-1.914 1.918-3.144 2.302l-.367.112-.272.037c-.392.065-.767.1-1.106.1h-.508l-.31.02c-.223 0-.435.04-.672.125-.856.268-1.882.405-3.138.415h-.229l-.251-.002-.17-.004-.265-.008-.28-.012-.302-.015-.801-.048c.192.07.387.136.584.198l.209.01.303.015.19.009.27.01.174.003.254.004.169.001c1.338 0 2.426-.14 3.335-.425a1.79 1.79 0 01.625-.116l.31-.02h.503c.349 0 .732-.036 1.13-.101l.283-.04.276-.083c1.31-.384 2.403-1.171 3.332-2.393l.612-.885c.576-.872.944-1.628 1.148-2.657l.04-.209.015-.087.013-.089.012-.092.01-.1.01-.107.02-.253.005-.073c.018-.144.055-.277.115-.415.053-.104.147-.216.262-.31a6.664 6.664 0 001.335-1.4 6.785 6.785 0 001.027-1.985l.046-.155.09-.338c.028-.113.054-.226.077-.339l.059-.332-.006-.076-.047-.403zm-.574-2.398l-.021.263-.033.275-.04.262-.009.06v.051a6.532 6.532 0 01-.401 1.335l-.018.035-.008.033v.047l-.016.07a.232.232 0 00-.004.043v.06a5.53 5.53 0 01-.26 1.14c-.19.56-.45 1.08-.773 1.544l-.07.098a5.718 5.718 0 01-1.224 1.267c-.2.139-.373.34-.508.585-.117.212-.18.442-.19.69l-.002.067c0 .291-.033.578-.1.907a5.912 5.912 0 01-.574 1.628l-.049.092-.048.088-.049.086-.052.089-.056.094-.1.16-.078.123-.445.639c-.794 1.084-1.698 1.763-2.782 2.074l-.063.021-.03.007-.04.01-.069.02a.444.444 0 01-.122.02l-.024.003-.06.02a4.83 4.83 0 01-.911.077h-.544l-.11.004-.237.013-.096.003h-.029c-.085 0-.163.006-.251.02l-.08.015-.087.018-.098.024-.174.046c-.926.27-1.903.398-3.128.398h-.153l-.153-.003-.23-.005-.159-.005-.25-.01-.366-.02-.308-.018-.632-.04h-.106l-.086-.018-.174-.023-.068-.008-.06-.005-.057-.004-.055-.001h-.028c-.931-.093-1.58-.23-2.345-.575l-.12-.059-.096-.057a6.525 6.525 0 01-.271-.161c.23.186.469.365.705.532.668.267 1.282.386 2.12.469h.03l.057.002.06.004.064.006.116.014.096.013.097.02.117.001.837.052.289.016.264.013.246.01.234.006.154.002.23.001c1.24 0 2.23-.13 3.17-.403l.115-.03.1-.026.045-.01.083-.019.074-.013a1.44 1.44 0 01.2-.02h.093l.07-.003.307-.015.053-.002h.639c.302-.006.581-.031.835-.081l.058-.02.05-.003a.627.627 0 00.065-.012l.045-.012.08-.022.032-.008a.675.675 0 01.015-.003l.07-.023c1.116-.32 2.047-1.02 2.861-2.131l.448-.643.15-.237.089-.147.078-.134.049-.088.05-.092a6.058 6.058 0 00.613-1.715 4.71 4.71 0 00.102-.936c0-.248.058-.476.173-.685.125-.226.282-.41.465-.536.45-.344.846-.74 1.181-1.195l.077-.106c.365-.5.654-1.067.862-1.683.146-.454.231-.813.268-1.178v-.068l.002-.016.011-.045a.234.234 0 00.008-.059v-.022l.012-.025c.194-.466.333-.93.413-1.383l.001-.053.03-.184.004-.028.021-.15.019-.143c-.04-.123-.08-.245-.122-.366zm-7.787-5.972l-.19.001-.184.003-.176.004-.169.006-.159.008-.15.009a5.475 5.475 0 00-.321.03l-.082.008-.196.014-.062.006-.026.002-.045.007-.02.004h-.01l-.014.001-.042.009a.275.275 0 01-.063.008c-.564.06-1.082.23-1.621.496a8.103 8.103 0 00-.237.121l-.149.082-.201.112-.11.053a6.02 6.02 0 01-.428.185l-.097.036-.093.019-.041.007a.573.573 0 01-.328-.026l-.036-.015c-.634-.279-1.18-.448-1.656-.448h-.203c-1.001.06-1.848.34-2.627 1.04l-.12.098-.13.148c-.36.44-.543.818-.705 1.327l-.019.05-.058.168-.022.058-.038.075a4.789 4.789 0 00-.292 1.227l-.017.097-.008.03-.012.038-.029.078-.063.185-.07.218c-.06.15-.133.311-.214.476l-.067.136-.037.052-.043.084-.01.017-.023.037-.012.02a.176.176 0 01-.025.032c-.498.717-.779 1.341-.812 2.15v.244l-.02.357a.55.55 0 01-.109.223l-.064.064-.06.062-.058.06-.056.063-.058.065-.06.071-.064.078-.148.186-.182.231-.1.131-.081.102a9.357 9.357 0 01-.022.027l-.085.125c-.844 1.219-.99 2.202-.557 3.745l-.003.021.007.031.02.04.074.223.036.107.034.094.016.045c.059.16.119.3.186.435l.041.08c.016.048.04.108.072.177l.044.09.046.092.083.188.083.181c.604 1.303 1.195 2.054 2.32 2.686l.057.038.089.044c.572.253 1.043.366 1.751.454l.2.023.104.011.27.038.176.022h.13l.712.047.38.022.172.008.163.008.232.008.148.004.22.003h.147c1.184 0 2.13-.132 3.066-.403l.02-.009a.176.176 0 01.052-.021l.034-.008.048-.01.036-.008a.363.363 0 00.016-.005l.052-.006.133-.01.336-.018.516-.022h.566c.247 0 .495-.02.742-.061l.14-.02.152-.042c.105-.032.211-.073.32-.125.424-.202.873-.55 1.33-1.002.262-.259.511-.536.739-.813l.091-.113.084-.106.115-.152c.472-.714.732-1.259.885-2.051.09-.513.094-1 .042-1.622v-.155a.884.884 0 01.15-.42c.108-.15.22-.247.353-.296.656-.283 1.197-.747 1.658-1.409.312-.41.557-.879.72-1.38.11-.272.178-.572.226-.955l.001-.106a.5.5 0 01.018-.146.663.663 0 01.062-.252l.017-.04.047-.122c.136-.363.23-.697.282-1.015v-.051c.185-1.014.169-1.709-.25-2.536l-.041-.08-.068-.091a3.29 3.29 0 00-.268-.376 3.635 3.635 0 00-.514-.513l-.111-.09-.094-.075a.76.76 0 01-.086-.068l-.034-.032-.159-.156a3.467 3.467 0 01-.338-.35l-.107-.13-.202-.25c-.6-.732-1.166-1.16-2.207-1.555l-.081-.03-.03-.03-.03-.017c-.616-.189-1.32-.284-2.153-.284zm.136.14c.716.01 1.33.092 1.875.247l.085.025.028.027.025.016c1.077.397 1.638.812 2.242 1.547l.266.33.045.054c.11.129.214.238.349.36l.154.152.042.039a.84.84 0 00.097.076l.137.111a3.496 3.496 0 01.816.91l.065.085.034.07c.403.794.419 1.462.238 2.462l-.001.052a5.18 5.18 0 01-.274.977l-.046.12-.031.078a.643.643 0 00-.056.248.538.538 0 00-.02.162v.098a3.617 3.617 0 01-.218.916 4.55 4.55 0 01-.702 1.347c-.45.644-.97 1.09-1.597 1.36-.16.06-.292.175-.415.345-.099.136-.15.292-.175.492v.17c.051.616.047 1.093-.04 1.59-.15.771-.402 1.3-.863 1.999l-.073.097-.078.1-.042.053-.09.111c-.225.274-.47.547-.73.803-.447.442-.884.78-1.292.975a2.121 2.121 0 01-.298.117l-.14.04-.133.018a4.41 4.41 0 01-.721.059h-.57l-.681.03-.197.012-.095.008-.069.007-.025.004-.032.008-.073.015-.03.007a.337.337 0 00-.074.028l-.01.006c-.916.265-1.848.396-3.02.396h-.145l-.218-.004-.073-.002-.15-.004-.155-.006-.334-.016-.182-.01-.911-.058h-.127l-.34-.046-.097-.014-.103-.01-.196-.024c-.698-.086-1.158-.196-1.713-.441l-.079-.039-.053-.036c-1.045-.587-1.618-1.278-2.183-2.45l-.083-.174-.041-.09-.083-.186-.044-.1-.067-.134-.02-.043a1.715 1.715 0 01-.072-.174l-.004-.01a3.644 3.644 0 01-.185-.407l-.05-.135-.033-.093-.113-.337-.017-.034v-.024c-.416-1.492-.29-2.426.488-3.577l.13-.192.08-.1.12-.157.259-.327.069-.086.093-.113.058-.067.056-.063.057-.062.058-.06.096-.097a.69.69 0 00.14-.296l.022-.37v-.244c.032-.775.304-1.379.78-2.065a.224.224 0 00.037-.048l.036-.063.013-.018.041-.08.036-.053.023-.043a7.29 7.29 0 00.269-.591L9 11.458l.03-.09.039-.105.012-.041.009-.045.014-.08a4.67 4.67 0 01.28-1.19l.038-.072.018-.045.026-.073.038-.11.022-.058c.158-.5.334-.862.68-1.285l.12-.138.114-.093c.754-.677 1.572-.948 2.539-1.006h.199c.45 0 .982.166 1.596.435a.699.699 0 00.293.067c.05 0 .1-.005.154-.014l.045-.008.102-.02c.215-.077.435-.173.665-.286l.204-.114.066-.037c.11-.06.212-.113.314-.163.525-.26 1.028-.425 1.565-.481a.303.303 0 00.061-.006l.059-.012.015-.002.045-.007.05-.005.093-.008.16-.012.086-.008.057-.007.124-.012.136-.01.148-.01.157-.007c.027-.001.054-.003.082-.003l.17-.006.09-.001.181-.003zm8.179 11.826c-.1.165-.205.325-.316.48l-.086.118a7.15 7.15 0 01-1.165 1.288c-.21.188-.349.46-.395.754l-.022.207-.014.121-.01.068-.01.063-.017.087a2.66 2.66 0 01-.007.03c-.227 1.23-.671 2.165-1.287 3.077l-.613.895c.213-.19.418-.389.617-.594l.14-.206c.628-.93 1.082-1.885 1.313-3.139l.007-.03.017-.09.016-.099.015-.115.027-.254c.04-.252.16-.488.338-.646a7.179 7.179 0 001.105-1.2l.086-.117.18-.255c.03-.145.056-.292.08-.439zM19.922 7.17c-.188 0-.37.006-.573.016l-.21.012-.461.032-.087.01-.173.013-.057.006a.622.622 0 00-.082.013.067.067 0 00-.026.002l-.053.013-.018.003c-.617.069-1.156.296-1.79.672L16.316 8a8.14 8.14 0 01-1.248.475.783.783 0 01-.498-.055l-.014-.005-.039-.019-.095-.047-.055-.03-.053-.035-.191-.095-.072-.034c-.344-.159-.65-.243-.995-.243h-.142c-.79.057-1.394.256-1.957.76l-.063.062-.126.162a2.69 2.69 0 00-.075.105l-.044.068a1.99 1.99 0 00-.116.216l-.037.082-.038.09-.04.102-.077.209-.012.033-.009.023-.018.05-.061.185-.02.05-.013.03-.005.026-.001.029c-.11.353-.184.667-.222.984l-.019.125-.011.067-.011.057-.006.026-.011.047-.013.045-.124.37-.039.126-.008.031-.04.104-.042.107-.023.055-.047.109-.048.106-.048.1c-.063.13-.123.239-.167.296l-.047.091-.006.01-.024.033-.059.078a.43.43 0 00-.008.012l-.157.25-.065.11c-.25.426-.387.802-.4 1.22v.142l.003.063.004.047.006.047.01.053.02.103.103.31a.206.206 0 010 .136l-.003.022c0 .032-.024.075-.061.112l-.07.065a8.37 8.37 0 00-1 1.095l-.115.15a2.09 2.09 0 01-.14.2l-.061.079-.036.034c-.667.945-.756 1.586-.404 2.813l-.002.022c.093.331.198.608.332.872l.048.107.085.182.166.373c.513 1.136.992 1.769 1.903 2.274l.084.041c.306.14.56.225.889.29l.127.023c.065.012.133.023.206.033l.15.02.162.021.176.02.486.06.09.001c.666.064 1.397.1 2.093.1h.209l.2-.004c.977-.024 1.62-.142 2.043-.386.108-.044.22-.079.333-.1l.114-.019.05-.007.057-.007.093-.01.148-.01.175-.011.266-.012.324-.012.073-.003h.038a3.02 3.02 0 01.15-.014l.087-.004.043-.001h.387a2.2 2.2 0 00.486-.042l.083-.02.066-.022c.084-.025.172-.06.262-.104.322-.158.661-.43 1.008-.783.198-.202.385-.418.557-.634l.044-.056.08-.104.067-.09.028-.04c.416-.644.621-1.072.743-1.689.045-.233.057-.479.046-.809l-.01-.224-.022-.438-.01-.163-.006-.155-.002-.036c-.012-.38.015-.624.089-.707l.058-.057.013-.018.04-.08c.144-.21.389-.387.673-.487.622-.205 1.101-.574 1.517-1.168a3.96 3.96 0 00.557-1.101c.087-.257.146-.52.166-.757v-.104l.003-.025.008-.042.028-.14.033-.142.02-.078.01-.036.018-.063.02-.058c.01-.027.02-.052.032-.078l.024-.05c.14-.324.232-.62.27-.904l.001-.049.02-.112c.12-.75.103-1.226-.17-1.763l-.04-.08a2.591 2.591 0 00-.155-.228c-.166-.219-.3-.341-.555-.537l-.124-.099-.086-.073-.035-.031-.033-.032-.04-.04-.084-.073-.038-.035-.072-.067a3.183 3.183 0 01-.134-.14l-.07-.078a6.122 6.122 0 01-.037-.043l-.08-.096-.151-.184c-.565-.709-1.004-1.048-1.96-1.404l-.025-.004-.031-.001-.206-.056c-.446-.109-.961-.164-1.57-.164zm0 .14c.697 0 1.266.072 1.746.217l.02.003.026-.001.2.077c.735.297 1.129.6 1.59 1.158l.253.309.082.097c.077.09.143.164.212.233l.07.069.077.07.085.075.055.054.035.033.06.053.05.04.09.073.143.112a2.2 2.2 0 01.425.428c.05.066.098.137.144.212l.038.076c.236.467.268.887.179 1.521l-.044.28v.051c-.036.26-.125.545-.259.855-.03.059-.053.114-.075.181l-.022.07-.022.082-.023.094-.027.116-.026.13a.844.844 0 00-.013.104v.092a3.17 3.17 0 01-.16.72c-.12.374-.3.728-.539 1.063-.399.57-.854.921-1.447 1.117l-.062.023a1.48 1.48 0 00-.686.525l-.04.077-.052.053c-.107.118-.138.358-.129.745l.004.135.043.833.002.026c.014.364.005.622-.041.862-.118.596-.316 1.01-.722 1.639l-.054.075-.036.048-.08.102a8.59 8.59 0 01-.59.678c-.337.343-.665.605-.97.755a1.404 1.404 0 01-.183.077l-.122.04-.076.019a2.076 2.076 0 01-.453.037h-.342c-.114 0-.2.005-.334.021h-.032l-.46.016-.211.01-.179.011-.15.012-.095.01-.083.01-.073.012a1.73 1.73 0 00-.442.125c-.352.201-.868.314-1.623.356l-.178.008c-.061.003-.124.004-.188.006l-.195.004h-.205a22.03 22.03 0 01-2.086-.1h-.088l-.479-.059-.172-.02-.16-.02-.147-.02-.136-.022a3.697 3.697 0 01-1.05-.313l-.08-.04c-.876-.485-1.338-1.095-1.84-2.207l-.166-.373-.115-.248-.018-.042a4.71 4.71 0 01-.322-.834l.002-.02-.022-.08-.04-.154c-.268-1.055-.156-1.633.436-2.472l.032-.031.068-.084c.06-.078.103-.14.146-.21l.11-.143c.31-.4.573-.694.984-1.078l.072-.067.022-.023a.31.31 0 00.08-.16v-.015l.007-.023a.342.342 0 00-.01-.192l-.1-.296-.018-.094-.008-.05-.006-.043-.004-.041-.002-.058v-.137c.012-.39.142-.745.38-1.153l.042-.07.177-.284.073-.097a.47.47 0 00.032-.049l.04-.08c.044-.056.102-.159.163-.284l.047-.097.048-.103.023-.054.046-.107.022-.054.043-.107.038-.103.015-.053.044-.137.104-.313.017-.052.014-.055.013-.06.013-.069.013-.082.014-.095a5.2 5.2 0 01.221-.97l.004-.021-.001-.025.013-.032a1.76 1.76 0 00.017-.044l.023-.064.04-.122.016-.047a.941.941 0 01.008-.021l.068-.183.04-.105.018-.048.037-.088a2.2 2.2 0 01.089-.187l.038-.066.04-.065.021-.032.047-.066.025-.034.055-.071.062-.082.054-.052c.534-.477 1.109-.666 1.865-.722h.137c.297 0 .564.068.86.197l.101.046.147.071.08.04.053.036.114.06a.656.656 0 00.106.048.917.917 0 00.585.062c.37-.101.908-.305 1.278-.486l.08-.041c.623-.369 1.146-.59 1.723-.654a.12.12 0 00.02-.001l.028-.006.022-.005a.19.19 0 01.044-.008l.04-.007.043-.005.052-.005.22-.019.04-.004.344-.024c.342-.024.609-.036.886-.036zm.101-2.29c-.507 0-1.031.033-1.45.081l-.123.013-.109.012-.094.012-.081.012-.067.012h-.015l-.018.004-.032.007a.27.27 0 01-.062.008c-.953.115-1.661.413-2.598.952l-.03.014a.534.534 0 01-.216.056.748.748 0 01-.277-.055 4.439 4.439 0 00-1.714-.346h-.304l-.094.008-.173.016c-.3.03-.524.067-.826.142a5.172 5.172 0 00-2.116 1.076l-.275.24-.19.229c-.448.54-.65.963-.887 1.667a.81.81 0 01-.078.23l-.04.08-.037.096a5.917 5.917 0 00-.316 1.372v.013l-.016.04-.021.059-.084.265-.016.045-.039.1-.038.092-.018.043-.035.077-.025.053-.011.01-.073.115-.01.039-.023.018a.37.37 0 00-.03.049l-.02.027c-.566.838-.882 1.525-.963 2.465-.017.115-.05.242-.098.383l-.12.297a.765.765 0 01-.102.175l-.051.068c-.035.04-.07.083-.11.133l-.136.176-.056.069-.023.028-.04.047-.094.107-.026.032-.023.03-.122.16c-1.053 1.507-1.256 2.814-.723 4.674l.042.124c.107.361.235.704.39 1.03l.069.137.08.155c.031.061.053.11.07.16l.12.261.075.158.01.022c.209.317.432.624.67.92l.006.01-.013-.022-.017-.026-.065-.106-.064-.108a7.096 7.096 0 01-.032-.055l-.062-.112-.063-.117-.064-.124-.065-.13-.068-.14-.071-.15-.115-.246-.041-.089a1.113 1.113 0 00-.056-.134l-.049-.097-.059-.112a6.75 6.75 0 01-.442-1.13l-.041-.123c-.52-1.814-.324-3.075.701-4.543l.13-.171.023-.027.135-.156.033-.041.047-.057.149-.192.072-.09.04-.045.055-.075a.884.884 0 00.116-.203l.122-.3c.052-.154.088-.289.107-.418.075-.88.363-1.53.878-2.309l.085-.125a.338.338 0 01.015-.026l.035-.05.01-.016.007-.016.056-.096.01-.005.013-.02.016-.031.034-.074.038-.086.039-.096.02-.05.023-.062.035-.103.05-.161.026-.077.026-.065.006-.03v-.02c.065-.532.172-.992.34-1.416l.038-.074a.914.914 0 00.088-.259l.03-.087.059-.166c.196-.534.392-.903.769-1.357l.182-.22.175-.153c.178-.159.363-.302.556-.43a5.02 5.02 0 011.588-.692 5.4 5.4 0 01.885-.146l.177-.016h.298c.57 0 1.128.115 1.657.336a.903.903 0 00.334.066.68.68 0 00.28-.07l.037-.018c.925-.532 1.618-.824 2.536-.935a.29.29 0 00.06-.006l.064-.013.08-.012.04-.006.087-.012.101-.013.175-.018c.416-.048.934-.08 1.435-.08.89 0 1.66.101 2.31.302-.174-.1-.35-.195-.521-.285a8.779 8.779 0 00-1.789-.166zm.718 11.47l-.037.006a.174.174 0 00-.072.042c-.142.2-.345.561-.487.822-.081.16-.163.3-.223.42-.204.321-.204.582-.224.822 0 .28-.02.561-.345.782-.224.14-.406.18-1.402.32-.122.02-.162.04-.223.06-.061.04-.142.06-.305.1-.04 0-.081.04-.101.081l-.054.073a1.56 1.56 0 01-.495.348c-.06.02-.101.06-.101.12 0 .14-.041.3-.122.4a.349.349 0 01-.264.141h-.041c-.203 0-.325-.08-.386-.16 0-.02-.02 0-.02 0-.061.24-.183.44-.447.5-.04.02-.061.02-.102.02-.142 0-.223-.04-.284-.1-.02-.02-.081-.02-.081.02a.695.695 0 01-.122.281.436.436 0 01-.325.2h-.061a.383.383 0 01-.284-.1c-.061-.06-.224-.06-.285.02 0 .02-.02.02-.02.04-.142.18-.366.281-.67.281h-.02c-.245 0-.387-.12-.448-.22a.975.975 0 01-.06-.14c-.041-.1-.204-.14-.305-.14h-.02c-.082 0-.102-.081-.122-.121 0-.02-.02 0-.02 0l.04.24c.02.04.02.16-.142.24-.122.06-.305.081-.508.081-.366 0-.833-.1-1.016-.28a.537.537 0 01-.122-.1c-.06-.08-.203-.121-.284-.06-.081.06-.122.06-.162.06h-.041c-.183-.02-.305-.181-.406-.422-.02-.06-.082-.08-.143-.08-.101.02-.223.02-.325.02a.825.825 0 01-.304-.06c-.102-.04-.142-.12-.183-.22h-.203c-.04 0-.061-.02-.081-.02-.02-.02-.061-.02-.082-.04 0-.02-.02 0-.02.02l.107.238c.487 1.082.82 1.754 1.559 2.146.325.18.832.22 1.828.341.731.08 1.28.08 2.193.08.874 0 1.138-.04 1.3-.08.305-.06.447-.12.61-.18.183-.08.365-.16.71-.22.326-.06.732-.08 1.504-.1.32-.016.525-.02.668-.02l.194-.001c.075 0 .084-.004.133-.02.59-.18.955-.741 1.3-1.263.285-.42.488-.761.59-1.262.04-.24.04-.4.02-.661-.02-.26-.041-.642-.02-1.283.02-.541.06-.761.182-1.002.102-.16.183-.26.264-.36.061-.08.122-.14.163-.241 0-.02 0-.04-.02-.04-.062-.06-.346-.2-.691-.36l-.034-.009zm-7.746 4.216c-.122.301-.244.762-.122.962.02.04.081.1.244.1.244 0 .406-.06.508-.2.142-.18.162-.44.142-.641l-.02-.18zm-1.056-1.583c-.04.04-.102.12-.203.24-.04.081-.122.181-.203.301-.102.18-.183.281-.244.361l-.02.04c-.102.16-.183.26-.407.641-.06.12-.142.22-.203.301-.04.04-.06.08-.081.12-.04.06-.061.1-.061.14 0 .12.06.18.142.241l.02.02c.102.1.447.2.813.2.244 0 .386-.04.426-.06-.02-.18-.04-.36-.06-.52a6.17 6.17 0 010-1.383c.02-.18.04-.321.04-.421.02-.08.04-.16.04-.22zm2.823 1.323c-.122 0-.386.04-.61.1v.206c.002.268.021.611.163.736.041.04.082.04.143.04.04-.02.101-.04.142-.1.183-.22.183-.782.162-.982zm-5.26-.541c0 .16 0 .4.06.601.02.08.04.18.082.28.08.261.182.502.284.522.02 0 .142-.08.366-.381.264-.36.426-.742.446-.882-.04 0-.08 0-.101.02l-.197-.002c-.44-.01-.745-.053-.94-.158zm3.107-.661c-.162 0-.305.04-.345.12-.081.1-.122.24-.142.4v.04c-.061.502.121 1.123.223 1.383.122-.16.305-.44.467-.761.163-.3.264-.621.285-.842 0-.16-.082-.24-.143-.26l-.08-.038a.76.76 0 00-.265-.042zm3.027 1.002c-.082 0-.163.02-.244.04-.142.02-.264.04-.345.04-.02.26 0 .641.142.761.02.04.081.06.162.04.203-.04.264-.3.285-.5zm.772-.14l-.407.1c-.02.14-.04.38.061.5.04.06.122.08.224.08.04 0 .06-.02.08-.04.082-.12.062-.42.042-.64zm-7.618-.462c-.04.301-.04.602.02.882 0 .06.021.14.041.18.02.04.061.04.102.04h.386l.02-.02c-.02-.06-.04-.1-.04-.2a2.092 2.092 0 01-.061-.761 1.776 1.776 0 01-.468-.12zm-.589-.16c-.04.22-.04.42-.04.621 0 .1 0 .2.06.3l.082.081c.02.02.04.02.06.02h.123l-.02-.105a1.369 1.369 0 01-.02-.216c0-.2.02-.4.04-.6a.953.953 0 00-.183-.06zm5.83-.12c-.081-.06-.345-.04-.569.02l-.142.862c.203.04.406.06.467.04.02-.06.061-.12.081-.2.082-.181.244-.622.163-.722zm.67.02c-.081-.06-.203-.06-.264-.02-.04.02-.101.12-.142.26-.04.14-.081.3-.122.481l.569.02c.02-.12.06-.32.081-.38.04-.14 0-.261-.122-.361zm.792-.12l-.284.02h-.02c0 .02-.04.04-.04.16 0 .16-.041.4-.062.581l.447-.14c0-.18 0-.461-.04-.621zm-2.518-10.1h-.04c-.61.04-.895.18-1.138.42-.061.06-.143.22-.407.942-.121.36-.162.561-.182.762-.02.18-.041.36-.143.641-.06.18-.121.36-.162.501-.122.42-.224.741-.528 1.142a.874.874 0 00-.122.2c-.061.1-.142.241-.264.381-.081.1-.264.501-.244.622.02.2.081.32.142.46.082.14.163.301.163.522v.04c.02.34-.02.52-.69 1.102-.427.38-.732.741-.935 1.002-.02.02 0 .06.04.06h.143c.162.02.325.08.426.2.02.02.04.02.081.02a.662.662 0 01.346-.02c.142.02.264.06.365.14.041.04.082.04.122.04a.6.6 0 01.325.02c.081.02.142.081.203.121.04.06.143.06.203.02.02-.02.061-.02.082-.04a.848.848 0 01.447.02c.06.02.142.04.203.08.101.06.162.16.223.28.04.08.142.121.224.06.08-.06.162-.08.243-.04.02.02.061.04.082.06.06.061.142.121.223.101a.957.957 0 01.67.08.51.51 0 01.142.107l.061.074v-.04c0-.02.02-.04.041-.04l.04-.02c.102-.04.671-.201.894.04 0 0 .02.02.041 0 .02-.04.061-.04.061-.06.142-.08.386-.1.548.04.041.02.082.02.102-.02l.06-.06c.062-.04.123-.08.204-.06l.305-.02c.081 0 .325-.02.406-.04h.02c.04 0 .061-.021.102-.021.142-.04.325-.06.467 0 .142.06.122.22.102.34 0 .06-.02.121-.02.161v.08c0 .08 0 .152-.007.214l-.014.087.02.06c.02.06.082.1.142.06.077-.045.153-.101.203-.152l.041-.05v-.018c0-.02.02-.04.02-.1.02-.12.041-.341.041-.822v-.501c-.02-.26-.02-.461.102-.662.122-.2.243-.28.365-.34.143-.08.285-.18.549-.521.122-.18.142-.24.162-.3.02-.121.061-.201.264-.362.163-.12.63-.48 1.28-.36.17.033.437.108.722.214l.172.066c.02 0 .02 0 .04.02h.02c.305.12.59.24.773.341.06.02.121.02.162-.04.061-.06.122-.12.183-.16.02-.02.04-.02.06-.04.062-.06.062-.16-.02-.2a17.09 17.09 0 00-2.051-.742c-.614-.179-.634-.974-.588-1.81l.02-.315c.02-.34.04-.66.02-.921-.061-.882-.204-1.864-.935-2.305-.717-.447-1.871-.375-2.667-.282l-.177.021c-.284.08-.568.14-.771.14-.468-.02-.833-.22-1.138-.38-.244-.14-.467-.24-.67-.24zm-5.14 9.92l-.015.072c-.02.195.064.564.117.809 0 .02.02.02.02 0 0-.22.041-.46.102-.681v-.02l-.06-.06c-.062-.04-.102-.08-.163-.12zm8.552.1c-.06 0-.183.02-.264.04l-.122.02c-.02.04-.02.16-.02.24v.34c.142 0 .264 0 .386-.04v-.3c0-.08.02-.14.02-.2 0-.04.02-.08 0-.1zm-5.403-.461h-.06c-.021 0-.041 0-.041.02 0 0-.02 0-.02.02 0 0-.01 0-.016.006l-.005.014-.02.02s0 .009-.006.015l-.015.005c-.02.04-.06.08-.08.12-.062.1-.143.2-.204.3-.061.08-.122.18-.183.261l-.101.14-.02.02.121.02c.102.02.183.04.285.04.182.02.385.04.589.04h.02c.04-.06.101-.14.162-.24.041-.06.082-.12.102-.16-.061-.04-.081-.06-.081-.1-.02-.12-.04-.24-.082-.341l-.015-.03-.015-.03-.01-.02s0-.02-.02-.02l-.02-.02h-.021s-.02 0-.02-.02h-.02c-.041-.014-.091-.036-.138-.05l-.066-.01zm-.813-.18h-.1a.286.286 0 00-.184.06c0 .02-.02.02-.02.02-.142.1-.244.24-.325.38l-.122.24c-.02.06-.04.1-.06.14l.019.02c.012.014.02.028.02.041.021.02.021.02.041.02l.183.06c.061.02.142.04.224.06l.08-.12c.042-.06.102-.14.143-.2.102-.14.183-.281.284-.421l-.012-.046c-.012-.047-.023-.1-.069-.175 0 0-.04-.06-.02-.04l-.04-.02h-.021c0-.013-.01-.018-.021-.02zm9.46-2.38l-.14.005c-.363.034-.63.23-.727.31-.122.08-.142.1-.142.14-.041.1-.061.2-.224.421-.305.401-.508.521-.65.621-.101.08-.162.12-.244.24-.08.121-.08.221-.06.462v.5c0 .201-.02.362-.02.502-.021.08.06.12.121.1.02-.02.02-.02.04-.02.062-.02.143-.06.305-.08.975-.14 1.118-.16 1.26-.26.182-.1.182-.221.203-.502.02-.26.04-.6.264-.982.06-.1.142-.26.223-.4a9.73 9.73 0 01.427-.742c.04-.06 0-.14-.061-.16a5.18 5.18 0 00-.427-.14l-.148-.014zM9.379 18.422c-.06 0-.121-.02-.182.02-.041.02-.082.08-.122.12-.102.12-.183.24-.264.36-.04.101-.102.181-.163.281.02.02.04.02.061.04l.163.06c.06.02.101.02.162.04l.02-.04.163-.32c.122-.2.244-.38.406-.521 0 0-.02 0-.06-.02-.062-.02-.123-.02-.184-.02zm-.848-.19l-.045.01a.243.243 0 00-.102.1c-.06.1-.142.22-.203.32-.04.06-.081.12-.102.18 0 .02-.02.06-.04.101h.02c0 .02.04.04.04.04l.123.08c.06.02.101.04.162.06.02-.08.081-.14.122-.22l.108-.18c.077-.118.163-.234.258-.341a.426.426 0 00-.264-.14l-.032-.005-.045-.004zm9.794-14.23l-.012.003-.152.015-.086.01-.073.01-.061.01a1.32 1.32 0 00-.026.005h-.018l-.097.016-.032.002c-.779.087-1.46.308-2.248.67a1.513 1.513 0 01-1.082.115 6.063 6.063 0 00-1.362-.163h-.345a6.943 6.943 0 00-1.586.263 6.295 6.295 0 00-2.389 1.34l-.244.221-.25.288c-.497.605-.723 1.032-.993 1.755l-.065.18-.034.094-.008.028-.014.047-.035.094-.045.133-.045.13a7.46 7.46 0 00-.33 1.37l-.013.109-.014.035-.018.047-.032.094c-.01.03-.02.06-.027.087l-.01.038a.426.426 0 01-.024.067l-.034.074-.016.037-.006.016-.053.085-.012.04-.013.02-.036.05c-.589.871-.947 1.61-1.108 2.624a1.427 1.427 0 01-.194.575l-.324.56-.042.06a.738.738 0 01-.087.103l-.169.207a7.09 7.09 0 00-.827 1.517l-.09.247c.014.14.03.28.048.42.178-.704.499-1.371 1-2.088l.159-.196a.752.752 0 00.085-.098l.039-.055.022-.033.328-.566c.12-.214.194-.42.214-.633.15-.944.478-1.646 1.015-2.457l.088-.132.011-.011a.227.227 0 00.037-.073l.003-.012.053-.087.007-.016.006-.017.032-.067a.743.743 0 00.037-.093l.008-.03c.02-.076.06-.193.099-.29l.005-.02a7.05 7.05 0 01.338-1.458l.093-.272.022-.058a1 1 0 00.032-.106l.033-.092.064-.175c.263-.704.482-1.118.964-1.706l.243-.279.237-.213a6.13 6.13 0 012.324-1.305 6.776 6.776 0 011.544-.257h.342c.428 0 .888.056 1.322.158.407.106.833.061 1.194-.127.77-.353 1.436-.569 2.186-.653.013 0 .029 0 .049-.003l.094-.016h.01l.058-.01.069-.01.123-.015.15-.015.115-.01.206-.021.22-.02A12.61 12.61 0 0018.324 4zm-6.792 10.063l.142.008c.183.02.325.04.467.08.122.04.223.06.305.1 0 0 .02 0 .02.02.02 0 .04.02.04.02.02.02.041.02.061.02.02.02.061.02.082.04h.02c.102.04.183.101.264.141.04.02.061.06.102.08.02 0 .02.02.02.02l.02.02c.366.321.346.642.305.842-.203.902-1.645 1.924-2.295 1.924h-.122a1.085 1.085 0 01-.406-.24.84.84 0 01-.183-.281c0-.02 0-.04-.02-.06-.041-.16-.082-.341.06-.662l.061-.12.02-.04c.02-.04.02-.06.041-.1.02-.04.04-.08.04-.12l.021-.04c.04-.1.04-.16.04-.2 0-.041 0-.081.021-.141.04-.18.061-.32.081-.441.041-.24.061-.44.183-.621.02-.04.04-.06.081-.08l.03-.03.011-.01c.04-.02.061-.04.102-.06.02 0 .02-.02.04-.02s.061-.02.082-.02c.121-.02.264-.04.406-.02zm.162.45h-.142c-.102 0-.183.02-.203.06-.081.1-.102.22-.122.42-.02.12-.04.3-.081.481-.02.02-.02.06-.02.08-.021.12-.062.24-.265.722-.081.18-.06.26-.04.38.02.02.02.04.02.06.02.06.142.14.223.18-.04-.4.082-.7.183-.921.04-.06.061-.12.081-.18.02-.08.02-.16.02-.24 0-.181.021-.382.184-.762.06-.14.101-.2.162-.28zm9.75-5.993c-.833-.3-1.645-.2-2.58-.1-.142 0-.304.02-.447.04-.467.04-.934.3-1.3.521l-.136.08c-.087.051-.168.1-.25.14.65 0 1.32.08 1.829.401.873.541 1.036 1.604 1.096 2.586.02.28 0 .62-.02.961-.06.762-.101 1.644.305 1.764.365.1 1.381.541 2.56 1.142h.141c.407-.04.732-.46.914-.701.224-.3.325-.581.386-.742.061-.22.082-.32.102-.5l.012-.091c.01-.093.018-.19.049-.31.081-.401.162-.622.244-.802l.03-.088c.05-.144.102-.283.152-.533.082-.461.143-.802-.02-1.143-.06-.1-.101-.12-.264-.26l-.066-.052c-.118-.092-.28-.209-.482-.409-.488-.44-.732-.661-.874-.942-.203-.4-.995-.822-1.381-.962zM6.341 8.303c-.095.114-.188.23-.279.347l.001.04-.018.071-.053.152a8.623 8.623 0 00-.375 1.58l-.056.163-.013.016-.008.013-.051.073-.166.253-.101.158-.06.095-.054.09-.052.09-.05.089-.026.046-.05.096-.055.104a6.893 6.893 0 00-.659 1.917.998.998 0 01-.168.447l-.498.792-.004.032-.027.334.144-.22.53-.844c.1-.14.17-.33.194-.515a6.722 6.722 0 01.643-1.865l.053-.102.05-.095.05-.09.05-.086.065-.11.014-.023.09-.143.105-.163.126-.193.04-.059.01-.007.025-.025v-.013l.007-.01a.09.09 0 00.01-.02l.002-.015.058-.17a8.613 8.613 0 01.426-1.723l.023-.088.002-.02v-.1l.016-.028.011-.033a.73.73 0 00.011-.04zm9.295 2.142c.122-.1.73-.541 1.482-.32.529.14.813.56.915.7.08.121.345.502.345 1.023.02.4-.142.701-.447 1.222-.183.32-.284.501-.447.621-.325.261-.69.321-.995.321-.224 0-.406-.04-.528-.06-.325-.06-.914-.16-1.118-.621-.04-.1-.04-.14-.04-.22l-.001-.082a3.21 3.21 0 00-.04-.4v-.02c-.02-.14-.04-.28 0-.48v-.02c.102-.562.142-.642.163-.702.06-.1.203-.16.304-.1.102.06.163.18.102.3-.02.04-.04.16-.122.582v.02a.96.96 0 000 .34v.02c.035.275.04.417.04.503v.098c.041.08.102.14.184.18.08.04.162-.04.142-.12-.102-.48-.082-1.041.101-1.382.037-.072.095-.173.158-.282l.127-.22c.02-.02.02-.04.04-.06 0-.02.02-.04.02-.04.041-.08.102-.16.122-.2 0 0 0-.02.02-.02 0 0 0-.02.021-.02l.02-.04v-.04l.02-.02c.021-.04.062-.08.082-.12.06-.08 0-.18-.102-.14-.162.08-.264.16-.284.16a.231.231 0 01-.325-.04.224.224 0 01.04-.321zm-2.357-.581c.244 0 .508.08.691.22.081.06.203.2.264.581 0 .18-.06.542-.183 1.343l-.02.16c-.061.381-.203.882-.752 1.022-.528.12-.65.16-1.015.16h-.02c-.265 0-.793-.16-.894-.58-.061-.28.06-.461.264-.802.04-.06.06-.12.101-.18.264-.441.366-.762.447-1.002.081-.24.142-.461.325-.622.04-.04.081-.08.142-.12l.102-.06c.04-.02.102-.04.162-.06.122-.04.244-.06.386-.06zm-.182.46c-.082.02-.163.06-.264.08-.143.101-.183.221-.285.502-.081.26-.203.621-.487 1.102-.04.06-.061.12-.102.18-.162.281-.223.361-.203.461.04.12.264.22.406.24-.06-.28-.04-.54.04-.76.041-.14.102-.221.184-.341.08-.1.162-.22.264-.421.06-.12.183-.441.304-.722.061-.12.102-.22.143-.32z"/>`;
  }
};
export default Ape;
