#ifndef LINUX_SYSCALLS_H
#define LINUX_SYSCALLS_H

typedef struct {
  char *name;
  char *rdi;
  char *rsi;
  char *rdx;
  char *r10;
  char *r8;
  char *r9;
} LINUX_SYSCALL;

static const LINUX_SYSCALL linux_syscalls[] = {
    {"sys_read", "fd", "*buf", "count", "", "", ""},
    {"sys_write", "fd", "*buf", "count", "", "", ""},
    {"sys_open", "*filename", "flags", "mode", "", "", ""},
    {"sys_close", "fd", "", "", "", "", ""},
    {"sys_stat", "*filename", "*statbuf", "", "", "", ""},
    {"sys_fstat", "fd", "*statbuf", "", "", "", ""},
    {"sys_lstat", "*filename", "*statbuf", "", "", "", ""},
    {"sys_poll", "*ufds", "nfds", "timeout_msecs", "", "", ""},
    {"sys_lseek", "fd", "offset", "origin", "", "", ""},
    {"sys_mmap", "addr", "len", "prot", "flags", "fd", "off"},
    {"sys_mprotect", "start", "len", "prot", "", "", ""},
    {"sys_munmap", "addr", "len", "", "", "", ""},
    {"sys_brk", "brk", "", "", "", "", ""},
    {"sys_rt_sigaction", "sig", "*act", "*oact", "sigsetsize", "", ""},
    {"sys_rt_sigprocmask", "how", "*nset", "*oset", "sigsetsize", "", ""},
    {"sys_rt_sigreturn", "__unused", "", "", "", "", ""},
    {"sys_ioctl", "fd", "cmd", "arg", "", "", ""},
    {"sys_pread64", "fd", "*buf", "count", "pos", "", ""},
    {"sys_pwrite64", "fd", "*buf", "count", "pos", "", ""},
    {"sys_readv", "fd", "*vec", "vlen", "", "", ""},
    {"sys_writev", "fd", "*vec", "vlen", "", "", ""},
    {"sys_access", "*filename", "mode", "", "", "", ""},
    {"sys_pipe", "*filedes", "", "", "", "", ""},
    {"sys_select", "n", "*inp", "*outp", "fd_set*exp", "*tvp", ""},
    {"sys_sched_yield", "", "", "", "", "", ""},
    {"sys_mremap", "addr", "old_len", "new_len", "flags", "new_addr", ""},
    {"sys_msync", "start", "len", "flags", "", "", ""},
    {"sys_mincore", "start", "len", "*vec", "", "", ""},
    {"sys_madvise", "start", "len_in", "behavior", "", "", ""},
    {"sys_shmget", "key", "size", "shmflg", "", "", ""},
    {"sys_shmat", "shmid", "*shmaddr", "shmflg", "", "", ""},
    {"sys_shmctl", "shmid", "cmd", "*buf", "", "", ""},
    {"sys_dup", "fildes", "", "", "", "", ""},
    {"sys_dup2", "oldfd", "newfd", "", "", "", ""},
    {"sys_pause", "", "", "", "", "", ""},
    {"sys_nanosleep", "*rqtp", "*rmtp", "", "", "", ""},
    {"sys_getitimer", "which", "*value", "", "", "", ""},
    {"sys_alarm", "seconds", "", "", "", "", ""},
    {"sys_setitimer", "which", "*value", "*ovalue", "", "", ""},
    {"sys_getpid", "", "", "", "", "", ""},
    {"sys_sendfile", "out_fd", "in_fd", "*offset", "count", "", ""},
    {"sys_socket", "family", "type", "protocol", "", "", ""},
    {"sys_connect", "fd", "*uservaddr", "addrlen", "", "", ""},
    {"sys_accept", "fd", "*upeer_sockaddr", "*upeer_addrlen", "", "", ""},
    {"sys_sendto", "fd", "*buff", "len", "flags", "*addr", "addr_len"},
    {"sys_recvfrom", "fd", "*ubuf", "size", "flags", "*addr", "*addr_len"},
    {"sys_sendmsg", "fd", "*msg", "flags", "", "", ""},
    {"sys_recvmsg", "fd", "*msg", "flags", "", "", ""},
    {"sys_shutdown", "fd", "how", "", "", "", ""},
    {"sys_bind", "fd", "*umyaddr", "addrlen", "", "", ""},
    {"sys_listen", "fd", "backlog", "", "", "", ""},
    {"sys_getsockname", "fd", "*usockaddr", "*usockaddr_len", "", "", ""},
    {"sys_getpeername", "fd", "*usockaddr", "*usockaddr_len", "", "", ""},
    {"sys_socketpair", "family", "type", "protocol", "*usockvec", "", ""},
    {"sys_setsockopt", "fd", "level", "optname", "*optval", "optlen", ""},
    {"sys_getsockopt", "fd", "level", "optname", "*optval", "*optlen", ""},
    {"sys_clone", "clone_flags", "newsp", "*parent_tid", "*child_tid", "tid",
     ""},
    {"sys_fork", "", "", "", "", "", ""},
    {"sys_vfork", "", "", "", "", "", ""},
    {"sys_execve", "*filename", "argv[]", "envp[]", "", "", ""},
    {"sys_exit", "error_code", "", "", "", "", ""},
    {"sys_wait4", "upid", "*stat_addr", "options", "*ru", "", ""},
    {"sys_kill", "pid", "sig", "", "", "", ""},
    {"sys_uname", "*name", "", "", "", "", ""},
    {"sys_semget", "key", "nsems", "semflg", "", "", ""},
    {"sys_semop", "semid", "*tsops", "nsops", "", "", ""},
    {"sys_semctl", "semid", "semnum", "cmd", "arg", "", ""},
    {"sys_shmdt", "*shmaddr", "", "", "", "", ""},
    {"sys_msgget", "key", "msgflg", "", "", "", ""},
    {"sys_msgsnd", "msqid", "*msgp", "msgsz", "msgflg", "", ""},
    {"sys_msgrcv", "msqid", "*msgp", "msgsz", "msgtyp", "msgflg", ""},
    {"sys_msgctl", "msqid", "cmd", "*buf", "", "", ""},
    {"sys_fcntl", "fd", "cmd", "arg", "", "", ""},
    {"sys_flock", "fd", "cmd", "", "", "", ""},
    {"sys_fsync", "fd", "", "", "", "", ""},
    {"sys_fdatasync", "fd", "", "", "", "", ""},
    {"sys_truncate", "*path", "length", "", "", "", ""},
    {"sys_ftruncate", "fd", "length", "", "", "", ""},
    {"sys_getdents", "fd", "*dirent", "count", "", "", ""},
    {"sys_getcwd", "*buf", "size", "", "", "", ""},
    {"sys_chdir", "*filename", "", "", "", "", ""},
    {"sys_fchdir", "fd", "", "", "", "", ""},
    {"sys_rename", "*oldname", "*newname", "", "", "", ""},
    {"sys_mkdir", "*pathname", "mode", "", "", "", ""},
    {"sys_rmdir", "*pathname", "", "", "", "", ""},
    {"sys_creat", "*pathname", "mode", "", "", "", ""},
    {"sys_link", "*oldname", "*newname", "", "", "", ""},
    {"sys_unlink", "*pathname", "", "", "", "", ""},
    {"sys_symlink", "*oldname", "*newname", "", "", "", ""},
    {"sys_readlink", "*path", "*buf", "bufsiz", "", "", ""},
    {"sys_chmod", "*filename", "mode", "", "", "", ""},
    {"sys_fchmod", "fd", "mode", "", "", "", ""},
    {"sys_chown", "*filename", "user", "group", "", "", ""},
    {"sys_fchown", "fd", "user", "group", "", "", ""},
    {"sys_lchown", "*filename", "user", "group", "", "", ""},
    {"sys_umask", "mask", "", "", "", "", ""},
    {"sys_gettimeofday", "*tv", "*tz", "", "", "", ""},
    {"sys_getrlimit", "resource", "*rlim", "", "", "", ""},
    {"sys_getrusage", "who", "*ru", "", "", "", ""},
    {"sys_sysinfo", "*info", "", "", "", "", ""},
    {"sys_times", "*tbuf", "", "", "", "", ""},
    {"sys_ptrace", "request", "pid", "addr", "data", "", ""},
    {"sys_getuid", "", "", "", "", "", ""},
    {"sys_syslog", "type", "*buf", "len", "", "", ""},
    {"sys_getgid", "", "", "", "", "", ""},
    {"sys_setuid", "uid", "", "", "", "", ""},
    {"sys_setgid", "gid", "", "", "", "", ""},
    {"sys_geteuid", "", "", "", "", "", ""},
    {"sys_getegid", "", "", "", "", "", ""},
    {"sys_setpgid", "pid", "pgid", "", "", "", ""},
    {"sys_getppid", "", "", "", "", "", ""},
    {"sys_getpgrp", "", "", "", "", "", ""},
    {"sys_setsid", "", "", "", "", "", ""},
    {"sys_setreuid", "ruid", "euid", "", "", "", ""},
    {"sys_setregid", "rgid", "egid", "", "", "", ""},
    {"sys_getgroups", "gidsetsize", "*grouplist", "", "", "", ""},
    {"sys_setgroups", "gidsetsize", "*grouplist", "", "", "", ""},
    {"sys_setresuid", "*ruid", "*euid", "*suid", "", "", ""},
    {"sys_getresuid", "*ruid", "*euid", "*suid", "", "", ""},
    {"sys_setresgid", "rgid", "egid", "sgid", "", "", ""},
    {"sys_getresgid", "*rgid", "*egid", "*sgid", "", "", ""},
    {"sys_getpgid", "pid", "", "", "", "", ""},
    {"sys_setfsuid", "uid", "", "", "", "", ""},
    {"sys_setfsgid", "gid", "", "", "", "", ""},
    {"sys_getsid", "pid", "", "", "", "", ""},
    {"sys_capget", "header", "dataptr", "", "", "", ""},
    {"sys_capset", "header", "data", "", "", "", ""},
    {"sys_rt_sigpending", "*set", "sigsetsize", "", "", "", ""},
    {"sys_rt_sigtimedwait", "*uthese", "*uinfo", "*uts", "sigsetsize", "", ""},
    {"sys_rt_sigqueueinfo", "pid", "sig", "*uinfo", "", "", ""},
    {"sys_rt_sigsuspend", "*unewset", "sigsetsize", "", "", "", ""},
    {"sys_sigaltstack", "*uss", "*uoss", "", "", "", ""},
    {"sys_utime", "*filename", "*times", "", "", "", ""},
    {"sys_mknod", "*filename", "mode", "dev", "", "", ""},
    {"sys_uselib", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_personality", "personality", "", "", "", "", ""},
    {"sys_ustat", "dev", "*ubuf", "", "", "", ""},
    {"sys_statfs", "*pathname", "*buf", "", "", "", ""},
    {"sys_fstatfs", "fd", "*buf", "", "", "", ""},
    {"sys_sysfs", "option", "arg1", "arg2", "", "", ""},
    {"sys_getpriority", "which", "who", "", "", "", ""},
    {"sys_setpriority", "which", "who", "niceval", "", "", ""},
    {"sys_sched_setparam", "pid", "*param", "", "", "", ""},
    {"sys_sched_getparam", "pid", "*param", "", "", "", ""},
    {"sys_sched_setscheduler", "pid", "policy", "*param", "", "", ""},
    {"sys_sched_getscheduler", "pid", "", "", "", "", ""},
    {"sys_sched_get_priority_max", "policy", "", "", "", "", ""},
    {"sys_sched_get_priority_min", "policy", "", "", "", "", ""},
    {"sys_sched_rr_get_interval", "pid", "*interval", "", "", "", ""},
    {"sys_mlock", "start", "len", "", "", "", ""},
    {"sys_munlock", "start", "len", "", "", "", ""},
    {"sys_mlockall", "flags", "", "", "", "", ""},
    {"sys_munlockall", "", "", "", "", "", ""},
    {"sys_vhangup", "", "", "", "", "", ""},
    {"sys_modify_ldt", "func", "*ptr", "bytecount", "", "", ""},
    {"sys_pivot_root", "*new_root", "*put_old", "", "", "", ""},
    {"sys__sysctl", "*args", "", "", "", "", ""},
    {"sys_prctl", "option", "arg2", "arg3", "arg4", "", "arg5"},
    {"sys_arch_prctl", "*task", "code", "*addr", "", "", ""},
    {"sys_adjtimex", "*txc_p", "", "", "", "", ""},
    {"sys_setrlimit", "resource", "*rlim", "", "", "", ""},
    {"sys_chroot", "*filename", "", "", "", "", ""},
    {"sys_sync", "", "", "", "", "", ""},
    {"sys_acct", "*name", "", "", "", "", ""},
    {"sys_settimeofday", "*tv", "*tz", "", "", "", ""},
    {"sys_mount", "*dev_name", "*dir_name", "*type", "flags", "*data", ""},
    {"sys_umount2", "*target", "flags", "", "", "", ""},
    {"sys_swapon", "*specialfile", "swap_flags", "", "", "", ""},
    {"sys_swapoff", "*specialfile", "", "", "", "", ""},
    {"sys_reboot", "magic1", "magic2", "cmd", "*arg", "", ""},
    {"sys_sethostname", "*name", "len", "", "", "", ""},
    {"sys_setdomainname", "*name", "len", "", "", "", ""},
    {"sys_iopl", "level", "*regs", "", "", "", ""},
    {"sys_ioperm", "from", "num", "turn_on", "", "", ""},
    {"sys_create_module", "2.6", "", "", "", "", ""},
    {"sys_init_module", "*umod", "len", "*uargs", "", "", ""},
    {"sys_delete_module", "*name_user", "flags", "", "", "", ""},
    {"sys_get_kernel_syms", "2.6", "", "", "", "", ""},
    {"sys_query_module", "2.6", "", "", "", "", ""},
    {"sys_quotactl", "cmd", "*special", "id", "*addr", "", ""},
    {"sys_nfsservctl", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_getpmsg", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_putpmsg", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_afs_syscall", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_tuxcall", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_security", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_gettid", "", "", "", "", "", ""},
    {"sys_readahead", "fd", "offset", "count", "", "", ""},
    {"sys_setxattr", "*pathname", "*name", "*value", "size", "flags", ""},
    {"sys_lsetxattr", "*pathname", "*name", "*value", "size", "flags", ""},
    {"sys_fsetxattr", "fd", "*name", "*value", "size", "flags", ""},
    {"sys_getxattr", "*pathname", "*name", "*value", "size", "", ""},
    {"sys_lgetxattr", "*pathname", "*name", "*value", "size", "", ""},
    {"sys_fgetxattr", "fd", "*name", "*value", "size", "", ""},
    {"sys_listxattr", "*pathname", "*list", "size", "", "", ""},
    {"sys_llistxattr", "*pathname", "*list", "size", "", "", ""},
    {"sys_flistxattr", "fd", "*list", "size", "", "", ""},
    {"sys_removexattr", "*pathname", "*name", "", "", "", ""},
    {"sys_lremovexattr", "*pathname", "*name", "", "", "", ""},
    {"sys_fremovexattr", "fd", "*name", "", "", "", ""},
    {"sys_tkill", "pid", "sig", "", "", "", ""},
    {"sys_time", "*tloc", "", "", "", "", ""},
    {"sys_futex", "*uaddr", "op", "val", "*utime", "*uaddr2", "val3"},
    {"sys_sched_setaffinity", "pid", "len", "*user_mask_ptr", "", "", ""},
    {"sys_sched_getaffinity", "pid", "len", "*user_mask_ptr", "", "", ""},
    {"sys_set_thread_area", "arch_prctl", "", "", "", "", ""},
    {"sys_io_setup", "nr_events", "*ctxp", "", "", "", ""},
    {"sys_io_destroy", "ctx", "", "", "", "", ""},
    {"sys_io_getevents", "ctx_id", "min_nr", "nr", "*events", "", ""},
    {"sys_io_submit", "ctx_id", "nr", "**iocbpp", "", "", ""},
    {"sys_io_cancel", "ctx_id", "*iocb", "*result", "", "", ""},
    {"sys_get_thread_area", "arch_prctl", "", "", "", "", ""},
    {"sys_lookup_dcookie", "cookie64", "buf", "len", "", "", ""},
    {"sys_epoll_create", "size", "", "", "", "", ""},
    {"sys_epoll_ctl_old", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_epoll_wait_old", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_remap_file_pages", "start", "size", "prot", "pgoff", "flags", ""},
    {"sys_getdents64", "fd", "*dirent", "count", "", "", ""},
    {"sys_set_tid_address", "*tidptr", "", "", "", "", ""},
    {"sys_restart_syscall", "", "", "", "", "", ""},
    {"sys_semtimedop", "semid", "*tsops", "nsops", "*timeout", "", ""},
    {"sys_fadvise64", "fd", "offset", "len", "advice", "", ""},
    {"sys_timer_create", "which_clock", "*timer_event_spec",
     "*created_timer_id", "", "", ""},
    {"sys_timer_settime", "timer_id", "flags", "*new_setting", "*old_setting",
     "", ""},
    {"sys_timer_gettime", "timer_id", "*setting", "", "", "", ""},
    {"sys_timer_getoverrun", "timer_id", "", "", "", "", ""},
    {"sys_timer_delete", "timer_id", "", "", "", "", ""},
    {"sys_clock_settime", "which_clock", "*tp", "", "", "", ""},
    {"sys_clock_gettime", "which_clock", "*tp", "", "", "", ""},
    {"sys_clock_getres", "which_clock", "*tp", "", "", "", ""},
    {"sys_clock_nanosleep", "which_clock", "flags", "*rqtp", "*rmtp", "", ""},
    {"sys_exit_group", "error_code", "", "", "", "", ""},
    {"sys_epoll_wait", "epfd", "*events", "maxevents", "timeout", "", ""},
    {"sys_epoll_ctl", "epfd", "op", "fd", "*event", "", ""},
    {"sys_tgkill", "tgid", "pid", "sig", "", "", ""},
    {"sys_utimes", "*filename", "*utimes", "", "", "", ""},
    {"sys_vserver", "IMPLEMENTED", "", "", "", "", ""},
    {"sys_mbind", "start", "len", "mode", "*nmask", "maxnode", "flags"},
    {"sys_set_mempolicy", "mode", "*nmask", "maxnode", "", "", ""},
    {"sys_get_mempolicy", "*policy", "*nmask", "maxnode", "addr", "flags", ""},
    {"sys_mq_open", "*u_name", "oflag", "mode", "*u_attr", "", ""},
    {"sys_mq_unlink", "*u_name", "", "", "", "", ""},
    {"sys_mq_timedsend", "mqdes", "*u_msg_ptr", "msg_len", "msg_prio",
     "*u_abs_timeout", ""},
    {"sys_mq_timedreceive", "mqdes", "*u_msg_ptr", "msg_len", "*u_msg_prio",
     "*u_abs_timeout", ""},
    {"sys_mq_notify", "mqdes", "*u_notification", "", "", "", ""},
    {"sys_mq_getsetattr", "mqdes", "*u_mqstat", "*u_omqstat", "", "", ""},
    {"sys_kexec_load", "entry", "nr_segments", "*segments", "flags", "", ""},
    {"sys_waitid", "which", "upid", "*infop", "options", "*ru", ""},
    {"sys_add_key", "*_type", "*_description", "*_payload", "plen", "", ""},
    {"sys_request_key", "*_type", "*_description", "*_callout_info",
     "destringid", "", ""},
    {"sys_keyctl", "option", "arg2", "arg3", "arg4", "arg5", ""},
    {"sys_ioprio_set", "which", "who", "ioprio", "", "", ""},
    {"sys_ioprio_get", "which", "who", "", "", "", ""},
    {"sys_inotify_init", "", "", "", "", "", ""},
    {"sys_inotify_add_watch", "fd", "*pathname", "mask", "", "", ""},
    {"sys_inotify_rm_watch", "fd", "wd", "", "", "", ""},
    {"sys_migrate_pages", "pid", "maxnode", "*old_nodes", "*new_nodes", "", ""},
    {"sys_openat", "dfd", "*filename", "flags", "mode", "", ""},
    {"sys_mkdirat", "dfd", "*pathname", "mode", "", "", ""},
    {"sys_mknodat", "dfd", "*filename", "mode", "dev", "", ""},
    {"sys_fchownat", "dfd", "*filename", "user", "group", "flag", ""},
    {"sys_futimesat", "dfd", "*filename", "*utimes", "", "", ""},
    {"sys_newfstatat", "dfd", "*filename", "*statbuf", "flag", "", ""},
    {"sys_unlinkat", "dfd", "*pathname", "flag", "", "", ""},
    {"sys_renameat", "oldfd", "*oldname", "newfd", "*newname", "", ""},
    {"sys_linkat", "oldfd", "*oldname", "newfd", "*newname", "flags", ""},
    {"sys_symlinkat", "*oldname", "newfd", "*newname", "", "", ""},
    {"sys_readlinkat", "dfd", "*pathname", "*buf", "bufsiz", "", ""},
    {"sys_fchmodat", "dfd", "*filename", "mode", "", "", ""},
    {"sys_faccessat", "dfd", "*filename", "mode", "", "", ""},
    {"sys_pselect6", "n", "*inp", "*outp", "*exp", "*tsp", "*sig"},
    {"sys_ppoll", "*ufds", "nfds", "*tsp", "*sigmask", "sigsetsize", ""},
    {"sys_unshare", "unshare_flags", "", "", "", "", ""},
    {"sys_set_robust_list", "*head", "len", "", "", "", ""},
    {"sys_get_robust_list", "pid", "**head_ptr", "*len_ptr", "", "", ""},
    {"sys_splice", "fd_in", "*off_in", "fd_out", "*off_out", "len", "flags"},
    {"sys_tee", "fdin", "fdout", "len", "flags", "", ""},
    {"sys_sync_file_range", "fd", "offset", "bytes", "flags", "", ""},
    {"sys_vmsplice", "fd", "*iov", "nr_segs", "flags", "", ""},
    {"sys_move_pages", "pid", "nr_pages", "**pages", "*nodes", "*status",
     "flags"},
    {"sys_utimensat", "dfd", "*filename", "*utimes", "flags", "", ""},
    {"sys_epoll_pwait", "epfd", "*events", "maxevents", "timeout", "*sigmask",
     "sigsetsize"},
    {"sys_signalfd", "ufd", "*user_mask", "sizemask", "", "", ""},
    {"sys_timerfd_create", "clockid", "flags", "", "", "", ""},
    {"sys_eventfd", "count", "", "", "", "", ""},
    {"sys_fallocate", "fd", "mode", "offset", "len", "", ""},
    {"sys_timerfd_settime", "ufd", "flags", "*utmr", "*otmr", "", ""},
    {"sys_timerfd_gettime", "ufd", "*otmr", "", "", "", ""},
    {"sys_accept4", "fd", "*upeer_sockaddr", "*upeer_addrlen", "flags", "", ""},
    {"sys_signalfd4", "ufd", "*user_mask", "sizemask", "flags", "", ""},
    {"sys_eventfd2", "count", "flags", "", "", "", ""},
    {"sys_epoll_create1", "flags", "", "", "", "", ""},
    {"sys_dup3", "oldfd", "newfd", "flags", "", "", ""},
    {"sys_pipe2", "*filedes", "flags", "", "", "", ""},
    {"sys_inotify_init1", "flags", "", "", "", "", ""},
    {"sys_preadv", "fd", "*vec", "vlen", "pos_l", "pos_h", ""},
    {"sys_pwritev", "fd", "*vec", "vlen", "pos_l", "pos_h", ""},
    {"sys_rt_tgsigqueueinfo", "tgid", "pid", "sig", "*uinfo", "", ""},
    {"sys_perf_event_open", "*attr_uptr", "pid", "cpu", "group_fd", "flags",
     ""},
    {"sys_recvmmsg", "fd", "*mmsg", "vlen", "flags", "*timeout", ""},
    {"sys_fanotify_init", "flags", "event_f_flags", "", "", "", ""},
    {"sys_fanotify_mark", "fanotify_fd", "flags", "mask", "dfd", "pathname",
     ""},
    {"sys_prlimit64", "pid", "resource", "*new_rlim", "*old_rlim", "", ""},
    {"sys_name_to_handle_at", "dfd", "*name", "*handle", "*mnt_id", "flag", ""},
    {"sys_open_by_handle_at", "dfd", "*name", "*handle", "*mnt_id", "flags",
     ""},
    {"sys_clock_adjtime", "which_clock", "*tx", "", "", "", ""},
    {"sys_syncfs", "fd", "", "", "", "", ""},
    {"sys_sendmmsg", "fd", "*mmsg", "vlen", "flags", "", ""},
    {"sys_setns", "fd", "nstype", "", "", "", ""},
    {"sys_getcpu", "*cpup", "*nodep", "*unused", "", "", ""},
    {"sys_process_vm_readv", "pid", "*lvec", "liovcnt", "*rvec", "riovcnt",
     "flags"},
    {"sys_process_vm_writev", "pid", "*lvec", "liovcnt", "*rvec", "riovcnt",
     "flags"},
    {"sys_kcmp", "pid1", "pid2", "type", "idx1", "idx2", ""},
    {"sys_finit_module", "fd", "*uargs", "flags", "", "", ""},
    {"sys_sched_setattr", "pid", "*attr", "flags", "", "", ""},
    {"sys_sched_getattr", "pid", "*attr", "size", "flags", "", ""},
    {"sys_renameat2", "olddfd", "*oldname", "newdfd", "*newname", "flags", ""},
    {"sys_seccomp", "op", "flags", "*uargs", "", "", ""},
    {"sys_getrandom", "*buf", "count", "flags", "", "", ""},
    {"sys_memfd_create", "*uname_ptr", "flags", "", "", "", ""},
    {"sys_kexec_file_load", "kernel_fd", "initrd_fd", "cmdline_len",
     "*cmdline_ptr", "flags", ""},
    {"sys_bpf", "cmd", "*attr", "size", "", "", ""},
    {"stub_execveat", "dfd", "*filename", "*argv", "*envp", "flags", ""},
    {"userfaultfd", "flags", "", "", "", "", ""},
    {"membarrier", "cmd", "flags", "", "", "", ""},
    {"mlock2", "start", "len", "flags", "", "", ""},
    {"copy_file_range", "fd_in", "*off_in", "fd_out", "off_out", "len",
     "flags"},
    {"preadv2", "fd", "*vec", "vlen", "pos_l", "pos_h", "flags"},
    {"pwritev2", "fd", "*vec", "vlen", "pos_l", "pos_h", "flags"},
    {"pkey_mprotect", "", "", "", "", "", ""},
    {"pkey_alloc", "", "", "", "", "", ""},
    {"pkey_free", "", "", "", "", "", ""},
    {"statx", "", "", "", "", "", ""},
    {"io_pgetevents", "", "", "", "", "", ""},
    {"rseq", "", "", "", "", "", ""},
    {"pkey_mprotect", "", "", "", "", "", ""}};

#endif
