package main

import (
	"fmt"
	"os"
	"path/filepath"
	"time"

	"github.com/briandowns/spinner"
)

func buildCSProj(spinner *spinner.Spinner, name string, curDir string) error {
	fmt.Println(" C# init")
	spinner.Start()

	if _, err := os.Stat("/home/" + currentUser.Username + "/.bflat/bflat"); os.IsNotExist(err) {
		if err := DownloadCSCompiler("/home/" + currentUser.Username); err != nil {
			return err
		}
	}

	err := os.WriteFile("malino.generated.cs", []byte(
		"namespace "+name+" {\n"+
			"	// Don't you dare mess with this.\n"+
			"	public class MalinoAutoGenerated {\n"+
			"		public static string OSVersion = \""+time.Now().Format("060102")+"\";\n"+
			"	}\n"+
			"}"), 0777)
	if err != nil {
		spinner.Stop()
		return err
	}

	csFiles, err := getCsFiles(curDir)
	if err != nil {
		return err
	}
	buildCmd := append([]string{"/home/" + currentUser.Username + "/.bflat/bflat", "build", "-o", "mInit", "-r/opt/malino/libmalino-cs.dll"}, csFiles...)

	if len(buildflags) == 0 {
		if err := execCmd(true, buildCmd...); err != nil {
			spinner.Stop()
			return err
		}
	} else {
		if err := execCmd(true, append(buildCmd, buildflags...)...); err != nil {
			spinner.Stop()
			return err
		}
	}

	spinner.Stop()
	return nil
}

func DownloadCSCompiler(homeDirectory string) error {
	wd, err := os.Getwd()
	if err != nil {
		return err
	}

	if err := downloadFile("https://github.com/bflattened/bflat/releases/download/v8.0.2/bflat-8.0.2-linux-glibc-x64.tar.gz", "bflat.tar.gz"); err != nil {
		return err
	}

	if err := createAndCD(homeDirectory + "/.bflat"); err != nil {
		return err
	}

	if err := execCmd(true, "tar", "-xzf", wd+"/bflat.tar.gz"); err != nil {
		return err
	}

	if err := os.Chdir(wd); err != nil {
		return err
	}

	if err := os.Remove("bflat.tar.gz"); err != nil {
		return err
	}

	return nil
}

func getCsFiles(dir string) ([]string, error) {
	var csFiles []string

	err := filepath.Walk(dir, func(path string, info os.FileInfo, err error) error {
		if err != nil {
			return err
		}
		if !info.IsDir() && filepath.Ext(info.Name()) == ".cs" {
			csFiles = append(csFiles, path)
		}
		return nil
	})

	if err != nil {
		return nil, err
	}

	return csFiles, nil
}
