require "active_support/core_ext/integer/time"

require "dotenv"
Dotenv.load(".env.local", ".env.#{Rails.env}")

Rails.application.configure do

  config.session_store :redis_session_store,
    serializer: :json,
    on_redis_down: ->(*a) { Rails.logger.error("Redis down! #{a.inspect}") },
    redis: {
      expire_after: 120.days,
      key_prefix: "session:",
      url: ENV.fetch("REDIS_URL") { "redis://default:password@host.docker.internal:6379/1" }
    }

  config.action_controller.default_url_options = {host: "localhost", port: 3000}
  config.action_mailer.default_url_options = {host: "localhost", port: 3000}

  config.web_console.allowed_ips = ["0.0.0.0/0"]

  # Settings specified here will take precedence over those in config/application.rb.

  # In the development environment your application's code is reloaded any time
  # it changes. This slows down response time but is perfect for development
  # since you don't have to restart the web server when you make code changes.
  config.cache_classes = false

  # Do not eager load code on boot.
  config.eager_load = false

  # Show full error reports.
  config.consider_all_requests_local = true

  # Enable server timing
  config.server_timing = true

  # Enable caching by default for StimulusReflex
  config.action_controller.perform_caching = true
  config.action_controller.enable_fragment_cache_logging = true

  config.cache_store = :redis_cache_store, {
    url: ENV.fetch("REDIS_URL") { "redis://default:password@host.docker.internal:6379/1" }

  }
  config.public_file_server.headers = {
    "Cache-Control" => "public, max-age=#{2.days.to_i}"
  }

  # Store uploaded files on the local file system (see config/storage.yml for options).
  config.active_storage.service = :local

  # Don't care if the mailer can't send.
  config.action_mailer.raise_delivery_errors = false

  config.action_mailer.perform_caching = false

  # Print deprecation notices to the Rails logger.
  config.active_support.deprecation = :log

  # Raise exceptions for disallowed deprecations.
  config.active_support.disallowed_deprecation = :raise

  # Tell Active Support which deprecation messages to disallow.
  config.active_support.disallowed_deprecation_warnings = []

  # Raise an error on page load if there are pending migrations.
  config.active_record.migration_error = :page_load

  # Highlight code that triggered database queries in logs.
  config.active_record.verbose_query_logs = true

  # Suppress logger output for asset requests.
  config.assets.quiet = true
  config.assets.compile = true

  # Raises error for missing translations.
  # config.i18n.raise_on_missing_translations = true

  # Annotate rendered view with file names.
  config.action_view.annotate_rendered_view_with_filenames = true

  # Uncomment if you wish to allow Action Cable access from any origin.
  # config.action_cable.disable_request_forgery_protection = true
end
