<template>
  <el-dropdown trigger="click" class='international' @command="handleSetLanguage">
    <div style="font-size:20px;cursor: pointer;vertical-align: -5px!important;">
      <svg-icon class-name='international-icon' icon-class="language" />
    </div>
    <el-dropdown-menu slot="dropdown">
    <#list langs as lang>
      <el-dropdown-item command="${lang}" :disabled="language==='${lang}'">${lang}</el-dropdown-item>
    </#list>
    </el-dropdown-menu>
  </el-dropdown>
</template>

<script>
export default {
  computed: {
    language() {
      return this.$store.getters.language
    }
  },
  methods: {
    handleSetLanguage(lang) {
      this.$i18n.locale = lang
      this.$store.dispatch('setLanguage', lang)
      this.$message({
        message: 'switch language success',
        type: 'success'
      })
    }
  }
}
</script>

<style scoped>
.international-icon {
  font-size: 20px;
  cursor: pointer;
  vertical-align: -5px!important;
}
</style>