<?php

namespace Magetop\AjaxCartPro\Controller\Cart;



use Magento\Catalog\Api\ProductRepositoryInterface;

use Magento\Checkout\Model\Cart as CustomerCart;

use Magento\Framework\Exception\NoSuchEntityException;



/**

 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)

 */

class Add extends \Magento\Checkout\Controller\Cart

{

    /**

     * @var ProductRepositoryInterface

     */

    protected $productRepository;

	protected $imgHelper;

	protected $outputHelper;

	protected $productUrl;

	protected $checkoutHelper;

	protected $crossell;

	protected $cartData;

    /**

     * @param \Magento\Framework\App\Action\Context $context

     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig

     * @param \Magento\Checkout\Model\Session $checkoutSession

     * @param \Magento\Store\Model\StoreManagerInterface $storeManager

     * @param \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator

     * @param CustomerCart $cart

     * @param ProductRepositoryInterface $productRepository

     * @codeCoverageIgnore

     */

    public function __construct(

        \Magento\Framework\App\Action\Context $context,

        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,

        \Magento\Checkout\Model\Session $checkoutSession,

        \Magento\Store\Model\StoreManagerInterface $storeManager,

        \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator,

		\Magento\Catalog\Helper\Output $outputHelper,

		\Magento\Catalog\Helper\Image $imgHelper,

		\Magento\Catalog\Model\Product\Url $productUrl,

        CustomerCart $cart,

		\Magento\Checkout\Helper\Data $checkoutHelper,

        ProductRepositoryInterface $productRepository,

		\Magetop\AjaxCartPro\Controller\Product\Crosssell $crossell,

		\Magento\Checkout\CustomerData\Cart $cartData

    ) {

        parent::__construct(

            $context,

            $scopeConfig,

            $checkoutSession,

            $storeManager,

            $formKeyValidator,

            $cart

        );

		$this->checkoutHelper = $checkoutHelper;

		$this->imgHelper = $imgHelper;

		$this->outputHelper = $outputHelper;

		$this->productUrl = $productUrl;

        $this->productRepository = $productRepository;

		$this->crossell = $crossell;

		$this->cartData = $cartData;

    }



    /**

     * Initialize product instance from request data

     *

     * @return \Magento\Catalog\Model\Product|false

     */

    protected function _initProduct()

    {

        $productId = (int)$this->getRequest()->getParam('product');

        if ($productId) {

            $storeId = $this->_objectManager->get('Magento\Store\Model\StoreManagerInterface')->getStore()->getId();

            try {

                return $this->productRepository->getById($productId, false, $storeId);

            } catch (NoSuchEntityException $e) {

                return false;

            }

        }

        return false;

    }



    /**

     * Add product to shopping cart action

     *

     * @return \Magento\Framework\Controller\Result\Redirect

     * @SuppressWarnings(PHPMD.CyclomaticComplexity)

     */

    public function execute()

    {

        if (!$this->_formKeyValidator->validate($this->getRequest())) {

            return $this->resultRedirectFactory->create()->setPath('*/*/');

        }



        $params = $this->getRequest()->getParams();

        try {

            if (isset($params['qty'])) {

                $filter = new \Zend_Filter_LocalizedToNormalized(

                    ['locale' => $this->_objectManager->get('Magento\Framework\Locale\ResolverInterface')->getLocale()]

                );

                $params['qty'] = $filter->filter($params['qty']);

            }



            $product = $this->_initProduct();

            $related = $this->getRequest()->getParam('related_product');



            /**

             * Check product availability

             */

            if (!$product) {

                return $this->goBack();

            }



            $this->cart->addProduct($product, $params);

            if (!empty($related)) {

                $this->cart->addProductsByIds(explode(',', $related));

            }



            $this->cart->save();



            /**

             * @todo remove wishlist observer \Magento\Wishlist\Observer\AddToCart

             */

            $this->_eventManager->dispatch(

                'checkout_cart_add_product_complete',

                ['product' => $product, 'request' => $this->getRequest(), 'response' => $this->getResponse()]

            );



            if (!$this->_checkoutSession->getNoCartRedirect(true)) {

                if (!$this->cart->getQuote()->getHasError()) {

                    $message = __(

                        'You added %1 to your shopping cart.',

                        $product->getName()

                    );

                    $this->messageManager->addSuccessMessage($message);

                }

                return $this->goBack(null, $product, $params);

            }

        } catch (\Magento\Framework\Exception\LocalizedException $e) {

            if ($this->_checkoutSession->getUseNotice(true)) {

                $this->messageManager->addNotice(

                    $this->_objectManager->get('Magento\Framework\Escaper')->escapeHtml($e->getMessage())

                );

            } else {

                $messages = array_unique(explode("\n", $e->getMessage()));

                foreach ($messages as $message) {

                    $this->messageManager->addError(

                        $this->_objectManager->get('Magento\Framework\Escaper')->escapeHtml($message)

                    );

                }

            }



            $url = $this->_checkoutSession->getRedirectUrl(true);



            if (!$url) {

                $cartUrl = $this->_objectManager->get('Magento\Checkout\Helper\Cart')->getCartUrl();

                $url = $this->_redirect->getRedirectUrl($cartUrl);

            }



            return $this->goBack($url);



        } catch (\Exception $e) {

            $this->messageManager->addException($e, __('We can\'t add this item to your shopping cart right now.'));

            $this->_objectManager->get('Psr\Log\LoggerInterface')->critical($e);

            return $this->goBack();

        }

    }



    /**

     * Resolve response

     *

     * @param string $backUrl

     * @param \Magento\Catalog\Model\Product $product

     * @return $this|\Magento\Framework\Controller\Result\Redirect

     */

    protected function goBack($backUrl = null, $product = null, $params = null)

    {

        if (!$this->getRequest()->isAjax()) {

            return parent::_goBack($backUrl);

        }



        $result = [];



        if ($backUrl || $backUrl = $this->getBackUrl()) {

            $result['backUrl'] = $backUrl;

        } else {

            if ($product && !$product->getIsSalable()) {

                $result['product'] = [

                    'statusText' => __('Out of stock')

                ];

            }

        }

		

		if ($product) {

			/* $crosssellLayout = $this->crossell->execute();

			$crosssellLayout->addHandle('ajaxcartpro_product_crosssell');

			$crosssellHtml = $crosssellLayout->getLayout()->getBlock('product_crosssell')->toHtml();*/

			$crosssellHtml = '';

			$result['product'] = [

				'success' => true,

				'img' => (string)$this->imgHelper->init($product, 'product_page_image_large')->resize(100,100)->getUrl(),

				'name' => $this->outputHelper->productAttribute($product, $product->getName(), 'name'),

				'id' => $product->getId(),

				'url' => $this->productUrl->getUrl($product),

				'params' => $params,

				'price' => $this->checkoutHelper->formatPrice($product->getFinalPrice())

			];

			$result['crosssell'] = ['html' => $crosssellHtml];

			$result['cart'] = $this->cartData->getSectionData();

		}

        $this->getResponse()->representJson(

            $this->_objectManager->get('Magento\Framework\Json\Helper\Data')->jsonEncode($result)

        );

    }

}

