# Magento 2 Ajax Cart Extension by Magetop

**Magento 2 Ajax Cart Extension** by Magetop offers the main function of adding products to the cart via an AJAX pop-up. It significantly improves the user experience by allowing customers to add any product type to the cart right from the product list page. They no longer have to visit each product page, especially for products with many options such as configurable products, grouped products, and bundle products.

This extension is necessary for any ecommerce site to boost shopping experience. After tapping “Add to Cart” button, customers can select product options and add that product to cart in the Ajax pop-up. Then, another pop-up is displayed to notify the product added to cart successfully, cart subtotal and related product block which smartly promotes other products.

## Highlight features

- Automatically reload and recalculate Cart using AJAX when quantity changes.
- Show -/+ buttons around item quantity on cart page.
- Show item quantity as select instead numeric field.
- Show user confirmation when change item quantity to zero.
- Allow to change/synchronize quantities in shop, minicart and single product pages.
- Make the Add to cart button to perform with AJAX, without full page reload.
- Faster AJAX reload call when change quantities in Cart page.
- Option to lock quantity inputs to allow only change using plus and minus buttons.
- Compatible with different themes such as Porto, Ultimo, etc...
- 100% Open-source, Support multi-store, Support multi-language.
- Easy to install and customize.
- And many more feature ...

## More features & demo

- Extension details : https://www.magetop.com/magento-2-ajax-cart-extension.html
- Category page demo : https://livedemo.magetop.com/ajaxcart/men/tops-men.html
- Product page demo : https://livedemo.magetop.com/ajaxcart/sinbad-fitness-tank.html

## Support & contact info

- Need help setting up or want to customize this extension to meet your business needs? 
- Get instant support with our Live Chat
- Send Us an email to info@magetop.com or Contact Us : https://www.magetop.com/contacts
