# Machine Learning Tutorials and Articles

<img alt="GitHub stars" src="https://img.shields.io/github/stars/maelfabien/Machine_Learning_Tutorials.svg?style=social"> <img alt="GitHub forks" src="https://img.shields.io/github/forks/maelfabien/Machine_Learning_Tutorials.svg?style=social"> <img alt="GitHub watchers" src="https://img.shields.io/github/watchers/maelfabien/Machine_Learning_Tutorials.svg?style=social"> <img alt="GitHub followers" src="https://img.shields.io/github/followers/maelfabien.svg?style=social"> <img alt="GitHub commit activity" src="https://img.shields.io/github/commit-activity/y/maelfabien/Machine_Learning_Tutorials.svg"> <img alt="GitHub contributors" src="https://img.shields.io/github/contributors-anon/maelfabien/Machine_Learning_Tutorials.svg"> <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/3.svg">

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/mf_logo_short.jpg" alt="Illustration" width="50px"/>

In this repository, I'm uploading code, notebooks and articles from my personal blog : https://maelfabien.github.io/. Don't hesitate to ⭐ the repo if you enjoy my work ! New articles are being published weekly !

🚀 I recently started a newsletter in which I gather some cool articles I wrote on a topic, interesting Github repositories, projects, papers and more! I’ll try to send 1 to 2 emails per month. If you want to stay in the loop, just click here : http://eepurl.com/gyYzi5 

**NEW: I'm looking for motivated Data Scientists to help me build high environmental impact algorithms (CV essentially). Please contact me if you're interested (from my website, contact section)**

## Table of Content :
- [CheatSheets](https://github.com/maelfabien/Machine_Learning_Tutorials#machine-learning-cheatsheet)
- [Latest Articles](https://github.com/maelfabien/Machine_Learning_Tutorials/#latest-articles)
- [Machine Learning](https://github.com/maelfabien/Machine_Learning_Tutorials#machine-learning)
- [Deep Learning](https://github.com/maelfabien/Machine_Learning_Tutorials#deep-learning)
- [Data Engineering](https://github.com/maelfabien/Machine_Learning_Tutorials#data-engineering)
- [Written for other blogs](https://github.com/maelfabien/Machine_Learning_Tutorials#written-for-other-blogs)
- [Medium Articles](https://github.com/maelfabien/Machine_Learning_Tutorials#medium-articles)

<br>

First of all, if you're not familiar with the key concepts of machine learrning, make sure to check this first article :
https://maelfabien.github.io/machinelearning/ml_base/

The repository is organized the following way :
- articles and tutorials are posted by category
- there is a link to the article in question with the read time specified
- the is a link to the code folder for each article

You would like to work on an article with me ? Or you would like me to work on a specific topic ? Feel free to reach out ! (mael.fabien@gmail.com)

# Machine Learning Cheatsheet :

For the moment, these cheat sheets are written manually. I'd like to create a visual content later that would both dive in the maths and illustrate clearly each algorithm.

1. Supervised Learning

<a href="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/supervised.pdf"><img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/sup.png?" alt="Illustration" width="220px"/></a>

2. Unsupervised Learning 

<a href="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/unsupervised.pdf"><img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/unsup.png?" alt="Illustration" width="220px"/></a>

<br>

# Projects

I have made a series of projects, all of which are available on my blog : https://maelfabien.github.io/portfolio/#

<a href="https://maelfabien.github.io/portfolio/#">
<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/new_proj.png" alt="Illustration"/>
</a>

# Latest articles

[SP - Voice Gender Detection web application](https://maelfabien.github.io/machinelearning/Speech11/#): How to extract relevant features and build a voice gender detection application using MFCC, GMMs and a provided dataset.

[SP - Sound Visualization (3/3)](https://maelfabien.github.io/machinelearning/Speech10/#): Dive into spectrograms, chromagrams, tempograms, spectral power density and more...

[SP - Sound Feature Extraction (2/3)](https://maelfabien.github.io/machinelearning/Speech9/#): An overview with a Python implementation of the different sound features to extract.

[SP - Introduction to Voice Processing in Python (1/3)](https://maelfabien.github.io/machinelearning/Speech8/#): Summary of the book "Voice Computing with Python" with concepts, code and examples.

[SP - Building a Voice Activity Detection web application](https://maelfabien.github.io/machinelearning/Speech4/#) : Voice detection can be used to start a voice assistant or in emergency cases for example. Here's how to implement it using simple methods.

[CV - Implementing YoloV3 for Object Detection](https://maelfabien.github.io/computervision/yolo/) : Learn how to implement YoloV3 and detect objects on your images and videos.

[NLP - Easy Question Answering with AllenNLP](https://maelfabien.github.io/machinelearning/NLP_9/) : Understand the core concepts and create a simple example of Question Answering.

[NLP - Data Augmentation in NLP](https://maelfabien.github.io/machinelearning/NLP_8/) : Details of the implementation of “Easy Data Augmentation” paper.

[NLP - Character-level LSTMs to predict gender of first names](https://maelfabien.github.io/machinelearning/NLP_7/) : 90% accuracy on predictiong the gender of French and US first names.

[NLP - Few Shot Text Classification](https://maelfabien.github.io/machinelearning/NLP_5) : Implementation of a simple paper that leverages pre-trained models for few shot text classification.

[NLP - Improved Few Shot Text Classification](https://maelfabien.github.io/machinelearning/NLP_6) : Improving previous results with Data Augmentation and more complex models.

[RL - Introduction to Reinforcement Learning](https://maelfabien.github.io/rl/RL_1) : An introduction to the basic building blocks of reinforcement learning.

[RL - Markov Decision Process](https://maelfabien.github.io/rl/RL_2/) : Overview of Markov Decision Process and Bellman Equation.

[RL - Planning by Dynamic Programming](https://maelfabien.github.io/rl/RL_3/) : Introduction to Dynamic Programming, including Policy and Value Iteration.

[NLP - I trained a Neural Network to speak like me](https://maelfabien.github.io/machinelearning/NLP_4/) : Having written over 100 articles, I trained a NN to write articles just like me.

[DL - How do Neural Networks learn?](https://maelfabien.github.io/deeplearning/feed/) : Dive into feedforward process and back-propagation.

<center><a href="https://maelfabien.github.io/year-archive/#">See More</a></center>

<br>
<br>

<img src="https://github.com/maelfabien/maelfabien.github.io/blob/master/assets/images/ml_head.jpg" alt="Illustration"/>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/s_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| The linear regression model (1/2) | 14mn | [here](https://maelfabien.github.io/statistics/linreg/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/2-Statistics/LinearRegression) |
| The linear regression model (3/2) | 10mn | [here](https://maelfabien.github.io/statistics/linreg2/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/2-Statistics/LinearRegression) |
| Basics of Statistical Hypothesis Testing | 5mn | [here](https://maelfabien.github.io/statistics/Tests/) | --- |
| The Logistic Regression | 4mn | [here](https://maelfabien.github.io/statistics/linreg3/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/2-Statistics/LogisticRegression) |
| Statistics in Matlab | 4mn | [here](https://maelfabien.github.io/statistics/matlab/) | --- |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/sup_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| The Basics of Machine Learning | 4mn | [here](https://maelfabien.github.io/machinelearning/ml_base/) | --- |
| Bayes Classifier | 1mn | [here](https://maelfabien.github.io/machinelearning/bayes/) | --- |
| Linear Discriminant Analysis | 3mn | [here](https://maelfabien.github.io/machinelearning/LDA/) | --- |
| Adaboost and Boosting | 7mn | [here](https://maelfabien.github.io/machinelearning/adaboost/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/AdaBoost) |
| Gradient Boosting Regression | 6mn | [here](https://maelfabien.github.io/machinelearning/GradientBoost/#) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GradientBoost) |
| Gradient Boosting Classification | 3mn | [here](https://maelfabien.github.io/machinelearning/GradientBoostC/#) | --- |
| Large Scale Kernel Methods for SVM | 9mn | [here](https://maelfabien.github.io/machinelearning/largescale/#svm-classifier) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/LargeScaleKernel) |
| Anomaly Detection | 3mn | [here](https://maelfabien.github.io/machinelearning/anomaly/) | --- |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/ts_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to Time Series | 4mn | [here](https://maelfabien.github.io/statistics/TimeSeries1/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/2-Statistics/TimeSeries) |
| Key concepts of Time Series | 4mn | [here](https://maelfabien.github.io/statistics/TimeSeries2/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/2-Statistics/TimeSeries) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/mc_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Markov Chains | 9mn | [here](https://maelfabien.github.io/machinelearning/HMM_1/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/HMM) |
| Hidden Markov Models | 6mn | [here](https://maelfabien.github.io/machinelearning/HMM_2/) | --- |
| Build a language recognition app from scratch | 10mn | [here](https://maelfabien.github.io/machinelearning/HMM_3/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/HMM) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/graph_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to Graph Mining | 5mn | [here](https://maelfabien.github.io/machinelearning/graph_1/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GraphMining) |
| Graph Analysis | 4mn | [here](https://maelfabien.github.io/machinelearning/graph_2/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GraphMining) |
| Graph Algorithms | 11mn | [here](https://maelfabien.github.io/machinelearning/graph_3/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GraphMining) |
| Graph Learning | 8mn | [here](https://maelfabien.github.io/machinelearning/graph_4/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GraphMining) |
| Graph Embedding | 4mn | [here](https://maelfabien.github.io/machinelearning/graph_5/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/GraphMining) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/opt_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| GridSearch vs. Randomized Search | 2mn | [here](https://maelfabien.github.io/machinelearning/GridRand/) | --- |
| AutoML with h2o | 6mn | [here](https://maelfabien.github.io/machinelearning/AutoML/#) | --- |
| Bayesian Hyperparameter Optimization | 7mn | [here](https://maelfabien.github.io/machinelearning/HyperOpt/#) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/3-MachineLearning/BayesianHyperOpt) |
| Machine Learning Explainability | 12mn | [here](https://maelfabien.github.io/machinelearning/Explainability/#) | --- |
<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/dv_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to Data Viz | 12mn | [here](https://maelfabien.github.io/machinelearning/Dataviz/) | --- |
| Visual Recommendation System | 4mn | [here](https://maelfabien.github.io/machinelearning/VizReco/#) | --- |
| Interactive graphs in Python with Altair | 5mn | [here](https://maelfabien.github.io/machinelearning/Altair/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/6-DataViz/Altair) |
| Dynamic plots with BQ-Plot | --- | --- | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/6-DataViz/BQPlot) |
| An interactive tool with Altair | --- | [here](https://maelfabien.github.io/tsne) | --- |
| An interactive tool with D3.js | --- | [here](https://maelfabien.github.io/viz) | --- |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/on_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to Online Learning | 5mn | [here](https://maelfabien.github.io/machinelearning/Online/) | --- |
| Linear Classification | 1mn | [here](https://maelfabien.github.io/machinelearning/Online2/) | --- |

<br>

<img src="https://github.com/maelfabien/maelfabien.github.io/blob/master/assets/images/dl_head.jpg" alt="Illustration"/>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/tdl_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| The Rosenbaltt's Perceptron | 8mn | [here](https://maelfabien.github.io/deeplearning/Perceptron/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/Perceptron) |
| Multilayer Perceptron (MLP) | 5mn | [here](https://maelfabien.github.io/deeplearning/mlp/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/MultilayerPerceptron) |
| Prevent Overfitting of Neural Netorks | 6mn | [here](https://maelfabien.github.io/deeplearning/regu/) | --- |
| Full introduction to Neural Nets | 6mn | [here](https://maelfabien.github.io/deeplearning/intro/) | --- |
| Convolutional Neural Network | 6mn | [here](https://maelfabien.github.io/deeplearning/cnn/#) | --- |
| How do Neural Networks learn? | 3mn | [here](https://maelfabien.github.io/deeplearning/feed/) | --- |
| Activation functions in DL | 3mn | [here](https://maelfabien.github.io/deeplearning/act/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/Activations) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/arc_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Inception Architecture in Keras | 2mn | [here](https://maelfabien.github.io/deeplearning/inception/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/Inception) |
| Build an autoencoder using Keras functional API | 5mn | [here](https://maelfabien.github.io/deeplearning/autoencoder/) | --- |
| XCeption Architecture | 5mn | [here](https://maelfabien.github.io/deeplearning/xception/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/Xception) |
| GANs on the MNIST dataset | --- | --- | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/4-DeepLearning/GANs) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/cv_head.png" alt="Illustration"/>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/cv_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Build an Emotion Recognition WebApp from scratch | 8mn | [here](https://maelfabien.github.io/project/poleemploi/) | [here](https://github.com/maelfabien/Multimodal-Emotion-Recognition) |
| A full guide to Face, Mouth and Eyes Real Time detection | 16mn | [here](https://maelfabien.github.io/tutorials/face-detection/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/1_Computer%20Vision/01-FaceDetection) |
| How to use OpenPose on MacOS ? | 3mn | [here](https://maelfabien.github.io/tutorials/open-pose/) | --- |
| Introduction to Computer Vision | 1mn | [here](https://maelfabien.github.io/computervision/cv_1/) | --- |
| Image Filtering and Image Gradients | 5mn | [here](https://maelfabien.github.io/computervision/cv_2/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/1_Computer%20Vision/04-ImageFiltering) |
| Advanced Filtering and Image Transformation | 5mn | [here](https://maelfabien.github.io/computervision/cv_3/#) | --- |
| Image Features, Panorama, Matching | 5mn | [here](https://maelfabien.github.io/computervision/cv_4/#) | --- |
| Implementing YoloV3 for Object Detection | 3mn | [here](https://maelfabien.github.io/computervision/yolo/) | --- |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/nlp_head.png" alt="Illustration"/>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/nlp_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to NLP | 1mn | [here](https://maelfabien.github.io/machinelearning/NLP_0/#) | --- |
| Text Pre-Processing | 8mn | [here](https://maelfabien.github.io/machinelearning/NLP_1/) | --- |
| Text Embedding with BoW and Tf-Idf  | 5mn | [here](https://maelfabien.github.io/machinelearning/NLP_2/) | --- |
| Text Embedding with Word2Vec | 6mn | [here](https://maelfabien.github.io/machinelearning/NLP_3/) | --- |
| I trained a Neural Network to speak like me | 8mn | [here](https://maelfabien.github.io/machinelearning/NLP_4/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/5-NLP/SpeakLikeMe) |
| I trained a Neural Network to speak like me | 8mn | [here](https://maelfabien.github.io/machinelearning/NLP_4/) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/5-NLP/SpeakLikeMe) |
| Few Shot Text Classification | 10mn | [here](https://maelfabien.github.io/machinelearning/NLP_5) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/5-NLP/FewShotClassification) | 
| Improved Few Shot Text Classification | 9mn | [here](https://maelfabien.github.io/machinelearning/NLP_6) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/5-NLP/FewShotClassification) |
| Predicting Gender of First Names | 7mn | [here](https://maelfabien.github.io/machinelearning/NLP_7) | [here](https://github.com/maelfabien/Machine_Learning_Tutorials/tree/master/5-NLP/GenderClassification) |
| Data Augmentation in NLP | 3mn | [here](https://maelfabien.github.io/machinelearning/NLP_8) | --- |
| Easy Question Answering with AllenNLP | 4mn | [here](https://maelfabien.github.io/machinelearning/NLP_9) | --- |

<br>

<img src="https://github.com/maelfabien/maelfabien.github.io/blob/master/assets/images/rl_head.jpg" alt="Illustration"/>

<img src="https://github.com/maelfabien/maelfabien.github.io/blob/master/assets/images/trl_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article | Code Folder |
| --- | --- | --- | --- |
| Introduction to Reinforcement Learning | 6mn | [here](https://maelfabien.github.io/rl/RL_1) | --- |
| Markov Decision Process | 7mn | [here](https://maelfabien.github.io/rl/RL_2/) | --- |
| Planning by Dynamic Programming | 4mn | [here](https://maelfabien.github.io/rl/RL_3/) | --- |

<br>

<img src="https://github.com/maelfabien/maelfabien.github.io/blob/master/assets/images/bgd_head.jpg" alt="Illustration"/>

Two general articles :

1. Understanding Computer Components (6mn read)
https://maelfabien.github.io/bigdata/comp_components/

2. Useful Bash commands (1mn read) 
https://maelfabien.github.io/bigdata/Terminal/

3. Making your code production ready (1mn read)
https://maelfabien.github.io/bigdata/Code/

<br>


<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/hadoop_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| Introduction to Hadoop | 4mn | [here](https://maelfabien.github.io/bigdata/hadoop/) |
| MapReduce | 3mn | [here](https://maelfabien.github.io/bigdata/MapReduce/#) |
| HDFS | 2mn | [here](https://maelfabien.github.io/bigdata/HDFS/#) |
| VMs in Virtual Box | 1mn | [here](https://maelfabien.github.io/bigdata/VM/#) |
| Hadoop with the HortonWorks Sandbox | 2mn | [here](https://maelfabien.github.io/bigdata/HortonWorks/) |
| Load and move files to HDFS | 2mn | [here](https://maelfabien.github.io/bigdata/HDFS_2/) |
| Launch a MapReduce Job | 2mn | [here](https://maelfabien.github.io/bigdata/MRJob/) |
| MapReduce Jobs in Python | 3mn | [here](https://maelfabien.github.io/bigdata/MRJobP/) |
| MapReduce Job in Python locally | 1mn | [here](https://maelfabien.github.io/bigdata/MRH/) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/spark_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| Introduction to Spark | 6mn | [here](https://maelfabien.github.io/bigdata/spark1/) |
| Install Spark-Scala and PySpark | 1mn | [here](https://maelfabien.github.io/bigdata/spark2/) |
| Discover Spark-Scala | 2mn | [here](https://maelfabien.github.io/bigdata/spark3/#) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/nosql_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| A No-SQL project from scratch | 8mn | [here](https://maelfabien.github.io/project/nosql_recap/) |
| Big (Open) Data, the GDelt project | 2mn | [here](https://maelfabien.github.io/bigdata/zeppelin-GDELT/) |
| Install Zeppelin locally | 1mn | [here](https://maelfabien.github.io/bigdata/zeppelin_local/) |
| Run Zeppelin on AWS EMR | 4mn | [here](https://maelfabien.github.io/bigdata/zeppelin_emr/) |
| Work with S3 buckets | 1mn | [here](https://maelfabien.github.io/bigdata/storage/) |
| Launch and access AWS EC2 instances | 2mn | [here](https://maelfabien.github.io/bigdata/EC2/) |
| Install Apache Cassandra on EC2 Cluster | 2mn | [here](https://maelfabien.github.io/bigdata/EC2_Cassandra/) |
| Install Zookeeper on EC2 instances | 3mn | [here](https://maelfabien.github.io/bigdata/ZK/) |
| Build an ETL in Scala | 3mn | [here](https://maelfabien.github.io/bigdata/Scala/) |
| Move Scala Dataframes to Cassandra | 2mn | [here](https://maelfabien.github.io/bigdata/Scala_Cassandra/) |
| Move Scala Dataframes to Cassandra | 2mn | [here](https://maelfabien.github.io/bigdata/Scala_Cassandra/) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/aws_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| AWS Cloud Concepts | 2mn | [here](https://maelfabien.github.io/bigdata/cloud_concept/) |
| AWS Core Services | 1mn | [here](https://maelfabien.github.io/bigdata/core_services/) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/gcp_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| TPU Survival Guide on Colab | 8mn | [here](https://maelfabien.github.io/bigdata/ColabTPU/) |
| Store files on Google Cloud and Colab | 1mn | [here](https://maelfabien.github.io/bigdata/ColabDrive/) |
| TPU Survival Guide on Colab | 8mn | [here](https://maelfabien.github.io/bigdata/ColabTPU/) |
| Introduction to GCP (Week 1 Module 1) | 6mn | [here](https://maelfabien.github.io/bigdata/gcps_1/) |
| Lab - Instance VM + Cloud Storage| 3mn | [here](https://maelfabien.github.io/bigdata/gcps-2/) |
| Lab - BigQuery Public Datasets| 1mn | [here](https://maelfabien.github.io/bigdata/gcps-3/) |
| Introduction to Recommendation Systems (Week 1 Module 2)  | 4mn | [here](https://maelfabien.github.io/bigdata/gcps_4/) |
| Run Spark jobs on Cloud DataProc (Week 1 Module 2) | 2mn | [here](https://maelfabien.github.io/bigdata/gcps_5/) |
| Lab - Recommend products using Cloud SQL and SparkML | 6mn | [here](https://maelfabien.github.io/bigdata/gcps_6/) |
| Run ML models in SQL with BigQuery ML (Week 1 Module 3) | 6mn | [here](https://maelfabien.github.io/bigdata/gcps_7/) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/elk_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| Introduction to ElasticStack | 1mn | [here](https://maelfabien.github.io/bigdata/ElasticStack/) |
| Getting Started with ElasticSearch and Kibana | 7mn | [here](https://maelfabien.github.io/bigdata/ElasticCloud/) |
| Install and run Kibana locally | 1mn | [here](https://maelfabien.github.io/bigdata/Elasticsearch/) |
| Working with DevTools in ElasticSearch | 9mn | [here](https://maelfabien.github.io/bigdata/DevTools/) |
| Working with DevTools in ElasticSearch | 9mn | [here](https://maelfabien.github.io/bigdata/DevTools/) |

<br>

<img src="https://github.com/maelfabien/Machine_Learning_Tutorials/blob/master/Images/neo_head.jpg" alt="Illustration"/>

| Article Title | Read Time | Article |
| --- | --- | --- |
| Introduction to Graph Databases | 1mn | [here](https://maelfabien.github.io/bigdata/Neo4J/) |
| A day at Neo4J GraphTour | 7mn | [here](https://maelfabien.github.io/bigdata/Neo4J_gt/) |

<br>


# Written for other blogs

1. [Who's the painter? - For explorium.ai](https://www.explorium.ai/blog/whos-the-painter/) : An illustration of how data enrichment and feature engineering can improve a model.

2. [Machine Learning Interpretability and Explainability (1/2) - For explorium.ai](https://www.explorium.ai/blog/interpretability-and-explainability-part-1/) : An introduction to interpretable models with code and examples.

3. [Machine Learning Interpretability and Explainability (2/2) - For explorium.ai](https://www.explorium.ai/blog/interpretability-and-explainability-part-2/) : An introduction to explainability in Machine Learning with code and examples.

4. [A guide to Face Detection - For digitalminds.io](https://www.digitalminds.io/blog/a_guide_to_face_detection_in_python) : An overview of the different techniques face Face Detection in Python (with code).

5. [Modéliser des distributions avec Python (French) - For Stat4Decision](https://www.stat4decision.com/fr/distribution-donnees-python/): Distribution fitting web application with Streamlit.

6. [Introduction au Traitement Automatique de Language Naturel (TAL) (French) - For Stat4Decision](https://www.stat4decision.com/fr/traitement-langage-naturel-francais-tal-nlp/)

# Medium Articles

1. Boosting and Adaboost clearly explained : https://towardsdatascience.com/boosting-and-adaboost-clearly-explained-856e21152d3e

2. A guide to Face Detection in Python: https://towardsdatascience.com/a-guide-to-face-detection-in-python-3eab0f6b9fc1

3. Markov Chains and HMMs: https://towardsdatascience.com/markov-chains-and-hmms-ceaf2c854788

4. Introduction to Graphs (Part 1): https://towardsdatascience.com/introduction-to-graphs-part-1-2de6cda8c5a5

5. Graph Algorithms (Part 2): https://towardsdatascience.com/graph-algorithms-part-2-dce0b2734a1d

6. Graph Algorithms (Part 3): https://towardsdatascience.com/learning-in-graphs-with-python-part-3-8d5513eef62d

7. I trained a neural network to speak like me: https://towardsdatascience.com/i-trained-a-network-to-speak-like-me-9552c16e2396

####
Stay tuned :)
