# 未授权访问火眼红队工具

>原文：[Unauthorized Access of FireEye Red Team Tools](https://www.fireeye.com/blog/threat-research/2020/12/unauthorized-access-of-fireeye-red-team-tools.html)
>
>译者：[madneal](https://github.com/madneal)
>
>welcome to star my [articles-translator](https://github.com/madneal/articles-translator/), providing you advanced articles translation. Any suggestion, please issue or contact [me](mailto:bing@stu.ecnu.edu.cn)
>
>LICENSE: [MIT](https://opensource.org/licenses/MIT)

## 概述

一个由国家支撑的顶尖的竞争者窃取了火眼的红队工具。 因为我们认为竞争者已经拥有这些工具，并且我们不知道攻击者是否打算自己使用被盗的工具还是公开披露它们，所以火眼在此博客中发布了数百种对策，以使安全社区能够保护自己免受这些工具的攻击。我们已将防御策略整合到我们的火眼产品中，并与合作伙伴，政府机构共享了这些策略，以显着限制不良行为者利用红队工具的能力。

您可以在[这](https://github.com/fireeye/red_team_tool_countermeasures)火眼的 GitHub 仓库中找到策略列表。

## 红队工具和技术

红队是一组经过授权和组织的安全专家，模仿潜在的对手针对企业安全状况的攻击或利用能力。我们的红队的目的是通过演示成功攻击的影响并向防御者（即，蓝队）展示防御方法，以改善企业网络安全。过去15年来，我们一直在为全球客户进行红队评估。截至目前，我们已经建立了一套脚本，工具，扫描器和技术，以帮助改善客户的安全状况。不幸的是，这些工具被顶尖攻击者窃取。

被盗工具的范围从用于自动化侦察的简单脚本到类似于 CobaltStrike和 Metasploit 等公开可用技术的整个框架。许多红队工具已经发布给社区，并已分发到我们的开源虚拟机 CommandoVM 中。

其中一些工具是公开可用的工具，经过修改可以逃避基本的安全检测机制。其它的工具和框架是我们红队内部定制开发。

## 没有零日漏洞或者未知技术

攻击者窃取的红队工具不包含零日漏洞。这些工具采用了世界各地其他红队所使用的众所周知且有据可查的方法。尽管我们认为这种盗窃不会大大提高攻击者的整体能力，但火眼会尽一切努力防止这种情况的发生。

请务必注意，火眼尚未看到任何对手散布或使用这些工具，我们将继续与安全合作伙伴一起监视任何此类活动。

## 有益于社区的检测

为了使社区能够检测到这些工具，我们正在发布防御策略，以帮助组织识别这些工具（如果它们在野出现）。为了应对我们的红队工具的盗窃，我们针对 OpenIOC，Yara，Snort 和 ClamAV 等公开可用技术发布了数百种对策。

可在[此处](https://github.com/fireeye/red_team_tool_countermeasures)找到火眼 GitHub 仓库上的对策列表。我们将发布检测，并将随着我们开发新的或改进现有检测的主机，网络和基于文件的指标的重叠对策而继续更新公共存储库。 此外，我们在 GitHub 页面上发布了需要解决的 CVE 列表，以限制红队工具的有效性。

## 火眼产品能够帮助客户免于这些工具攻击


火眼的各个团队都在努力制定对策，以保护我们的客户和广大社区。 我们已将这些对策整合到我们的产品中，并与我们的合作伙伴（包括国土安全部）共享了这些对策，这些合作伙伴已将这些对策纳入其产品中，从而为社区提供了广泛的覆盖范围。

有关可用的检测签名的更多信息，可以在[GitHub仓库](https://github.com/fireeye/red_team_tool_countermeasures)中找到。
