> 原文：[你可能不知道谷歌浏览器开发工具的其他用处](https://medium.freecodecamp.com/10-tips-to-maximize-your-javascript-debugging-experience-b69a75859329#.20eb3ho5g) 
>
> 译者：[neal1991](https://github.com/neal1991)
>
> welcome to star my [articles-translator](https://github.com/neal1991/articles-translator/), providing you advanced articles translation. Any suggestion, please issue or contact [me](mailto:bing@stu.ecnu.edu.cn)
>
> LICENSE: [MIT](https://opensource.org/licenses/MIT)

## 你可能不知道谷歌浏览器开发工具的其他用处

Chrome内嵌开发者工具。它具有丰富的功能特色，比如元素，网络以及安全。今天，我们将完全关注javascript的console.

当我才开始编程的时候，我只是将console用作纪录服务器的响应。但是后来经过一些教学的帮助，我开始发现console可以做的更多。

在这我们讲一些你可以用console做更多有用的事情。如果你是用chrome浏览这篇文章，你可以马上就试试效果。

### 1. 选择节点元素

如果你熟悉jquery的话，你应该知道`$('.class')`和`$('#id')`事多的么的重要。你可以根据id或者类名选择相应的元素。

同样你可以在console使用同样的方式来访问元素。`$('tagName') $('.class') $('#id')`和`document.querySelector('')`是等同的。这个将返回文档中第一个匹配这个选择器的元素。

你可以用`$$('tagName') `来访问，注意这边的两个美元符号可以访问所有符合这个选择器的元素。这些元素会组成一个数组

![developer console](https://d262ilb51hltx0.cloudfront.net/max/1200/1*x-ygabMZbtYHH0mhGVaWbQ.png)





### 2.将你的浏览器转化成一个编辑器

你是否想过可以直接在浏览器中直接编辑？答案是肯定的，你可以将你的浏览器转化成一个文本编辑工具。你可以在dom元素中任意添加或者删除文本。

你不需要检测html中的元素。取而代之，你只要去console里面输入以下：

```document.body.contentEditable = true```



### 3.寻找dom中元素绑定的事件

当调试的时候你可能希望知道dom元素中绑定的事件。console工具能使你很轻松就找到这些事件。`getEventListeners($('selector'))`将会返回一个数组包含所有事件的对象。你可以展开这个对象看到所有的事件：

![events](https://d262ilb51hltx0.cloudfront.net/max/1200/1*ZYcW2PoXTIjz3oAUmdu58w.png)



如果希望找到某个特定事件的监听，你可以这么做：

```getEventListeners($('selector')).eventName[0].listener```

这将展示所有和这个事件相关的监听。比如：

```getEventListeners($('.firstName')).click[0].listener```



### 4.监听事件

如果你想监听特定元素绑定的事件的时候，你也可以在console里面这么做。你可以使用以下的这些命名：

* `monitorEvents($('selector'))`将会监听符合这个选择器的元素的所有事件，并且将会显示这些事件当事件被触发的时候。
* `monitorEvents($('selector'),'eventName')`将会监听符合这个选择器的特定事件。你可以将事件的名称作为一个参数传入到这个函数中。
* `monitorEvents($('selector'),['eventName1','eventName2'….])`将会监听符合这个选择器的事件。
* `unmonitorEvents($('selector'))`这个会停止监听并且在console里面显示出所有的事件。



### 5.找到语句块执行的时间

console里面有一个很重要的函数叫做`console.time('labelTime')`能够启动一个计时器。另外又一个函数叫做`console.timeEnd('labelName')`能够结束相应的计时器。

比如我们想看到一个循环的执行时间，我们可以做如下处理：

```javascript
console.time('myTime'); //Starts the timer with label - myTime

for(var i=0; i < 100000; i++){
  2+4+5;
}

console.timeEnd('mytime'); //Ends the timer with Label - myTime

//Output - myTime:12345.00 ms
```



###  6.将变量的值以表格形式呈现

当我们有如下的一个数组的时候：

```
var myArray=[{a:1,b:2,c:3},{a:1,b:2,c:3,d:4},{k:11,f:22},{a:1,b:2,c:3}]
```

我们可以使用`console.table(variableName)`从而以表格的形式更好地展现数据的属性。

![table](https://d262ilb51hltx0.cloudfront.net/max/1200/1*ODDvO9nnwEWyl1OqaZwifw.png)



### 7.在dom中检测元素

你可以直接在console里面检测元素：

* `inspect($('selector'))`将会检测符合这个在选择器的元素并且会跳转到匹配这个选择器的dom中。
* `$0,$1,$2`能够帮助你检测最近检测过的元素。



### 8.列出与纳素的属性

如果你希望列出元素所有的属性，你可以直接在console里面输入`dir($('selector'))`返回dom元素中的相关属性。



### 9.取到上次最近结果的值

你可以把console当作一个计算器来时用。你可以使用`$_`来获取最近的结果。如下所示：

```
2+3+4
9 //- The Answer of the SUM is 9

$_
9 // Gives the last Result

$_ * $_
81  // As the last Result was 9

Math.sqrt($_)
9 // As the last Result was 81

$_
9 // As the Last Result is 9
```



### 10.清除cosole和缓存

如果你希望清除console和它的缓存，你可以输入`clear()`就可以了。
