## DNS 缓存投毒

> 原文：[DNS Cache Poisoning](
https://medium.com/iocscan/dns-cache-poisoning-bea939b5afaf)
>
> 译者：[neal1991](https://github.com/neal1991)
>
> welcome to star my [articles-translator](https://github.com/neal1991/articles-translator/), providing you advanced articles translation. Any suggestion, please issue or contact [me](mailto:bing@stu.ecnu.edu.cn)
>
> LICENSE: [MIT](https://opensource.org/licenses/MIT)

![](https://cdn-images-1.medium.com/max/2000/1*3kt_t9wSc7MP4Gu2rD7_gw.png)

DNS 欺骗是 DNS 服务器记录更改导致恶意重定向流量的结果。DNS 欺骗可以通过直接攻击 DNS 服务器（我们将在这里讨论）或通过任何形式的专门针对 DNS 流量的中间人攻击来执行。

DNS 缓存欺骗以一种利用 DNS 通信结构的方式明确地工作。当 DNS 服务器尝试在域上执行查找时，它会将请求转发到根权威 DNS，并迭代地沿着 DNS 服务器链向下查询，直到它到达域上的权威 DNS 服务器。由于本地 DNS 服务器不知道哪个服务器负责哪个域，并且不知道到每个权威服务器的完整路由，因此只要回复与查询匹配并且格式正确，它就会从任何地方接受对其查询的回复。攻击者可以通过在回复本地 DNS 服务器时击败实际的权威 DNS 服务器来利用此设计，如果这样做，本地 DNS 服务器将使用攻击者的 DNS 记录而不是实际的权威答案。由于 DNS 的性质，本地 DNS 服务器无法确定哪个回复是真实的，哪个是假的。

由于 DNS 服务器将在内部缓存查询，因此每次请求域时，他们不必浪费时间查询权威服务器，从而加剧了这种攻击。这带来了另一个问题，因为如果攻击者可以击败权威DNS 服务器进行回复，那么攻击者记录将被本地 DNS 服务器缓存，这意味着任何使用本地DNS服务器的用户都将获得攻击者记录，可能会重定向所有使用该本地 DNS 服务器的用户都可以访问攻击者的网站。

![DNS Cache Poisoning Workflow](https://cdn-images-1.medium.com/max/2000/1*iBZM5hvnXRvelyJ0E1KRig.png)

## DNS 缓存投毒的例子

**生日攻击的盲目响应伪造**

DNS 协议交换不验证对递归迭代查询的响应。验证查询只会检查 16 位事务 ID 以及响应数据包的源 IP 地址和目标端口。在 2008 年之前，所有 DNS 使用固定端口53 解析.因此，除了事务 ID 之外，欺骗 DNS 回复所需的所有信息都是可预测的。用这种弱点攻击 DNS 被称为“生日悖论”，平均需要 256 次来猜测事务 ID。为了使攻击成功，伪造的 DNS 回复必须在合法权威响应之前到达目标解析器。如果合法响应首先到达，它将由解析器缓存，并且直到其生存时间（TTL）到期，解析器将不会要求权威服务器解析相同的域名，从而防止攻击者中毒映射该域，直到 TTL 到期。

**Kaminsky 漏洞**

在 2008 年 在 Black Hat 上有人揭示了生日攻击的拓展，其中基本的盲猜技术保持不变。该攻击利用了 DNS 响应的基本特性，因为 DNS 响应可以是直接应答（请求的直接 IP 地址）或引用（对给定区域具有权威性的服务器）。生日攻击伪造了一个为给定域记录注入错误条目的答案。 Kaminsky 漏洞使用引用来绕过先前条目上的 TTL 对整个域进行错误输入。基本思想是攻击者选择他们希望攻击的域，然后向目标解析器查询尚未被解析器缓存的子域（定位不存在的子域是一个很好的选择，记录是没有被 DNS 解析器缓存）。由于子域不在缓存中，因此目标解析器向该域的权威服务器发送查询。正是在这一点上，攻击者用大量伪造的响应来淹没解析器，每个伪造的响应都有不同的伪造事务 ID 号。如果攻击者成功注入伪造响应，则解析器将为权威服务器缓存错误映射。对受感染域的目标解析器的未来 DNS 查询将导致所有请求被转发到攻击者控制器权威解析器，使攻击者能够提供恶意响应，而无需为每个新 DNS 记录注入假条目。

**窃听**

许多增强 DNS 安全性的新提议包括源端口随机化，0x20 XOR 编码，WSEC-DNS，这些都取决于用于身份验证的组件的不对称可访问性。 换句话说，它们通过隐匿而不是通过身份验证和加密的机密性来提供安全性。他们的唯一目标是如上所述防止盲目攻击 使用这些安全方法仍然使 DNS 容易遭受受损服务器和网络窃听者的轻微攻击，以打破默默无闻并执行如上所述的相同攻击，这次没有盲目猜测。 即使在交换环境中，也可以使用 ARP 中毒和类似技术强制所有数据包进入恶意计算机，并且可以击破这种混淆技术。

## DNS 缓存投毒缓解

**DNSSEC**

防止 DNS 缓存被投毒的最佳方法是实现加密和身份验证的安全方法。DNS 作为一种过时的协议以及整个互联网的支柱，令人惊讶的是仍然是一种未加密的协议，没有对它收到的条目和响应进行任何形式的验证。

当然，解决方案是提供一种称为 DNS Secure 或 [DNSSEC](https://medium.com/iocscan/how-dnssec-works-9c652257be0)的验证和身份验证方法。该协议创建了与 DNS 记录一起存储的唯一加密签名。然后 DNS 解析器使用签名来验证 DNS 响应，确保记录未被篡改。此外，它还提供了从 TLD 到域权威区域的信任链，确保了 DNS 解析的整个过程是安全的。

尽管有这些明显的好处，但 DNSSEC 的采用速度很慢，许多不那么受欢迎的 TLD 仍然没有利用 DNSSEC 来保证安全。主要问题是 DNSSEC 设置复杂，需要升级设备来处理新协议，另外由于历史上大多数 DNS 欺骗攻击的罕见和不可知性，DNSSEC 的实现不被视为优先级，通常只执行一次应用就达到其生命周期的终点。
