# SAST 测试中要测量的三个参数

>原文：[3 parameters to measure SAST testing](https://snyk.io/blog/parameters-to-measure-sast-testing/)
>
>译者：[madneal](https://github.com/madneal)
>
>welcome to star my [articles-translator](https://github.com/madneal/articles-translator/), providing you advanced articles translation. Any suggestion, please issue or contact [me](mailto:bing@stu.ecnu.edu.cn)
>
>LICENSE: [MIT](https://opensource.org/licenses/MIT)

在我们之前的博客中，为什么[你不能仅使用列表、测试套件和基准测试来比较 SAST 工具](https://snyk.io/blog/cant-compare-sast-tools-lists-test-suites-benchmarks/)，我们探索了当今常用来评估和比较 SAST 测试工具的各种工具和指标。我们还研究了为什么这些工具可能会产生不一致的结果并且对于评估 SAST 测试工具可能根本不可靠的一些原因。

相反，在评估 SAST 测试工具时，你需要考虑 3 个参数：

accuracy
completeness
any unique additional values
* 准确性
* 完整性
* 任意其它独特价值

在本文中，我们将探索这些参数并研究测量它们的方法。在评估 SAST 测试工具时，有两种相关类型的测量 - 定量（意味着结果的数量与“误报”）和定性（特别是语言深度和支持）。

## 定量方面

以下对准确性和完整性的定义起初有点复杂，因为它们实际上是同一枚硬币的两面。数学上不可能（根据赖斯定理）进行完美的静态程序分析。人们可能会认为增加建议的数量会发现所有可能的问题。可悲的是，这也会将误报 (FPs) 的数量达到干扰让结果无法处理的级别。SAST 测试供应商可以使用一些技巧来改进结果，但在数学上完美是不可能的。

### 准确性

在 SAST 测试的上下文中，准确性被松散地定义为具有最高数量的 TP（真正类，即实际问题的发现），同时保持最少数量的 FPs（误报，因此是错误的）。

准确性尤其重要。高准确率意味着我们可以获得更有价值的结果，以及更少的“噪音”（不相关的、无法操作的报告）。“噪音”也是阻碍开发者使用 SAST 测试产品的第一大因素，这就是为什么准确性越高，整体开发者体验就越令人满意的原因。

为了计算准确性，你首先需要对结果进行分类。那么公式就是 TP*100/(TP+FP)。这将产生一个介于 1 到 100 之间的数字。数字越大，准确度越高。例如，找到 140 个 TP 和 40 个 FP 的工具的准确率为 77.7%。

### 完整性

NIST 定义：“完整性，有时称为召回率，作为发现的实际问题 (TP) 与所有可能的问题（TP 和假反例）的衡量标准。完整性越高（达到其理论最大值 1），工具就越能更好地解决代码中的现有问题。”实际上：遗漏的真实问题的数量，即漏报 (FN)。

工具越完整，你将拥有更好的可见性和保护。当然，这也可能转化为更多的发现，但再加上高准确率，这些发现中的大多数应该被证明是相关的。话虽如此，这些发现的严重性始终在完整性方面发挥关键作用——如果你试图将噪音降到最低，一千个低严重性的 FN 不一定是坏事。作为一般经验法则，FN 越少越好。重要的是要知道如何删除它们，以免错过实际的漏洞。

仅当你知道代码中存在任何漏洞，或者正在比较多个工具并发现结果存在差异时，才能生成此指标。另一个角度是寻找 FN 的严重性，然后专注于更高优先级的。FN 很难测量，因为它们是未知的未知数。取舍是不可避免的。经验表明，在大的项目中，总是需要预估 FN。在网络安全中，通过感觉太安全来放松警惕绝不是一种选择。

## 定性方面

定性测量着眼于如何处理语言和漏洞支持。正如我们在上一篇博客中所探讨的那样，只使用已知漏洞列表、测试套件和故意存在漏洞的仓库会产生不完整的图景。因此，一个好的 SAST 是超越列表的。

这种测量可以进一步分为两个感兴趣的领域：语言/漏洞支持和深度/准确性方法。

**语言支持是如何确定的？**

了解如何为你正在评估的 SAST 确定语言支持的优先级和确定方式非常重要。

我们已经知道漏洞列表是不够的。一种更全面的方法是聚合来自多个来源的数据，以创建可靠的语言支持，既能与当今的网络风险保持同步，又能与上下文相关。

因此，虽然列表可以作为一种参考，但还有其他资源可供探索：

* 新闻来源——“趋势”漏洞和新发布的攻击向量更有可能被利用
* 已知漏洞数据库和漏洞利用数据，例如 NVD 数据库和 [Snyk 漏洞数据库](https://security.snyk.io/)。
* 特定语言和框架的最佳实践和上下文
* 零日漏洞研究，如新模式或现有模式

在确定在 Snyk Code 中支持哪些语言和框架时，我们使用以上所有内容以及更多内容来构建客户应该关心的最相关问题的列表。

**语言深度和准确度如何处理？**

虽然拥有强大的支持语言和漏洞列表是重要的第一步，但你还必须考虑将这些转化为结果的程度。

例如，依靠开源社区构建和推送的几乎没有严格审查流程的新规则的 SAST 容易产生大量误报，并且通常会在不同语言和漏洞之间产生不一致的结果。

在 Snyk Code，我们拥有一支由专门的安全研究人员组成的团队，他们不断努力增加对越来越多的语言和漏洞的支持，并通过增加深度和准确性来改进现有支持。

**SAST的发展速度和维护性是多少？**

如上所示，SAST 解决方案的维护和持续开发非常重要。这意味着两个方面：产品的路线图和公司或社区实现它的能力。机器学习的最新进展使得了解它如何在路线图中发挥作用变得很有趣。同样关键的是对现代语言的支持、现代引擎的使用以及支持新语言的速度。

其次，了解公司或社区在维护 SAST 知识库方面的能力非常重要。如上所述，安全需要不断观察并对各种来源作出响应。

## 把这一切放在一起

通过定量评估，你现在想了解该工具在现实世界中的实际表现。如果该工具提供了许多结果（即使是 TP），或者有很多噪音 (FP)，那么拥有最好的语言和漏洞支持是不够的。安全专家想要高度的完整性，但开发人员对具体解决的实用建议更感兴趣。因此，重要的是要在建议的数量、优先级和开发团队解决这些问题的能力之间取得平衡。我们的经验和研究表明，向开发人员提供大量建议（尤其是在准确性较低的情况下）会使他们失去动力，实际上会减慢整个过程。

从定性的角度来看，我们建议列出你环境中感兴趣的方面，构建矩阵并插入每个竞争对手的值。

对于这些量化特征的测量，我们建议选择选择熟悉的真实项目。为了更加方便，我们建议该项目是一个相对中小型的项目。如上一篇博客所述，你应该避免使用故意易受攻击的应用程序，因为它可能不会表明该工具的真正价值。

运行 SAST 并收到结果后，就该对它们进行分类了。分类意味着确定某个结果是 TP（真正的问题）还是 FP（不是真正的问题）。SAST 结果通常与上下文相关，这就是为什么充分了解你正在扫描的项目很重要的原因。最后，你的个人专业知识和工作不能被预先准备好的基准结果所取代。

最后，你需要根据本文前面提到的公式计算准确性和完整性。

## 为什么不简单地收集所有工具并运行它们呢？

如上所示，每个工具都添加了 TP 和 FP。因此，尽管简单地使用所有可能的工具是有意义的，但实际上，分离噪音的工作将超过另一个工具所带来的价值。开发人员将需要处理来自不同工具使用不同格式的双重建议，这将产生大量包袱，更不用说运行时约束了。虽然这是获得 FN 和 FP 数量的好方法，但对于连续操作来说并不可行。根据我们的经验，拥有一个对开发人员友好的平台是最重要的。如果你在安全性非常关键或受监管的环境中工作，你可能希望稍后在 CI/CD 流程中添加专用工具。

SAST 无疑是每个开发人员都应该在他们的“工具箱”中拥有的强大工具，并且可以真正改变你的应用程序安全性。因此，您必须为你和你的组织选择最佳工具。我们希望上面和上一篇博文中概述的信息和步骤可以帮助你做出更明智的决定。