## 2019 年针对 API 安全的 4 点建议

> 原文：[4 Tips for Better API Security in 2019](https://medium.com/apis-and-digital-transformation/4-tips-for-better-api-security-in-2019-7d3a3b852a45)
>
> 译者：[neal1991](https://github.com/neal1991)
>
> welcome to star my [articles-translator](https://github.com/neal1991/articles-translator/), providing you advanced articles translation. Any suggestion, please issue or contact [me](mailto:bing@stu.ecnu.edu.cn)
>
> LICENSE: [MIT](https://opensource.org/licenses/MIT)

[![kMqL3d.md.png](https://s2.ax1x.com/2019/01/29/kMqL3d.md.png)](https://imgchr.com/i/kMqL3d)

无论是在[科技](https://www.darkreading.com/application-security/expect-api-breaches-to-accelerate/d/d-id/1332504)[媒体](https://securityboulevard.com/2018/12/2018-sees-api-breaches-surge-with-no-relief-in-sight/)亦或是[分析报告](https://www.gartner.com/doc/3834704/build-effective-api-security-strategy)中，2018年 “API”以及“安全”变得越来越常见，-或者更糟糕，“API” 以及“违规”[一起出现在头条中](https://www.securityweek.com/next-big-cyber-attack-vector-apis)。

APIs（应用程序编程接口）不仅是应用程序，系统和数据之间的连接组织，而且是允许开发人员利用和重用这些数字资产以实现新目的的机制。API 几乎影响到每个数字用例，它们在安全新闻中的作用不仅仅是 API 中的一个内在缺陷，因为它们中的一些已被破解，因此存在明显的缺陷。

但是头条新闻强调了一个重要信息：如果 API 安全性不是企业 2019 年优先事项的首要事项，那么优先级列表就不完整。

实际上，API 安全的要求正在成为一种共识：

* 在 2017 年 12 月的报告“[如何构建有效的API安全策略](https://www.gartner.com/doc/3834704/build-effective-api-security-strategy)中，”Gartner 分析师 Mark O'Neill， Dionisio Zumerl e和 Jeremy D'Hoinne 预测，“2022年，API 滥用将是最常见的攻击向量，导致企业网络应用程序的数据泄露。”

* [OWASP Top 10](https://www.owasp.org/images/7/72/OWASP_Top_10-2017_%28en%29.pdf.pdf)是一个备受推崇的 Web 安全威胁列表，其中多次提及 API。其明确的警告包括针对没有保护即传输敏感数据的 API 的警告，针对可疑行为而未监控流量的 API 以及使用易受攻击组件的 API。

* 医疗保健组织 HIMMS [发布报告](https://www.hipaaguide.net/api-vulnerabilities-and-usb-related-cyberattacks-identified/)详细说明了 2018 年风险不安全的 API 可能对敏感的医疗保健数据造成的影响。

调查显示企业已经[特别关注](https://www.slideshare.net/Imperva/api-security-survey?qid=aab26aae-da6c-40b0-8c28-0ea3a0f526a8&v=&b=&from_search=4)关于威胁机器人和分布式拒绝服务（DDoS）攻击代表 API。 尽管存在这些关注，但攻击风险仍然存在 - 特别是当企业缺乏对其 API 如何被利用的洞察力时。许多组织甚至仍然不知道他们部署了多少 API，是否有人使用 API，或者 API 是否正在推动流量。

当然，与 API 相关的违规和安全事件的数量越来越多，证明了 API 安全的重要性。 一个[政府机构的脆弱性](https://krebsonsecurity.com/2018/11/usps-site-exposed-data-on-60-million-users/?utm_source=feedburner&utm_medium=feed&utm_campaign=Feed%3A+KrebsOnSecurity+%28Krebs+on+Security%29)允许任何登录用户不恰当地查询系统以获取其他用户的私人详细信息，包括电子邮件地址，电话号码和街道地址。其他机构已经暴露了更敏感的数据。它们所带来的漏洞和损害各不相同 - 但重点是，依靠设计糟糕且管理不善的 API 可能会随着时间的推移风险越来越大

企业应如何应对这一日益严重的威胁 以下是 Google Cloud 的 Apigee 团队推荐的四个建议。

## 以 TLS 为基础

* “传输层安全性”或 TLS 加密流量，有助于确保客户端与正确的服务器通信，并且是 API 安全性的基础。API 不应该没有它。

* 跟上 TLS 的变化 - 因为它们很常见。许多 API 团队使用 Qualisys SSL Labs 的 [SSL Server Test](https://www.ssllabs.com/ssltest/) 等服务测试 TLS 配置。

* 考虑使用跟踪工具，数据屏蔽和标记化来除了加密。

## 专注于身份验证

* 控制 API 访问的能力是有效 API 安全性的基石。 企业应使用 OAuth 对用户进行身份验证。

* 验证终端用户以及应用的身份。

## 使用速率限制来防止暴力攻击并管理流量

* 使用速率限制来防止暴力攻击。例如，黑客可能会使用自动化软件通过系统猜测密码来生成大量连续登录尝试。如果 API 不受速率限制的保护，则可能允许此攻击无限期地继续或直到成功为止。

## 使用行为模式和机器学习将坏机器人放在适当位置

* 不仅监控 API 访问，还监控流量模式，以发现可疑行为。

* 应用复杂的算法和机器学习来发现坏机器人，并注意适用于网络或 Web 攻击的防御方法可能对 API 无效。


企业 IT 中为数不多的确定的事情之一是，只要企业使用技术，坏的参与者就会试图找到漏洞。挑战很多，但它们也是[成功的一个不可避免的一部分](https://www.rtinsights.com/with-apis-dealing-with-bad-bots-is-the-cost-of-success/ )，随着公司的数字化越成功，它可能吸引的攻击者就越多。


以上建议是一个起点，但企业需要积极主动，始终意识到在为开发人员提供用户友好的 API 以及保护其免受攻击者攻击之间保持平衡，这是一个微妙而迭代的过程。 除了技术方面的考虑之外，还有安全的人性方面 - 企业围绕其 API使 用的服务条款，它传递 API 变更或响应违规的方式等。

虽然没有自满的余地，但企业不会被不良行为者所俘虏，也不会越来越复杂。如果企业对 API 安全保持合适的关注，那么将会尽可能地确保2019年 那些 API 安全地头条将会是*其它*公司的违规。

**[对管理API和推动数字业务的更多提示感兴趣？ 请参阅 Apigee 的新电子书，“[API产品思维模式](https://pages.apigee.com/apis-products-register.html?utm_source=medium&utm_medium=article&utm_campaign=apis-products-microsite)。”]**
