> “Consider your origins: you were not made<br>to live as brutes, but to follow virtue and knowledge.”

— Dante, *The Divine Comedy*

<h1 align="center">Dante</h1>
<h3 align="center">A blog webapp built entirely with ASP.NET Core technologies.</h3>
<p align="center">
    <a href="https://travis-ci.org/maacpiash/Dante" target="_blank">
        <img src="https://travis-ci.org/maacpiash/Dante.svg?branch=master" alt="Build Status"/>
    </a>
    <a href="https://ci.appveyor.com/project/maacpiash/dante/branch/master" target="_blank">
        <img src="https://ci.appveyor.com/api/projects/status/a77ttt1754stb2rh/branch/master?svg=true" alt="Build Status"/>
    </a>
    <a href="http://hits.dwyl.io/maacpiash/Dante" target="_blank">
        <img src="http://hits.dwyl.io/maacpiash/Dante.svg" alt="HitCount"/>
    </a>
    <a href="https://github.com/maacpiash/Dante/issues" target="_blank">
        <img src="https://img.shields.io/github/issues/maacpiash/Dante.svg" alt="Open issues"/>
    </a>
    <a href="https://github.com/maacpiash/Dante/graphs/contributors" target="_blank">
        <img src="https://img.shields.io/github/contributors/maacpiash/Dante.svg" alt="Contributors"/>
    </a>
    <a href="https://gitter.im/maacpiash/Dante" target="_blank">
        <img src="https://badges.gitter.im/maacpiash/Dante.png" alt="Gitter"/>
    </a>
    <a href="https://twitter.com/intent/tweet?url=https%3A//github.com/maacpiash/Dante&text=A%20blog%20webapp%20built%20entirely%20with%20ASP%2ENET%20Core%20technologies%21" target="_blank">
        <img src="https://img.shields.io/twitter/url/http/shields.io.svg?style=flat" alt="Share on Twitter"/>
    </a>
</p>
<br>

## Frameworks used

- Back-end: ASP.NET Core
- Front-end for CRUD: Razor Template Engine
- Database management: Entity Framework Core
- Authentication and Authorization: Identity Framework

## Roadmap

- [x] Create stories.
    - [x] Save posts in an on-disk database.
- [x] Display stories.
    - [x] Display by date-time in descending order (most recent first).
    - [x] Pagination (10 stories per page)
    - [x] Search by text in title/body
- [x] Edit and delete stories.
    - [x] Edit stories
    - [x] Delete stories
- [x] Return stories in JSON and XML formats with a REST API.
    - [x] Return JSON
    - [x] Return XML
- [ ] User authentication.
    - [ ] User registration.
    - [ ] User login and logout.
    - [ ] Reserve Create/Update/Delete actions for registered and logged-in users only.
- [ ] User feedback to stories.
    - [ ] Reactions
    - [ ] Comments
- [ ] Users uploading avatars.
- [ ] Users following Authors.

*Under development!*
