﻿using System;
using System.Drawing;
using System.Runtime.Versioning;
using System.Windows.Forms;
using mRemoteNG.App;

namespace mRemoteNG.Tools
{
    [SupportedOSPlatform("windows")]
    public class MouseClickSimulator
    {
        public static void Click(Control controlToClick, Point currentMousePosition)
        {
            // Simulate a mouse event since one wasn't generated by Windows
            Point clientMousePosition = controlToClick.PointToClient(currentMousePosition);
            int tempWLow = clientMousePosition.X;
            int tempWHigh = clientMousePosition.Y;
            NativeMethods.SendMessage(controlToClick.Handle, NativeMethods.WM_LBUTTONDOWN,
                                      (IntPtr)NativeMethods.MK_LBUTTON,
                                      (IntPtr)NativeMethods.MAKELPARAM(ref tempWLow, ref tempWHigh));
            clientMousePosition.X = tempWLow;
            clientMousePosition.Y = tempWHigh;
            controlToClick.Focus();
        }
    }
}