# 「霞鹜新晰黑」v0.9 修改字形一览表

本表中所收录的字即「霞鹜新晰黑」v0.900 所包含的字，包含《通用规范汉字表》、《现代汉语通用字表》、GB/T 2312-80 收录的汉字（「麴」除外）以及未被以上三表收录的化学元素中文名称、常用偏旁等，按 Unicode 码位排序。v0.235 版本收录的其余汉字在修改过程中暂时剔除，后续整理和取舍后重新加入。

一个字形涉及多项调整的，先按最主要的调整项分组，再按照次要调整项分成若干小项。下表中每个字形只出现一次。

## 1. 较 v0.235 版本未作改动的字形

㑇㙍㙘㙦㰀㶲㸆㽏㿠䃎䎖䓖䓬䢼䣘一丁七万丈三上下丌不丑且丕丘丙丞两严丨个丫丬中丰串丶丸丹主丿乂久乇义乍乎乒乓乖乘乙乜九乞也乩乱乳乾了予争事二亍于亓五井些亠亡亢亦产亨亭亲亳亶亹人亻亿什仁仂仃仄仅仆仇仉介仍从仑仓仔仕他仗付仝仞仟仡代仪仲仵件价任份企伈伊伋伍伎伏伐休伙伤伦伧伯估伴伸伽伾佃位住佐佑体佖佘余佚作佝佞佟你佣佩佬佯佰佳佶佸佺佻侁侃侈例侍侏侑侗供侠侣侦侯侴侵便促俄俅俎俏俐俑俗俘俙俚保俣俨俩俱俳俶俾倓候借倡倨倩倪倬倭倮偁偌做偬偭偲偶偻傅傈傥傺傻僇僎僔僖僚僧僳僵儒儡儿兀元兄兆先光克党全六共关兵其具典兼冀冂内冉册再冒冔冖冗冠冢冥冫冬冰冲决况冼冽净凄准凌凑凓凛凝几凡凭凰凸凹刀刁刂刃分刊刎刑刖列判刨利别刮制刷券刹刺剅削剋剌前剔剕剟剡剧剩剪副剽剿劄劓力功加劢助努劭励劳劼勃勉勐勒勔募勠勤勰勹勺勿匀匆匍匕北匙十千卅升午卉半卑卓南博卜卟占卡卢卦卩卮危卸厂厄厉压厌厘厚厝原厢厦厨厮又叉友反叔叕受叙叟叠口古另叩召叮叱右叶叻吁吃各合吉吊名后吐吒吓吕君吝吞吣否含听吴吵吸吻吼吽吾呃呆呇呈告呋呙呛呲味呷呻呼命咀咂咆咇咉咋和咏咐咔咕咖咚咣咧咩咪咫咭咯咱咻咽咿品哂哄哆哇哈哉哎哒哚哢哦哧哨哩哮哱哲哳哺哽唏唑唔唛唠唣唤唪唬售唰唱唵唿啁啃啉啖啜啡啤啥啫啬啾喁喃善喆喇喉喋喏喘喜喟喤喵喹喽喾嗄嗅嗍嗐嗒嗓嗖嗜嗝嗟嗥嗪嗯嗵嗷嘁嘈嘉嘌嘎嘘嘚嘞嘟嘣嘤嘭嘱嘲嘴嘶嘹嘻噀噂噌噎噗噢噤器噪噫噬噱嚅嚏嚚嚭嚯囗四囝回囟团囤囫园囵固国囿圃圄圊土圣在圩圪圭地圲圳圻圾址坂均坋坌坍坏坐坑坟坡坤坥坩坪坫坼垈型垍垎垏垚垛垟垡垢垯垱垾埂埆埇埋城埏埔埕埗埘埚埝域埠埤埭埸基埽堂堃堇堋堌堎堕堞堠堡堤堧堵堼堽塃塌塑塔塞塥塬墀墅墐墓墕墙增墟墡墣墦墨壕士壬壮声壳壹夂处复夏夐夕外夙多夥大天太夫夬夭央夯失夹夼奂奄奈奉奎奏奔奠奥奭妥妻委姜娄娑婆婪婺媵嬖嬴子孑孓孔孖存孚孛孜孝孟孢季孥学孱孺宀审宥宴寥寨寮寸寺导封尉尊小少尔尖尢尤尥尬尸尹尽尾尿居届屎屏屐屑属屠屡屣履屦岸峛崒崖崩崶崽嶷巛川州巡巢工左巫巷巽巾币布帆希帑帔帕帖帙帚帛常帼幂幅幌幔幕幖幞幡干平年并幸序廾廿开弄弇弊弋式当彖彡形彩彪彬彭彳彼往征徂待徉徊律徐徒得徘徙御徨循徵德徼心忄必忉忌忍忏忐忒忖志忙忝忡忤忧快忮忱念忻忽忿怊怍怎怏怒怔怕怖怙思急性怨怪怵恁恃恍恐恓恙恚恤恩恪恬恭息恰恿悃悄悉悍悒悖悚悝悟悠患悦您悱悲悸悻悼情惎惑惔惕惙惚惜惠惧惰想惴惶惹惺愀愁愆愈愉愎愐愚愠愭愿慆慕慝慢慥慬慭慰憋憎憙憨憩憬憭懂懊懋懔懦懵戈戊戌戍成我戒戚戛戟戤截戬戴户手扌才扎扑打托扛扞扣扦扯扰扳扶扼找承技抄抉抒抓抔抖折抛披抱抹抻押抽拃拄拆拈拊拌拍拐拓拔招拤拥拦括拭拮拯拱拴拶拼拾拿持挂指挑挝挟挣挪挫挹挺挽捂捃捅捉捋捌捍捎捐捕捧据捷捺捻掇授掉掌排掞掣措掬掭掴掷掾揄揉揍描提插揣揪揲援揸揾搂搋搏搜搠搦搭摁摅摏摒摸摹摽撂撑撒撕撙撩播撰擀擂操擤支攴攵攸攻政故敉救敔敕教敝散整敷斗料斜斝斠斡斤斥斧斫斯无日旧旨旰旱旴时旺旿昀昃昇昊昌明昒易昔昕星映昣春昧昨昭是昳昺昼晁晃晋晒晗晚晞晡晢晤晫普景晰晱晴晶暑暕暖暗暝暮暴暵暿曛曝曰曲曹曼曾替月有朊朋服朓朕朝期朦木未末本札术朱朴朸机权杄杆杈杉杌李杏材村杓杖杙杜杠来杪杯杰杲杳杵杼板极枅枉析枕林枘枚果枝枯枰架枷枹柄柈柊柏某柑柒染柔柘柙柚柝柞查柰柱柴柷柽栀栌栐栓栖栗栝栟栩株栳栴栻格栽桁桂桃桄桅桌桑桔桕档桫桯桲桴桶梁梃梌梏梗梠梢梣梦梧梨械梴梵梽棁棉棋棐棒棘棚棠棣棤棪棫棬森棱棵棹棻椐椑椒椓椪椽楂楒楗楙楝楠楣楩楪楯楱楸楹楼榀榃榆榑榘榛榰槊槔槭槽槿樘模樨横樯樽橐橞橱檄檑檩檬欂止正此步武歧歪歹死歼殂殃殄殊殣殪毛毫毯气氕氖氘氚氛氤水氵永氺氾氿汀汁求汊汐汔汗汞江池汧汨汩汪汫汭汰汲汽汾沁沂沃沅沈沉沐沓沙沚沛沣沧沨沫沭沮沲油沺沼沽沾沿泇泉泊泌泐泔泗泙泚泡波注泪泮泰泱泳泵泶泸泽洁洄洇洈洋洌洎洑洒洓洗洙洛洢洣津洧洪洫洮洲洴洸洺活洼洽浕浙浛浜浞浟浠浡浥浦浩浬浭浮浯浰浲浴浸浼涂消涉涌涍涎涐涑涓涔涝涡涣涮涯涸淄淅淆淇淋淏淑淖淜淡淦淫深淴添淼清渊渔渚渝渠渣渤温渫渭港渰渺渼湄湉湍湎湑湓湖湘湜湟湨湫湲湴湿溁溆溇溍源溚溥溧溯溲溴溷溺滆滉滑滔滕滢滹漂漆漈漋漏漕漖漠漫漭漹漾潘潜潞潟潢潦潩潭潮潲潴潸潺潽澂澌澍澎澡澧澳澽濞濡濮瀑瀚瀣瀹灞火灬灭灯灶灼炅炌炎炒炔炙炮炷炸点炻烀烂烃烈烊烘烙烝烟烬烯烶烻烽焆焉焊焕焯焱然煃煋煌煎煓煜煟煤照煮煳熄熏熛熜熥熨熬熳熹燃燎燔燕燚燠燥燧燹爆爇爚爨爪爬爰父爻爽片版牌牒牛牝牡牦牧物牮牯牲特牺牾犀犁犇犍犬犭犯犰犴状犹狂狃狄狍狎狙狝狭狰狳狷狸猁猇猊猎猓猖猛猜猞猢猩猪猫猬献猯猱猴猷猸猹猾獠獯獴玉王玎玒玓玕玖玞玠玢玤玥玦玩玫玱玳玶玷玻玼玿珀珅珇珈珍珏珒珕珖珙珛珞珠珥珧珩珪班珰珵珷珸珹珺珽琀球琄理琇琈琎琚琡琢琤琥琪琫琰琲琳瑀瑁瑂瑃瑅瑆瑑瑓瑔瑗瑙瑚瑛瑜瑝瑞瑧瑾璐璜璞璠璨璩璪璲璺瓀甘甜生甡甥甦用甪甫甬田由甲申男甾畀畈畋界畎畔畛畤略畦番畬疆疋疍疐疑癗白百皂的皇皈皋皓皕皙皛皞皤皮皿盂盆盈盉益盎盒盖盛目盯盱盷相盼盾眇眈眉眊看眚真眦眭眯眵眷眺睁睄睎睚睛睥睨睫睬睹睾睿瞀瞄瞅瞍瞑瞟瞠瞢瞥瞩瞫瞭瞽矍矛矢知矩矬短矮矰石矶矻矼矽砂砄砆砉研砟砠砦砧砫砮砰破砵砷砹砺砼硁硅硇硊硒硔硖硝硪硬确硼碃碍碏碑碘碟碧碰碴磉磊磜磲磹磺磻礌礓礤礴礵示祟票祭禀禁禹禺禾秃秆秉秋种科秒秘租秣秤秦秧秩秫称秸移稀稆程稌稍税稔稗稞稣稻稽穄穆穑穗穙穟穴立竹竺竽竿笄笊笋笏笑笔笙笛笤符笨笮笯笳筀筅筇等筋筌筏筑答策筜筝筠筥筮筱筲筷箅箐箓箔箕箖算箝箬箭箱箸篁篆篌篝篥篪篮篷篾簃簉簕簝簟簧簰簸籍籥米籽粉粒粕粗粘粝粞粟粱粳精粿糅糇糈糊糌糕糗糙糟糯网罔罘罟罡罩罪署罽罾羊羌美羑羔羕群羹羽羿翂翅翈翕翡翥翦翮翰翱翻老耄者耆而耏耐耑耒耔耕耖耗耠耤耦耧耰耳耷聱聿肀肄肉肋肌肖肘肚肛肜肝肢肤肭肯肴肸肺胂胃胄胈背胖胗胙胚胛胜胞胡胣胥胩胫胬胭胱胳胼脂脆脉脊脒脖脬脯脱脾腆腈腊腘腥腨腩腮腯腰腱腹腺腼腽膏膘膛膜膝膨膳臊臌臑自臬臭臼舀舂舄舅舌舍舒舔舟艹艺艽艾芃芈芊芋芍芙芜芟芣芤芥芩芫芬芮芯芴芷芹芼芾苑苕苗苜苞若苦苫苯英苴苷苹苻苾茂范茄茅茇茈茉茌茎茔茗茜茬茯茱茴茵茶茸茹荃荆荇草荏荐荔荖荣荦荨荸荻荼荽莆莉莎莒莙莜莝莠莩莪莫莱获莸莽莿菁菇菉菊菌菍菔菖菜菝菟菠菥菲菹菽萁萆萋萌萍萎营萩落葆葎葑葓著葙葡董葫葬葭葱葳葶葸葺蒄蒙蒜蒯蒱蒲蒴蒸蒻蓁蓂蓍蓝蓟蓥蓬蓰蓼蔑蔓蔚蔡蔫蔽蕃蕈蕊蕗蕙蕾薁薤薨薯薰薷薿藉藐藓藕藜藟藠藤藦藩藻蘅蘧虍虎虑虒虚虞虢血衃衄衅行衍衎街衙衡西要覃覆觅角觜觱谷谼豆豇豉豕豚豢豨豸豹豺貂貅貉貊貌貘赤赦赧赫赭走赴赶趁趄趔趴趵趺趾趿跂跃跄跋跌跏跑跖跗跛跣跪跫跬路跱跳跶跽踅踊踏踒踔踝踞踟踢踯踵踶踹踺踽蹀蹂蹈蹭蹯蹰蹲蹼蹽躁躇躔軎辜辶辽迁迂迄迅过近迕迤迩迭迮迸送逃逋逍透逐逑途逗通逝逞速造逢逮逴逶逸逼逾遁遂遄遇遐遑道遢遣遥遨遭遵邑邕邗邘邛邢那邦邯邱邳邵邹邺邽邾郁郃郏郑郗郛郜郝郡郢郫郯郴都郿鄀鄄鄙鄞鄢鄯酃酆酉酊酋酌酎酏酐酒酢酣酤酥酩酪酬酯酲酴酵酷酹醋醍醐醒醚醢醭醴醵醺采釉里重野量釐金釜銎鑫阜阝队阡阢阪阮阱阳阴阻阼阽陂附陉陌陎陑陕陞陟陡除陴陵隅隆隋隍随隔隙隧隩隳隶雨雪雳雷雹雾需霆霈霏霓霖霜霞霪霰露霸霾青静非靠面革靬靳靴靸靺靽鞁鞅鞋鞔鞘鞠鞣鞧鞬鞭鞮鞲鞳韭飘首馘香馝馞馥馧骨骷骼髀髁髃髅髓鬯鬲鬷鬻鱼鲨鳌麦麸麹黄黇黎黏黑默黛黟黠黧黾鼋鼓鼗鼙鼻鼽鼾齄齇龠龢鿎鿬𥕢𥖨𥻗𦙶𦝼𦰡𨙸𨺙𪣻𪤗𫞩𬂩𬒔

## 2. 修正 v0.235 存在的错形

啄跐

> ㊟　以上两字在 v0.235 版本中分别误作「啄󠄀`⿰口豕, U+5544 U+E0100`」「𧿥`U+27FE5`」。

## 3. 仅涉及间架调整的字形

㑊㕮㘎㛃㠇㤘㥄㧐㧑㬊㭎㳇㳚㴔㵐㸌㺄䁖䂮䃅䎃䏡䲠䲢䴓䴔䴕䴖䴗䴙䶮业丛临为丽举乌乔习书买亚交亩享京亮亸今令仨们仿伉众优伞伟伣伪伫伶佗佥佧佴佼佽佾侂侘侥侧侨侪侹俞信俦俪俫俭修俯俸倌倍倕倞倥倦倧倴债倻值偏停健偰偷偾傍傕傣傧傩催傲像僦僬僮僰儋免兑兔兕八兰兴养兽冈冕冤冮冷凉凘凤凫凳刈刍划刘则刚创初删刬刭刳刿剁剃剐剑剖剥割劁劂劈劐劝办务劣劲势勇勋勍勖勚化华协卒单卖卞卣卤卫卷卺厅历厕厖厣厥双取变叛叨叭叹叼叽吖吟吠吩吭启吱吲吹呐呒呓呔呖呗员呜呤呸咎咙咛咡咤咨咬咴哑哓哕哗哜哪哭哼唁唐唝唢唯唳唼唾啐啦啧啪啰啴啵啶啸啻啼喀喑喙喧喱喳喷喻嗌嗔嗫嗲嗳嗽嗾嘏嘛嘡嘧嘬嘿噇噍噔噘噜噩噻嚄嚎嚓嚣囡囱围囹图圆圈圉圌圐圙圢圫圬圹坊坎坒块坚坜坝坞坠坨坯坽垂垃垄垅垆垕垙垞垩垫垭垸垺垿埒埙埪埴埵培堆堍堐堙堾塅塆塍塘塝填塮塾墁境墉墘墚墩墼壶壸备夜夤头夺奋契奓奕奖奘奡奢娈娶婴媭孕字孙孪孬孰孽宁它宄宅宇守宋完宓宕宗官宙定宛宜宝实宠客宣宪宫宬宰害宵家容宽宾宿寁寂寅寇富寐寒寓寝寞察寡寤对寻寿射将尕尘尜尧尨尪就尴屃岗岚岿崁崇崔崟崮崴嵌嵛巅巩差市帅师帏帘帝帡带帧帨席帮帱帷帻帽幛幢幪广庀庄庆床庋庐庑应庖店庙庚府庞庠庤庥度座庭庱庳庶康庸庹廉廋廑廒廓廖廙廛廨廪异弈弑彐归录彗彟彤彦彧彰影彷役彻径徕忆忑忘忞忠忭忸忺忾怀态怂怃怆怜怦总怼怿恋恔恝恢恣恧恫恶恹恻恽悆悈悫悭悯悰悴惇惊惋惘惟惦惩惫惮惯愃意愔愤愦慊慌慎慑慧慵慷憔憕憝憧憺懈懑懒懿戆戋戎戏戕或戗战戢戥戭戮戳戽戾房扁扂扅扇扈扉扊扒扔执扩扪扫扭扮抃投抗抚抡抢护报抨拉拎拖拜拢拧择拳挈挓挖挚挛挞挠挡挢挤挦挲捆捞损捡换捩捭捱捶捽掀掂掊掐掖掠探接控推掮掰掳掸掺掼揆揎揖揞揩揳揶揽搀搅搒搓搛搡搪搬搴携搽搿摄摈摊摧摩摭摺撄撅撇撖撞撮撷撸撺擅擘擞擢擦攉攒攫攽放效敌敖敛敢敦敩敫数文斋斌斐斑斓斛斟新方於施旁旃旄旆旋旌族旐旗旞早旮旯旷旻昄昈昉昝昤昱昽显晏晓晔晟晪晷晾暄暅暌暧暲暶暹暾曈曙曜最朳朵杀杂杕条杧杭杻枋枞枣枥枧枪枫枭柁柃柖柠柿栅标栈栉栊栏树校样栾案桠桡桢桥桦桨桩桷梆梓梼梾检棂棓棕棰棺椀椁椋植椎椟椤椭椰椴椸椿楔楦楫楮榄榅榇榉榍榕榖榜榨榫榭榷榻槎槚槛槜槟槲樟樱樵橄橑橙橛橡橥橦橹檀檐檗檞檫欠次欢欣欤欲欷欺欻款歃歆歉歙殁残殍殒殓殖殚殡殳段殷殿毁毂毅毽氍氡氢氧氨氩氪氰氲氽汈汉汋汛汴汶沆没沥沦沩沪沱泞泠泣泷泾洨洱浃浅浆浇浈浉测济浏浐浔浣涛涞涠涢涤润涩涪涫液涴涿淀淙淟淠淤淬淮淳渌渍渎渖渟渡渲游湃湔湾溃溅溏溟溠溢溱溵溶溻滁滂滇滏滓滗滘滟滠滤滥滦滧滨滩滪滫演漤漩漱漳漴漶漷漻漼潇潋潖潵潼澄澉澛澜澥澪澶澹激濂濉濑濒濠濩濯瀍瀔瀛瀱瀵灈灌灏灰灵灾炆炉炊炕炘炜炝炭炳烠烦烧烨热烷烹焐焓焖焘焙焞焦焰煅煊煲煴煸煽熔熘熟熠熻燊燋燮爟爱爷爸爹爿牂牍牖牢牤牥牵牻牿犊犋犏犟犨犷狈狉狞狡狨狩狮狲狺猃猄猝猡猰獍獐獗獬獭獾玃玑玟玮环现玲玺珊珌珑珝琐琔琛琟琬琭琮琯琴琶琼瑄瑖瑟瑢瑨瑭瑱瑳瑷璀璁璆璇璈璋璎璒璟璧璬璮璱瓘甙甚甩甭甯电町畲畴畹疁疃疒疔疖疗疙疚疟疠疢疣疥疫疬疭疮疯疰疱疲疳疵疸疹疼疽疾痂痄病症痈痉痊痒痔痖痘痛痞痢痣痤痦痧痨痪痫痰痱痴痹痼痿瘀瘁瘃瘅瘊瘌瘗瘘瘙瘛瘟瘠瘢瘥瘦瘩瘪瘫瘭瘳瘴瘵瘸瘼瘾瘿癀癃癍癔癖癜癞癣癫癯登癿皎皑皖皦皭皱盏盐监盔盗盘盦盲直省眢眬着睐睑睡睢督睦睽瞋瞎瞧瞪瞰瞳瞻瞿矗矜矧矫矸矾矿砍砚砜砣砬砻硌硎硕硗硭硷硿碇碌碎碓碗碚碛碥碲碳碶碹磅磋磏磐磨磬磴礁礅礞礳礻礼社祁祆祈祉祊祋祎祏祐祓祕祖祚祜祝神祢祥祧祯祲祷祸祺祼祾禄禅禊福禒禔禘禚禛禤禧秽稃稑稙稚稳稷稹稼穜究穷穸空突窄窅窆窎窕窖窗窘窜窝窠窣窥窦窨窬窭窸窿竖站竞竟章童竦竫端笕笠笺笼笾筘筛筦筶筹筼签简箜管箢箦箨箩箪箫篇篑篓簇簌簠簦簿籁粜粢粪粹粽糒糖糠糵罕罗置罱罹羖羚羞羟羡羰羱羸羼翀翊翌翎翔翘翙翛翟翠翩翼耍耢耩耪耱耵耶耸耻耽耿聂聃聆聋聍聒联聚聩聪肃肇肓股肩肪肮肷肼肽肾肿胁胧胪胶脎脏脐脔脘脞脟脩脲脶脸腋腐腑腒腓腔腕腙腚腠腧腻膀膈膊膑膪膺膻臀臁臂臆舠舡舣舨航舫般舯舰舱舲舳舴舵舶船舻舾艄艅艇艉艋艎艏艘艚艟艨节芄芏芒芠芡芦芰花芳苁苄苇苈苊苋苍苎苏苓苤苧茏茑茓茕茨茫茭茳茽荒荓荙荚荛荞荠荥荧荩荪荫荬莅莘莞莰莳莴莶莹莺菀菂菅菩菪菱菸菼萃萏萑萘萚萜萝萣萧萨萱萳萹葖葜蒂蒇蒉蒋蒌蒡蒨蒹蒺蒽蓇蓉蓓蓣蓿蔀蔈蔊蔌蔗蔟蔷蔹蔺蔻蕉蕖蕞蕤蕨蕰蕲蕺薄薏薛薜薢薪薮薳薸藁藿蘑蘖蘸蘼虏虔蠃衠衢衤补衩衫衬衲衽衿袂袄袆袍袖袗袜袢被袱袷袼裆裉裎裕裙裣裨裰裸裼裾褂褊褓褕褙褚褛褟褡褫褯褴褶襕襚襜襟襦襫见观觃规视觇览觉觊觋觌觏觐觑觖觟解觥觫觯觳言訾詈詟詹誉誊誓謇謦豁豌象豪豫豮贝贞负贡财责贤败货质贩贪贫贮贯贰贱贲贳贴贵贶贷费贺贼贽贾贿赀赁赂赃资赆赇赉赊赋赌赍赎赏赐赑赓赔赕赖赗赘赙赚赛赝赟赠赡赢赣赪赵趣趯趸趼跎跚跞跤践跷跹跺跻踌踣踩踪踬踮踱蹁蹄蹅蹇蹉蹋蹐蹑蹒蹙蹚蹜蹦蹩蹬蹴蹶蹾蹿躏躞身躲辛辞辣辨边达迈还这进远违迟迨述迳迹选逊逛逦逭逵逻遆遍遗遘遮邂邃邈邓邙邝邡邬邮邲邴邻邿郊郚郦郧部郪郭郸鄅鄌鄑鄘鄣鄫鄹酡酰酱酽醅醇醉醛醣醮释鉴銮鋆鋈鐾门闩闪闫闭闰闱闶闷闸闹闺闻阀阅阈阋阌阏阐阕阗阘阙防阶陀际陇院陨险陪陬陲陷隃隐隘障隹隺隼难雀雁集雇雉雎雏雯雱零霁霄霅霍霎霨霹靓靖靛靡靥靰鞒鞡鞯鞴韂韦韧韨韩韪韫韬音韵韶页顶顸项顺须顼颀预领颇颈颉颊颋颌颎频颔颖颗题颙颛颜额颞颟颠颡颢颤颥颦颧风飑飒飓飔飚飞骰骱骸骺髂髋髌髎鬶鱽鱿鲁鲂鲅鲆鲇鲈鲉鲊鲋鲌鲍鲎鲏鲐鲑鲒鲔鲕鲗鲘鲚鲛鲜鲝鲞鲟鲠鲡鲣鲤鲥鲦鲩鲪鲬鲭鲮鲯鲰鲱鲳鲴鲵鲶鲸鲹鲻鲼鲽鲾鳀鳁鳃鳅鳆鳇鳈鳉鳊鳍鳎鳑鳒鳓鳔鳕鳖鳗鳙鳚鳛鳜鳝鳟鳠鳢鳣鳤鸟鸠鸡鸢鸣鸧鸨鸭鸮鸯鸰鸳鸵鸷鸸鸹鸺鸻鸼鸾鸿鹀鹁鹂鹃鹅鹇鹉鹋鹎鹏鹑鹔鹕鹘鹙鹛鹜鹡鹢鹣鹤鹦鹧鹨鹪鹫鹭鹯鹰鹱鹲鹳鹴鹾麻麾黉黔黡黥黩黯黹黻黼鼍鼎鼐鼒齐齑龙龚龛龟𠅤𠳐𡎚𡐓𣗋𣲗𣲘𣸣𤧛𤩽𤫉𦒍𨟠𨭉𩾃𩾌𪟝𪾢𫇭𫌀𫖳𫚕𫚖𫛭𫠆𫢸𫫇𫭢𫭼𫮃𬀩𬀪𬃊𬇕𬇙𬇹𬊈𬊤𬍛𬍤𬒈𬒗𬕂𬜯𬞟𬟁𬩽𬮱𬯀𬯎𬱖𬶍𬶏𬶐𬶟𬶠𬶭𬶮𬷕𬸣𬸦

> ㊟　由于以下归类中的大多字形都涉及间架调整，故「间架调整」省略，不再体现于以下类别中。

## 4. 仅涉及避捺的字形

䐃倏剂囚因困囷憷戣攀桊棨棼棽楚槃樊毹氮氯泅漦濋灸焚獒癸盥类粲糜葵襻觎趑返迷逖逯遽邀邠鄃鄚醾鍪鏊闵闼阑阒阚雒鞑颁颍飕飙馨鹒鹩黍鿫𫔶

## 5. 仅涉及捺笔去折的字形

之乏入汆泛眨砭窆籴芝贬

> ㊟　本类中所包含的字均为含有「入」或「之」部件的字，因为原日文字体中「入」「之」部件的捺笔带折，而 G 标字体中「入」「之」部件的捺笔多不带折。

## 6. 仅涉及特定部首出脚调整的字形

### 6.1 酉部出脚调整（加脚为主）

酚酞酺酾醑醪

> ㊟　酉部右下角若靠近撇或横，则右下砍脚；若右下角旁为竖，或为撇、横但不靠近，则右下加脚。故「酚」「酞」酉部右下角砍脚，「酺」「酾」「醑」加脚。「醪」在本字体中，酉部右下角旁边虽为撇，但并不靠近，所以加脚。

### 6.2 鸟部、邑部声旁出脚调整（加脚）

郈郤鄱鸪鸽鹄鹆鹊鹐𬸪

## 7. 涉及断笔去除的字形

### 7.1 仅去除断笔

㛚㛹㫰㬎㬚㭕㮾㳘㻬䅟䏝䏲䜣䥽䦃䲟䴘与丏丐专东丝丢丧乃么乐乡乸亏云互亥亵以仫仰仳会传伢伥伭似佁低佛佤侄侉侔依侩侬侮俊俍俜俟俵倒倾偎偓偕偿傀傃傉傒储僭儇儦儳儴允充兖兜兢公兮兹冁写军农冯冱冶冻凇凯切到刻刽剀剜动劫劾勾匏卬卯印即却卵卿厍厩厶去厾县叁参叆叇及发叫台号吆吗吡吮呀呣呦呱呶咍咝咥咦咳哀哌哏哔哙哝哞哟唆唇唉唧唷啭啷喂喈喔嗉嗑嗞嗡嗦嗨噙嚷嚼囊囔圜场坛坬坳坶坻垒垓垠垤垦垮垵埃埌堉堑堲塈塱壅壤夷夸套奚女奴奶奸她好妁如妃妄妆妇妈妊妍妒妓妖妗妘妙妞妣妤妧妨妩妫妭妮妯妲妹妾姆姈姊始姐姑姒姓姗姘姚姝姞姣姤姥姨姱姶姹姻姽姿娀威娃娅娆娇娉娌娓娘娜娟娠娣娥娩娱娲娴娵娼婉婊婌婕婘婚婞婠婢婧婫婵婶婷婻婼婿媂媄媆媒媓媖媚媛媞媪媲媳媾嫁嫂嫄嫉嫌嫒嫔嫕嫖嫘嫚嫜嫠嫣嫦嫩嫪嫫嫭嫱嫽嬉嬗嬛嬥嬬嬲嬷嬿孀孅孤孩孳孵安宏室宸寰尝屁层屋展岌岽峁崀崧崭嵚嵬巍巧巯帐幄幺幻幼庇库底废庼廆廊廴延廷建弁弃弆弓引弗弘弛弟张弢弥弦弧弨弩弪弭弯弱弶弸弹弼彀彘彝很後微徽忪怅怠怡怫怯恨恳恸悌悔悛悢悬惛惨惭愍愕愧愫慈慨扆扬批扺抑抟抬抵抿拂拇拗拚拟拣拨拷按挎挥挨振捯握揿搌搐摆摔摛摞摴撤撬撵擐擒攘攥攮收改敏斩旅旒既旸昂昆昏昙昡昪昴晊晐晕晖晙晦晨暂暨曦曩朗朘望朽杨杩松构枇枍枨枲枵柢柳栋栎栲核根桀桉桎桧桹梅梭梯梳梿棍椠楷概榔榱榴槐槠樗樾橇橼檎櫆欸殆殇毋毌母每毐毒毓比毕毖毗毙毪毳毵氏氐民氓氟氦汝污汤沄沇沏沔沘沟沸治泓法泖泜泫泯泺泻泼洘洚洳派洿流浍浑浒浓浚浪海涄涕涘涟涨淞淯混渐渗渥湝湣溉溘溜溦溪溹溽滃滋滚漉漓漯潆潍潾澈澭澴瀌瀼炀炫炱炼烁烤烩烫烺焌焜煨煺熊爔爝爵牙牚牟犸狁狐狒狠狯狱狴狻狼猕猥猺猿玄率玙玚玛玡玭玹珉珋珐珢珫珲琅琉琊琏琨琵瑬瑰璃璘瓒瓖瓜瓞瓠瓢瓣瓤瓦瓮瓴瓶瓷瓻瓿甍甏甑甓甗畅畏畖留畚畜畯畿疏疝疡疤痃痍痓痕瘆瘤瘰皆皲皴盍眄眙眠眩眸眼睃睇瞌瞬瞵矣砀码砌砑砒砖砗砝砥砩砾硍硚硫碈碜碡碨碾磁磔磕磙磷祃祇祗祛禳离禽秀私秕秭秾稂穰穹穿窃窈窊窍窒窳竑竣笃笈笞笫第筚筤筵篡篦篯篱簋簏簪籀粤粥粮粼糁糍糸系紊素索紧紫累絜絷綦綮縠縢縻繁纂纛纟纠纡红纣纤纥约级纨纩纫纬纭纮纰纱纲纳纴纵纶纷纸纹纺纻纼纽纾线绀绂练组绅细终绉绊绋绍绎经绐绑绒结绔绕绖绗绘给绛络绞统绠绡绢绣绤绥绦绨绩绪绫续绯绰绲维绵绶绷绺绻综绽绾绿缀缁缂缃缅缆缇缈缉缊缋缌缍缎缏缐缑缓缔缕编缗缘缙缚缛缜缝缞缠缡缢缣缤缥缦缧缨缩缪缫缬缭缮缯缰缱缲缳缴缵罚罢罴罶羁羝羧羲翁翃翚翾耀考耋耘耨耲聊聘肆肟肠肱育胀胍胎胝胠胤胨胯胲胺能脍脓脚脿腭腾腿膂膣膦臃臜至致舆舐舛舜舞舭舷艮良艰艿芎芗芘芨芪芸芽苌苒苔苠苡茀茆茋茚茛茺荀荁荄荑荜荟荡荤荭荮药莓莛莨莲菘菰萦萼葰蒈蒎蒐蒗蒟蓄蓊蓏蓐蓑蓖蓠蓢蓦蔬蔸蕴蕹蕻薅薇薹藨蘘蘩虓虤衒衔衣表衮衰衷衾袁袅袋袤袪袭袯裁裂装裈裘裛裟裢裤裱裳裴裹褒褥褪褰襄襞觚觞讠计订讣认讥讦讧讨让讫训议讯讱讲讳讶讷许讹论讼讽设访诀证诂评诅诈诉诊诋诌诏诐译诒诔试诖诗诘诙诚诛诜话诞诟诠诡诣诤该详诧诨诩诫诬语诮误诰诱诲诳说诵诶请诸诹诺读诼诽课诿谁谂谄谅谆谇谈谊谋谍谎谏谐谑谓谔谕谖谗谘谙谚谛谜谝谞谟谠谡谢谤谥谦谧谨谩谫谬谭谮谯谰谱谳谴谵谶谿貔账购贸贻赅赈赞赳越趱跆跟跨跸踉蹊蹓躐躜躬车轧轨轩轪轫转轭轮软轰轱轳轴轶轷轸轹轺轻轼载轾轿辀辁辂较辄辅辆辇辈辉辊辋辌辍辎辏辐辑辒输辔辕辖辗辘辙辚辩辫辰辱运迓连退逄逆递逡邋邨邪邰邶邸郄郅郎郐郓鄂鄜鄠酂酝酶酸醨醯錾鎏鏖钅钆钇针钉钊钋钌钍钎钏钐钒钓钔钕钖钗钘钙钚钛钞钟钠钡钢钣钤钥钦钧钨钩钪钫钬钭钮钰钱钲钳钴钵钸钹钺钻钼钾钿铀铁铂铃铄铅铆铈铉铊铋铍铎铏铐铑铒铕铖铗铘铙铚铛铝铞铟铡铢铣铤铥铧铨铩铪铫铬铭铮铰铱铲铳铴铵银铷铸铹铺铻铼铽链铿销锁锂锃锄锅锆锇锈锉锊锋锌锍锎锐锑锒锓锖锗锘错锚锛锝锞锟锡锢锣锤锥锦锧锨锩锪锫锬锭键锯锰锱锲锳锴锵锶锷锸锹锺锻锼锽锾锿镀镁镂镃镄镅镆镇镈镉镊镋镌镍镎镏镑镒镓镔镕镖镗镘镙镚镛镜镝镞镟镠镡镢镣镤镥镦镧镨镩镫镬镭镮镰镱镲镳镴镵镶长闯闲闳阂阆阍阎阖阵陈降限陔陛隈隗隰隽雄雅雌雍雠雩震霉霭靼靿鞍顷顽顾顿颃颏颓颚飏饣饥饧饨饩饪饫饬饭饮饯饰饱饴饵饶饸饹饺饻饼饽饿馀馁馃馄馅馆馇馈馉馊馋馌馍馏馐馑馒馓馔馕马驭驮驯驰驲驳驴驵驸驺驻驼驽驾驿骀骁骂骃骄骅骆骇骈骉骊骋验骍骎骏骐骒骓骕骖骗骘骙骛骜骝骞骟骠骡骢骣骤骥骦骧骶髟髡髢髦髫髭髯髹髻髽鬃鬈鬏鬒鬓鬘鬟鬣鬼魁魂魄魅魆魇魈魉魋魍魏魑魔鲙鲢鲧鲫鲲鲿鳂鳄鳘鳞鸦鸩鸫鸱鸶鹈鹍鹚鹝鹮鹿麀麂麇麈麋麑麒麓麖麝麟麽黝黢黪鼠鼢鼫鼬鼯鼱鼷鼹齉鿍鿏鿭𥔲𦈡𧿹𨐈𨚕𨱇𨱏𨱑𨱔𩽾𪨶𫄧𫄨𫄷𫄸𫍯𫍲𫍽𫐄𫐐𫐓𫑡𫓧𫓯𫓶𫓹𫔍𫖮𫖯𫗧𫗴𫘜𫘝𫘧𫘨𫘪𫘬𫚭𫟅𫟦𫟷𫟹𫟼𫠊𫰛𫷷𬌗𬍡𬘓𬘘𬘡𬘩𬘫𬘬𬘭𬘯𬙂𬙊𬙋𬟽𬣙𬣞𬣡𬣳𬤇𬤊𬤝𬨂𬨎𬪩𬬩𬬭𬬮𬬱𬬸𬬹𬬻𬬿𬭁𬭊𬭎𬭚𬭛𬭤𬭩𬭬𬭯𬭳𬭶𬭸𬭼𬱟𬳵𬳽𬳿𬴂𬴃𬴊𬶨𬸚

### 7.2 去除断笔同时简化出脚

䌹妪姬姮婀婍婤婳媱媸嫡幽强檵瓯甄篼糨絮繄繇纪纯绁织绌绚绝继绮绱绳绸绹缄缒缟膙莼蔃蔼袈裒裔襁讪记讴讵讻诃识诇词诎诓询谀调谌谒谣谪谲轲轵遛钜钝钯钶钷钽铌铜铠铯锏锔锕锜镐镪镯飗饲饳饷驱驶驹骑骚鿔𫍣𫔎𫘦𬳶

### 7.3 去除断笔同时避捺

翷臻遴颂食飧飨餍餐餮饔饕魃鹌鹟

### 7.4 去除断笔同时调整特定部首出脚

#### 7.4.1 酉部加脚

酦酿醌

#### 7.4.2 鸟部汉字声旁加脚

鹠

## 8. 涉及出脚简化的字形

### 8.1 仅简化出脚

㟃㠓㧟䓛䓨䓫䗖䗛䗪䗴䝙䢺世亘亟仙伛伲伺但何使俺倔倘倚倜偃假偈偡僻儆冏凋减凵凶出击凼函凿剞劬勘包匈匐匚匜匝匠匡匣匦匪匮匹区医匼匾匿卧叚句只可史叵司同吏向吧吨呕呢周呵咄咒咸咺哃响哐哥哿商啊啕啮喊喝嗣嗤嗬嘀噶噼嚆圮圯坉坦坭坰坷垌垣垧垲垴埫埯埼堀堨堪堰塄墈墒壁壑夔够奁奇宦宧寄密尚尺尻尼局屈屉屙屮屯山屹屺屼屾岁岂岊岍岐岑岔岖岘岙岛岜岞岠岢岣岨岩岫岬岭岱岳岵岷峂峃峄峋峒峗峘峙峡峣峤峥峦峧峨峪峭峰峱峿崂崃崄崆崌崎崚崛崞崡崤崦崾嵁嵅嵇嵊嵋嵎嵖嵘嵝嵩嵯嵲嵴嶂嶅嶍嶒嶓嶝嶟嶦嶲巇巨己已巳巴帜庵庾徇徛徜徭忳怄怛怩恂恒恕恺恼惆惝惬感愣憾戡所扃扽把抠担拒拘拙拽捏捣掎掏掘掩揕揠揭搁搔搞摇摘撼擎擗擿敞敬敲断斶旎旖旦旬旭旵昫昵昶晅晌智暇曌曳更曷朏朐朔杞束杷枢枳枸柜柩柬柯栒框桐桓桤椅椆椹楞榈榧槁槌槱橘欧欹歅歇歌殉殛殴毡氅氆氇氙汇汕汜汹沌沤河泂泃泄泥洞洭洵洹浊涅涧涵淌淘淝淹渑渴湛湮溞滍滴漪潏澼灿炖炟炣炬炯炽烔烛烜焗煁煞煦熇熙熵燏牁犄犒狗独猗玘珂珣珦琦瑕瑶璥甸画畸疴瘐瘕癌盅盟盹眍眶矞砘砸础硐硙碉碣碱磡祀祠禋秬积稠稿窀窑窟竘竭笆笥笪笱笸筐筒筢筻箍箧箴篙篚簖籼粑缶缸缺罂罄罅罍罐罨羓羯翯翳耇耙耜耥职肥肫胆胰胴胸脑腌腴臣臧臾舁舢舥舸色艳艴芑芭苉苘苛苟苣茁茝茧茼荷菏菡萄萤萸葚葛葩葴蒿藏虐虫虬虮虱虷虸虹虺虻虼虽虾虿蚁蚄蚆蚊蚋蚌蚕蚝蚤蚧蚨蚩蚪蚬蚯蚰蚱蚲蚵蚶蚺蛀蛃蛄蛆蛇蛉蛊蛋蛎蛏蛐蛔蛘蛙蛛蛞蛟蛤蛩蛮蛰蛱蛲蛳蛴蛸蛹蛾蜀蜂蜇蜈蜉蜊蜍蜎蜒蜓蜕蜗蜘蜚蜜蜞蜡蜢蜣蜥蜩蜮蜱蜴蜷蜻蜾蜿蝇蝈蝉蝌蝎蝓蝗蝘蝙蝠蝣蝤蝥蝮蝰蝲蝴蝶蝻蝼蝽蝾螃螅螈螋融螓螗螟螠螣螨螫螬螯螱螳螵螽蟆蟊蟋蟏蟑蟒蟓蟛蟠蟥蟪蟫蟮蟹蟾蠊蠋蠓蠕蠖蠛蠡蠢蠲蠹蠼袒裥褐触觭觿訄訇訚警譬豳貆赒赜起超趋趟足距踦蹢躅躯躺辟辿迎迢迥迦迪迫迺追适逅遏遒遹避郇郾鄗酅配酗问间闽闾闿阁阄阇阉阊阔阿陆陋陧陶雊雕靶鞨鞫颅颐飐馗驷髑高鱾鲀鲃鲖鲷鲺鳋鳏鳐鳡鸤鸥鸬鸲鹖鹗鹞鹬黜鼩齁齿龀龁龂龃龄龅龆龇龉龊龋𠙶𦭜𪨰𪩘𫠜𫭟𫵷𫶇𫸩𬉼𬜬𬮿𬶋𬸘𬹼𬺈

> ㊟　「㇗」「匚」等部件下部断笔视作出脚。

### 8.2 简化出脚同时去除断笔

屿岈峻崿嵫嶙巉蚀蚂蚍蚓蚜蚣蚴蛑蛭蜃蜐螂螭螺蟀龈龌

### 8.3 简化出脚同时避捺

檠阃𬺓

### 8.4 简化出脚同时调整特定部首出脚

#### 8.4.1 酉部加脚

酮
