--
-- PostgreSQL database dump
--

--
-- Data for Name: nods_page; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO "public"."nods_page" ("id", "parent_page_id", "path", "checksum", "meta", "type", "source") VALUES (1, NULL, '/docs/openai_embeddings', 'gBybdse34zVsXwYNsdr/OA+Xx4zCySJNgfku8qFs65c=', NULL, 'markdown', 'guide');


--
-- Data for Name: nods_page_section; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO "public"."nods_page_section" ("id", "page_id", "content", "token_count", "embedding", "slug", "heading") VALUES (1, 1, '# OpenAI Embeddings

OpenAI embeddings are pre-trained language models used for natural language processing tasks. These models are built using deep learning algorithms and can be fine-tuned for specific tasks. OpenAI provides several pre-trained embeddings, including GPT-2, GPT-3, and BERT. Each of these models has a different number of parameters and can be used for different tasks.

To use OpenAI embeddings, you can install the OpenAI API and authenticate with your API key. Then, you can load the desired OpenAI embedding model and use it for your NLP task. For example, you can generate text using the model by calling the completions method.

OpenAI embeddings are trained on large amounts of text data and are designed to capture the meaning of words and phrases in a way that is useful for downstream NLP tasks. This is achieved through a process called unsupervised learning, where the model learns from the patterns in the data without being explicitly trained on a specific task.

Once trained, OpenAI embeddings can be used for a variety of NLP tasks, such as text classification, sentiment analysis, and language translation. In addition, they can be fine-tuned for specific tasks by providing additional training data and adjusting the model''s parameters.

OpenAI provides several pre-trained embedding models with varying sizes and capabilities. GPT-2 and GPT-3 are both transformer-based models that are well-suited for language generation tasks, such as text completion and question answering. BERT, on the other hand, is a bidirectional encoder that is particularly useful for tasks that require understanding the relationship between different words in a sentence, such as sentiment analysis and named entity recognition.

Overall, OpenAI embeddings are a powerful tool for NLP tasks and have been used to achieve state-of-the-art performance on a wide range of benchmarks and applications.
', 380, '[-0.011226157,-0.0019087797,-0.00039245744,-0.008141462,-0.0030547138,0.0046670167,0.014630647,0.008188099,-0.011239481,-0.042106416,0.011026285,0.025756868,-0.019227708,-0.013211554,-0.0023385051,0.02091996,0.011132883,0.017055763,0.014564023,-0.0143375015,-0.020440266,-0.010380031,-0.024650907,-0.014883818,-0.008634481,-0.006942229,0.0324326,-0.027875513,-0.023784796,-0.018161723,0.012531988,0.0125719635,-0.007082139,0.0010060235,-0.007948252,0.015150315,0.011645889,-0.023158528,0.028195309,0.015736606,0.00774838,0.03107347,0.014817194,-0.019960573,-0.0055464543,-0.00071954,-0.02086666,-0.01652277,0.0030863604,0.01582988,-0.00030084935,0.050048005,-0.013857808,0.004213973,-0.02241234,0.00080698414,-0.018468194,0.030380579,0.017388884,-0.0047436343,-0.009000912,-0.008308022,-0.009900338,0.015723282,-0.0123920785,0.0061494024,0.00055381266,0.021293055,0.0046636853,-0.010173497,0.020999908,0.017855253,0.0025716894,0.004107374,0.025437072,-0.0020187094,-0.0072820117,-0.015203614,-0.02739582,0.0006083611,-0.009727115,-0.015683308,0.0009877019,0.022545587,0.00921411,-0.022025919,0.007828329,-0.002974765,-0.015936479,0.0052199964,0.015576709,0.01367126,0.016656019,0.007488546,-0.003267911,0.032565847,-0.022532262,0.0018604773,0.0008465422,-0.032246053,-0.014497399,0.016109701,-0.02205257,-0.017135711,-0.031046819,0.027475769,0.024890754,-0.0030930226,0.005150041,0.022785434,0.0045304373,0.015989779,-0.0043405583,-0.022399014,-0.017815277,0.003660993,0.0397879,-0.020120472,-0.019387607,0.014683946,0.019161085,0.018881263,0.020933285,-0.01765538,0.01477722,-0.015656658,0.0052599707,-0.0050267866,0.0042239665,-0.011719175,0.012671899,0.018281646,0.021426303,-0.015776582,-0.031100119,0.04109373,-0.0062959753,-0.0076950807,-0.015816556,-0.019574154,0.022758784,0.011665876,-0.007155426,-0.011312768,-0.011279456,0.0103600435,0.0067423563,0.011239481,0.024944054,0.004187323,0.016496122,-0.0019987223,-0.0362435,0.010533267,-0.003890846,-0.010253445,0.012805147,0.0062093637,-0.036190197,-0.017268961,0.010886374,0.015403487,-0.016376197,0.007128776,0.013211554,0.023425026,0.0060727843,-0.0028165327,-0.018081775,-0.013711235,-0.0077084056,0.017722005,-0.04690335,-0.0008819362,0.0077550425,-0.0035410696,0.03102017,0.013211554,-0.01134608,-0.023171853,0.0065957834,0.0029714338,0.016136352,0.0076284567,-0.005786301,-0.028675003,0.0026999407,0.0047036596,0.010306745,-0.024051292,0.0024817467,0.01906781,0.015070366,-0.016656019,-0.6306369,-0.013318153,0.0287816,-0.02662298,0.015616683,0.01475057,0.0060561285,-0.0036809803,-0.011292781,0.037895773,0.009473943,-0.02806206,-0.02017377,0.0071021263,0.026476407,-0.025610294,-0.0056297346,-0.027555717,0.01776198,0.027529068,-0.02305193,0.012658575,-0.0162163,-0.009493931,-0.00058004586,0.013384777,0.0016014762,-0.006572465,0.009540568,0.009946975,-0.021159807,0.03986785,0.032832343,-0.011292781,0.039707948,0.01369791,-0.03099352,0.027982112,-0.007108789,0.046583556,-0.0041107056,-0.02061349,-0.015683308,-0.0067756684,0.01336479,0.019814,0.015723282,-0.008727754,-0.021772748,0.0020886648,-0.0008677786,0.026249886,-0.010786437,-0.014270877,-0.004687004,-0.0024151227,0.028275257,-0.0011625901,0.030540476,-0.026196586,0.031926256,0.015270238,-0.021159807,-0.028435156,-0.024277814,0.015270238,-0.008914301,0.013544675,-0.0036210185,-0.047782786,0.013637949,0.018001825,0.009127499,-0.009867026,-0.0011359405,0.030700374,0.012958383,-0.010526604,-0.014950443,0.008954275,0.022638861,-0.014697271,0.0036976363,-0.0077683674,0.023318427,0.028701652,0.0010934677,0.006375924,0.011259469,0.0055497857,0.00072911725,0.025783516,-0.03533741,-0.06816976,0.0025000684,0.0066457517,-0.012338779,-0.007821666,0.00738861,-0.007521858,0.013371452,-0.027129324,0.014190928,0.027822213,0.017428858,0.009294058,0.016895866,0.0070688142,-0.002623323,-0.018521493,-0.014910468,0.0009219106,0.0015007074,-0.014270877,-0.00343114,-0.022452313,-0.0017005795,-0.0057130144,0.028088711,-0.032779045,0.0143375015,-0.0029597746,-0.015669983,-0.008154787,0.010926348,0.0025900109,-0.01275851,-0.006589121,-0.011599252,0.01513699,0.012751848,-0.015869854,-0.006422561,-0.0059695174,0.02750242,0.022465639,0.03459122,0.0033145477,-0.00057421625,-0.009993612,0.0021985944,0.007568495,0.017575432,-0.0014499065,-0.039095007,-0.012178881,-0.007208725,0.004547093,-0.001614801,-0.014284202,0.0032878981,-0.010226795,-0.008014876,0.036216848,0.010240121,-0.019227708,-0.009593867,-0.03677649,0.005309939,-0.020213746,-0.0034444646,0.02811536,-0.016256275,-0.010526604,0.0074752215,-0.0109396735,-0.00503678,0.029101396,-0.017455507,-0.043012504,0.016722644,-0.028568404,0.013064981,0.01369791,-0.012825134,0.019600803,-0.028248608,0.0013716231,-0.00083779776,-0.018414894,-0.0030197361,-0.013977731,-0.0036010314,-0.023331752,0.010866387,0.0029198,0.024757506,0.015749931,-0.01283846,0.009220772,0.0013582984,0.028595053,-0.025450397,0.031180067,8.385265e-05,0.01806845,0.028621703,-6.9070426e-05,-0.004180661,0.015550059,0.00083155173,0.009673816,0.005176691,-0.0021985944,-0.0074818837,-0.0030014147,-0.0039941133,-0.021959295,0.0021269736,-0.0002644143,0.022758784,0.01812175,-0.028488455,-0.015749931,-0.002639979,0.013211554,-0.007635119,0.011266131,-0.01372456,-0.011719175,0.0020520214,0.021053208,0.021799397,0.005669709,-0.011472666,0.023958018,0.005000137,0.0038608653,0.0012350439,-0.03320544,0.021293055,0.02459761,0.010633202,0.007328648,0.025370449,-0.007301999,0.04341225,0.007341973,0.0325392,-0.029341243,-0.006702382,0.013817834,0.0014948777,-0.025183901,0.040001094,0.0016714315,0.037282832,0.009147486,-0.019281007,0.004547093,-0.028595053,-0.0008927626,-0.015723282,0.010180159,0.00957388,-0.017588755,0.018907912,-0.010886374,0.022878708,0.027768916,-0.00641923,-0.0069222413,0.013398102,0.017015789,0.021066533,-0.013951082,-0.0011342749,-0.02271881,-0.029154696,0.003417815,-0.010666515,-0.022079218,0.0007745049,-0.022132518,0.031553164,0.028488455,-0.00046678493,0.017255636,0.0141376285,0.056710415,-0.0075884825,-0.04887542,0.049275167,-0.00053257623,-0.0063492744,-0.0041406862,-0.041573424,-0.014257552,-0.0143908,0.0022918682,-0.0060428036,0.035897054,0.010786437,0.003162978,-8.411289e-05,0.015576709,0.022438988,0.002531715,0.025703568,-0.015243589,-0.0030447203,0.0023884731,-0.019747376,-0.013458063,0.025037328,-0.001523193,-0.018814638,0.0021353017,-0.0074752215,-0.010952998,0.0056264033,0.0097337775,0.020520216,-0.01411098,0.021039883,0.027195947,-0.007854979,-0.008581181,0.018934563,0.011765812,0.0037542668,-0.018907912,0.0077617047,0.020040521,0.034378022,0.015083691,-0.016749293,0.008288035,-0.025836816,0.018961212,-0.017055763,0.005966186,-0.016456148,0.021599526,-0.030513827,-0.026836177,0.019560829,-0.004580405,0.013817834,0.00077200646,-0.0079682395,-0.036323447,-0.009047549,-0.02415789,-0.011012959,-0.012072283,-0.00018956632,0.010779776,0.03664324,-0.014564023,0.027275898,0.015350187,-0.014297526,-0.026169937,0.007934927,-0.006505841,-8.49457e-05,0.0065458156,-0.014324176,0.0051467097,0.004680341,0.036190197,0.008308022,0.006519166,0.015017067,0.022585561,-0.021719448,-0.018281646,-0.014990417,-0.029367892,0.005449849,0.0001763456,-0.006895592,-0.0114993155,-0.016282924,0.025223875,-0.032965593,-0.00056089147,0.03091357,0.018588116,0.010006936,-0.016149675,-0.012432053,-0.041440174,0.008914301,-0.036456693,-0.005103404,-0.01840157,-0.009673816,-0.00387419,0.004267272,0.0010959661,-0.026929451,0.030167382,0.0047003287,-0.025756868,-0.051513735,-0.031286664,-0.0030697044,0.017868577,0.010160171,-0.0023018618,-0.019574154,0.011379392,0.018308297,-0.015989779,0.011865748,-0.018414894,0.001045998,-0.00076367846,-0.013764534,0.007155426,-0.005489824,-0.014297526,0.014630647,-0.003924158,-0.007275349,0.0060294787,0.015190289,0.047063246,0.02045359,0.0029514465,0.016775941,-0.052553073,-0.022638861,-0.025703568,-0.011599252,-0.030647075,0.0052732956,-0.0033695127,0.019347632,0.027982112,0.011079584,-0.019001186,-0.007854979,0.007548508,0.012518664,0.007115451,0.004627042,-0.017442184,-0.0012192206,0.023571597,0.009114173,-0.019494204,-0.031100119,-0.01281181,0.02343835,0.025916766,-0.023504974,0.018801315,-0.0009685475,0.0047969334,-0.013844483,0.018441545,-0.016815918,0.022785434,-0.012198868,-0.003434471,0.008947614,-0.0079682395,-0.031206718,0.0020153783,-0.027688965,0.0049301814,0.00683563,-0.0021985944,-0.012338779,0.0024734188,0.020933285,-0.017788628,-0.017135711,0.024451036,0.018001825,0.039468102,-0.009314046,0.03520416,-0.031180067,-0.039308205,-0.0058296067,-0.008734416,0.0018937894,0.021786073,0.04026759,0.025383772,0.011912385,-0.0144441,0.03682979,0.011266131,-0.0029597746,0.0055797664,-0.0013924432,-0.008994251,-0.0106065525,-0.012871771,-0.0011859086,0.003644337,0.015017067,-0.013358127,0.013404764,0.010066898,-0.009467281,-0.009873688,-0.012078945,-0.021119831,-0.01796185,0.044931278,-0.017921876,0.023211828,-0.04546427,0.0028964817,-0.001234211,0.013131605,0.021146482,0.0042073103,0.019547503,-0.0059062243,0.0020270376,0.0067756684,-0.014990417,-0.027555717,-0.0005309106,-0.055324633,0.0025666924,0.0060428036,0.0075884825,0.022758784,-0.013584649,-0.012518664,0.002861504,0.008647805,-0.0041306927,-0.0018304965,0.011312768,-0.028088711,-0.02449101,-0.034324724,-0.025810167,-0.0013691247,-0.016922515,0.007455234,0.0018205029,0.0252372,-0.025863467,0.000558393,0.01134608,0.013404764,0.04621046,-0.0035377385,0.022452313,-0.0042572785,0.012325454,-0.0045504244,0.017015789,-0.004250616,0.004353883,0.01045998,0.002786552,0.016482797,-0.029900886,0.0155900335,0.004643698,0.00037018003,-0.026423108,0.03914831,-0.023931367,-0.009986949,0.003920827,-0.022532262,-0.02194597,-0.0018588117,-0.015550059,-0.00683563,1.733267e-05,-0.004886876,-0.009294058,0.013584649,0.023691522,0.011019622,0.00023422527,0.033791732,-0.0026299853,0.009367345,-0.01314493,-0.004007438,0.020293694,0.01203897,-0.0019504199,0.0023868075,0.012472027,0.0035077576,0.007341973,0.011086246,0.012198868,0.030433878,-0.04050744,-0.016829241,0.008394633,-0.013464726,0.014230902,-0.00048968697,-0.0020137127,0.0021153144,-0.010813087,0.007088802,0.03744273,-0.010566578,-0.024197863,0.0027798896,-0.005789632,-0.027848864,-0.006895592,-0.0057330015,0.018175049,-0.025290499,-0.025663594,0.013251529,-0.0047436343,0.013611299,-0.007228712,-0.004250616,-0.006505841,0.03304554,-0.009907,-0.021199781,-0.008934288,0.010373369,-0.009907,-0.0106265405,-0.008547869,-0.0065791276,0.008367984,-0.021719448,-0.0130183445,-0.005133385,-0.013078306,0.018668067,0.0041406862,0.008234736,-0.0007715901,-0.014710596,-0.0022402345,-0.012458703,-0.0052666334,0.007235375,0.022838734,-0.006206033,0.026889477,-0.025397098,-0.0046670167,-0.016336223,0.0064958474,0.0005009298,-0.050900795,-0.021439627,0.009647166,0.003284567,0.0101135345,-0.0037409419,-0.005986173,-0.0041406862,-0.024744181,0.026569681,0.0037376108,0.009707128,0.008221411,0.018028475,0.016656019,-0.016829241,-0.018974537,-0.01203897,-0.019774025,-0.012665236,-0.033685133,0.008328009,-0.01239874,0.030753674,0.013318153,-0.03810897,-0.024757506,-0.006179383,-0.04234626,-0.004363877,-0.0054798303,0.01832162,0.022598887,0.045624167,0.0106065525,0.026223237,0.010893037,0.013977731,-0.030407228,0.016163,-0.014657296,-0.009027562,-0.024610933,0.0033628503,-0.030167382,0.018827964,-0.009387332,-0.028142009,-0.009940312,0.029687688,-0.0042039794,-0.013937756,0.0047669527,0.028595053,0.02551702,0.023038605,0.030034134,-0.020067172,-0.00039891165,0.005136716,-0.0109396735,-0.01211892,-0.017801953,0.010713152,0.023624897,0.021626174,0.0065125036,0.0041906545,0.0014965433,0.007215387,0.044904627,0.000357688,-0.025490372,0.013791184,0.015656658,0.0038608653,-0.009793739,0.011072922,0.008454595,-0.0025933422,0.020333668,-0.029794287,-0.023371726,-0.026050014,0.015510085,-0.017428858,-0.0038941773,0.0040907185,0.012105594,-0.033631835,0.016416172,0.0027665647,-0.001125114,0.00952058,-0.019320982,0.023291778,-0.008288035,-0.029661039,0.0042572785,0.00041015446,0.008807703,0.005653053,-0.001606473,-0.029927535,0.01693584,0.03336534,-0.012305466,0.019281007,0.18452205,-0.05415205,0.0008819362,0.0015914827,0.002769896,-0.016722644,0.009647166,0.0011867414,-0.023011956,-0.004220635,0.018108424,0.014910468,-0.016749293,0.00083446654,0.0072820117,-0.029421192,-0.03397828,-0.015963128,-0.003434471,0.0032645797,-0.009687141,-0.0020603496,-0.005806288,-0.0038009034,0.0025633613,0.010579904,-0.007828329,-0.0027932143,0.01696249,0.014617322,-0.0009327371,0.011699188,0.018254997,0.0044238386,-0.0061427397,0.0022185817,0.008821027,0.025423747,0.015510085,-0.0025233869,0.03096687,0.009640504,-0.0038042348,-0.021399653,0.0024784156,0.026716255,-0.027249247,-0.017921876,-0.010013599,0.011439354,-0.008074838,-0.014710596,0.0027265903,0.00426061,-0.009960299,0.0155234095,-0.0035344071,0.010959661,0.022612212,0.0050867484,-0.02302528,-0.00387419,-0.007142101,0.0029947523,-0.013617961,0.0075085335,-0.007115451,-0.018041799,0.018348271,0.0061960393,-0.0066624074,-0.001405768,-0.0055164737,-0.008727754,-0.032752395,-0.026463082,0.04413179,0.023011956,0.012005659,0.03251255,0.012078945,-0.010173497,0.0028315233,-0.0068123117,-0.0142042525,-0.043225702,0.01812175,-0.03677649,-0.0021769416,-0.018934563,-0.0016114698,-0.019281007,0.0061560646,0.011519303,0.012285479,-0.0028914849,0.013911107,-0.0031529844,0.0017105731,-0.023944693,-0.027902164,0.04679675,0.024530984,0.0002519223,-0.0053199325,0.019467555,-0.012545314,-0.003774254,0.012965045,0.005523136,0.004706991,-0.039521404,0.014950443,-0.0046237106,-0.00738861,0.0044871317,0.008474583,0.0072020628,0.0071021263,-0.0029364561,-0.03251255,-6.1627274e-05,-0.010826413,-0.0011542621,0.0007491045,-0.03384503,-0.033685133,0.019654103,-0.014044356,0.010080223,0.015656658,-0.023544949,0.0021852697,0.018934563,-0.013911107,0.0008044857,0.0040973807,0.013398102,0.0058962307,0.0012500342,0.007095464,-0.0001765538,-0.004180661,0.004673679,0.0073486357,-0.010453317,0.0077283927,0.010666515,0.006975541,-0.008980925,-0.0041573425,-0.005819613,0.009294058,0.00031729715,0.018188372,0.010899698,-0.00686228,-0.020307017,-0.0063159624,0.0064292233,-0.05964187,-0.014843844,0.00077617046,-0.017002463,-0.008008214,-0.024051292,-0.16682668,0.0025133933,0.0016939171,-0.051460437,0.017921876,0.01007356,0.011959022,-0.013884458,-0.016389523,-0.011645889,0.01868139,-0.009973624,-0.023638222,-0.034937665,0.010226795,0.026010038,0.0053365882,0.007188738,0.02734252,-0.0012533654,0.04088053,-0.035603907,0.008781053,-0.003284567,-0.0117325,-0.007821666,0.00066748995,0.027742265,-0.0027099343,-0.037096284,0.007128776,-0.018827964,0.04828913,0.001895455,0.028754951,0.004104043,0.0504744,-0.022825409,-0.027609017,0.019614128,0.03461787,0.008008214,0.0019920599,0.0017472163,0.0037975723,-0.008567856,0.031313315,-0.010679839,0.029421192,-0.012851784,0.008581181,0.009567217,-0.00023380887,-0.011545952,0.006159396,0.010906361,0.0104266675,0.00683563,-0.007974902,-0.036483344,0.013424751,-0.014990417,0.008987588,-0.006019485,-0.010566578,-0.0049768183,-0.030194031,0.027275898,-0.02133303,0.021985944,0.007288674,0.0117458245,-0.011932372,-0.009747102,0.028648352,0.030727023,-0.03160646,0.007888291,0.025836816,0.0031912932,-0.017055763,0.023065256,-0.011026285,0.00038121463,0.0040674,-0.00846792,0.012911746,0.01790855,-0.04026759,0.0016164667,0.023305101,-0.0252372,0.0045037875,0.01189906,0.005143379,0.019667428,0.021159807,-0.030034134,0.018188372,-0.0061960393,0.0035843754,0.0059761796,0.0074752215,0.0064158984,0.028088711,0.014537374,-0.018215023,-0.019494204,0.030194031,-0.01660272,-0.004000776,-0.013777859,-0.009407319,0.015669983,-0.018801315,0.011239481,-0.010120197,-0.019161085,0.031739708,-0.010952998,0.026169937,-0.0034944327,-0.018294971,0.03320544,-0.00702884,-0.035044264,-0.119816735,-0.011406042,0.012405403,0.013078306,-0.011299443,0.01776198,0.019667428,0.023611572,-0.021706125,0.028648352,-0.039361503,-0.021253081,0.007894953,-0.015949804,-0.0010285092,-0.006239345,-0.0030413892,-0.00954723,-0.03738943,0.022905357,-0.0013074975,0.00021736104,0.027635667,-0.013071644,0.0005121726,0.0016506115,-0.021626174,0.023131879,0.0075285207,-0.013871132,0.01704244,-0.026116638,0.0023618236,-0.020320343,-0.0020053848,0.011972346,-0.0051467097,-0.019574154,0.010400019,-0.010193484,-0.0010801428,-0.012458703,0.01331149,-0.0028764945,-0.009687141,-0.01375121,-0.021079857,0.019907273,-0.018254997,-0.026796203,-0.039921146,-0.009747102,-0.043545496,0.01153929,0.0076417816,0.021799397,0.008754403,-0.0043505523,0.010233458,-0.010952998,-0.02117313,-0.008367984,-0.03325874,-0.009387332,-0.005196678,0.0008885986,-0.017015789,-0.014071004,-0.008767729,-0.008341335,-0.00012169304,0.017975176,-0.0009535571,0.010020261,-0.019360956,-0.0029481153,0.0020320343,-0.016669344,0.01989395,-0.00283652,-0.013191567,-0.0015048713,0.00025025668,-0.03696304,-0.015630009,0.0049135257,0.0068056495,-0.024570959,0.001723898,-0.04048079,0.006828968,0.037789177,-0.00040078544,-0.020906635,-0.0033078853,-0.0027932143,-0.03672319,-0.0015764922,0.006455873,0.03032728,-0.007934927,-0.00056755386,-0.049648263,0.015296888,-0.0063026375,-0.01275851,-0.007988227,-0.017788628,0.010659852,-0.0033312037,-0.005689696,0.016282924,-0.021452952,-0.00015479687,-0.006052797,0.013791184,-0.018694716,-0.010999635,0.0287283,0.0049768183,0.0142042525,0.008681117,-0.0126385875,-0.0027332527,0.0040773936,0.026063338,0.0016306243,-0.028142009,-0.02744912,0.02415789,-0.00066915556,-0.014150954,0.00880104,-0.018628092,-0.0040640687,-0.0052199964,-0.0136446105,0.0009727115,0.014310852,0.013951082,0.018534819,0.023465,-0.037682578,-0.03688309,0.016656019,-0.017388884,-0.016509445,-0.024371088,0.012292142,-0.022705484,0.010013599,0.008701105,0.043465547,0.018001825,-0.02567692,-0.03605695,-0.025250524,0.0054132063,0.025050653,0.010193484,0.0034877704,0.0076084696,0.060281463,0.020080496,0.007521858,-0.0018704709,-0.008434608,-0.0034944327,-0.029661039,-0.01704244,-0.0023385051,-0.009254084,-0.007668431,-0.003171306,0.0011051268,0.012505339,0.027609017,-0.007834991,0.013804508,-0.012911746,-0.017855253,0.036563292,0.01076645,-0.0107931,-0.009793739,0.006172721,0.023811445,0.009780414,-0.0030813634,-0.009014238,-0.023971343,-0.018721364,0.009407319,0.0088610025,-0.0019637446,0.02459761,0.016616045,-0.010579904,0.01549676,0.023584923,0.023171853,0.0011959021,0.028301908,-0.005623072,-0.002748243,-0.03666989,-0.012818472,-0.004936844,-0.03381838,-0.011099571,0.02194597,0.018521493,0.012865109,-0.009227434,-0.013211554,-0.011805786,-0.014310852,0.014603998,0.0068422924,-0.029261295,-0.034431323,0.001309163,0.031393263,0.013131605,0.028515104,-0.0030697044,0.03320544,-0.011492653,0.010200146,-0.004753628,0.0324326,0.012738523,-0.022372365,-0.022785434,-0.0046770102,-0.012472027,-0.023318427,-0.0144041255,-0.030806974,0.018934563,0.016735967,0.08458593,0.026902802,-0.003376175,0.019081136,-0.010140184,0.0059095556,0.011692525,0.0054698368,-0.015616683,0.0106265405,-0.010400019,-0.003284567,-0.030167382,-0.018281646,-0.0016222963,-0.023904718,0.011039609,0.01740221,-0.0073819477,0.025530346,0.036616594,0.000350401,0.025130602,-0.0006083611,-0.03168641,0.0029447842,0.02662298,-0.008454595,-0.009893675,-0.025770193,0.04101378,0.021253081,-0.039814547,-0.0014748905,-0.016722644,-0.0008465422,-0.0046703476,-0.025383772,0.008920964,0.016163,0.016669344,0.01654942,-0.0085945055,-0.049888108,-0.021985944,0.011845761,-0.016456148,-0.022572236,-0.021373004]', 'openai-embeddings', 'OpenAI Embeddings');
INSERT INTO "public"."nods_page_section" ("id", "page_id", "content", "token_count", "embedding", "slug", "heading") VALUES (2, 1, '## Storing Embeddings in Postgres

`pgvector` is a Postgres extension that provides support for vector operations, including similarity search and nearest neighbor search. It allows you to store vectors as columns in a database table and perform vector operations on them using SQL queries.

One interesting use case of `pgvector` is to use it in conjunction with OpenAI embeddings. Since OpenAI embeddings represent words and phrases as high-dimensional vectors, you can store these vectors in a pg\_vector column and use the extension''s similarity search capabilities to find similar words or phrases in a large dataset.

For example, let''s say you have a database of customer reviews and you want to find all the reviews that mention a particular product. You could use OpenAI embeddings to represent each review as a vector and store these vectors in a pg\_vector column. Then, you could perform a similarity search to find all the reviews that are similar to the vector representing the product name.

This approach can be very powerful for applications that involve large amounts of text data, as it allows you to perform complex queries on the data using vector operations. However, it does require some additional setup and configuration compared to traditional SQL queries, so it may not be suitable for all use cases.
', 255, '[-0.0064866035,0.0046572206,-0.01285929,-0.023574248,-0.011713413,0.01221599,0.01797218,-0.010232483,-0.019808264,-0.03347838,0.004188148,-0.003018817,-0.010741762,0.0010503875,0.0033170132,0.009213925,0.0068886657,0.012390217,0.018709294,-0.034336112,0.0052837674,-0.026268063,-0.03709694,-0.016149499,-0.0018511614,0.010219081,0.015412385,-0.025705177,-0.008088151,0.01861548,0.008845368,-0.008483512,-0.005890211,0.0010763541,-0.0413588,-0.013301558,0.01622991,-0.0022347958,0.0484619,0.024364969,0.0086577395,0.0121288765,-0.010748463,-0.022394864,0.015492797,-0.0042384057,-0.009971143,-0.030985594,0.019446408,-0.0012865991,0.009810317,0.061435103,-0.024914455,0.02404332,-0.0064732013,0.008798461,-0.016243313,0.015157745,-0.0035247453,-0.012691763,-0.006774748,0.025383526,-0.00039284828,-0.0052971696,-0.023480432,-0.017181458,-0.010366504,0.019138161,0.0015395632,0.011271143,0.026897961,0.04216292,-0.0025329918,-0.0134087745,0.0050324784,-0.016792798,0.011143824,0.0068953666,-0.017824758,0.016564963,-0.011880938,-0.0060409848,0.014983518,0.004208251,0.0096964,0.0116732055,-0.0050559323,0.010936092,-0.02223404,0.017020633,0.009334544,0.017610325,-0.0015412384,0.004938664,0.02165775,0.023735072,0.015291765,0.0129061965,0.0013695244,-0.00092809356,-0.014715477,0.0021108266,-0.038169105,-0.017034035,-0.015519601,0.018267026,-0.019017542,-0.033773225,0.011666505,0.024539197,-0.012041763,0.025638167,0.0008870497,-0.0018561871,-0.00950207,-0.008731451,0.01854847,-0.0154659925,-0.035542298,-0.0008652714,0.040179417,0.005196654,0.009234029,-0.01854847,0.0094350595,-0.015506199,0.020652596,-0.008027842,0.0053574787,-0.022247441,0.013040218,0.042672202,0.006791501,-0.018977337,-0.034282506,0.019553626,-0.021094864,-0.017395891,-0.019902078,-0.026844352,0.02747425,0.01344228,-0.039455704,-0.013804136,-0.035971165,0.02747425,0.009837122,0.028278375,0.018065995,-0.0030322191,0.014072177,-0.00646315,-0.037606217,0.0004418496,-0.015398982,-0.015693828,-0.01668558,-0.0019701049,-0.032486625,-0.017302077,0.0034476833,0.019660842,-0.018628882,0.009555678,0.01628352,0.020934038,0.0015186224,0.00549485,-0.01182733,-0.0206794,0.012745372,0.023440227,-0.052080456,0.014795889,-0.00265026,0.009079904,0.012350011,-0.0010344725,-0.026911363,-0.041841272,0.01958043,-0.0006261281,0.021697957,0.035086628,0.0180928,-0.01971445,0.029002087,0.0022029658,-0.0034292554,-0.025624765,-0.011512381,0.010420112,0.0030070902,-0.03776704,-0.6227139,-0.009756709,0.03602477,-0.037659828,0.03476498,-0.0062922733,0.0022180432,0.0011140474,-0.022515483,0.011465474,0.009495369,-0.02049177,-0.017154654,0.02514229,0.022796927,-0.014179394,0.011981454,-0.009006193,0.0141391875,0.028412396,-0.020893833,0.020237131,0.013603104,0.0055484585,0.021403112,0.03559591,-0.023869094,-0.0050257775,0.008818564,0.022957752,-0.028358787,0.01460826,0.005709283,-0.006881965,0.044334058,0.010051555,-0.025959816,0.03755261,-0.0046371175,0.039643332,-0.006928872,-0.034014463,-0.0016953623,0.010192277,-0.011143824,0.016645376,0.011023206,-0.01389795,-0.0009942664,-0.015626818,-0.008711347,0.010400009,0.013107228,0.003385699,0.0014616636,-0.014031971,0.030235078,0.0080211405,0.030851573,-0.0077598006,0.03109281,0.0045232,-0.0071366043,-0.014849497,-0.02482064,0.0063827373,0.0046505197,-0.015130941,-0.021349503,-0.024673218,0.012611351,0.014876301,-0.005538407,0.010265988,-0.006081191,0.02630827,0.03245982,0.019808264,-0.009817019,-0.0009884029,0.022837132,-0.02340002,-0.025705177,0.012651557,0.023265999,0.03063714,-0.04964128,0.008074749,0.034416523,-0.006664181,-0.0010126942,0.042591788,-0.039402097,-0.07188872,0.0088855745,0.008959286,0.00076349935,0.006640727,-0.01324795,-0.015506199,0.0012070242,-0.014702074,-0.0067948513,0.021376306,0.0059572216,0.0044695917,-0.0140051665,0.011532485,-0.0020237132,-0.01998249,-0.006171655,-0.018200016,0.015854653,-0.017891768,-0.005850005,-0.03154848,0.036802094,-0.012705166,-0.029162912,-0.021966,0.021496926,-0.012772176,-0.0013309934,0.0012355036,0.013583002,-0.0011517407,-0.0026284817,-0.005454644,-0.015600014,0.024338165,0.021872183,-0.010332999,0.028331984,0.008965987,0.009019596,-0.00045818338,0.013388671,0.0016903365,0.007411347,-0.014527848,0.00017851981,0.012792279,0.0034979412,-0.015760839,-0.037123743,-0.021161875,0.0022096669,0.00633248,-0.012557743,0.0019282233,-0.00846341,-0.009843823,-0.016270118,0.020960843,-0.0001500404,-0.0073443362,-0.023051566,-0.030503118,-0.015117539,-0.019325789,-0.022408267,0.034014463,-0.020531977,-0.008034543,-0.021403112,-0.032754667,0.0046773236,0.018334037,-0.00918042,-0.01687321,0.019325789,-0.031843327,0.017690737,0.014031971,-0.0072304187,0.030395903,-0.031762913,0.024056721,0.0046639214,-0.010701556,0.0047041276,-0.027501054,-0.007263924,-0.01854847,-0.0044360864,0.01079537,-0.00032814138,0.03082477,-0.01306032,0.0073778415,-0.008175265,0.016243313,-0.016457746,0.011733515,-0.017288676,0.007250522,-0.01661857,0.030101057,-0.007659285,0.013871146,-0.012262898,-0.014045373,0.007150006,-0.015264962,0.015559807,-0.01945981,-0.012591248,-0.020116512,0.008811863,0.008135059,0.010272689,0.027876312,-0.029967036,-0.0052904687,0.0032483276,0.034604155,-0.019902078,0.010882484,0.015251559,0.012510835,-0.008356193,0.00155129,0.022770124,0.015452591,-0.014822694,0.023319608,-0.0044829934,0.013288156,0.002799358,-0.042511377,-0.0009347946,0.017771149,0.012597949,0.006218562,0.013857744,-0.00092390546,0.054734066,-0.0015068956,-0.00021778369,0.0054177884,-0.013033517,0.034791782,-0.0039268075,-0.03369281,0.008362894,0.001370362,0.025102083,-0.0025162392,-0.029591778,0.010574236,-0.017811356,-0.009381452,-0.022207236,0.024780434,-0.0024777083,-0.008322688,0.0037894363,-0.0013494212,0.025182497,0.028278375,0.0030221676,-0.02618765,0.018655686,0.013623208,0.021470122,0.010802072,0.013777331,-0.04511138,-0.02475363,0.01241032,-0.0068350574,-0.044441275,-0.0019500017,-0.0061113453,-0.0064530983,0.019781461,0.0036822197,0.015157745,0.011586092,0.0316557,-0.0017221664,-0.037954673,0.018267026,0.007485058,-0.0010168824,-0.016940221,-0.023681464,-0.0031109564,0.0015923339,0.0010663024,0.008905678,0.04149282,-0.0024391774,-0.00995774,0.0017891768,-0.003575003,0.045915503,0.0068685627,0.0023688164,0.006151552,-0.010272689,0.016310323,-0.034952607,-0.025678372,0.057896957,-0.007840213,0.0062587685,-0.017650532,-0.0119010415,-0.011096917,0.001842785,-0.022247441,-0.004539952,-0.018950531,0.0152381575,0.03251343,0.0043925294,0.00091552915,0.034952607,0.024713423,0.002656961,-0.031789716,0.007082996,0.011981454,0.028492808,0.007920626,-0.015600014,-0.0011919469,-0.026455693,0.02255569,-0.02578559,-0.0154659925,0.004751035,0.018494861,-0.017690737,-0.029162912,0.016377334,-0.02999384,0.008450007,0.022006204,-0.008027842,-0.017797954,0.01111702,-0.020317543,0.0029702345,-0.0043154676,0.0056054173,0.031762913,0.03851756,-0.019660842,0.041385602,-0.0021677853,-0.0015219729,-0.019701049,-0.017422695,-0.00039703643,-0.009488668,0.016940221,-0.018387645,-0.0030925286,0.0029987139,0.022354659,-0.0015278363,0.018213417,0.032754667,0.032030955,-0.0010755163,-0.0091603175,0.004660571,-0.0007429774,0.008329389,0.012718568,-0.01492991,0.0239227,-0.017918572,0.01912476,-0.015130941,-0.0010964571,0.027876312,0.0072036143,0.010413411,-0.0006843434,-0.028734045,-0.03763302,-0.008248976,0.0006382737,-0.009475266,-0.012879392,-0.024083527,-0.019298986,-0.008825266,-0.010326298,-0.021577338,0.022957752,-0.014112383,-0.03109281,-0.03988457,-0.033183534,0.035006214,-0.010869081,0.0072304187,-0.0004979708,-0.040152613,0.0034443329,-0.008577327,-0.012463928,-0.021054657,-0.0055451076,-0.03141446,0.009146915,-0.016189706,0.027420642,-0.008289183,-0.015894858,0.022971153,-0.028144354,-0.004600262,0.00059304177,0.027166003,0.026924765,0.017851561,0.013576301,-0.019500017,-0.042511377,-0.020089708,-0.001822682,0.016069086,-0.030288685,0.012517537,-0.0046170144,0.0058768094,0.013053619,0.0070025832,-0.021577338,-0.017248468,0.013046918,0.02126909,0.0039837663,0.037820652,0.008845368,0.020518575,0.017958779,-0.0024927857,-0.00891908,-0.007290728,0.006600521,0.02307837,0.0063961395,-0.01170001,0.01842785,0.010473721,-0.0024525793,-0.0297258,0.015519601,0.01907115,0.023614453,0.0046873754,0.031843327,-0.019620635,-0.00788712,-0.0018494861,-0.0047979425,-0.020505173,-0.011204134,-0.0065569645,-0.019285584,0.011110319,-0.010413411,0.009153616,-0.023708267,-0.029886624,0.010587638,0.017985582,0.013938156,0.0031561882,0.006553614,-0.008322688,-0.040259827,-0.0034024513,0.0038530962,-0.0011860835,0.02482064,0.02792992,0.024190743,0.04886396,-0.010306194,0.02049177,-0.00085857033,-0.0055953655,0.01531857,0.00066968484,-0.008677842,-2.8557934e-05,0.0035046423,0.013871146,-0.014795889,0.007062893,0.03187013,0.0059974277,0.002449229,-0.013422176,-0.0024827342,-0.024351567,-0.022381462,-0.028171157,0.055162933,-0.0070762946,0.021295894,-0.033719618,-0.003819591,0.0043791276,0.0053038704,0.019942285,0.01260465,0.014889703,-0.001990208,0.00465387,0.0052971696,0.0112175355,-0.007934027,-0.0037827352,-0.037954673,-0.0057159844,0.015667023,0.015734034,0.017797954,-0.019419605,0.014514445,-0.026897961,0.0005775456,-0.024324764,-0.009649493,0.014165992,-0.013294857,-0.0140051665,-0.032433018,-0.040233023,-0.02734023,-0.028787654,0.020612389,0.014809291,0.01771754,-0.013388671,-0.015667023,-0.0018712645,-0.0070695938,0.042028904,-0.011344855,0.020464966,0.0030623737,-0.0042953645,-0.035167042,0.019057749,0.013201042,-0.007840213,0.0063626342,0.01971445,-0.033183534,-0.029511366,0.011371659,-0.0132278465,-0.0032734564,-0.030101057,0.02985982,0.013656713,-0.014795889,-0.004389179,-0.003400776,-0.030797964,0.020759812,-0.009689699,0.01783816,0.018843316,0.0053172726,-0.020049501,0.011787124,0.0025949765,0.029806212,0.018401047,0.009703102,-0.019808264,0.0011525783,-0.0087046465,0.015734034,0.0023587649,0.015492797,-5.067659e-05,-0.010044854,0.007290728,0.0040373746,0.029002087,0.0010738411,-0.0009691374,0.030717552,-0.04680004,-0.012262898,0.018253624,0.0011726815,0.0109427925,-0.0062353145,-0.024994867,-0.017851561,0.019044347,-0.01066135,0.021496926,-0.016631974,-0.0046940763,0.014313415,0.00017234229,0.0006646591,-0.0071165008,-0.0045667565,0.014889703,-0.02605363,-0.016069086,0.008369595,-0.0033622452,0.01396496,-0.0066038715,-0.0007224555,0.009200524,0.019567028,0.007612378,-0.02985982,0.007960832,0.006774748,-0.040849518,0.0068953666,-0.03224539,-0.009274235,0.024204144,-0.0030171417,0.0028847964,-0.021148471,-0.02062579,0.029350542,-0.006372686,-0.008738152,0.013000011,0.01692682,0.019272182,-0.0016735839,-0.008168564,-0.0039569624,0.004972169,-0.00046907258,0.015130941,-0.015197951,0.022059813,-0.032995906,-0.0039871167,-0.019768057,-0.025356723,-0.031334046,-0.018414449,0.0032014202,0.016538158,-0.0027105694,-0.030101057,-0.0057427883,-0.021376306,0.050016537,-0.004020622,0.006004129,0.013294857,0.017891768,0.023668062,0.0055049015,-0.015492797,-0.0043724263,-0.0219794,-0.0023286103,-0.015854653,-0.003826292,-0.019687645,0.03559591,0.024378372,-0.018910326,-0.031360853,0.015104136,-0.04473612,-0.011746917,-0.001770749,0.010607741,0.026026826,0.020397956,-0.0010864056,0.024364969,0.011163927,0.013569599,-0.020277336,0.012329907,-0.035381474,0.0025112135,0.012169083,0.027554663,-0.036614463,-0.007324233,-0.007163408,0.004952066,0.0067445934,0.022770124,-0.010400009,0.0059739742,-0.002546394,0.02358765,0.015251559,0.022247441,0.026294868,-0.037820652,-0.018133005,0.019500017,-0.0031494873,-0.011646402,0.0027809301,0.013482486,-0.007103099,0.010232483,-0.0057695927,0.0023420122,0.0034041267,0.0029065746,0.027326828,0.013154135,-0.015171147,0.014474239,0.0071768104,0.01176032,-0.026469095,-0.003980416,-0.023936104,0.0014616636,0.0059739742,0.008470111,-0.00055953657,-0.020692801,0.016511355,-0.01324795,-0.028224766,0.016189706,0.003005415,-0.011586092,0.0066340263,-0.00037818975,-0.008450007,-0.009475266,-0.02372167,-0.0068752635,-0.02449899,-0.007652584,-0.0032500029,0.015693828,0.002727322,0.020987647,-0.0010654648,-0.03924127,0.0058164997,0.015090735,0.00066800957,0.0106680505,0.16018158,-0.0075252643,0.0041077356,0.02443198,0.0074046454,-0.0024408526,0.012189186,-0.0006139825,-0.012350011,-0.010828875,0.005913665,0.005454644,-0.0022264195,0.005809799,0.021228883,-0.03961653,-0.040635087,-0.027058786,-0.0102123795,-0.0088855745,0.0015638544,-0.014045373,0.0025413681,-0.012772176,-0.002340337,0.005260314,-0.00019726176,0.011740216,0.020330945,0.01912476,-0.0017975532,0.00575284,0.034362916,-0.015171147,-0.0073443362,-0.014313415,0.03937529,0.01396496,0.01208867,0.008282482,0.01964744,-0.023198988,0.006623975,-0.0026586363,0.014889703,0.0132747535,-0.030556727,0.022287648,0.0008862121,-0.0008870497,-0.007518563,-0.00620516,-0.0018411098,0.0029534819,-0.010359802,-0.0033136627,0.02165775,-0.01008506,0.0070561916,0.000248776,-0.0050559323,0.015894858,0.0062085106,0.020062905,-0.009924236,0.0017338933,-0.0024978113,0.035971165,-0.007900522,0.0062286137,0.0020655945,-0.011639701,-0.006701037,-0.010386607,-0.019084552,-0.022662906,0.01958043,0.025289712,-0.0064933044,-0.0073443362,-0.0046069627,-0.020786615,0.003005415,-0.0022012906,-0.035703123,-0.015908262,0.005132994,-0.019741254,-0.018655686,-0.009656194,0.011257742,0.015010322,-0.010353101,-0.024123732,-0.00038719428,-0.002901549,0.013522692,0.030422706,0.008738152,-0.017275272,-0.0277959,0.06615263,0.029162912,-0.015037126,-0.018923728,0.032406215,-0.022997959,0.004382478,0.0052201077,-0.003322039,-0.011525783,-0.034014463,-0.008382997,0.005571912,-0.01848146,0.00045734574,0.043261893,0.00021118736,0.0064162426,-0.0029568325,-0.027246416,-0.00067806116,0.016082488,0.0049420143,0.0053675305,-0.034175288,-0.050954685,0.030449511,-0.019888677,-0.020330945,0.020049501,-0.029564975,0.010433515,-0.0005654,0.0068551605,0.020464966,0.009877328,-0.00022825407,0.0006872751,0.0070561916,0.008818564,-0.026522703,0.019861873,0.01143867,0.0031595388,-0.0029367292,-0.014527848,0.011519082,0.0004971332,-0.012624753,0.0020706204,-0.008912379,-0.0020237132,0.01499692,-0.014380425,-0.010225782,0.0046639214,-0.049534064,0.0061951084,-0.0104402155,-0.056663968,-0.011780422,0.031789716,-0.008456708,-0.015868055,-0.02275672,-0.16790117,-0.001919847,0.01241032,-0.028358787,0.006352583,0.0036688177,0.015600014,-0.027849508,0.0021527081,-0.0012413671,0.0075252643,0.001157604,-0.027447447,-0.01998249,0.017101046,0.010446916,0.017087644,-0.0038631477,0.01460826,0.025343321,0.03916086,-0.04704128,0.0035079927,-0.00087029714,-0.0077665015,-0.0034242298,-0.015613415,0.016779397,0.014085579,-0.03883921,-0.0008011927,-0.01577424,0.043583542,-0.02242167,-0.005079386,0.0019416254,0.025343321,0.0037894363,0.0053038704,0.006242016,0.053420663,0.031200027,-0.0053273244,0.011720113,0.021671154,0.0015772565,0.011096917,-0.02967219,0.005655675,0.00085857033,0.024378372,0.0023319607,0.032942295,-0.00016197663,0.018575273,-0.009997947,-0.00491186,-0.010413411,-0.00090380234,-0.023815485,-0.0087046465,-0.027300024,-0.02701858,-0.017824758,-0.002410698,-0.024887651,-0.021818576,0.013006712,-0.022528885,0.0071366043,-0.0063961395,0.0129263,-0.002281703,0.008181966,0.014715477,0.037284568,-0.03832993,0.011177329,-0.004221653,0.014434033,-0.011565989,0.020706203,-0.0019985843,0.016149499,0.008295883,-0.0020404656,0.018829914,0.00025547703,-0.042243335,0.0017824757,0.015680427,-0.028841263,-0.030047448,0.024914455,0.020505173,0.0080613475,-0.0032014202,0.007833512,0.017395891,-0.016658777,0.020987647,-0.005340726,-0.017235067,-0.0070025832,0.02468662,0.010936092,-0.020277336,-0.01072836,0.043985605,-0.0046840245,-0.014165992,-0.001377063,0.017235067,0.018655686,-0.010265988,0.021309298,-0.003400776,0.0016811226,0.029457757,0.013469084,0.02159074,0.0077396976,-0.0021744864,0.024606207,0.0042752614,0.0055183037,-0.09965782,-0.019540222,0.022448473,0.016900014,-0.032486625,0.0012363413,0.0029635334,0.023815485,-0.03219178,0.017275272,-0.020840224,-0.057896957,-0.00801444,0.02862683,-0.01499692,-0.0021979401,-0.017570117,0.005531706,-0.017529912,0.02404332,0.008764956,-0.009850524,-0.0067378925,0.0017355685,-0.01582785,0.025557755,0.012249495,0.008671141,0.008744853,0.00646315,0.005541757,0.0011743567,0.009106709,-0.017650532,-0.030422706,-0.032406215,-0.0132747535,-0.00530052,0.004576808,-0.025423734,-0.011472175,-0.021175276,-0.0023537392,0.010386607,-0.0132278465,-0.01783816,-0.017288676,0.011720113,0.00472088,-0.019151563,-0.008945884,-0.006845109,-0.011137123,0.0027809301,0.026469095,0.020317543,-0.0024341515,0.004751035,0.002030414,0.023681464,-0.03755261,0.025959816,-0.014487641,0.005253613,0.0036621166,0.010721658,-0.010031452,-0.029779406,-0.007317532,-0.013462382,-0.0017221664,0.0106211435,-0.008248976,0.009381452,-0.0035079927,0.01376393,-0.009703102,-0.028707242,0.031468067,-0.020371152,-0.004563406,-0.019768057,0.010265988,-0.037364982,0.0044762925,0.0012966506,-0.000933957,-0.010359802,0.0045868596,-0.050525818,-0.022475278,-0.0007241308,0.015720632,-0.022073215,-0.02404332,0.0070561916,-0.015492797,-0.023145381,0.02669693,0.0258526,-0.039589725,-0.0101185655,-0.05358149,0.014125786,0.009394853,0.010641246,-0.022046411,-0.054171182,0.02081342,-0.00459021,-0.0014348595,-0.00407088,0.017369088,0.010741762,-0.003581704,0.0010369854,-0.014152589,0.0011936221,0.019205172,0.0090464,0.007451553,0.017637128,-0.025383526,0.0033655956,-0.015988674,0.03535467,0.0020739709,0.0066675316,-0.0020990998,0.023279402,-0.017663933,-0.0008577327,0.016712386,-0.03658766,-0.020129913,0.00982372,0.0043657254,-0.0036922712,0.016846405,0.013717022,0.031789716,0.0037525806,-0.020277336,-0.032138173,0.023989711,0.0067881504,-0.0014030295,-0.0016149499,0.007150006,0.01079537,0.029591778,0.0051564476,0.00053692056,-0.0014666894,-0.005508252,-0.03599797,0.0017372437,-0.009783514,0.011284546,0.0062755207,0.012001556,0.0036889208,0.044870142,0.0053574787,0.016337128,-0.020250533,0.010346401,-0.023627855,-0.030503118,-0.002184538,0.01687321,-0.014702074,-0.01609589,0.005253613,0.007491759,0.0054378915,0.00072664366,0.012812383,0.015988674,-0.005411087,0.0036788692,0.009542276,0.016484551,-0.01460826,-0.000850194,0.022743318,0.0426454,0.03535467,-0.020451564,0.005990727,-0.0044762925,-0.0056724274,0.009394853,0.018856717,-0.004221653,0.0092541315,0.029591778,0.0040775808,-0.0060845413,0.021684555,0.031521678,0.032486625,0.012852589,0.004499746,-0.03200415,-0.01344228,-0.032218583,-0.009508771,-0.013690218,-0.01111702,0.0064530983,0.012785578,0.008409801,-0.009522174,-0.014956714,-0.013053619,-0.003219848,0.011572691,0.012068567,-0.017918572,-0.024070123,0.017462902,-0.005421139,0.008972689,0.032433018,-0.00019600532,0.041385602,0.015760839,0.0048046433,-0.008684544,0.030074252,-0.012309805,-0.0033840234,-0.0092541315,-0.020196924,0.0024241,0.0069891815,-0.014246404,-0.025463939,0.01958043,0.0153721785,0.08164543,0.034899,-0.0011433644,-0.0059940773,-0.024673218,-2.3741564e-05,0.0200361,0.0051296437,-0.014675271,-0.02578559,0.017690737,0.017422695,-0.02218043,-0.02889487,0.010788669,0.00472088,-0.0053038704,-0.001680285,-0.012912897,0.0063056755,0.020116512,-0.00459021,0.028868066,0.021255689,-0.028278375,-0.009997947,0.009167018,-0.0040675295,-0.018374242,-0.024780434,0.008135059,0.010232483,-0.040635087,-0.0141391875,0.00024563487,-0.0040373746,-0.014728879,-0.016203107,0.018896924,0.017998984,0.019406203,0.0055350563,-0.024364969,-0.018910326,-0.008483512,0.0018327335,-0.014970116,-0.039187662,-0.022394864]', 'storing-embeddings-in-postgres', 'Storing Embeddings in Postgres');

--
-- PostgreSQL database dump complete
--