---
title: The Future of Rallly
date: "2023-06-18"
excerpt: Rallly has always been about simplifying group scheduling, but my aim is to evolve it into more than just a polling platform.
---

Rallly has always been about simplifying group scheduling, but my aim is to evolve it into more than just a polling platform. I'm looking to create a unique, flexible, and familiar workflow that will assist users in finding the perfect date for their event.

## The Workflow

Envisioned as a three-component funnel, this new workflow is designed to simplify and streamline your scheduling process.

![funnel](/static/images/the-future-of-rallly/funnel.svg)

## Breaking it Down

Here's how these components will work together:

### Availability Grids

When you're scheduling an event, getting a general idea of participants' availability can be incredibly helpful. The Availability Grid will let users select a broad range, and participants can then highlight areas on the grid to indicate when they are available. This will give hosts a quick snapshot of potential suitable time slots.

![Availability Grids](/static/images/the-future-of-rallly/availability-grid.svg)

### Polls

Polling is at the core of what Rallly does, and it fits seamlessly into this new workflow. Once you've gathered general availability, hosts will be able to narrow down a few options and let participants vote for their preferred dates.

![Polls](/static/images/the-future-of-rallly/poll.svg)

### RSVP

After you've narrowed down to a single date through polling, the RSVP component will come into play. This page will let participants confirm their attendance and access detailed information about your event.

![RSVP](/static/images/the-future-of-rallly/rsvp.svg)

## Tying it Together

The above components will follow this order: Availability Grid -> Poll -> RSVP. However, the beauty of this workflow is its flexibility. You can start from any part of the workflow that fits your needs. For example, you might start with an Availability Grid, select a few options to create a poll, and finish with an RSVP. Alternatively, you could select a single option from an Availability Grid to create an RSVP, or you might prefer to start directly with a poll or RSVP.

## Conclusion

I am incredibly excited to start working on this enhanced workflow for Rallly. As always, your feedback is invaluable to me. Let me know if you think this workflow could be useful or if you have any suggestions for improvement. I'm looking forward to continuing to shape Rallly into a tool that makes scheduling easy and efficient for everyone.
