# Contributing Guide

Contributions are welcome from anyone who is interested in improving this project and there are multiple ways in which you can contribute.

## Code 🧑‍💻

Have a look at the [open issues](https://github.com/lukevella/rallly/issues) and look for issues that are labeled with `help wanted` or `good first issue`. If you find an issue that you would like to work on, please leave a comment on the issue to let us know.

If there isn't an issue for the work that you would like to contribute, start by opening a [discussion](https://github.com/lukevella/rallly/discussions/new/choose) to discuss the changes that you would like to make.

In order to maintain a high standard of code quality, please ensure that you are familiar with the technology stack used in this project where it applies to your code. The technology stack used in this project is:

- [TypeScript](https://www.typescriptlang.org/)
- [React](https://reactjs.org/)
- [Next.js](https://nextjs.org/)
- [Tailwind CSS](https://tailwindcss.com/)
- [tRPC](https://trpc.io/)
- [Prisma](https://www.prisma.io/)

## Translations 🌐

To contribute translations, please check out our [guide for translators](https://support.rallly.co/contribute/translations) which contains all the information you need to get started.

## Becoming a Sponsor 💰

If you find this project useful and would like to contribute financially on an ongoing basis, please consider becoming a sponsor. Sponsors help us cover the costs of hosting, development, and maintenance, and enable us to continue working on the project.

To become a sponsor, visit our [sponsor page](https://github.com/sponsors/lukevella) and select the sponsorship level that works for you.

Donations are also accepted through [PayPal](http://paypal.me/ralllyco).

## Documentation

To contribute documentation please check out the [contributing guide](https://support.rallly.co/contribute/documentation) which contains all the information you need to get started.

## Code of Conduct 👮‍♀️

Please note that this project is released with a [Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project, you agree to abide by its terms.

## License 👩‍⚖️

By contributing to this project, you agree that your contributions will be licensed under the [AGPL-3.0 license](LICENSE).

Thank you for your interest in contributing to this project!
