<!-- markdownlint-disable -->
<h1 align="center">
    Best-of React Web
    <br>
</h1>

<p align="center">
    <strong>🏆&nbsp; A ranked list of awesome React open-source libraries and tools. Updated weekly.</strong>
</p>

<p align="center">
    <a href="https://best-of.org" title="Best-of Badge"><img src="http://bit.ly/3o3EHNN"></a>
    <a href="#Contents" title="Project Count"><img src="https://img.shields.io/badge/projects-430-blue.svg?color=5ac4bf"></a>
    <a href="#Contribution" title="Contributions are welcome"><img src="https://img.shields.io/badge/contributions-welcome-green.svg"></a>
    <a href="https://github.com/LukasMasuch/best-of-react/releases" title="Best-of Updates"><img src="https://img.shields.io/github/release-date/LukasMasuch/best-of-react?color=green&label=updated"></a>
</p>

This curated list contains 430 awesome open-source projects with a total of 5M stars grouped into 22 categories. All projects are ranked by a project-quality score, which is calculated based on various metrics automatically collected from GitHub and different package managers. If you like to add or update projects, feel free to open an [issue](https://github.com/LukasMasuch/best-of-react/issues/new/choose), submit a [pull request](https://github.com/LukasMasuch/best-of-react/pulls), or directly edit the [projects.yaml](https://github.com/LukasMasuch/best-of-react/edit/main/projects.yaml). Contributions are very welcome!

> 🧙‍♂️  Discover other [best-of lists](https://best-of.org) or [create your own](https://github.com/best-of-lists/best-of/blob/main/create-best-of-list.md).

## Contents

- [UI Frameworks & Libraries](#ui-frameworks--libraries) _47 projects_
- [App Frameworks](#app-frameworks) _6 projects_
- [Styling](#styling) _16 projects_
- [Layout](#layout) _11 projects_
- [Data Tables & Grids](#data-tables--grids) _39 projects_
- [Input Components](#input-components) _24 projects_
- [Internationalization & Localization](#internationalization--localization) _4 projects_
- [State Management](#state-management) _31 projects_
- [Routing](#routing) _12 projects_
- [Animations](#animations) _12 projects_
- [Data Visualization](#data-visualization) _37 projects_
- [Data Fetching](#data-fetching) _7 projects_
- [Notifications](#notifications) _9 projects_
- [File Handling](#file-handling) _10 projects_
- [Editor Components](#editor-components) _41 projects_
- [Drag & Drop](#drag--drop) _12 projects_
- [Developer Tools](#developer-tools) _31 projects_
- [Desktop Applications](#desktop-applications) _2 projects_
- [Utilities](#utilities) _8 projects_
- [Testing](#testing) _6 projects_
- [Admin Dashboards](#admin-dashboards) _11 projects_
- [Other Components](#other-components) _38 projects_
- [Others](#others) _17 projects_

## Explanation
- 🥇🥈🥉&nbsp; Combined project-quality score
- ⭐️&nbsp; Star count from GitHub
- 🐣&nbsp; New project _(less than 6 months old)_
- 💤&nbsp; Inactive project _(6 months no activity)_
- 💀&nbsp; Dead project _(12 months no activity)_
- 📈📉&nbsp; Project is trending up or down
- ➕&nbsp; Project was recently added
- ❗️&nbsp; Warning _(e.g. missing/risky license)_
- 👨‍💻&nbsp; Contributors count from GitHub
- 🔀&nbsp; Fork count from GitHub
- 📋&nbsp; Issue count from GitHub
- ⏱️&nbsp; Last update timestamp on package manager
- 📥&nbsp; Download count from package manager
- 📦&nbsp; Number of dependent projects
- <img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13">&nbsp; Projects related to Material UI Framework.
- <img src="https://gw.alipayobjects.com/zos/rmsportal/KDpgvguMpGfqaHPjicRK.svg" style="display:inline;" width="13" height="13">&nbsp; Projects related to Ant Design Framework.
- <img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13">&nbsp; Projects related to Bootstrap UI Framework.

<br>

## UI Frameworks & Libraries

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/mui/material-ui">Material-UI</a></b> (🥇52 ·  ⭐ 92K) - MaterialUI: Ready-to-use foundational React components, free.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/mui/material-ui) (👨‍💻 3.2K · 🔀 32K · 📦 1.2M · 📋 19K - 8% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/mui-org/material-ui
	```
- [npm](https://www.npmjs.com/package/@material-ui/core) (📥 6M / month · 📦 14K · ⏱️ 03.04.2022):
	```
	npm install @material-ui/core
	```
</details>
<details><summary><b><a href="https://github.com/ant-design/ant-design">Ant Design</a></b> (🥇51 ·  ⭐ 91K) - An enterprise-class UI design language and React UI library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://gw.alipayobjects.com/zos/rmsportal/KDpgvguMpGfqaHPjicRK.svg" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/ant-design/ant-design) (👨‍💻 2.4K · 🔀 47K · 📥 11K · 📦 630K · 📋 30K - 3% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/ant-design/ant-design
	```
- [npm](https://www.npmjs.com/package/antd) (📥 6.4M / month · 📦 39K · ⏱️ 03.06.2024):
	```
	npm install antd
	```
</details>
<details><summary><b><a href="https://github.com/react-bootstrap/react-bootstrap">Bootstrap React</a></b> (🥇45 ·  ⭐ 22K) - Bootstrap components built with React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/react-bootstrap/react-bootstrap) (👨‍💻 530 · 🔀 3.6K · 📥 51K · 📦 1.6M · 📋 3.6K - 5% open · ⏱️ 23.05.2024):

	```
	git clone https://github.com/react-bootstrap/react-bootstrap
	```
- [npm](https://www.npmjs.com/package/react-bootstrap) (📥 5.2M / month · 📦 7.9K · ⏱️ 18.03.2024):
	```
	npm install react-bootstrap
	```
</details>
<details><summary><b><a href="https://github.com/jgthms/bulma">bulma</a></b> (🥇43 ·  ⭐ 49K) - Modern CSS framework based on Flexbox. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jgthms/bulma) (👨‍💻 420 · 🔀 3.9K · 📥 800K · 📦 250K · 📋 2.8K - 15% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/jgthms/bulma
	```
- [npm](https://www.npmjs.com/package/bulma) (📥 1M / month · 📦 2.5K · ⏱️ 20.05.2024):
	```
	npm install bulma
	```
</details>
<details><summary><b><a href="https://github.com/microsoft/fluentui">fluentui</a></b> (🥇43 ·  ⭐ 18K) - Fluent UI web represents a collection of utilities, React components, and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/microsoft/fluentui) (👨‍💻 890 · 🔀 2.7K · 📦 14K · 📋 13K - 4% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/microsoft/fluentui
	```
- [npm](https://www.npmjs.com/package/@fluentui/react) (📥 790K / month · 📦 430 · ⏱️ 28.05.2024):
	```
	npm install @fluentui/react
	```
</details>
<details><summary><b><a href="https://github.com/palantir/blueprint">Blueprint</a></b> (🥈41 ·  ⭐ 20K) - A React-based UI toolkit for the web. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/palantir/blueprint) (👨‍💻 400 · 🔀 2.1K · 📦 17K · 📋 3.1K - 22% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/palantir/blueprint
	```
- [npm](https://www.npmjs.com/package/@blueprintjs/core) (📥 750K / month · 📦 610 · ⏱️ 15.05.2024):
	```
	npm install @blueprintjs/core
	```
</details>
<details><summary><b><a href="https://github.com/primefaces/primereact">primereact</a></b> (🥈41 ·  ⭐ 6K) - The Most Complete React UI Component Library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/primefaces/primereact) (👨‍💻 280 · 🔀 940 · 📦 33K · 📋 4.6K - 5% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/primefaces/primereact
	```
- [npm](https://www.npmjs.com/package/primereact) (📥 610K / month · 📦 450 · ⏱️ 24.05.2024):
	```
	npm install primereact
	```
</details>
<details><summary><b><a href="https://github.com/ant-design/ant-design-mobile">ant-design-mobile</a></b> (🥈40 ·  ⭐ 11K) - Essential UI blocks for building mobile web apps. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ant-design/ant-design-mobile) (👨‍💻 300 · 🔀 2.4K · 📦 26K · 📋 4.4K - 4% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/ant-design/ant-design-mobile
	```
- [npm](https://www.npmjs.com/package/antd-mobile) (📥 220K / month · 📦 1.1K · ⏱️ 27.05.2024):
	```
	npm install antd-mobile
	```
</details>
<details><summary><b><a href="https://github.com/reactstrap/reactstrap">reactstrap</a></b> (🥈40 ·  ⭐ 11K) - Simple React Bootstrap 5 components. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reactstrap/reactstrap) (👨‍💻 270 · 🔀 1.3K · 📦 390K · 📋 1.3K - 22% open · ⏱️ 30.04.2024):

	```
	git clone https://github.com/reactstrap/reactstrap
	```
- [npm](https://www.npmjs.com/package/reactstrap) (📥 2M / month · 📦 2.6K · ⏱️ 08.11.2023):
	```
	npm install reactstrap
	```
</details>
<details><summary><b><a href="https://github.com/carbon-design-system/carbon">carbon</a></b> (🥈40 ·  ⭐ 7.5K) - A design system built by IBM. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/carbon-design-system/carbon) (👨‍💻 510 · 🔀 1.8K · 📥 3 · 📦 7.3K · 📋 8.2K - 7% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/carbon-design-system/carbon
	```
- [npm](https://www.npmjs.com/package/carbon-components-react) (📥 150K / month · 📦 270 · ⏱️ 05.06.2024):
	```
	npm install carbon-components-react
	```
</details>
<details><summary><b><a href="https://github.com/Shopify/polaris">polaris-react</a></b> (🥈40 ·  ⭐ 5.7K) - Shopifys design system to help us work together to build a great.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Shopify/polaris) (👨‍💻 520 · 🔀 1.2K · 📦 10K · 📋 4.7K - 4% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/Shopify/polaris-react
	```
- [npm](https://www.npmjs.com/package/@shopify/polaris) (📥 540K / month · 📦 130 · ⏱️ 24.05.2024):
	```
	npm install @shopify/polaris
	```
</details>
<details><summary><b><a href="https://github.com/chakra-ui/chakra-ui">chakra-ui</a></b> (🥈39 ·  ⭐ 37K) - Simple, Modular & Accessible UI Components for your React Applications. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/chakra-ui/chakra-ui) (👨‍💻 660 · 🔀 3.2K · 📦 300K · 📋 3.6K - 7% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/chakra-ui/chakra-ui
	```
- [npm](https://www.npmjs.com/package/chakra-ui) (📥 3.7K / month · 📦 8 · ⏱️ 03.08.2019):
	```
	npm install chakra-ui
	```
</details>
<details><summary><b><a href="https://github.com/Semantic-Org/Semantic-UI-React">Semantic UI React</a></b> (🥈39 ·  ⭐ 13K) - The official Semantic-UI-React integration. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Semantic-Org/Semantic-UI-React) (👨‍💻 330 · 🔀 4K · 📦 190K · 📋 2.6K - 7% open · ⏱️ 19.03.2024):

	```
	git clone https://github.com/Semantic-Org/Semantic-UI-React
	```
- [npm](https://www.npmjs.com/package/semantic-ui-react) (📥 1.1M / month · 📦 1.9K · ⏱️ 30.12.2023):
	```
	npm install semantic-ui-react
	```
</details>
<details><summary><b><a href="https://github.com/adobe/react-spectrum">react-spectrum</a></b> (🥈38 ·  ⭐ 12K) - A collection of libraries and tools that help you build.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/adobe/react-spectrum) (👨‍💻 340 · 🔀 1K · 📦 2.1K · 📋 2.3K - 30% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/adobe/react-spectrum
	```
- [npm](https://www.npmjs.com/package/react-aria) (📥 2M / month · 📦 510 · ⏱️ 05.06.2024):
	```
	npm install react-aria
	```
</details>
<details><summary><b><a href="https://github.com/grommet/grommet">Grommet</a></b> (🥈38 ·  ⭐ 8.3K) - a react-based framework that provides accessibility, modularity,.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/grommet/grommet) (👨‍💻 380 · 🔀 1K · 📥 2.3K · 📦 10K · 📋 3.4K - 9% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/grommet/grommet
	```
- [npm](https://www.npmjs.com/package/grommet) (📥 120K / month · 📦 230 · ⏱️ 28.05.2024):
	```
	npm install grommet
	```
</details>
<details><summary><b><a href="https://github.com/rsuite/rsuite">React Suite</a></b> (🥈37 ·  ⭐ 8.2K) - A suite of React components . <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/rsuite/rsuite) (👨‍💻 120 · 🔀 920 · 📦 19K · 📋 1.1K - 20% open · ⏱️ 31.05.2024):

	```
	git clone https://github.com/rsuite/rsuite
	```
- [npm](https://www.npmjs.com/package/rsuite) (📥 390K / month · 📦 280 · ⏱️ 30.05.2024):
	```
	npm install rsuite
	```
</details>
<details><summary><b><a href="https://github.com/ariakit/ariakit">reakit</a></b> (🥈35 ·  ⭐ 7.7K) - Toolkit for building accessible web apps with React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ariakit/ariakit) (👨‍💻 120 · 🔀 370 · 📦 1.8K · 📋 610 - 14% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/reakit/reakit
	```
- [npm](https://www.npmjs.com/package/reakit) (📥 500K / month · 📦 240 · ⏱️ 18.11.2021):
	```
	npm install reakit
	```
</details>
<details><summary><b><a href="https://github.com/system-ui/theme-ui">theme-ui</a></b> (🥈35 ·  ⭐ 5.2K) - Build consistent, themeable React apps based on constraint-based design.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/system-ui/theme-ui) (👨‍💻 160 · 🔀 670 · 📦 37K · 📋 680 - 9% open · ⏱️ 10.04.2024):

	```
	git clone https://github.com/system-ui/theme-ui
	```
- [npm](https://www.npmjs.com/package/theme-ui) (📥 260K / month · 📦 1.3K · ⏱️ 19.02.2024):
	```
	npm install theme-ui
	```
</details>
<details><summary><b><a href="https://github.com/tailwindlabs/headlessui">headlessui</a></b> (🥉34 ·  ⭐ 25K) - Completely unstyled, fully accessible UI components, designed to.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/tailwindlabs/headlessui) (👨‍💻 62 · 🔀 1K · 📦 3.7K · 📋 1.2K - 1% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/tailwindlabs/headlessui
	```
- [npm](https://www.npmjs.com/package/headlessui) (📥 29K / month · 📦 6 · ⏱️ 13.09.2020):
	```
	npm install headlessui
	```
</details>
<details><summary><b><a href="https://github.com/DouyinFE/semi-design">semi-design</a></b> (🥉34 ·  ⭐ 8K) - A modern, comprehensive, flexible design system and React UI library... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/DouyinFE/semi-design) (👨‍💻 130 · 🔀 680 · 📦 1.2K · 📋 1K - 15% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/DouyinFE/semi-design
	```
- [npm](https://www.npmjs.com/package/@douyinfe/semi-animation-react) (📥 11K / month · 📦 9 · ⏱️ 04.06.2024):
	```
	npm install @douyinfe/semi-animation-react
	```
</details>
<details><summary><b><a href="https://github.com/primer/react">components</a></b> (🥉34 ·  ⭐ 3K) - An implementation of GitHubs Primer Design System using React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/primer/react) (👨‍💻 390 · 🔀 510 · 📦 3.2K · 📋 930 - 11% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/primer/react
	```
- [npm](https://www.npmjs.com/package/@primer/components) (📥 24K / month · 📦 40 · ⏱️ 30.06.2022):
	```
	npm install @primer/components
	```
</details>
<details><summary><b><a href="https://github.com/mantinedev/mantine">mantine</a></b> (🥉32 ·  ⭐ 25K) - A fully featured React components library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mantinedev/mantine) (👨‍💻 520 · 🔀 1.8K · 📦 1 · 📋 2.5K - 1% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/mantinedev/mantine
	```
- [npm](https://www.npmjs.com/package/@mantine/tag-picker) (📥 47 / month · 📦 5 · ⏱️ 30.07.2021):
	```
	npm install @mantine/tag-picker
	```
</details>
<details><summary><b><a href="https://github.com/pinterest/gestalt">gestalt</a></b> (🥉32 ·  ⭐ 4.2K) - A set of React UI components that supports Pinterests design language. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/pinterest/gestalt) (👨‍💻 130 · 🔀 340 · 📦 850 · ⏱️ 05.06.2024):

	```
	git clone https://github.com/pinterest/gestalt
	```
- [npm](https://www.npmjs.com/package/gestalt) (📥 21K / month · 📦 20 · ⏱️ 04.06.2024):
	```
	npm install gestalt
	```
</details>
<details><summary><b><a href="https://github.com/JetBrains/ring-ui">ring-ui</a></b> (🥉32 ·  ⭐ 3.6K) - A collection of JetBrains Web UI components. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/JetBrains/ring-ui) (👨‍💻 180 · 🔀 180 · 📦 76 · ⏱️ 06.06.2024):

	```
	git clone https://github.com/JetBrains/ring-ui
	```
- [npm](https://www.npmjs.com/package/@jetbrains/ring-ui) (📥 18K / month · 📦 66 · ⏱️ 05.06.2024):
	```
	npm install @jetbrains/ring-ui
	```
</details>
<details><summary><b><a href="https://github.com/tabler/tabler">tabler</a></b> (🥉31 ·  ⭐ 37K) - Tabler is free and open-source HTML Dashboard UI Kit built on Bootstrap. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/tabler/tabler) (👨‍💻 120 · 🔀 3.8K · 📦 1.2K · 📋 900 - 8% open · ⏱️ 30.04.2024):

	```
	git clone https://github.com/tabler/tabler
	```
- [npm](https://www.npmjs.com/package/tabler) (📥 900 / month · 📦 12 · ⏱️ 09.11.2020):
	```
	npm install tabler
	```
</details>
<details><summary><b><a href="https://github.com/coreui/coreui-react">coreui-react</a></b> (🥉31 ·  ⭐ 650) - CoreUI React.js UI Components. CoreUI for React.js replaces and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/coreui/coreui-react) (👨‍💻 12 · 🔀 260 · 📦 20K · 📋 290 - 2% open · ⏱️ 27.05.2024):

	```
	git clone https://github.com/coreui/coreui-react
	```
- [npm](https://www.npmjs.com/package/@coreui/react) (📥 260K / month · 📦 93 · ⏱️ 27.05.2024):
	```
	npm install @coreui/react
	```
</details>
<details><summary><b><a href="https://github.com/kiwicom/orbit">orbit</a></b> (🥉30 ·  ⭐ 1.4K) - React components of open-source Orbit design system by Kiwi.com. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/kiwicom/orbit) (👨‍💻 88 · 🔀 150 · 📦 72 · 📋 400 - 7% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/kiwicom/orbit
	```
- [npm](https://www.npmjs.com/package/@kiwicom/orbit-components) (📥 30K / month · 📦 37 · ⏱️ 31.05.2024):
	```
	npm install @kiwicom/orbit-components
	```
</details>
<details><summary><b><a href="https://github.com/couds/react-bulma-components">react-bulma-components</a></b> (🥉30 ·  ⭐ 1.2K) - React components for Bulma framework. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/couds/react-bulma-components) (👨‍💻 62 · 🔀 130 · 📦 4.8K · 📋 250 - 14% open · ⏱️ 26.01.2024):

	```
	git clone https://github.com/couds/react-bulma-components
	```
- [npm](https://www.npmjs.com/package/react-bulma-components) (📥 110K / month · 📦 140 · ⏱️ 04.02.2022):
	```
	npm install react-bulma-components
	```
</details>
<details><summary><b><a href="https://github.com/radix-ui/primitives">Radix Primitives</a></b> (🥉29 ·  ⭐ 15K) - Radix Primitives is an open-source UI component library for.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/radix-ui/primitives) (👨‍💻 44 · 🔀 700 · 📋 1.4K - 30% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/radix-ui/primitives
	```
- [npm](https://www.npmjs.com/package/@radix-ui/utils) (📥 23K / month · 📦 38 · ⏱️ 27.01.2021):
	```
	npm install @radix-ui/utils
	```
</details>
<details><summary><b><a href="https://github.com/segmentio/evergreen">Evergreen</a></b> (🥉28 ·  ⭐ 12K · 💤) - Evergreen React UI Framework by Segment. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/segmentio/evergreen) (👨‍💻 160 · 🔀 830 · 📦 3 · 📋 540 - 14% open · ⏱️ 21.06.2023):

	```
	git clone https://github.com/segmentio/evergreen
	```
- [npm](https://www.npmjs.com/package/evergreen-ui) (📥 41K / month · 📦 140 · ⏱️ 21.06.2023):
	```
	npm install evergreen-ui
	```
</details>
<details><summary><b><a href="https://github.com/uber/baseweb">baseweb</a></b> (🥉28 ·  ⭐ 8.6K) - A React Component library implementing the Base design language. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uber/baseweb) (👨‍💻 250 · 🔀 830 · 📦 3 · ⏱️ 20.03.2024):

	```
	git clone https://github.com/uber/baseweb
	```
- [npm](https://www.npmjs.com/package/baseui) (📥 150K / month · 📦 110 · ⏱️ 20.03.2024):
	```
	npm install baseui
	```
</details>
<details><summary><b><a href="https://github.com/sheinsight/shineout">shineout</a></b> (🥉26 ·  ⭐ 910) - React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/sheinsight/shineout) (👨‍💻 45 · 🔀 150 · 📋 130 - 31% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/sheinsight/shineout
	```
- [npm](https://www.npmjs.com/package/shineout) (📥 9.8K / month · 📦 20 · ⏱️ 03.06.2024):
	```
	npm install shineout
	```
</details>
<details><summary><b><a href="https://github.com/alibaba/ChatUI">ChatUI</a></b> (🥉24 ·  ⭐ 2.5K · 💤) - The UI design language and React library for Conversational UI. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/alibaba/ChatUI) (👨‍💻 6 · 🔀 270 · 📦 350 · 📋 110 - 27% open · ⏱️ 05.07.2023):

	```
	git clone https://github.com/alibaba/ChatUI
	```
- [npm](https://www.npmjs.com/package/@chatui/core) (📥 4.4K / month · 📦 14 · ⏱️ 23.11.2023):
	```
	npm install @chatui/core
	```
</details>
<details><summary><b><a href="https://github.com/pivotal-cf/pivotal-ui">pivotal-ui</a></b> (🥉24 ·  ⭐ 640) - Pivotals design system & component library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/pivotal-cf/pivotal-ui) (👨‍💻 170 · 🔀 93 · 📥 510 · 📦 180 · 📋 330 - 18% open · ⏱️ 15.05.2024):

	```
	git clone https://github.com/pivotal-cf/pivotal-ui
	```
- [npm](https://www.npmjs.com/package/@npmcorp/pui-react-helpers) (📥 43 / month · 📦 25 · ⏱️ 20.07.2016):
	```
	npm install @npmcorp/pui-react-helpers
	```
</details>
<details><summary><b><a href="https://github.com/proksh/atomize">atomize</a></b> (🥉22 ·  ⭐ 1.7K · 💤) - Design System for developers build on styled-components & React JS. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/proksh/atomize) (👨‍💻 12 · 🔀 330 · 📦 630 · 📋 48 - 58% open · ⏱️ 19.10.2023):

	```
	git clone https://github.com/proksh/atomize
	```
- [npm](https://www.npmjs.com/package/atomize) (📥 2.1K / month · 📦 13 · ⏱️ 14.06.2021):
	```
	npm install atomize
	```
</details>
<details><summary><b><a href="https://github.com/march08/dashboard-ui-kit">dashboard-ui-kit</a></b> (🥉17 ·  ⭐ 200) - React UI components for rapid development. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/march08/dashboard-ui-kit) (👨‍💻 1 · 🔀 30 · 📦 43 · 📋 34 - 70% open · ⏱️ 23.01.2024):

	```
	git clone https://github.com/march08/dashboard-ui-kit
	```
- [npm](https://www.npmjs.com/package/@duik/it) (📥 220 / month · 📦 3 · ⏱️ 14.05.2020):
	```
	npm install @duik/it
	```
</details>
<details><summary>Show 11 hidden projects...</summary>

- <b><a href="https://github.com/elastic/eui">eui</a></b> (🥈38 ·  ⭐ 6K) - Elastic UI Framework. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/Semantic-Org/Semantic-UI">Semantic-UI</a></b> (🥈36 ·  ⭐ 51K · 💀) - Semantic is a UI component framework based around useful.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/rebassjs/rebass">Rebass</a></b> (🥉32 ·  ⭐ 7.9K · 💀) - React primitive UI components built with styled-system. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/tabler/tabler-react">tabler-react</a></b> (🥉27 ·  ⭐ 2.3K · 💀) - React components and demo for the Tabler UI theme. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/supabase/ui">Supabase UI</a></b> (🥉27 ·  ⭐ 1.5K · 💀) - Supabase UI Library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/digiaonline/react-foundation">react-foundation</a></b> (🥉25 ·  ⭐ 600 · 💀) - Foundation as React components. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/geist-org/geist-ui">geist-ui</a></b> (🥉24 ·  ⭐ 4.2K · 💀) - A design system for building modern websites and applications. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/jxom/bumbag-ui">bumbag-ui</a></b> (🥉21 ·  ⭐ 1K · 💀) - Build themeable React & React Native applications with your Bumbag. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/fibo/trunx">trunx</a></b> (🥉21 ·  ⭐ 64) - Super Saiyan React components, son of awesome Bulma. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/DesignRevision/shards-react">shards-react</a></b> (🥉19 ·  ⭐ 760 · 💀) - A beautiful and modern React design system. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/fluent-org/fluent-windows">fluent-windows</a></b> (🥉13 ·  ⭐ 120 · 💀) - React components that inspired by Microsofts Fluent Design.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## App Frameworks

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Application frameworks, content management systems, and static site generators for React._

<details><summary><b><a href="https://github.com/vercel/next.js">Next.js</a></b> (🥇55 ·  ⭐ 120K) - The React Framework. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/vercel/next.js) (👨‍💻 3.5K · 🔀 26K · 📦 3M · 📋 21K - 15% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/vercel/next.js
	```
- [npm](https://www.npmjs.com/package/next) (📥 28M / month · 📦 130K · ⏱️ 02.06.2024):
	```
	npm install next
	```
</details>
<details><summary><b><a href="https://github.com/gatsbyjs/gatsby">Gatsby</a></b> (🥈46 ·  ⭐ 55K) - The best React-based framework with performance, scalability and security.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/gatsbyjs/gatsby) (👨‍💻 4.4K · 🔀 10K · 📦 250K · 📋 14K - 2% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/gatsbyjs/gatsby
	```
- [npm](https://www.npmjs.com/package/gatsby) (📥 1.4M / month · 📦 3.5K · ⏱️ 04.06.2024):
	```
	npm install gatsby
	```
</details>
<details><summary><b><a href="https://github.com/cube-js/cube">cube.js</a></b> (🥈41 ·  ⭐ 17K) - Cube The Semantic Layer for Building Data Applications. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/cube-js/cube) (👨‍💻 310 · 🔀 1.7K · 📥 330K · 📦 1.8K · 📋 2.2K - 26% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/cube-js/cube.js
	```
- [npm](https://www.npmjs.com/package/@cubejs-backend/api-gateway) (📥 74K / month · 📦 20 · ⏱️ 05.06.2024):
	```
	npm install @cubejs-backend/api-gateway
	```
</details>
<details><summary><b><a href="https://github.com/umijs/umi">umi</a></b> (🥈41 ·  ⭐ 15K) - A framework in react community. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/umijs/umi) (👨‍💻 490 · 🔀 2.6K · 📦 37K · 📋 6.7K - 2% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/umijs/umi
	```
- [npm](https://www.npmjs.com/package/umi) (📥 150K / month · 📦 1.6K · ⏱️ 31.05.2024):
	```
	npm install umi
	```
</details>
<details><summary><b><a href="https://github.com/redwoodjs/redwood">redwood</a></b> (🥉40 ·  ⭐ 17K) - The App Framework for Startups. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/redwoodjs/redwood) (👨‍💻 440 · 🔀 960 · 📦 5.2K · 📋 2.3K - 19% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/redwoodjs/redwood
	```
- [npm](https://www.npmjs.com/package/@redwoodjs/core) (📥 220K / month · 📦 25 · ⏱️ 31.05.2024):
	```
	npm install @redwoodjs/core
	```
</details>
<details><summary><b><a href="https://github.com/blitz-js/blitz">blitz</a></b> (🥉33 ·  ⭐ 13K) - The Missing Fullstack Toolkit for Next.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/blitz-js/blitz) (👨‍💻 320 · 🔀 780 · 📦 2.6K · 📋 640 - 10% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/blitz-js/blitz
	```
- [npm](https://www.npmjs.com/package/blitz) (📥 24K / month · 📦 28 · ⏱️ 04.06.2024):
	```
	npm install blitz
	```
</details>
<br>

## Styling

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_CSS and component styling frameworks._

<details><summary><b><a href="https://github.com/tailwindlabs/tailwindcss">Tailwind CSS</a></b> (🥇49 ·  ⭐ 79K) - A utility-first CSS framework for rapid UI development. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/tailwindlabs/tailwindcss) (👨‍💻 300 · 🔀 4K · 📥 3.2M · 📦 9.7M · 📋 3.3K - 1% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/tailwindlabs/tailwindcss
	```
- [npm](https://www.npmjs.com/package/tailwindcss) (📥 37M / month · 📦 150K · ⏱️ 05.06.2024):
	```
	npm install tailwindcss
	```
</details>
<details><summary><b><a href="https://github.com/styled-components/styled-components">Styled Components</a></b> (🥇46 ·  ⭐ 40K · 📈) - Visual primitives for the component age. Use the best.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/styled-components/styled-components) (👨‍💻 360 · 🔀 2.5K · 📦 2.4M · 📋 2.9K - 8% open · ⏱️ 09.05.2024):

	```
	git clone https://github.com/styled-components/styled-components
	```
- [npm](https://www.npmjs.com/package/styled-components) (📥 24M / month · 📦 45K · ⏱️ 09.05.2024):
	```
	npm install styled-components
	```
</details>
<details><summary><b><a href="https://github.com/emotion-js/emotion">emotion</a></b> (🥈40 ·  ⭐ 17K) - CSS-in-JS library designed for high performance style composition. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/emotion-js/emotion) (👨‍💻 320 · 🔀 1.1K · 📦 320K · 📋 1.7K - 17% open · ⏱️ 17.05.2024):

	```
	git clone https://github.com/emotion-js/emotion
	```
- [npm](https://www.npmjs.com/package/@emotion/react) (📥 34M / month · 📦 18K · ⏱️ 27.02.2024):
	```
	npm install @emotion/react
	```
</details>
<details><summary><b><a href="https://github.com/styled-components/polished">polished</a></b> (🥈38 ·  ⭐ 7.6K) - A lightweight toolset for writing styles in JavaScript. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/styled-components/polished) (👨‍💻 84 · 🔀 210 · 📦 380K · 📋 240 - 9% open · ⏱️ 01.02.2024):

	```
	git clone https://github.com/styled-components/polished
	```
- [npm](https://www.npmjs.com/package/polished) (📥 29M / month · 📦 6.8K · ⏱️ 01.02.2024):
	```
	npm install polished
	```
</details>
<details><summary><b><a href="https://github.com/cssinjs/jss">jss</a></b> (🥈36 ·  ⭐ 7.1K) - JSS is an authoring tool for CSS which uses JavaScript as a host language. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/cssinjs/jss) (👨‍💻 140 · 🔀 400 · 📦 710K · 📋 990 - 21% open · ⏱️ 14.05.2024):

	```
	git clone https://github.com/cssinjs/jss
	```
- [npm](https://www.npmjs.com/package/react-jss) (📥 1.1M / month · 📦 1.8K · ⏱️ 09.02.2023):
	```
	npm install react-jss
	```
</details>
<details><summary><b><a href="https://github.com/vanilla-extract-css/vanilla-extract">vanilla-extract</a></b> (🥈35 ·  ⭐ 9.3K) - Zero-runtime Stylesheets-in-TypeScript. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/vanilla-extract-css/vanilla-extract) (👨‍💻 100 · 🔀 270 · 📦 64K · 📋 310 - 14% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/seek-oss/vanilla-extract
	```
- [npm](https://www.npmjs.com/package/@vanilla-extract/integration) (📥 2.3M / month · 📦 59 · ⏱️ 22.05.2024):
	```
	npm install @vanilla-extract/integration
	```
</details>
<details><summary><b><a href="https://github.com/yocontra/react-responsive">react-responsive</a></b> (🥈33 ·  ⭐ 7K) - CSS media queries in react - for responsive design, and more. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/yocontra/react-responsive) (👨‍💻 66 · 🔀 300 · 📦 76K · 📋 220 - 1% open · ⏱️ 19.03.2024):

	```
	git clone https://github.com/yocontra/react-responsive
	```
- [npm](https://www.npmjs.com/package/react-responsive) (📥 2.7M / month · 📦 1.3K · ⏱️ 19.03.2024):
	```
	npm install react-responsive
	```
</details>
<details><summary><b><a href="https://github.com/ben-rogerson/twin.macro">twin.macro</a></b> (🥉32 ·  ⭐ 7.8K) - Twin blends the magic of Tailwind with the flexibility of css-in-js.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ben-rogerson/twin.macro) (👨‍💻 49 · 🔀 180 · 📦 15K · 📋 330 - 5% open · ⏱️ 08.04.2024):

	```
	git clone https://github.com/ben-rogerson/twin.macro
	```
- [npm](https://www.npmjs.com/package/twin.macro) (📥 330K / month · 📦 440 · ⏱️ 19.01.2024):
	```
	npm install twin.macro
	```
</details>
<details><summary><b><a href="https://github.com/callstack/linaria">linaria</a></b> (🥉31 ·  ⭐ 11K) - Zero-runtime CSS in JS library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/callstack/linaria) (👨‍💻 150 · 🔀 410 · 📦 1.8K · 📋 670 - 21% open · ⏱️ 26.04.2024):

	```
	git clone https://github.com/callstack/linaria
	```
- [npm](https://www.npmjs.com/package/linaria) (📥 33K / month · 📦 170 · ⏱️ 26.04.2024):
	```
	npm install linaria
	```
</details>
<details><summary><b><a href="https://github.com/stitchesjs/stitches">stitches</a></b> (🥉31 ·  ⭐ 7.7K · 💤) - [Not Actively Maintained] CSS-in-JS with near-zero runtime, SSR,.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/stitchesjs/stitches) (👨‍💻 54 · 🔀 250 · 📦 4 · 📋 660 - 17% open · ⏱️ 19.06.2023):

	```
	git clone https://github.com/modulz/stitches
	```
- [npm](https://www.npmjs.com/package/@stitches/react) (📥 1.5M / month · 📦 2.3K · ⏱️ 20.10.2022):
	```
	npm install @stitches/react
	```
</details>
<details><summary><b><a href="https://github.com/react-container-query/react-container-query">react-container-query</a></b> (🥉26 ·  ⭐ 890 · 💤) - Modular responsive component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-container-query/react-container-query) (👨‍💻 19 · 🔀 45 · 📦 18K · 📋 53 - 32% open · ⏱️ 14.09.2023):

	```
	git clone https://github.com/react-container-query/react-container-query
	```
- [npm](https://www.npmjs.com/package/react-container-query) (📥 79K / month · 📦 200 · ⏱️ 14.09.2023):
	```
	npm install react-container-query
	```
</details>
<details><summary><b><a href="https://github.com/styletron/styletron">styletron</a></b> (🥉25 ·  ⭐ 3.3K · 💤) - Toolkit for component-oriented styling. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/styletron/styletron) (👨‍💻 41 · 🔀 100 · 📦 8.1K · 📋 190 - 19% open · ⏱️ 06.10.2023):

	```
	git clone https://github.com/styletron/styletron
	```
- [npm](https://www.npmjs.com/package/styletron) (📥 670 / month · 📦 30 · ⏱️ 17.01.2018):
	```
	npm install styletron
	```
</details>
<details><summary>Show 4 hidden projects...</summary>

- <b><a href="https://github.com/FormidableLabs/radium">radium</a></b> (🥉32 ·  ⭐ 7.4K · 💀) - A toolchain for React component styling. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/Khan/aphrodite">aphrodite</a></b> (🥉31 ·  ⭐ 5.3K · 💀) - Framework-agnostic CSS-in-JS with support for server-side.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/robinweser/inline-style-prefixer">inline-style-prefixer</a></b> (🥉31 ·  ⭐ 390 · 💀) - Autoprefixer for JavaScript style objects. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/aesthetic-suite/framework">aesthetic</a></b> (🥉17 ·  ⭐ 200 · 💀) - Aesthetic is an end-to-end multi-platform styling framework that.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Layout

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Components to layout the UI elements._

<details><summary><b><a href="https://github.com/react-grid-layout/react-grid-layout">react-grid-layout</a></b> (🥇37 ·  ⭐ 20K) - A draggable and resizable grid layout with responsive.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-grid-layout/react-grid-layout) (👨‍💻 130 · 🔀 2.5K · 📦 18K · 📋 1.5K - 11% open · ⏱️ 15.02.2024):

	```
	git clone https://github.com/react-grid-layout/react-grid-layout
	```
- [npm](https://www.npmjs.com/package/react-grid-layout) (📥 2.8M / month · 📦 730 · ⏱️ 24.11.2023):
	```
	npm install react-grid-layout
	```
</details>
<details><summary><b><a href="https://github.com/floating-ui/react-popper">react-popper</a></b> (🥇34 ·  ⭐ 2.5K) - Official React library to use Popper, the positioning library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/floating-ui/react-popper) (👨‍💻 73 · 🔀 230 · 📦 760K · 📋 300 - 13% open · ⏱️ 08.05.2024):

	```
	git clone https://github.com/floating-ui/react-popper
	```
- [npm](https://www.npmjs.com/package/react-popper) (📥 21M / month · 📦 3.2K · ⏱️ 28.04.2022):
	```
	npm install react-popper
	```
</details>
<details><summary><b><a href="https://github.com/aeagle/react-spaces">react-spaces</a></b> (🥈26 ·  ⭐ 1.3K) - React components that allow you to divide a page or container into.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/aeagle/react-spaces) (👨‍💻 9 · 🔀 23 · 📦 180 · 📋 68 - 14% open · ⏱️ 21.04.2024):

	```
	git clone https://github.com/aeagle/react-spaces
	```
- [npm](https://www.npmjs.com/package/react-spaces) (📥 4.6K / month · 📦 78 · ⏱️ 30.04.2024):
	```
	npm install react-spaces
	```
</details>
<details><summary><b><a href="https://github.com/leefsmp/Re-Flex">Re-Flex</a></b> (🥉25 ·  ⭐ 620) - Resizable Flex layout container components for advanced React web.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/leefsmp/Re-Flex) (👨‍💻 25 · 🔀 72 · 📦 1.5K · 📋 130 - 10% open · ⏱️ 10.03.2024):

	```
	git clone https://github.com/leefsmp/Re-Flex
	```
- [npm](https://www.npmjs.com/package/react-reflex) (📥 130K / month · 📦 67 · ⏱️ 10.03.2024):
	```
	npm install react-reflex
	```
</details>
<details><summary>Show 7 hidden projects...</summary>

- <b><a href="https://github.com/golden-layout/golden-layout">golden-layout</a></b> (🥈29 ·  ⭐ 6.2K · 💀) - A multi window layout manager for webapps. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/eiriklv/react-masonry-component">react-masonry-component</a></b> (🥈29 ·  ⭐ 1.4K · 💀) - A React.js component for using @desandros Masonry. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/xudafeng/autoresponsive-react">autoresponsive-react</a></b> (🥉21 ·  ⭐ 1.6K · 💤) - Auto Responsive Layout Library For React. <code>❗Unlicensed</code>
- <b><a href="https://github.com/kettanaito/atomic-layout">atomic-layout</a></b> (🥉21 ·  ⭐ 1.1K · 💀) - Build declarative, responsive layouts in React using CSS Grid. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/AriTheElk/hedron">hedron</a></b> (🥉20 ·  ⭐ 860 · 💀) - A no-frills flexbox grid system for React, powered by styled-components. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/paol-imi/muuri-react">muuri-react</a></b> (🥉19 ·  ⭐ 350 · 💀) - The layout engine for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/martinnov92/React-Splitters">React-Splitters</a></b> (🥉18 ·  ⭐ 160 · 💀) - React splitter component, written in TypeScript. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Data Tables & Grids

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Data grid, tables, and spreadsheet components._

<details><summary><b><a href="https://github.com/ag-grid/ag-grid">ag-Grid</a></b> (🥇44 ·  ⭐ 12K) - The best JavaScript Data Table for building Enterprise Applications... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ag-grid/ag-grid) (👨‍💻 180 · 🔀 1.8K · 📦 5.5K · 📋 6K - 1% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/ag-grid/ag-grid
	```
- [npm](https://www.npmjs.com/package/ag-grid-community) (📥 2.8M / month · 📦 800 · ⏱️ 15.05.2024):
	```
	npm install ag-grid-community
	```
</details>
<details><summary><b><a href="https://github.com/TanStack/table">react-table</a></b> (🥇41 ·  ⭐ 24K) - Headless UI for building powerful tables & datagrids for TS/JS -.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/TanStack/table) (👨‍💻 420 · 🔀 3K · 📋 2.4K - 6% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/tannerlinsley/react-table
	```
- [npm](https://www.npmjs.com/package/react-table) (📥 5.6M / month · 📦 2.2K · ⏱️ 16.05.2022):
	```
	npm install react-table
	```
</details>
<details><summary><b><a href="https://github.com/mui/mui-x">material-ui-x</a></b> (🥇41 ·  ⭐ 3.9K) - MUI X: Build complex and data-rich applications using a.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/mui/mui-x) (👨‍💻 360 · 🔀 1.2K · 📥 15K · 📦 110K · 📋 5.5K - 19% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/mui-org/material-ui-x
	```
- [npm](https://www.npmjs.com/package/@material-ui/data-grid) (📥 200K / month · 📦 130 · ⏱️ 12.08.2021):
	```
	npm install @material-ui/data-grid
	```
</details>
<details><summary><b><a href="https://github.com/adazzle/react-data-grid">react-data-grid</a></b> (🥈36 ·  ⭐ 6.7K) - Feature-rich and customizable data grid React component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/adazzle/react-data-grid) (👨‍💻 140 · 🔀 2.2K · 📦 10K · 📋 1.5K - 11% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/adazzle/react-data-grid
	```
- [npm](https://www.npmjs.com/package/react-data-grid) (📥 580K / month · 📦 380 · ⏱️ 16.05.2024):
	```
	npm install react-data-grid
	```
</details>
<details><summary><b><a href="https://github.com/bvaughn/react-window">react-window</a></b> (🥈35 ·  ⭐ 15K · 💤) - React components for efficiently rendering large lists and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/bvaughn/react-window) (👨‍💻 37 · 🔀 770 · 📥 38 · 📦 160K · 📋 640 - 39% open · ⏱️ 22.11.2023):

	```
	git clone https://github.com/bvaughn/react-window
	```
- [npm](https://www.npmjs.com/package/react-window) (📥 8.5M / month · 📦 2.5K · ⏱️ 22.11.2023):
	```
	npm install react-window
	```
</details>
<details><summary><b><a href="https://github.com/mbrn/material-table">material-table</a></b> (🥈34 ·  ⭐ 3.5K · 💤) - Datatable for React based on material-uis table with.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/mbrn/material-table) (👨‍💻 200 · 🔀 1K · 📦 28K · 📋 2.6K - 1% open · ⏱️ 18.06.2023):

	```
	git clone https://github.com/mbrn/material-table
	```
- [npm](https://www.npmjs.com/package/material-table) (📥 240K / month · 📦 240 · ⏱️ 18.06.2023):
	```
	npm install material-table
	```
</details>
<details><summary><b><a href="https://github.com/finos/perspective">Perspective</a></b> (🥈33 ·  ⭐ 7.7K) - A data visualization and analytics component, especially well-.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/finos/perspective) (👨‍💻 93 · 🔀 1K · 📥 2.9K · 📦 120 · 📋 760 - 13% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/finos/perspective
	```
- [PyPi](https://pypi.org/project/perspective-python) (📥 5.9K / month · 📦 22 · ⏱️ 23.05.2024):
	```
	pip install perspective-python
	```
- [Conda](https://anaconda.org/conda-forge/perspective) (📥 650K · ⏱️ 23.05.2024):
	```
	conda install -c conda-forge perspective
	```
- [npm](https://www.npmjs.com/package/@finos/perspective) (📥 64K / month · 📦 48 · ⏱️ 23.05.2024):
	```
	npm install @finos/perspective
	```
</details>
<details><summary><b><a href="https://github.com/olifolkerd/tabulator">tabulator</a></b> (🥈33 ·  ⭐ 6.3K) - Interactive Tables and Data Grids for JavaScript. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/olifolkerd/tabulator) (👨‍💻 110 · 🔀 780 · 📋 4.2K - 3% open · ⏱️ 28.04.2024):

	```
	git clone https://github.com/olifolkerd/tabulator
	```
- [npm](https://www.npmjs.com/package/tabulator-tables) (📥 370K / month · 📦 140 · ⏱️ 28.04.2024):
	```
	npm install tabulator-tables
	```
</details>
<details><summary><b><a href="https://github.com/jbetancur/react-data-table-component">React Data Table</a></b> (🥈33 ·  ⭐ 2K) - A responsive table library with built-in sorting,.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/jbetancur/react-data-table-component) (👨‍💻 68 · 🔀 400 · 📦 31K · 📋 790 - 6% open · ⏱️ 09.03.2024):

	```
	git clone https://github.com/jbetancur/react-data-table-component
	```
- [npm](https://www.npmjs.com/package/react-data-table-component) (📥 530K / month · 📦 260 · ⏱️ 12.01.2024):
	```
	npm install react-data-table-component
	```
</details>
<details><summary><b><a href="https://github.com/6pac/SlickGrid">SlickGrid</a></b> (🥈32 ·  ⭐ 1.8K) - A lightning fast JavaScript grid/spreadsheet. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/6pac/SlickGrid) (👨‍💻 150 · 🔀 420 · 📦 1.7K · 📋 410 - 2% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/6pac/SlickGrid
	```
- [npm](https://www.npmjs.com/package/slickgrid) (📥 30K / month · 📦 46 · ⏱️ 07.05.2024):
	```
	npm install slickgrid
	```
</details>
<details><summary><b><a href="https://github.com/schrodinger/fixed-data-table-2">fixed-data-table-2</a></b> (🥈32 ·  ⭐ 1.3K) - A React table component designed to allow presenting.. <code><a href="http://bit.ly/3aKzpTv">BSD-3</a></code></summary>

- [GitHub](https://github.com/schrodinger/fixed-data-table-2) (👨‍💻 110 · 🔀 290 · 📦 1.3K · 📋 360 - 12% open · ⏱️ 23.05.2024):

	```
	git clone https://github.com/schrodinger/fixed-data-table-2
	```
- [npm](https://www.npmjs.com/package/fixed-data-table-2) (📥 210K / month · 📦 110 · ⏱️ 23.05.2024):
	```
	npm install fixed-data-table-2
	```
</details>
<details><summary><b><a href="https://github.com/grid-js/gridjs">gridjs</a></b> (🥈31 ·  ⭐ 4.3K · 📉) - Advanced table plugin. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/grid-js/gridjs) (👨‍💻 45 · 🔀 230 · 📦 2.9K · 📋 360 - 27% open · ⏱️ 03.03.2024):

	```
	git clone https://github.com/grid-js/gridjs
	```
- [npm](https://www.npmjs.com/package/gridjs) (📥 97K / month · 📦 58 · ⏱️ 03.03.2024):
	```
	npm install gridjs
	```
</details>
<details><summary><b><a href="https://github.com/glideapps/glide-data-grid">glide-data-grid</a></b> (🥉28 ·  ⭐ 3.5K) - Glide Data Grid is a no compromise, outrageously react fast.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/glideapps/glide-data-grid) (👨‍💻 40 · 🔀 270 · 📦 3 · 📋 540 - 13% open · ⏱️ 10.05.2024):

	```
	git clone https://github.com/glideapps/glide-data-grid
	```
- [npm](https://www.npmjs.com/package/@glideapps/glide-data-grid) (📥 110K / month · 📦 20 · ⏱️ 10.05.2024):
	```
	npm install @glideapps/glide-data-grid
	```
</details>
<details><summary><b><a href="https://github.com/Autodesk/react-base-table">react-base-table</a></b> (🥉28 ·  ⭐ 1.5K) - A react table component to display large datasets with high.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Autodesk/react-base-table) (👨‍💻 13 · 🔀 160 · 📦 610 · 📋 280 - 31% open · ⏱️ 24.05.2024):

	```
	git clone https://github.com/Autodesk/react-base-table
	```
- [npm](https://www.npmjs.com/package/react-base-table) (📥 95K / month · 📦 47 · ⏱️ 24.05.2024):
	```
	npm install react-base-table
	```
</details>
<details><summary><b><a href="https://github.com/iddan/react-spreadsheet">React Spreadsheet</a></b> (🥉28 ·  ⭐ 1.2K) - Simple, customizable yet performant spreadsheet for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/iddan/react-spreadsheet) (👨‍💻 34 · 🔀 140 · 📦 770 · 📋 180 - 14% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/iddan/react-spreadsheet
	```
- [npm](https://www.npmjs.com/package/react-spreadsheet) (📥 100K / month · 📦 16 · ⏱️ 28.01.2024):
	```
	npm install react-spreadsheet
	```
</details>
<details><summary><b><a href="https://github.com/komarovalexander/ka-table">ka-table</a></b> (🥉28 ·  ⭐ 720) - Lightweight MIT React Table component with Sorting, Filtering, Grouping,.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/komarovalexander/ka-table) (👨‍💻 10 · 🔀 53 · 📦 330 · 📋 180 - 5% open · ⏱️ 18.05.2024):

	```
	git clone https://github.com/komarovalexander/ka-table
	```
- [npm](https://www.npmjs.com/package/ka-table) (📥 23K / month · 📦 16 · ⏱️ 18.05.2024):
	```
	npm install ka-table
	```
</details>
<details><summary><b><a href="https://github.com/rsuite/rsuite-table">rsuite-table</a></b> (🥉28 ·  ⭐ 700) - A React table component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/rsuite/rsuite-table) (👨‍💻 29 · 🔀 130 · 📦 15K · 📋 200 - 22% open · ⏱️ 01.12.2023):

	```
	git clone https://github.com/rsuite/rsuite-table
	```
- [npm](https://www.npmjs.com/package/rsuite-table) (📥 350K / month · 📦 29 · ⏱️ 01.12.2023):
	```
	npm install rsuite-table
	```
</details>
<details><summary><b><a href="https://github.com/jspreadsheet/ce">jspreadsheet</a></b> (🥉27 ·  ⭐ 6.6K) - Jspreadsheet is a lightweight vanilla javascript plugin to create.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jspreadsheet/ce) (👨‍💻 78 · 🔀 810 · 📦 3 · 📋 1.5K - 9% open · ⏱️ 24.04.2024):

	```
	git clone https://github.com/jspreadsheet/ce
	```
- [npm](https://www.npmjs.com/package/jexcel) (📥 14K / month · 📦 25 · ⏱️ 24.02.2021):
	```
	npm install jexcel
	```
</details>
<details><summary><b><a href="https://github.com/revolist/revogrid">RevoGrid</a></b> (🥉25 ·  ⭐ 2.7K) - Powerful virtual data grid smartsheet with advanced customization. Best.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/revolist/revogrid) (👨‍💻 24 · 🔀 170 · 📋 300 - 52% open · ⏱️ 16.04.2024):

	```
	git clone https://github.com/revolist/revogrid
	```
- [npm](https://www.npmjs.com/package/@revolist/revogrid) (📥 44K / month · 📦 30 · ⏱️ 23.10.2023):
	```
	npm install @revolist/revogrid
	```
</details>
<details><summary><b><a href="https://github.com/frappe/datatable">datatable</a></b> (🥉24 ·  ⭐ 980) - The Missing Javascript Datatable for the Web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/frappe/datatable) (👨‍💻 25 · 🔀 150 · 📦 3 · 📋 89 - 64% open · ⏱️ 17.04.2024):

	```
	git clone https://github.com/frappe/datatable
	```
- [npm](https://www.npmjs.com/package/frappe-datatable) (📥 43K / month · 📦 11 · ⏱️ 17.04.2024):
	```
	npm install frappe-datatable
	```
</details>
<details><summary><b><a href="https://github.com/inovua/reactdatagrid">reactdatagrid</a></b> (🥉23 ·  ⭐ 3.4K · 💤) - Empower Your Data with the best React Data Grid there is. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/inovua/reactdatagrid) (👨‍💻 1 · 🔀 56 · 📦 750 · 📋 340 - 32% open · ⏱️ 31.07.2023):

	```
	git clone https://github.com/inovua/reactdatagrid
	```
- [npm](https://www.npmjs.com/package/@inovua/reactdatagrid-community) (📥 41K / month · 📦 25 · ⏱️ 31.07.2023):
	```
	npm install @inovua/reactdatagrid-community
	```
</details>
<details><summary>Show 18 hidden projects...</summary>

- <b><a href="https://github.com/bvaughn/react-virtualized">react-virtualized</a></b> (🥇39 ·  ⭐ 26K · 💀) - React components for efficiently rendering large lists.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/handsontable/handsontable">Handsontable</a></b> (🥇39 ·  ⭐ 19K) - JavaScript data grid with a spreadsheet look & feel. Works with.. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/gregnb/mui-datatables">MUI-Datatables</a></b> (🥈32 ·  ⭐ 2.7K · 💀) - Datatables for React using Material-UI. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code>
- <b><a href="https://github.com/tabalinas/jsgrid">jsgrid</a></b> (🥈31 ·  ⭐ 1.5K · 💀) - Lightweight Grid jQuery Plugin. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/mleibman/SlickGrid">mleibman/SlickGrid</a></b> (🥉30 ·  ⭐ 6.8K · 💀) - A lightning fast JavaScript grid/spreadsheet. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/nadbm/react-datasheet">React-Datasheet</a></b> (🥉28 ·  ⭐ 5.4K · 💀) - Excel-like data grid (table) component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-bootstrap-table/react-bootstrap-table2">react-bootstrap-table2</a></b> (🥉27 ·  ⭐ 1.3K · 💀) - Next Generation of react-bootstrap-table. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13"></code>
- <b><a href="https://github.com/tonytomov/jqGrid">jqGrid</a></b> (🥉26 ·  ⭐ 2.8K) - jQuery grid plugin. <code>❗Unlicensed</code>
- <b><a href="https://github.com/volosoft/jtable">jtable</a></b> (🥉26 ·  ⭐ 1.1K · 💀) - A JQuery plugin to create AJAX based CRUD tables. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/plotly/react-pivottable">react-pivottable</a></b> (🥉24 ·  ⭐ 970 · 💀) - React-based dragndrop pivot table with Plotly.js charts. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/davidguttman/react-pivot">ReactPivot</a></b> (🥉22 ·  ⭐ 1K · 💀) - React-Pivot is a data-grid component with pivot-table-like.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/joaocarmo/react-smart-data-table">react-smart-data-table</a></b> (🥉19 ·  ⭐ 88 · 💤) - A smart data table component for React meant to be.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/nnajm/orb">orb</a></b> (🥉18 ·  ⭐ 560 · 💀) - Pivot table javascript library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/FancyGrid/FancyGrid">FancyGrid</a></b> (🥉17 ·  ⭐ 200 · 💀) - FancyGrid - JavaScript grid library with charts.. <code>❗Unlicensed</code>
- <b><a href="https://github.com/paramquery/grid">grid</a></b> (🥉16 ·  ⭐ 540 · 💀) - jQuery grid plugin based on jQueryui widget design. <code><a href="http://bit.ly/2M0xdwT">❗️GPL-3.0</a></code>
- <b><a href="https://github.com/githubocto/flat-ui">flat-ui</a></b> (🥉16 ·  ⭐ 370 · 💀) - Welcome friends! **flat-ui** is a React component that will render.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/webismymind/editablegrid">editablegrid</a></b> (🥉13 ·  ⭐ 800) - EditableGrid is an open source Javascript library aimed at.. <code>❗Unlicensed</code>
- <b><a href="https://github.com/archit-p/editable-react-table">editable-react-table</a></b> (🥉9 ·  ⭐ 650) - React table built to resemble a database. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Input Components

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Input and form components._

<details><summary><b><a href="https://github.com/react-hook-form/react-hook-form">react-hook-form</a></b> (🥇44 ·  ⭐ 40K) - React Hooks for form state management and validation (Web +.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-hook-form/react-hook-form) (👨‍💻 310 · 🔀 2K · 📦 780K · 📋 4.4K - 0% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/react-hook-form/react-hook-form
	```
- [npm](https://www.npmjs.com/package/react-hook-form) (📥 22M / month · 📦 5.7K · ⏱️ 21.05.2024):
	```
	npm install react-hook-form
	```
</details>
<details><summary><b><a href="https://github.com/Hacker0x01/react-datepicker">react-datepicker</a></b> (🥇43 ·  ⭐ 7.9K) - A simple and reusable datepicker component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Hacker0x01/react-datepicker) (👨‍💻 460 · 🔀 2.2K · 📦 250K · 📋 2.2K - 14% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/Hacker0x01/react-datepicker
	```
- [npm](https://www.npmjs.com/package/react-datepicker) (📥 9.5M / month · 📦 3.2K · ⏱️ 18.04.2024):
	```
	npm install react-datepicker
	```
</details>
<details><summary><b><a href="https://github.com/jaredpalmer/formik">formik</a></b> (🥇42 ·  ⭐ 34K) - Build forms in React, without the tears. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/jaredpalmer/formik) (👨‍💻 450 · 🔀 2.8K · 📦 600K · 📋 2.4K - 34% open · ⏱️ 24.04.2024):

	```
	git clone https://github.com/jaredpalmer/formik
	```
- [npm](https://www.npmjs.com/package/formik) (📥 11M / month · 📦 4.6K · ⏱️ 24.04.2024):
	```
	npm install formik
	```
</details>
<details><summary><b><a href="https://github.com/JedWatson/react-select">react-select</a></b> (🥈41 ·  ⭐ 27K · 💤) - The Select Component for React.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/JedWatson/react-select) (👨‍💻 510 · 🔀 4.1K · 📦 490K · 📋 3.6K - 11% open · ⏱️ 10.11.2023):

	```
	git clone https://github.com/JedWatson/react-select
	```
- [npm](https://www.npmjs.com/package/react-select) (📥 21M / month · 📦 8K · ⏱️ 06.11.2023):
	```
	npm install react-select
	```
</details>
<details><summary><b><a href="https://github.com/rjsf-team/react-jsonschema-form">react-jsonschema-form</a></b> (🥈38 ·  ⭐ 14K) - A React component for building Web forms from JSON.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/rjsf-team/react-jsonschema-form) (👨‍💻 340 · 🔀 2.2K · 📦 6.1K · 📋 2.1K - 13% open · ⏱️ 24.05.2024):

	```
	git clone https://github.com/rjsf-team/react-jsonschema-form
	```
- [npm](https://www.npmjs.com/package/@rjsf/antd) (📥 40K / month · 📦 33 · ⏱️ 17.05.2024):
	```
	npm install @rjsf/antd
	```
</details>
<details><summary><b><a href="https://github.com/downshift-js/downshift">downshift</a></b> (🥈38 ·  ⭐ 12K) - A set of primitives to build simple, flexible, WAI-ARIA compliant React.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/downshift-js/downshift) (👨‍💻 210 · 🔀 930 · 📦 110K · 📋 830 - 5% open · ⏱️ 17.05.2024):

	```
	git clone https://github.com/downshift-js/downshift
	```
- [npm](https://www.npmjs.com/package/downshift) (📥 7M / month · 📦 1.5K · ⏱️ 17.05.2024):
	```
	npm install downshift
	```
</details>
<details><summary><b><a href="https://github.com/nosir/cleave.js">cleave.js</a></b> (🥈35 ·  ⭐ 18K · 💤) - Format input text content when you are typing... <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/nosir/cleave.js) (👨‍💻 79 · 🔀 1.6K · 📦 18K · 📋 550 - 40% open · ⏱️ 25.11.2023):

	```
	git clone https://github.com/nosir/cleave.js
	```
- [npm](https://www.npmjs.com/package/cleave.js) (📥 1.1M / month · 📦 480 · ⏱️ 19.05.2020):
	```
	npm install cleave.js
	```
</details>
<details><summary><b><a href="https://github.com/surveyjs/survey-library">survey-library</a></b> (🥈34 ·  ⭐ 4K) - Free JavaScript form builder library with integration for React,.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/surveyjs/survey-library) (👨‍💻 160 · 🔀 780 · 📥 880 · 📦 10 · 📋 5.3K - 11% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/surveyjs/survey-library
	```
- [npm](https://www.npmjs.com/package/survey-knockout) (📥 55K / month · 📦 25 · ⏱️ 28.05.2024):
	```
	npm install survey-knockout
	```
</details>
<details><summary><b><a href="https://github.com/wojtekmaj/react-date-picker">react-date-picker</a></b> (🥈34 ·  ⭐ 1.2K) - A date picker for your React app. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/wojtekmaj/react-date-picker) (👨‍💻 23 · 🔀 190 · 📦 28K · 📋 360 - 6% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/wojtekmaj/react-date-picker
	```
- [npm](https://www.npmjs.com/package/react-date-picker) (📥 960K / month · 📦 340 · ⏱️ 30.04.2024):
	```
	npm install react-date-picker
	```
</details>
<details><summary><b><a href="https://github.com/hypeserver/react-date-range">react-date-range</a></b> (🥉33 ·  ⭐ 2.6K) - A React component for choosing dates and date ranges. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/hypeserver/react-date-range) (👨‍💻 68 · 🔀 650 · 📦 37K · 📋 440 - 49% open · ⏱️ 22.04.2024):

	```
	git clone https://github.com/hypeserver/react-date-range
	```
- [npm](https://www.npmjs.com/package/react-date-range) (📥 1.1M / month · 📦 420 · ⏱️ 22.04.2024):
	```
	npm install react-date-range
	```
</details>
<details><summary><b><a href="https://github.com/jquense/react-widgets">react-widgets</a></b> (🥉31 ·  ⭐ 2.3K · 💤) - Polished, feature rich, accessible form inputs built with.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jquense/react-widgets) (👨‍💻 110 · 🔀 400 · 📦 8.7K · 📋 900 - 5% open · ⏱️ 02.08.2023):

	```
	git clone https://github.com/jquense/react-widgets
	```
- [npm](https://www.npmjs.com/package/react-widgets) (📥 190K / month · 📦 230 · ⏱️ 23.03.2022):
	```
	npm install react-widgets
	```
</details>
<details><summary><b><a href="https://github.com/ndom91/react-timezone-select">react-timezone-select</a></b> (🥉26 ·  ⭐ 200) - An extremely usable and dynamic React timezone selector. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ndom91/react-timezone-select) (👨‍💻 18 · 🔀 46 · 📦 2.6K · 📋 66 - 4% open · ⏱️ 16.05.2024):

	```
	git clone https://github.com/ndom91/react-timezone-select
	```
- [npm](https://www.npmjs.com/package/react-timezone-select) (📥 190K / month · 📦 35 · ⏱️ 16.05.2024):
	```
	npm install react-timezone-select
	```
</details>
<details><summary>Show 12 hidden projects...</summary>

- <b><a href="https://github.com/arqex/react-datetime">react-datetime</a></b> (🥈34 ·  ⭐ 2K · 💀) - A lightweight but complete datetime picker react component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-dates/react-dates">react-dates</a></b> (🥉31 ·  ⭐ 12K · 💀) - An easily internationalizable, mobile-friendly datepicker library.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/unform/unform">unform</a></b> (🥉30 ·  ⭐ 4.5K · 💀) - Performance-focused API for React forms. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/haoxins/react-flatpickr">react-flatpickr</a></b> (🥉26 ·  ⭐ 590 · 💀) - flatpickr for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/formsy/formsy-material-ui">formsy-material-ui</a></b> (🥉24 ·  ⭐ 570 · 💀) - A Formsy compatibility wrapper for Material-UI form.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/hernansartorio/react-nice-dates">react-nice-dates</a></b> (🥉23 ·  ⭐ 1.1K · 💀) - A responsive, touch-friendly, and modular date picker.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/twisty/formsy-react-components">formsy-react-components</a></b> (🥉21 ·  ⭐ 290 · 💀) - Bootstrap components for a formsy-react form. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/mberneti/react-datepicker2">react-datepicker2</a></b> (🥉21 ·  ⭐ 230 · 💀) - react datepicker component.(include persian jalaali.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/antonfisher/react-simple-timefield">react-simple-timefield</a></b> (🥉21 ·  ⭐ 96 · 💀) - Simple React time input field. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/alexkuz/react-input-enhancements">react-input-enhancements</a></b> (🥉20 ·  ⭐ 1.4K · 💀) - Set of enhancements for input control. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/BelkaLab/react-yearly-calendar">react-yearly-calendar</a></b> (🥉16 ·  ⭐ 550 · 💀) - React.js Yearly Calendar Component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/almogtavor/date-range-picker">date-range-picker</a></b> (🥉12 ·  ⭐ 100 · 💀) - Flexible React date range picker calendar with no.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Internationalization & Localization

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/formatjs/formatjs">formatjs</a></b> (🥇43 ·  ⭐ 14K) - The monorepo home to all of the FormatJS related libraries, most.. <code><a href="http://bit.ly/3aKzpTv">BSD-3</a></code></summary>

- [GitHub](https://github.com/formatjs/formatjs) (👨‍💻 320 · 🔀 1.3K · 📦 180K · 📋 1.9K - 1% open · ⏱️ 20.05.2024):

	```
	git clone https://github.com/formatjs/formatjs
	```
- [npm](https://www.npmjs.com/package/react-intl) (📥 6.9M / month · 📦 5.2K · ⏱️ 19.05.2024):
	```
	npm install react-intl
	```
</details>
<details><summary><b><a href="https://github.com/i18next/react-i18next">react-i18next</a></b> (🥈40 ·  ⭐ 9K) - Internationalization for react done right. Using the i18next i18n.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/i18next/react-i18next) (👨‍💻 190 · 🔀 1K · 📦 220K · 📋 1.2K - 1% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/i18next/react-i18next
	```
- [npm](https://www.npmjs.com/package/react-i18next) (📥 15M / month · 📦 5.4K · ⏱️ 22.05.2024):
	```
	npm install react-i18next
	```
</details>
<details><summary><b><a href="https://github.com/lingui/js-lingui">js-lingui</a></b> (🥉36 ·  ⭐ 4.3K) - A readable, automated, and optimized (3 kb) internationalization for.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/lingui/js-lingui) (👨‍💻 220 · 🔀 360 · 📦 5.3K · 📋 930 - 3% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/lingui/js-lingui
	```
- [npm](https://www.npmjs.com/package/@lingui/macro) (📥 510K / month · 📦 240 · ⏱️ 30.05.2024):
	```
	npm install @lingui/macro
	```
</details>
<details><summary><b><a href="https://github.com/DoneDeal0/Talkr">talkr</a></b> (🥉18 ·  ⭐ 240) - Talkr is the lightest i18n provider for React applications. It supports.. <code><a href="http://bit.ly/3hkKRql">ISC</a></code></summary>

- [GitHub](https://github.com/DoneDeal0/Talkr) (👨‍💻 6 · 🔀 10 · 📦 43 · ⏱️ 20.05.2024):

	```
	git clone https://github.com/DoneDeal0/Talkr
	```
- [npm](https://www.npmjs.com/package/talkr) (📥 2.2K / month · 📦 1 · ⏱️ 23.02.2023):
	```
	npm install talkr
	```
</details>
<br>

## State Management

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/reduxjs/redux">redux</a></b> (🥇48 ·  ⭐ 61K · 📉) - A JS library for predictable global state management. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reduxjs/redux) (👨‍💻 1K · 🔀 15K · 📦 4.1M · 📋 2K - 1% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/reduxjs/redux
	```
- [npm](https://www.npmjs.com/package/redux) (📥 43M / month · 📦 32K · ⏱️ 23.12.2023):
	```
	npm install redux
	```
</details>
<details><summary><b><a href="https://github.com/reduxjs/react-redux">react-redux</a></b> (🥇47 ·  ⭐ 23K) - Official React bindings for Redux. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reduxjs/react-redux) (👨‍💻 300 · 🔀 3.4K · 📦 3.8M · 📋 1.3K - 2% open · ⏱️ 09.05.2024):

	```
	git clone https://github.com/reduxjs/react-redux
	```
- [npm](https://www.npmjs.com/package/react-redux) (📥 33M / month · 📦 27K · ⏱️ 02.05.2024):
	```
	npm install react-redux
	```
</details>
<details><summary><b><a href="https://github.com/immerjs/immer">immer</a></b> (🥇45 ·  ⭐ 27K) - Create the next immutable state by mutating the current one. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/immerjs/immer) (👨‍💻 200 · 🔀 840 · 📦 9.8M · 📋 660 - 4% open · ⏱️ 27.04.2024):

	```
	git clone https://github.com/immerjs/immer
	```
- [npm](https://www.npmjs.com/package/immer) (📥 47M / month · 📦 7.2K · ⏱️ 27.04.2024):
	```
	npm install immer
	```
</details>
<details><summary><b><a href="https://github.com/mobxjs/mobx">mobx</a></b> (🥇43 ·  ⭐ 27K) - Simple, scalable state management. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mobxjs/mobx) (👨‍💻 350 · 🔀 1.8K · 📦 160K · 📋 2K - 3% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/mobxjs/mobx
	```
- [npm](https://www.npmjs.com/package/mobx) (📥 6.2M / month · 📦 6.8K · ⏱️ 28.03.2024):
	```
	npm install mobx
	```
</details>
<details><summary><b><a href="https://github.com/statelyai/xstate">xstate</a></b> (🥇43 ·  ⭐ 26K) - Actor-based state management & orchestration for complex app logic. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/statelyai/xstate) (👨‍💻 360 · 🔀 1.2K · 📦 260K · 📋 1.4K - 9% open · ⏱️ 01.06.2024):

	```
	git clone https://github.com/statelyai/xstate
	```
- [npm](https://www.npmjs.com/package/xstate) (📥 7.1M / month · 📦 1.2K · ⏱️ 01.06.2024):
	```
	npm install xstate
	```
</details>
<details><summary><b><a href="https://github.com/pmndrs/zustand">zustand</a></b> (🥈42 ·  ⭐ 44K) - Bear necessities for state management in React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/pmndrs/zustand) (👨‍💻 230 · 🔀 1.3K · 📦 390K · 📋 660 - 1% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/pmndrs/zustand
	```
- [npm](https://www.npmjs.com/package/zustand) (📥 15M / month · 📦 3.2K · ⏱️ 22.05.2024):
	```
	npm install zustand
	```
</details>
<details><summary><b><a href="https://github.com/reduxjs/reselect">reselect</a></b> (🥈42 ·  ⭐ 19K) - Selector library for Redux. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reduxjs/reselect) (👨‍💻 110 · 🔀 670 · 📦 2.6M · 📋 420 - 8% open · ⏱️ 01.06.2024):

	```
	git clone https://github.com/reduxjs/reselect
	```
- [npm](https://www.npmjs.com/package/reselect) (📥 32M / month · 📦 4.8K · ⏱️ 01.06.2024):
	```
	npm install reselect
	```
</details>
<details><summary><b><a href="https://github.com/immutable-js/immutable-js">immutable-js</a></b> (🥈40 ·  ⭐ 33K) - Immutable persistent data collections for Javascript which increase.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/immutable-js/immutable-js) (👨‍💻 230 · 🔀 1.8K · 📦 5 · 📋 1.3K - 9% open · ⏱️ 13.05.2024):

	```
	git clone https://github.com/immutable-js/immutable-js
	```
- [npm](https://www.npmjs.com/package/immutable) (📥 77M / month · 📦 14K · ⏱️ 13.05.2024):
	```
	npm install immutable
	```
</details>
<details><summary><b><a href="https://github.com/pubkey/rxdb">rxdb</a></b> (🥈39 ·  ⭐ 21K) - A fast, local first, reactive Database for JavaScript Applications.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/pubkey/rxdb) (👨‍💻 240 · 🔀 1K · 📦 1.7K · 📋 710 - 2% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/pubkey/rxdb
	```
- [npm](https://www.npmjs.com/package/rxdb) (📥 66K / month · 📦 150 · ⏱️ 29.05.2024):
	```
	npm install rxdb
	```
</details>
<details><summary><b><a href="https://github.com/facebookexperimental/Recoil">Recoil</a></b> (🥈37 ·  ⭐ 19K · 💤) - Recoil is an experimental state management library for React apps. It.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/facebookexperimental/Recoil) (👨‍💻 120 · 🔀 1.2K · 📦 87K · 📋 1.1K - 29% open · ⏱️ 07.09.2023):

	```
	git clone https://github.com/facebookexperimental/Recoil
	```
- [npm](https://www.npmjs.com/package/recoil) (📥 2.5M / month · 📦 870 · ⏱️ 01.03.2023):
	```
	npm install recoil
	```
</details>
<details><summary><b><a href="https://github.com/reduxjs/redux-toolkit">redux-toolkit</a></b> (🥈36 ·  ⭐ 10K) - The official, opinionated, batteries-included toolset for.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reduxjs/redux-toolkit) (👨‍💻 360 · 🔀 1.1K · 📦 19 · 📋 2.5K - 12% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/reduxjs/redux-toolkit
	```
- [npm](https://www.npmjs.com/package/redux-toolkit) (📥 60K / month · 📦 24 · ⏱️ 21.10.2015):
	```
	npm install redux-toolkit
	```
</details>
<details><summary><b><a href="https://github.com/effector/effector">effector</a></b> (🥉34 ·  ⭐ 4.5K) - Business logic with ease. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/effector/effector) (👨‍💻 140 · 🔀 220 · 📦 5.3K · 📋 420 - 30% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/effector/effector
	```
- [npm](https://www.npmjs.com/package/effector-react) (📥 140K / month · 📦 140 · ⏱️ 23.05.2024):
	```
	npm install effector-react
	```
</details>
<details><summary><b><a href="https://github.com/ctrlplusb/easy-peasy">easy-peasy</a></b> (🥉31 ·  ⭐ 5K · 💤) - Vegetarian friendly state for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ctrlplusb/easy-peasy) (👨‍💻 69 · 🔀 200 · 📦 6.3K · 📋 540 - 2% open · ⏱️ 19.10.2023):

	```
	git clone https://github.com/ctrlplusb/easy-peasy
	```
- [npm](https://www.npmjs.com/package/easy-peasy) (📥 120K / month · 📦 80 · ⏱️ 13.10.2023):
	```
	npm install easy-peasy
	```
</details>
<details><summary><b><a href="https://github.com/keajs/kea">kea</a></b> (🥉28 ·  ⭐ 1.9K) - Batteries Included State Management for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/keajs/kea) (👨‍💻 18 · 🔀 51 · 📦 940 · 📋 130 - 4% open · ⏱️ 24.01.2024):

	```
	git clone https://github.com/keajs/kea
	```
- [npm](https://www.npmjs.com/package/kea) (📥 450K / month · 📦 50 · ⏱️ 19.12.2023):
	```
	npm install kea
	```
</details>
<details><summary><b><a href="https://github.com/avkonst/hookstate">hookstate</a></b> (🥉27 ·  ⭐ 1.6K · 💤) - The simple but very powerful and incredibly fast state management.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/avkonst/hookstate) (👨‍💻 28 · 🔀 110 · 📦 3 · 📋 320 - 7% open · ⏱️ 20.11.2023):

	```
	git clone https://github.com/avkonst/hookstate
	```
- [npm](https://www.npmjs.com/package/@hookstate/core) (📥 140K / month · 📦 76 · ⏱️ 31.03.2023):
	```
	npm install @hookstate/core
	```
</details>
<details><summary><b><a href="https://github.com/yahoo/fluxible">fluxible</a></b> (🥉26 ·  ⭐ 1.8K) - A pluggable container for universal flux applications. <code><a href="http://bit.ly/3aKzpTv">BSD-3</a></code></summary>

- [GitHub](https://github.com/yahoo/fluxible) (👨‍💻 110 · 🔀 230 · 📦 640 · 📋 240 - 7% open · ⏱️ 06.05.2024):

	```
	git clone https://github.com/yahoo/fluxible
	```
- [npm](https://www.npmjs.com/package/fluxible) (📥 5.4K / month · 📦 70 · ⏱️ 21.06.2021):
	```
	npm install fluxible
	```
</details>
<details><summary><b><a href="https://github.com/yahoo/react-i13n">react-i13n</a></b> (🥉23 ·  ⭐ 380) - A performant, scalable and pluggable approach to instrumenting your.. <code><a href="http://bit.ly/3aKzpTv">BSD-3</a></code></summary>

- [GitHub](https://github.com/yahoo/react-i13n) (👨‍💻 32 · 🔀 53 · 📦 60 · 📋 57 - 15% open · ⏱️ 29.04.2024):

	```
	git clone https://github.com/yahoo/react-i13n
	```
- [npm](https://www.npmjs.com/package/react-i13n) (📥 6.8K / month · 📦 28 · ⏱️ 25.04.2023):
	```
	npm install react-i13n
	```
</details>
<details><summary><b><a href="https://github.com/Mojang/ore-ui">ore-ui</a></b> (🥉21 ·  ⭐ 380) - Building blocks to construct game UIs using web tech. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Mojang/ore-ui) (👨‍💻 19 · 🔀 18 · 📦 15 · 📋 23 - 30% open · ⏱️ 20.05.2024):

	```
	git clone https://github.com/Mojang/ore-ui
	```
- [npm](https://www.npmjs.com/package/@react-facet/dom-fiber-testing-library) (📥 340K / month · 📦 12 · ⏱️ 20.05.2024):
	```
	npm install @react-facet/dom-fiber-testing-library
	```
</details>
<details><summary>Show 13 hidden projects...</summary>

- <b><a href="https://github.com/localForage/localForage">localForage</a></b> (🥈39 ·  ⭐ 24K · 💀) - Offline storage, improved. Wraps IndexedDB, WebSQL, or.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code>
- <b><a href="https://github.com/remix-run/history">history</a></b> (🥈39 ·  ⭐ 8.3K · 💀) - Manage session history with JavaScript. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/final-form/react-final-form">react-final-form</a></b> (🥉32 ·  ⭐ 7.3K · 💀) - High performance subscription-based form state management.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/goatslacker/alt">alt</a></b> (🥉30 ·  ⭐ 3.5K · 💀) - Isomorphic flux implementation. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/mobxjs/mobx-react">mobx-react</a></b> (🥉28 ·  ⭐ 4.9K · 💀) - React bindings for MobX. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/cerebral/cerebral">cerebral</a></b> (🥉28 ·  ⭐ 2K · 💀) - Declarative state and side effects management for popular JavaScript.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/jamiebuilds/unstated-next">Unstated Next</a></b> (🥉26 ·  ⭐ 4.2K · 💀) - 200 bytes to never think about React state management.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/CharlesStover/reactn">reactn</a></b> (🥉25 ·  ⭐ 1.9K · 💀) - React, but with built-in global state management. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/BinaryMuse/fluxxor">fluxxor</a></b> (🥉25 ·  ⭐ 1.7K · 💀) - Flux architecture tools for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/tshelburne/redux-batched-actions">redux-batched-actions</a></b> (🥉22 ·  ⭐ 1K · 💀) - redux higher order reducer + action to reduce actions.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/Yomguithereal/baobab-react">baobab-react</a></b> (🥉21 ·  ⭐ 310 · 💀) - React integration for Baobab. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/teafuljs/teaful">teaful</a></b> (🥉17 ·  ⭐ 710 · 💀) - Tiny, easy and powerful React state management. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/noahgrant/resourcerer">resourcerer</a></b> (🥉14 ·  ⭐ 80) - Declarative data-fetching and caching framework for REST APIs with.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Routing

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/remix-run/react-router">react-router</a></b> (🥇48 ·  ⭐ 52K) - Declarative routing for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/remix-run/react-router) (👨‍💻 970 · 🔀 10K · 📦 8.1M · 📋 7.4K - 1% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/remix-run/react-router
	```
- [npm](https://www.npmjs.com/package/react-router-dom) (📥 42M / month · 📦 38K · ⏱️ 04.06.2024):
	```
	npm install react-router-dom
	```
</details>
<details><summary><b><a href="https://github.com/remix-run/react-router">remix-run/react-router</a></b> (🥇48 ·  ⭐ 52K) - Declarative routing for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/remix-run/react-router) (👨‍💻 970 · 🔀 10K · 📦 8.1M · 📋 7.4K - 1% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/remix-run/react-router
	```
- [npm](https://www.npmjs.com/package/react-router-dom) (📥 42M / month · 📦 38K · ⏱️ 04.06.2024):
	```
	npm install react-router-dom
	```
</details>
<details><summary><b><a href="https://github.com/molefrog/wouter">wouter</a></b> (🥈32 ·  ⭐ 6.3K) - A minimalist-friendly ~2.1KB routing for React and Preact. <code><a href="http://bit.ly/3rvuUlR">Unlicense</a></code></summary>

- [GitHub](https://github.com/molefrog/wouter) (👨‍💻 48 · 🔀 140 · 📦 8.4K · 📋 240 - 7% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/molefrog/wouter
	```
- [npm](https://www.npmjs.com/package/wouter) (📥 160K / month · 📦 170 · ⏱️ 30.05.2024):
	```
	npm install wouter
	```
</details>
<details><summary><b><a href="https://github.com/kriasoft/universal-router">universal-router</a></b> (🥈28 ·  ⭐ 1.7K · 💤) - A simple middleware-style router for isomorphic.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/kriasoft/universal-router) (👨‍💻 22 · 🔀 110 · 📦 8.7K · 📋 100 - 33% open · ⏱️ 23.06.2023):

	```
	git clone https://github.com/kriasoft/universal-router
	```
- [npm](https://www.npmjs.com/package/universal-router) (📥 96K / month · 📦 130 · ⏱️ 23.06.2023):
	```
	npm install universal-router
	```
</details>
<details><summary><b><a href="https://github.com/salvoravida/redux-first-history">redux-first-history</a></b> (🥉23 ·  ⭐ 440) - Redux history binding support react-router - @reach/router.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/salvoravida/redux-first-history) (👨‍💻 12 · 🔀 33 · 📦 1.1K · 📋 87 - 12% open · ⏱️ 14.12.2023):

	```
	git clone https://github.com/salvoravida/redux-first-history
	```
- [npm](https://www.npmjs.com/package/redux-first-history) (📥 220K / month · 📦 26 · ⏱️ 14.12.2023):
	```
	npm install redux-first-history
	```
</details>
<details><summary>Show 7 hidden projects...</summary>

- <b><a href="https://github.com/reach/router">router</a></b> (🥈33 ·  ⭐ 6.9K · 💀) - Next generation Routing for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/acdlite/redux-router">redux-router</a></b> (🥈28 ·  ⭐ 2.3K · 💀) - Redux bindings for React Router keep your router state inside.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/frontarm/navi">navi</a></b> (🥉26 ·  ⭐ 2.1K · 💀) - Declarative, asynchronous routing for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/taion/react-router-scroll">react-router-scroll</a></b> (🥉24 ·  ⭐ 840 · 💀) - React Router scroll management. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/STRML/react-router-component">react-router-component</a></b> (🥉22 ·  ⭐ 880 · 💀) - Declarative router component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/robbestad/react-breadcrumbs">react-breadcrumbs</a></b> (🥉22 ·  ⭐ 410 · 💀) - Automatic breadcrumbs for React-Router. <code><a href="http://bit.ly/3hkKRql">ISC</a></code>
- <b><a href="https://github.com/pshrmn/curi">curi</a></b> (🥉18 ·  ⭐ 270 · 💀) - A JavaScript router for single-page applications. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Animations

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/pmndrs/react-spring">react-spring</a></b> (🥇41 ·  ⭐ 28K) - A spring physics based React animation library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/pmndrs/react-spring) (👨‍💻 190 · 🔀 1.2K · 📦 160K · 📋 1.2K - 9% open · ⏱️ 26.05.2024):

	```
	git clone https://github.com/pmndrs/react-spring
	```
- [npm](https://www.npmjs.com/package/react-spring) (📥 3.1M / month · 📦 2.5K · ⏱️ 26.09.2023):
	```
	npm install react-spring
	```
</details>
<details><summary><b><a href="https://github.com/framer/motion">motion</a></b> (🥇41 ·  ⭐ 22K) - Open source, production-ready animation and gesture library for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/framer/motion) (👨‍💻 190 · 🔀 740 · 📦 3 · 📋 1.6K - 13% open · ⏱️ 31.05.2024):

	```
	git clone https://github.com/framer/motion
	```
- [npm](https://www.npmjs.com/package/framer-motion) (📥 16M / month · 📦 6.6K · ⏱️ 31.05.2024):
	```
	npm install framer-motion
	```
</details>
<details><summary><b><a href="https://github.com/tsparticles/tsparticles">tsparticles</a></b> (🥈36 ·  ⭐ 7.2K) - tsParticles - Easily create highly customizable JavaScript particles.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/tsparticles/tsparticles) (👨‍💻 88 · 🔀 800 · 📥 510 · 📦 32K · 📋 410 - 2% open · ⏱️ 12.05.2024):

	```
	git clone https://github.com/matteobruni/tsparticles
	```
- [npm](https://www.npmjs.com/package/tsparticles) (📥 200K / month · 📦 140 · ⏱️ 12.05.2024):
	```
	npm install tsparticles
	```
</details>
<details><summary><b><a href="https://github.com/mkosir/react-parallax-tilt">react-parallax-tilt</a></b> (🥉29 ·  ⭐ 930) - Easily apply tilt hover effect on React components -.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mkosir/react-parallax-tilt) (👨‍💻 15 · 🔀 110 · 📦 25K · ⏱️ 25.05.2024):

	```
	git clone https://github.com/mkosir/react-parallax-tilt
	```
- [npm](https://www.npmjs.com/package/react-parallax-tilt) (📥 120K / month · 📦 37 · ⏱️ 25.05.2024):
	```
	npm install react-parallax-tilt
	```
</details>
<details><summary>Show 8 hidden projects...</summary>

- <b><a href="https://github.com/chenglou/react-motion">react-motion</a></b> (🥈35 ·  ⭐ 22K · 💀) - A spring that solves your animation problems. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/joshwcomeau/react-flip-move">react-flip-move</a></b> (🥈31 ·  ⭐ 4K · 💀) - Effortless animation between DOM changes (eg. list.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/sghall/react-move">React-Move</a></b> (🥉29 ·  ⭐ 6.6K · 💀) - React Move | Beautiful, data-driven animations for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/maisano/react-router-transition">react-router-transition</a></b> (🥉26 ·  ⭐ 2.6K · 💀) - painless transitions built for react-router, powered.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/plus1tv/react-anime">react-anime</a></b> (🥉25 ·  ⭐ 1.5K · 💀) - ()*: A super easy animation library for React!. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/lindelof/particles-bg">particles-bg</a></b> (🥉18 ·  ⭐ 640 · 💀) - React particles animation background component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/luukdv/gooey-react">gooey-react</a></b> (🥉16 ·  ⭐ 640 · 💀) - The gooey effect for React, used for shape blobbing / metaballs.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/teodosii/react-tweenful">react-tweenful</a></b> (🥉9 ·  ⭐ 86 · 💀) - Animation engine designed for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Data Visualization

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Data visualization, chart and diagram components._

<details><summary><b><a href="https://github.com/mrdoob/three.js">three.js</a></b> (🥇51 ·  ⭐ 100K · 📈) - JavaScript 3D Library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mrdoob/three.js) (👨‍💻 2.3K · 🔀 35K · 📦 330K · 📋 12K - 3% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/mrdoob/three.js
	```
- [npm](https://www.npmjs.com/package/three) (📥 5.5M / month · 📦 7.1K · ⏱️ 31.05.2024):
	```
	npm install three
	```
</details>
<details><summary><b><a href="https://github.com/chartjs/Chart.js">Chart.js</a></b> (🥇47 ·  ⭐ 64K) - Simple HTML5 Charts using the canvas tag. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/chartjs/Chart.js) (👨‍💻 500 · 🔀 12K · 📥 13M · 📦 960K · 📋 7.1K - 5% open · ⏱️ 31.05.2024):

	```
	git clone https://github.com/chartjs/Chart.js
	```
- [npm](https://www.npmjs.com/package/chart.js) (📥 14M / month · 📦 3.2K · ⏱️ 17.05.2024):
	```
	npm install chart.js
	```
</details>
<details><summary><b><a href="https://github.com/d3/d3">d3</a></b> (🥇46 ·  ⭐ 110K) - Bring data to life with SVG, Canvas and HTML. <code><a href="http://bit.ly/3hkKRql">ISC</a></code></summary>

- [GitHub](https://github.com/d3/d3) (👨‍💻 150 · 🔀 23K · 📥 740K · 📦 370K · 📋 2.2K - 0% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/d3/d3
	```
- [npm](https://www.npmjs.com/package/d3) (📥 13M / month · 📦 9.7K · ⏱️ 12.03.2024):
	```
	npm install d3
	```
</details>
<details><summary><b><a href="https://github.com/mermaid-js/mermaid">mermaid</a></b> (🥇45 ·  ⭐ 68K) - Generation of diagrams like flowcharts or sequence diagrams from text in a.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mermaid-js/mermaid) (👨‍💻 630 · 🔀 5.9K · 📦 48K · 📋 2.9K - 33% open · ⏱️ 24.05.2024):

	```
	git clone https://github.com/mermaid-js/mermaid
	```
- [npm](https://www.npmjs.com/package/mermaid) (📥 2.8M / month · 📦 1K · ⏱️ 14.05.2024):
	```
	npm install mermaid
	```
</details>
<details><summary><b><a href="https://github.com/recharts/recharts">Recharts</a></b> (🥇45 ·  ⭐ 23K) - Redefined chart library built with React and D3. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/recharts/recharts) (👨‍💻 330 · 🔀 1.7K · 📦 240K · 📋 3K - 17% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/recharts/recharts
	```
- [npm](https://www.npmjs.com/package/recharts) (📥 7.1M / month · 📦 1.8K · ⏱️ 02.06.2024):
	```
	npm install recharts
	```
</details>
<details><summary><b><a href="https://github.com/apache/echarts">echarts</a></b> (🥈40 ·  ⭐ 59K) - Apache ECharts is a powerful, interactive charting and data.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/apache/echarts) (👨‍💻 270 · 🔀 20K · 📦 270K · 📋 18K - 12% open · ⏱️ 21.05.2024):

	```
	git clone https://github.com/apache/echarts
	```
- [npm](https://www.npmjs.com/package/@mempool/echarts) (📥 12 / month · 📦 5 · ⏱️ 23.10.2021):
	```
	npm install @mempool/echarts
	```
</details>
<details><summary><b><a href="https://github.com/FormidableLabs/victory">Victory</a></b> (🥈40 ·  ⭐ 11K) - A collection of composable React components for building interactive data.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/FormidableLabs/victory) (👨‍💻 320 · 🔀 520 · 📦 24K · 📋 1.9K - 5% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/FormidableLabs/victory
	```
- [npm](https://www.npmjs.com/package/victory) (📥 990K / month · 📦 350 · ⏱️ 16.05.2024):
	```
	npm install victory
	```
</details>
<details><summary><b><a href="https://github.com/pmndrs/react-three-fiber">react-three-fiber</a></b> (🥈39 ·  ⭐ 26K) - A React renderer for Three.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/pmndrs/react-three-fiber) (👨‍💻 200 · 🔀 1.5K · 📦 26K · 📋 990 - 5% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/pmndrs/react-three-fiber
	```
- [npm](https://www.npmjs.com/package/react-three-fiber) (📥 220K / month · 📦 180 · ⏱️ 11.04.2021):
	```
	npm install react-three-fiber
	```
</details>
<details><summary><b><a href="https://github.com/apexcharts/apexcharts.js">apexcharts.js</a></b> (🥈39 ·  ⭐ 14K) - Interactive JavaScript Charts built on SVG. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/apexcharts/apexcharts.js) (👨‍💻 200 · 🔀 1.3K · 📦 4 · 📋 3.3K - 9% open · ⏱️ 01.06.2024):

	```
	git clone https://github.com/apexcharts/apexcharts.js
	```
- [npm](https://www.npmjs.com/package/apexcharts) (📥 3.4M / month · 📦 830 · ⏱️ 12.05.2024):
	```
	npm install apexcharts
	```
</details>
<details><summary><b><a href="https://github.com/plouc/nivo">nivo</a></b> (🥈38 ·  ⭐ 13K) - nivo provides a rich set of dataviz components, built on top of the awesome d3.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/plouc/nivo) (👨‍💻 210 · 🔀 1K · 📦 1.9K · 📋 1.7K - 6% open · ⏱️ 12.05.2024):

	```
	git clone https://github.com/plouc/nivo
	```
- [npm](https://www.npmjs.com/package/@nivo/core) (📥 1.7M / month · 📦 260 · ⏱️ 12.05.2024):
	```
	npm install @nivo/core
	```
</details>
<details><summary><b><a href="https://github.com/airbnb/visx">visx</a></b> (🥈36 ·  ⭐ 19K) - visx | visualization components. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/airbnb/visx) (👨‍💻 170 · 🔀 690 · 📦 2.5K · 📋 790 - 15% open · ⏱️ 29.05.2024):

	```
	git clone https://github.com/airbnb/visx
	```
- [npm](https://www.npmjs.com/package/@visx/group) (📥 2.7M / month · 📦 150 · ⏱️ 11.07.2023):
	```
	npm install @visx/group
	```
</details>
<details><summary><b><a href="https://github.com/reactchartjs/react-chartjs-2">React Chartjs 2</a></b> (🥈36 ·  ⭐ 6.4K · 💤) - React components for Chart.js, the most popular charting.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reactchartjs/react-chartjs-2) (👨‍💻 78 · 🔀 2.3K · 📦 340K · 📋 770 - 12% open · ⏱️ 30.10.2023):

	```
	git clone https://github.com/reactchartjs/react-chartjs-2
	```
- [npm](https://www.npmjs.com/package/react-chartjs-2) (📥 5.3M / month · 📦 1.3K · ⏱️ 09.01.2023):
	```
	npm install react-chartjs-2
	```
</details>
<details><summary><b><a href="https://github.com/ant-design/ant-design-charts">ant-design-charts</a></b> (🥈35 ·  ⭐ 1.8K) - A React Chart Library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://gw.alipayobjects.com/zos/rmsportal/KDpgvguMpGfqaHPjicRK.svg" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/ant-design/ant-design-charts) (👨‍💻 66 · 🔀 350 · 📦 10K · 📋 1.8K - 11% open · ⏱️ 06.05.2024):

	```
	git clone https://github.com/ant-design/ant-design-charts
	```
- [npm](https://www.npmjs.com/package/@ant-design/charts) (📥 220K / month · 📦 180 · ⏱️ 06.05.2024):
	```
	npm install @ant-design/charts
	```
</details>
<details><summary><b><a href="https://github.com/uber/react-vis">react-vis</a></b> (🥈33 ·  ⭐ 8.7K · 💤) - Data Visualization Components. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uber/react-vis) (👨‍💻 130 · 🔀 830 · 📦 13K · 📋 860 - 40% open · ⏱️ 08.06.2023):

	```
	git clone https://github.com/uber/react-vis
	```
- [npm](https://www.npmjs.com/package/react-vis) (📥 270K / month · 📦 190 · ⏱️ 08.06.2023):
	```
	npm install react-vis
	```
</details>
<details><summary><b><a href="https://github.com/rakannimer/react-google-charts">react-google-charts</a></b> (🥈33 ·  ⭐ 1.6K · 💤) - A thin, typed, React wrapper over Google Charts.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/rakannimer/react-google-charts) (👨‍💻 52 · 🔀 340 · 📦 29K · 📋 380 - 37% open · ⏱️ 20.07.2023):

	```
	git clone https://github.com/RakanNimer/react-google-charts
	```
- [npm](https://www.npmjs.com/package/react-google-charts) (📥 510K / month · 📦 180 · ⏱️ 20.07.2023):
	```
	npm install react-google-charts
	```
</details>
<details><summary><b><a href="https://github.com/hustcc/echarts-for-react">echarts-for-react</a></b> (🥉32 ·  ⭐ 4.4K) - Apache ECharts components for React wrapper. Apache echarts.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/hustcc/echarts-for-react) (👨‍💻 31 · 🔀 620 · 📦 24K · 📋 500 - 10% open · ⏱️ 17.02.2024):

	```
	git clone https://github.com/hustcc/echarts-for-react
	```
- [npm](https://www.npmjs.com/package/echarts-for-react) (📥 1.2M / month · 📦 740 · ⏱️ 29.10.2021):
	```
	npm install echarts-for-react
	```
</details>
<details><summary><b><a href="https://github.com/apexcharts/react-apexcharts">React ApexCharts</a></b> (🥉32 ·  ⭐ 1.3K) - React Component for ApexCharts. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/apexcharts/react-apexcharts) (👨‍💻 26 · 🔀 150 · 📦 110K · 📋 470 - 61% open · ⏱️ 22.05.2024):

	```
	git clone https://github.com/apexcharts/react-apexcharts
	```
- [npm](https://www.npmjs.com/package/react-apexcharts) (📥 1.7M / month · 📦 420 · ⏱️ 13.07.2023):
	```
	npm install react-apexcharts
	```
</details>
<details><summary><b><a href="https://github.com/carbon-design-system/carbon-charts">carbon-charts</a></b> (🥉32 ·  ⭐ 870) - Robust dataviz framework implemented using D3 & typescript. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/carbon-design-system/carbon-charts) (👨‍💻 77 · 🔀 180 · 📦 1.1K · 📋 880 - 21% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/carbon-design-system/carbon-charts
	```
- [npm](https://www.npmjs.com/package/@carbon/charts) (📥 170K / month · 📦 33 · ⏱️ 03.06.2024):
	```
	npm install @carbon/charts
	```
</details>
<details><summary><b><a href="https://github.com/alibaba/BizCharts">BizCharts</a></b> (🥉30 ·  ⭐ 6.1K · 💤) - Powerful data visualization library based on G2 and React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/alibaba/BizCharts) (👨‍💻 80 · 🔀 680 · 📦 15K · 📋 1.4K - 25% open · ⏱️ 13.10.2023):

	```
	git clone https://github.com/alibaba/BizCharts
	```
- [npm](https://www.npmjs.com/package/bizcharts) (📥 100K / month · 📦 790 · ⏱️ 13.10.2023):
	```
	npm install bizcharts
	```
</details>
<details><summary><b><a href="https://github.com/frappe/charts">charts</a></b> (🥉29 ·  ⭐ 15K · 💤) - Simple, responsive, modern SVG Charts with zero dependencies. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/frappe/charts) (👨‍💻 55 · 🔀 720 · 📦 6 · 📋 300 - 48% open · ⏱️ 27.09.2023):

	```
	git clone https://github.com/frappe/charts
	```
- [npm](https://www.npmjs.com/package/frappe-charts) (📥 50K / month · 📦 56 · ⏱️ 14.11.2022):
	```
	npm install frappe-charts
	```
</details>
<details><summary><b><a href="https://github.com/projectstorm/react-diagrams">react-diagrams</a></b> (🥉29 ·  ⭐ 8.4K) - a super simple, no-nonsense diagramming library written in react.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/projectstorm/react-diagrams) (👨‍💻 95 · 🔀 1.2K · 📦 3 · 📋 810 - 38% open · ⏱️ 19.02.2024):

	```
	git clone https://github.com/projectstorm/react-diagrams
	```
- [npm](https://www.npmjs.com/package/@projectstorm/react-diagrams) (📥 110K / month · 📦 41 · ⏱️ 15.02.2024):
	```
	npm install @projectstorm/react-diagrams
	```
</details>
<details><summary><b><a href="https://github.com/wa0x6e/cal-heatmap">cal-heatmap</a></b> (🥉29 ·  ⭐ 2.6K · 📉) - Cal-Heatmap is a javascript charting library to create a time-.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/wa0x6e/cal-heatmap) (👨‍💻 27 · 🔀 280 · 📦 480 · 📋 320 - 12% open · ⏱️ 03.03.2024):

	```
	git clone https://github.com/wa0x6e/cal-heatmap
	```
- [npm](https://www.npmjs.com/package/cal-heatmap) (📥 25K / month · 📦 8 · ⏱️ 03.03.2024):
	```
	npm install cal-heatmap
	```
</details>
<details><summary><b><a href="https://github.com/nteract/semiotic">Semiotic</a></b> (🥉29 ·  ⭐ 2.4K) - A data visualization framework combining React & D3. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/nteract/semiotic) (👨‍💻 31 · 🔀 130 · 📦 420 · 📋 460 - 8% open · ⏱️ 09.04.2024):

	```
	git clone https://github.com/nteract/semiotic
	```
- [npm](https://www.npmjs.com/package/semiotic) (📥 5.9K / month · 📦 18 · ⏱️ 10.04.2024):
	```
	npm install semiotic
	```
</details>
<details><summary><b><a href="https://github.com/reaviz/reaviz">Reaviz</a></b> (🥉28 ·  ⭐ 930) - Data visualization library for React. Maintained by @goodcodeus. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/reaviz/reaviz) (👨‍💻 27 · 🔀 110 · 📦 490 · 📋 67 - 41% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/reaviz/reaviz
	```
- [npm](https://www.npmjs.com/package/reaviz) (📥 24K / month · 📦 9 · ⏱️ 05.06.2024):
	```
	npm install reaviz
	```
</details>
<details><summary><b><a href="https://github.com/jerosoler/Drawflow">Drawflow</a></b> (🥉27 ·  ⭐ 4.3K) - Simple flow library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jerosoler/Drawflow) (👨‍💻 13 · 🔀 680 · 📦 420 · 📋 820 - 25% open · ⏱️ 08.03.2024):

	```
	git clone https://github.com/jerosoler/Drawflow
	```
- [npm](https://www.npmjs.com/package/drawflow) (📥 44K / month · 📦 5 · ⏱️ 30.06.2022):
	```
	npm install drawflow
	```
</details>
<details><summary>Show 12 hidden projects...</summary>

- <b><a href="https://github.com/elastic/elastic-charts">elastic-charts</a></b> (🥉32 ·  ⭐ 360) - Elastic Charts library. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/kirjs/react-highcharts">react-highcharts</a></b> (🥉30 ·  ⭐ 1.3K · 💀) - React wrapper for Highcharts library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/borisyankov/react-sparklines">react-sparklines</a></b> (🥉29 ·  ⭐ 2.8K · 💀) - Beautiful and expressive Sparklines React component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/viserjs/viser">Viser</a></b> (🥉27 ·  ⭐ 1.6K · 💀) - viser is a toolkit fit for data vis engineer. https://viserjs.gitee.io/. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/esnet/react-timeseries-charts">react-timeseries-charts</a></b> (🥉26 ·  ⭐ 850 · 💀) - Declarative and modular timeseries charting.. <code><a href="https://tldrlegal.com/search?q=BSD-3-Clause-LBNL">❗️BSD-3-Clause-LBNL</a></code>
- <b><a href="https://github.com/syncfusion/ej2-react-ui-components">ej2-react-ui-components</a></b> (🥉26 ·  ⭐ 330) - Syncfusion React UI components library offer more.. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/alibaba/GGEditor">GGEditor</a></b> (🥉25 ·  ⭐ 3.4K · 💀) - A visual graph editor based on G6 and React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/fraserxu/react-chartist">react-chartist</a></b> (🥉24 ·  ⭐ 530 · 💀) - React component for Chartist.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/rumble-charts/rumble-charts">rumble-charts</a></b> (🥉21 ·  ⭐ 350 · 💀) - React components for building composable and flexible charts. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/dunnock/react-sigma">react-sigma</a></b> (🥉21 ·  ⭐ 260 · 💀) - Lightweight React library for drawing network graphs built on top.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/kis/chartify">chartify</a></b> (🥉17 ·  ⭐ 690 · 💀) - React.js plugin for building charts using CSS. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/99ff00/react-charty">react-charty</a></b> (🥉12 ·  ⭐ 71 · 💀) - Data Visualization Component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Data Fetching

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/apollographql/apollo-client">apollo-client</a></b> (🥇45 ·  ⭐ 19K) - A fully-featured, production ready caching GraphQL client for.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/apollographql/apollo-client) (👨‍💻 880 · 🔀 2.6K · 📦 180K · 📋 5.1K - 10% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/apollographql/apollo-client
	```
- [npm](https://www.npmjs.com/package/apollo-utilities) (📥 5.9M / month · 📦 710 · ⏱️ 09.05.2020):
	```
	npm install apollo-utilities
	```
</details>
<details><summary><b><a href="https://github.com/TanStack/query">react-query</a></b> (🥈43 ·  ⭐ 40K) - Powerful asynchronous state management, server-state utilities and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/TanStack/query) (👨‍💻 760 · 🔀 2.7K · 📦 2K · 📋 1.8K - 2% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/tannerlinsley/react-query
	```
- [npm](https://www.npmjs.com/package/react-query) (📥 6M / month · 📦 2.1K · ⏱️ 25.01.2023):
	```
	npm install react-query
	```
</details>
<details><summary><b><a href="https://github.com/vercel/swr">swr</a></b> (🥈41 ·  ⭐ 30K) - React Hooks for Data Fetching. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/vercel/swr) (👨‍💻 180 · 🔀 1.2K · 📦 280K · 📋 910 - 13% open · ⏱️ 31.05.2024):

	```
	git clone https://github.com/vercel/swr
	```
- [npm](https://www.npmjs.com/package/swr) (📥 9.3M / month · 📦 1.9K · ⏱️ 01.06.2024):
	```
	npm install swr
	```
</details>
<details><summary><b><a href="https://github.com/facebook/relay">relay</a></b> (🥉35 ·  ⭐ 18K) - Relay is a JavaScript framework for building data-driven React applications. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/facebook/relay) (👨‍💻 880 · 🔀 1.8K · 📦 3 · 📋 2.4K - 28% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/facebook/relay
	```
- [npm](https://www.npmjs.com/package/relay) (📥 940 / month · 📦 7 · ⏱️ 14.04.2013):
	```
	npm install relay
	```
</details>
<details><summary><b><a href="https://github.com/unjs/unstorage">unstorage</a></b> (🥉35 ·  ⭐ 1.6K) - Unstorage provides an async Key-Value storage API with conventional.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/unjs/unstorage) (👨‍💻 55 · 🔀 120 · 📦 170K · 📋 170 - 44% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/unjs/unstorage
	```
- [npm](https://www.npmjs.com/package/unstorage) (📥 3.5M / month · 📦 240 · ⏱️ 14.03.2024):
	```
	npm install unstorage
	```
</details>
<details><summary><b><a href="https://github.com/heroku/react-refetch">react-refetch</a></b> (🥉26 ·  ⭐ 3.4K) - A simple, declarative, and composable way to fetch data for React.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/heroku/react-refetch) (👨‍💻 74 · 🔀 140 · 📦 890 · 📋 150 - 32% open · ⏱️ 21.05.2024):

	```
	git clone https://github.com/heroku/react-refetch
	```
- [npm](https://www.npmjs.com/package/react-refetch) (📥 31K / month · 📦 38 · ⏱️ 20.01.2020):
	```
	npm install react-refetch
	```
</details>
<details><summary>Show 1 hidden projects...</summary>

- <b><a href="https://github.com/contiamo/restful-react">restful-react</a></b> (🥉24 ·  ⭐ 1.9K · 💀) - A consistent, declarative way of interacting with RESTful.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Notifications

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Toasts, snackbars, and notification system._

<details><summary><b><a href="https://github.com/fkhadra/react-toastify">React-Toastify</a></b> (🥇39 ·  ⭐ 12K) - React notification made easy !. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/fkhadra/react-toastify) (👨‍💻 95 · 🔀 670 · 📦 770K · 📋 800 - 14% open · ⏱️ 15.05.2024):

	```
	git clone https://github.com/fkhadra/react-toastify
	```
- [npm](https://www.npmjs.com/package/react-toastify) (📥 8.2M / month · 📦 3.1K · ⏱️ 15.03.2024):
	```
	npm install react-toastify
	```
</details>
<details><summary><b><a href="https://github.com/timolins/react-hot-toast">React Hot Toast</a></b> (🥈35 ·  ⭐ 9.3K) - Smoking Hot React Notifications. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/timolins/react-hot-toast) (👨‍💻 26 · 🔀 310 · 📦 290K · 📋 260 - 52% open · ⏱️ 22.01.2024):

	```
	git clone https://github.com/timolins/react-hot-toast
	```
- [npm](https://www.npmjs.com/package/react-hot-toast) (📥 3.7M / month · 📦 1K · ⏱️ 28.04.2023):
	```
	npm install react-hot-toast
	```
</details>
<details><summary><b><a href="https://github.com/iamhosseindhv/notistack">Notistack</a></b> (🥈32 ·  ⭐ 3.8K · 💤) - Highly customizable notification snackbars (toasts) that can.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/iamhosseindhv/notistack) (👨‍💻 49 · 🔀 290 · 📦 57K · 📋 430 - 10% open · ⏱️ 23.10.2023):

	```
	git clone https://github.com/iamhosseindhv/notistack
	```
- [npm](https://www.npmjs.com/package/notistack) (📥 3.2M / month · 📦 960 · ⏱️ 08.03.2023):
	```
	npm install notistack
	```
</details>
<details><summary><b><a href="https://github.com/LouisBarranqueiro/reapop">reapop</a></b> (🥉24 ·  ⭐ 1.5K) - A simple and customizable React notifications system. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/LouisBarranqueiro/reapop) (👨‍💻 19 · 🔀 80 · 📦 630 · 📋 97 - 2% open · ⏱️ 11.03.2024):

	```
	git clone https://github.com/LouisBarranqueiro/reapop
	```
- [npm](https://www.npmjs.com/package/reapop) (📥 15K / month · 📦 20 · ⏱️ 27.08.2023):
	```
	npm install reapop
	```
</details>
<details><summary>Show 5 hidden projects...</summary>

- <b><a href="https://github.com/jossmac/react-toast-notifications">react-toast-notifications</a></b> (🥈26 ·  ⭐ 2.2K · 💀) - A toast notification system for react. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/teodosii/react-notifications-component">react-notifications-component</a></b> (🥈26 ·  ⭐ 1.3K · 💀) - Delightful and highly customisable React Component to.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/Cogoport/cogo-toast">cogo-toast</a></b> (🥉20 ·  ⭐ 670 · 💀) - Beautiful, Zero Configuration, Toast Messages for React. Only ~.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/moharnadreza/react-toast">react-toast</a></b> (🥉17 ·  ⭐ 72 · 💀) - Minimal toast notifications for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/alexpermiakov/simple-react-notifications">simple-react-notifications</a></b> (🥉14 ·  ⭐ 60 · 💀) - Tiny React.js notification library (1kb gzip). <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## File Handling

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_File upload, download, and viewer components._

<details><summary><b><a href="https://github.com/transloadit/uppy">uppy</a></b> (🥇41 ·  ⭐ 28K) - The next open source file uploader for web browsers. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/transloadit/uppy) (👨‍💻 430 · 🔀 2K · 📦 24K · 📋 2.3K - 7% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/transloadit/uppy
	```
- [npm](https://www.npmjs.com/package/uppy) (📥 130K / month · 📦 59 · ⏱️ 04.06.2024):
	```
	npm install uppy
	```
</details>
<details><summary><b><a href="https://github.com/SheetJS/sheetjs">SheetJS</a></b> (🥈40 ·  ⭐ 35K) - SheetJS Spreadsheet Data Toolkit -- New home.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/SheetJS/sheetjs) (👨‍💻 200 · 🔀 8K · 📦 200K · 📋 2.4K - 5% open · ⏱️ 01.02.2024):

	```
	git clone https://github.com/SheetJS/sheetjs
	```
- [npm](https://www.npmjs.com/package/xlsx) (📥 9.2M / month · 📦 6.3K · ⏱️ 24.03.2022):
	```
	npm install xlsx
	```
</details>
<details><summary><b><a href="https://github.com/mac-s-g/react-json-view">react-json-view</a></b> (🥈32 ·  ⭐ 3.4K · 💤) - JSON viewer for react. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mac-s-g/react-json-view) (👨‍💻 33 · 🔀 520 · 📦 100K · 📋 270 - 65% open · ⏱️ 30.06.2023):

	```
	git clone https://github.com/mac-s-g/react-json-view
	```
- [npm](https://www.npmjs.com/package/react-json-view) (📥 2.4M / month · 📦 1.5K · ⏱️ 09.03.2021):
	```
	npm install react-json-view
	```
</details>
<details><summary><b><a href="https://github.com/rpldy/react-uploady">react-uploady</a></b> (🥉25 ·  ⭐ 1.1K) - Modern file uploading - components & hooks for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/rpldy/react-uploady) (👨‍💻 10 · 🔀 36 · 📦 760 · 📋 130 - 0% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/rpldy/react-uploady
	```
- [npm](https://www.npmjs.com/package/@rpldy/uploady) (📥 47K / month · 📦 25 · ⏱️ 16.05.2024):
	```
	npm install @rpldy/uploady
	```
</details>
<details><summary><b><a href="https://github.com/plangrid/react-file-viewer">react-file-viewer</a></b> (🥉24 ·  ⭐ 510) - Extendable file viewer for web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/plangrid/react-file-viewer) (👨‍💻 15 · 🔀 330 · 📦 2.5K · 📋 170 - 91% open · ⏱️ 30.01.2024):

	```
	git clone https://github.com/plangrid/react-file-viewer
	```
- [npm](https://www.npmjs.com/package/react-file-viewer) (📥 86K / month · 📦 64 · ⏱️ 13.11.2019):
	```
	npm install react-file-viewer
	```
</details>
<details><summary>Show 5 hidden projects...</summary>

- <b><a href="https://github.com/react-dropzone/react-dropzone">React Dropzone</a></b> (🥈36 ·  ⭐ 10K · 💀) - Simple HTML5 drag-drop zone with React.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-csv/react-csv">react-csv</a></b> (🥉31 ·  ⭐ 1.1K · 💀) - React components to build CSV files on the fly basing on.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/Yuvaleros/material-ui-dropzone">material-ui-dropzone</a></b> (🥉27 ·  ⭐ 480 · 💀) - A Material-UI file upload dropzone. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code>
- <b><a href="https://github.com/pqina/react-filepond">React FilePond</a></b> (🥉26 ·  ⭐ 1.8K · 💀) - A handy FilePond adapter component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/securedeveloper/react-data-export">React-Data-Export</a></b> (🥉23 ·  ⭐ 180 · 💀) - Export dataset in react. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Editor Components

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Editor components for code, text, images and more._

<details><summary><b><a href="https://github.com/ianstormtaylor/slate">Slate</a></b> (🥇41 ·  ⭐ 29K) - A completely customizable framework for building rich text editors... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ianstormtaylor/slate) (👨‍💻 570 · 🔀 3.2K · 📦 200K · 📋 3.1K - 20% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/ianstormtaylor/slate
	```
- [npm](https://www.npmjs.com/package/slate) (📥 3.2M / month · 📦 1.7K · ⏱️ 21.04.2024):
	```
	npm install slate
	```
</details>
<details><summary><b><a href="https://github.com/securingsincity/react-ace">React Ace</a></b> (🥇36 ·  ⭐ 4K) - React Ace Component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/securingsincity/react-ace) (👨‍💻 120 · 🔀 600 · 📥 1.2K · 📦 30K · 📋 510 - 40% open · ⏱️ 24.03.2024):

	```
	git clone https://github.com/securingsincity/react-ace
	```
- [npm](https://www.npmjs.com/package/react-ace) (📥 2M / month · 📦 1.3K · ⏱️ 24.03.2024):
	```
	npm install react-ace
	```
</details>
<details><summary><b><a href="https://github.com/ueberdosis/tiptap">tiptap</a></b> (🥇35 ·  ⭐ 24K) - The headless rich text editor framework for web artisans. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ueberdosis/tiptap) (👨‍💻 320 · 🔀 2K · 📦 4.8K · 📋 2.7K - 20% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/ueberdosis/tiptap
	```
- [npm](https://www.npmjs.com/package/magic-tiptap-extensions) (📥 6 / month · 📦 5 · ⏱️ 31.03.2021):
	```
	npm install magic-tiptap-extensions
	```
</details>
<details><summary><b><a href="https://github.com/xdan/jodit">jodit</a></b> (🥇35 ·  ⭐ 1.6K) - Jodit - Best WYSIWYG Editor for You. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/xdan/jodit) (👨‍💻 90 · 🔀 340 · 📦 8K · 📋 920 - 28% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/xdan/jodit
	```
- [npm](https://www.npmjs.com/package/jodit) (📥 280K / month · 📦 100 · ⏱️ 02.06.2024):
	```
	npm install jodit
	```
</details>
<details><summary><b><a href="https://github.com/codex-team/editor.js">editor.js</a></b> (🥈34 ·  ⭐ 27K) - A block-style editor with clean JSON output. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/codex-team/editor.js) (👨‍💻 54 · 🔀 2K · 📥 13K · 📋 1.5K - 41% open · ⏱️ 23.05.2024):

	```
	git clone https://github.com/codex-team/editor.js
	```
- [npm](https://www.npmjs.com/package/@editorjs/editorjs) (📥 320K / month · 📦 460 · ⏱️ 23.05.2024):
	```
	npm install @editorjs/editorjs
	```
</details>
<details><summary><b><a href="https://github.com/jpuri/react-draft-wysiwyg">react-draft-wysiwyg</a></b> (🥈34 ·  ⭐ 6.4K · 💤) - A Wysiwyg editor build on top of ReactJS and DraftJS... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jpuri/react-draft-wysiwyg) (👨‍💻 84 · 🔀 1.1K · 📦 42K · 📋 1.1K - 65% open · ⏱️ 12.06.2023):

	```
	git clone https://github.com/jpuri/react-draft-wysiwyg
	```
- [npm](https://www.npmjs.com/package/react-draft-wysiwyg) (📥 1.1M / month · 📦 730 · ⏱️ 17.07.2022):
	```
	npm install react-draft-wysiwyg
	```
</details>
<details><summary><b><a href="https://github.com/sekoyo/react-image-crop">react-image-crop</a></b> (🥈33 ·  ⭐ 3.8K) - A responsive image cropping tool for React. <code><a href="http://bit.ly/3hkKRql">ISC</a></code></summary>

- [GitHub](https://github.com/sekoyo/react-image-crop) (👨‍💻 73 · 🔀 340 · 📦 26K · 📋 440 - 12% open · ⏱️ 04.05.2024):

	```
	git clone https://github.com/DominicTobias/react-image-crop
	```
- [npm](https://www.npmjs.com/package/react-image-crop) (📥 1.7M / month · 📦 420 · ⏱️ 15.01.2024):
	```
	npm install react-image-crop
	```
</details>
<details><summary><b><a href="https://github.com/react-monaco-editor/react-monaco-editor">react-monaco-editor</a></b> (🥈33 ·  ⭐ 3.7K) - Monaco Editor for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-monaco-editor/react-monaco-editor) (👨‍💻 78 · 🔀 370 · 📦 15K · 📋 350 - 19% open · ⏱️ 01.06.2024):

	```
	git clone https://github.com/react-monaco-editor/react-monaco-editor
	```
- [npm](https://www.npmjs.com/package/react-monaco-editor) (📥 970K / month · 📦 620 · ⏱️ 09.12.2023):
	```
	npm install react-monaco-editor
	```
</details>
<details><summary><b><a href="https://github.com/uiwjs/react-codemirror">react-codemirror</a></b> (🥈33 ·  ⭐ 1.5K) - CodeMirror 6 component for React. @codemirror.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uiwjs/react-codemirror) (👨‍💻 43 · 🔀 120 · 📦 66K · 📋 330 - 37% open · ⏱️ 16.05.2024):

	```
	git clone https://github.com/uiwjs/react-codemirror
	```
- [npm](https://www.npmjs.com/package/@uiw/react-codemirror) (📥 2.3M / month · 📦 330 · ⏱️ 16.05.2024):
	```
	npm install @uiw/react-codemirror
	```
</details>
<details><summary><b><a href="https://github.com/uiwjs/react-md-editor">react-md-editor</a></b> (🥈30 ·  ⭐ 2K) - A simple markdown editor with preview, implemented with React.js.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uiwjs/react-md-editor) (👨‍💻 28 · 🔀 150 · 📦 9.2K · 📋 360 - 40% open · ⏱️ 28.03.2024):

	```
	git clone https://github.com/uiwjs/react-md-editor
	```
- [npm](https://www.npmjs.com/package/@uiw/react-md-editor) (📥 390K / month · 📦 590 · ⏱️ 12.03.2024):
	```
	npm install @uiw/react-md-editor
	```
</details>
<details><summary><b><a href="https://github.com/unlayer/react-email-editor">React Email Editor</a></b> (🥈29 ·  ⭐ 4.4K) - Drag-n-Drop Email Editor Component for React.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/unlayer/react-email-editor) (👨‍💻 12 · 🔀 710 · 📦 1.4K · 📋 330 - 59% open · ⏱️ 09.05.2024):

	```
	git clone https://github.com/unlayer/react-email-editor
	```
- [npm](https://www.npmjs.com/package/react-email-editor) (📥 230K / month · 📦 38 · ⏱️ 08.05.2024):
	```
	npm install react-email-editor
	```
</details>
<details><summary><b><a href="https://github.com/suren-atoyan/monaco-react">Monaco React</a></b> (🥈29 ·  ⭐ 3.5K) - Monaco Editor for React - use the monaco-editor in any React.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/suren-atoyan/monaco-react) (👨‍💻 41 · 🔀 250 · 📦 5 · 📋 470 - 28% open · ⏱️ 02.05.2024):

	```
	git clone https://github.com/suren-atoyan/monaco-react
	```
- [npm](https://www.npmjs.com/package/@monaco-editor/react) (📥 2.8M / month · 📦 1.4K · ⏱️ 06.10.2023):
	```
	npm install @monaco-editor/react
	```
</details>
<details><summary><b><a href="https://github.com/uber/react-digraph">react-digraph</a></b> (🥈29 ·  ⭐ 2.6K · 💤) - A library for creating directed graph editors. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uber/react-digraph) (👨‍💻 49 · 🔀 270 · 📦 340 · 📋 190 - 46% open · ⏱️ 05.09.2023):

	```
	git clone https://github.com/uber/react-digraph
	```
- [npm](https://www.npmjs.com/package/react-digraph) (📥 160K / month · 📦 15 · ⏱️ 05.09.2023):
	```
	npm install react-digraph
	```
</details>
<details><summary><b><a href="https://github.com/Ionaru/easy-markdown-editor">easy-markdown-editor</a></b> (🥈29 ·  ⭐ 2.3K) - EasyMDE: A simple, beautiful, and embeddable JavaScript.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Ionaru/easy-markdown-editor) (👨‍💻 110 · 🔀 300 · 📦 3 · 📋 420 - 56% open · ⏱️ 21.12.2023):

	```
	git clone https://github.com/Ionaru/easy-markdown-editor
	```
- [npm](https://www.npmjs.com/package/easymde) (📥 290K / month · 📦 87 · ⏱️ 21.12.2023):
	```
	npm install easymde
	```
</details>
<details><summary><b><a href="https://github.com/ProseMirror/prosemirror">prosemirror</a></b> (🥉28 ·  ⭐ 7.4K) - The ProseMirror WYSIWYM editor. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ProseMirror/prosemirror) (👨‍💻 36 · 🔀 320 · 📦 220 · 📋 1.3K - 9% open · ⏱️ 25.05.2024):

	```
	git clone https://github.com/ProseMirror/prosemirror
	```
- [npm](https://www.npmjs.com/package/prosemirror) (📥 12K / month · 📦 46 · ⏱️ 28.09.2017):
	```
	npm install prosemirror
	```
</details>
<details><summary><b><a href="https://github.com/remirror/remirror">remirror</a></b> (🥉28 ·  ⭐ 2.6K) - ProseMirror toolkit for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/remirror/remirror) (👨‍💻 79 · 🔀 230 · 📦 620 · 📋 670 - 27% open · ⏱️ 08.04.2024):

	```
	git clone https://github.com/remirror/remirror
	```
- [npm](https://www.npmjs.com/package/create-context-state) (📥 140K / month · 📦 20 · ⏱️ 12.12.2023):
	```
	npm install create-context-state
	```
</details>
<details><summary><b><a href="https://github.com/globocom/megadraft">megadraft</a></b> (🥉27 ·  ⭐ 1.2K · 💤) - Megadraft is a Rich Text editor built on top of Facebooks Draft.JS.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/globocom/megadraft) (👨‍💻 96 · 🔀 210 · 📦 300 · 📋 180 - 14% open · ⏱️ 31.10.2023):

	```
	git clone https://github.com/globocom/megadraft
	```
- [npm](https://www.npmjs.com/package/megadraft) (📥 10K / month · 📦 54 · ⏱️ 04.01.2023):
	```
	npm install megadraft
	```
</details>
<details><summary><b><a href="https://github.com/remcohaszing/monaco-yaml">Monaco Yaml</a></b> (🥉27 ·  ⭐ 240) - YAML plugin for the Monaco Editor. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/remcohaszing/monaco-yaml) (👨‍💻 26 · 🔀 66 · 📦 730 · 📋 120 - 2% open · ⏱️ 10.05.2024):

	```
	git clone https://github.com/remcohaszing/monaco-yaml
	```
- [npm](https://www.npmjs.com/package/monaco-yaml) (📥 910K / month · 📦 74 · ⏱️ 19.01.2024):
	```
	npm install monaco-yaml
	```
</details>
<details><summary><b><a href="https://github.com/liferay/alloy-editor">alloy-editor</a></b> (🥉26 ·  ⭐ 1.4K · 💤) - WYSIWYG editor based on CKEditor with completely.. <code><a href="http://bit.ly/37RvQcA">❗️LGPL-3.0</a></code></summary>

- [GitHub](https://github.com/liferay/alloy-editor) (👨‍💻 59 · 🔀 290 · 📥 9.9K · 📦 250 · 📋 840 - 11% open · ⏱️ 24.10.2023):

	```
	git clone https://github.com/liferay/alloy-editor
	```
- [npm](https://www.npmjs.com/package/alloyeditor) (📥 5.9K / month · 📦 8 · ⏱️ 24.10.2023):
	```
	npm install alloyeditor
	```
</details>
<details><summary><b><a href="https://github.com/antonmedv/codejar">codejar</a></b> (🥉23 ·  ⭐ 1.7K) - An embeddable code editor for the browser. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/antonmedv/codejar) (👨‍💻 26 · 🔀 110 · 📦 720 · 📋 76 - 11% open · ⏱️ 08.01.2024):

	```
	git clone https://github.com/antonmedv/codejar
	```
- [npm](https://www.npmjs.com/package/codejar) (📥 39K / month · 📦 51 · ⏱️ 03.08.2023):
	```
	npm install codejar
	```
</details>
<details><summary><b><a href="https://github.com/salgum1114/react-design-editor">react-design-editor</a></b> (🥉23 ·  ⭐ 1.5K) - React Design Editor has started to developed direct.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/salgum1114/react-design-editor) (👨‍💻 7 · 🔀 390 · 📦 52 · 📋 180 - 33% open · ⏱️ 18.01.2024):

	```
	git clone https://github.com/salgum1114/react-design-editor
	```
- [npm](https://www.npmjs.com/package/react-design-editor) (📥 770 / month · 📦 5 · ⏱️ 18.01.2024):
	```
	npm install react-design-editor
	```
</details>
<details><summary><b><a href="https://github.com/uiwjs/react-monacoeditor">react-monacoeditor</a></b> (🥉21 ·  ⭐ 280 · 💤) - Monaco Editor component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uiwjs/react-monacoeditor) (👨‍💻 7 · 🔀 24 · 📦 280 · 📋 30 - 60% open · ⏱️ 07.11.2023):

	```
	git clone https://github.com/jaywcjlove/react-monacoeditor
	```
- [npm](https://www.npmjs.com/package/@uiw/react-monacoeditor) (📥 7K / month · 📦 6 · ⏱️ 07.11.2023):
	```
	npm install @uiw/react-monacoeditor
	```
</details>
<details><summary><b><a href="https://github.com/edtr-io/edtr-io">edtr-io</a></b> (🥉19 ·  ⭐ 710) - Edtr.io is an open source WYSIWYG in-line web editor written in React. Its.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/edtr-io/edtr-io) (👨‍💻 18 · 🔀 35 · 📦 9 · 📋 220 - 27% open · ⏱️ 09.12.2023):

	```
	git clone https://github.com/edtr-io/edtr-io
	```
- [npm](https://www.npmjs.com/package/@edtr-io/store) (📥 40 / month · 📦 15 · ⏱️ 30.03.2023):
	```
	npm install @edtr-io/store
	```
</details>
<details><summary><b><a href="https://github.com/appleple/smartblock">smartblock</a></b> (🥉17 ·  ⭐ 310 · 💤) - intuitive block based wysiwyg editor built with React and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/appleple/smartblock) (👨‍💻 4 · 🔀 28 · 📦 19 · 📋 18 - 83% open · ⏱️ 20.06.2023):

	```
	git clone https://github.com/appleple/smartblock
	```
- [npm](https://www.npmjs.com/package/@steelydylan/smartblock) (📥 160 / month · 📦 5 · ⏱️ 20.06.2021):
	```
	npm install @steelydylan/smartblock
	```
</details>
<details><summary>Show 17 hidden projects...</summary>

- <b><a href="https://github.com/tinymce/tinymce">tinymce</a></b> (🥇40 ·  ⭐ 15K) - The worlds #1 JavaScript library for rich text.. <code><a href="https://tldrlegal.com/search?q=CNRI-Python-GPL-Compatible">❗️CNRI-Python-GPL-Compatible</a></code>
- <b><a href="https://github.com/facebookarchive/draft-js">Draft JS</a></b> (🥇39 ·  ⭐ 23K · 💀) - A React framework for building text editors. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/zenoamaro/react-quill">react-quill</a></b> (🥈34 ·  ⭐ 6.5K · 💀) - A Quill component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/ckeditor/ckeditor5-react">ckeditor5-react</a></b> (🥈31 ·  ⭐ 410) - Official CKEditor 5 React component. <code><a href="https://tldrlegal.com/search?q=CNRI-Python-GPL-Compatible">❗️CNRI-Python-GPL-Compatible</a></code>
- <b><a href="https://github.com/sstur/react-rte">react-rte</a></b> (🥈30 ·  ⭐ 2.9K · 💀) - Pure React rich text WYSIWYG editor based on draft-js. <code><a href="http://bit.ly/3hkKRql">ISC</a></code>
- <b><a href="https://github.com/andrerpena/react-mde">react-mde</a></b> (🥈29 ·  ⭐ 1.4K · 💀) - React Markdown Editor. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-page/react-page">ReactPage</a></b> (🥉28 ·  ⭐ 9.4K · 💀) - Next-gen, highly customizable content editor for the browser -.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-simple-code-editor/react-simple-code-editor">react-simple-code-editor</a></b> (🥉28 ·  ⭐ 1.5K · 💀) - Simple no-frills code editor with syntax highlighting. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/ricardo-ch/react-easy-crop">react-easy-crop</a></b> (🥉27 ·  ⭐ 2.2K · 💀) - Ricardo fork of https://valentinh.github.io/react-easy-.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/HarryChen0506/react-markdown-editor-lite">react-markdown-editor-lite</a></b> (🥉27 ·  ⭐ 1K · 💀) - a light-weight Markdown editor based on React... <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/RIP21/react-simplemde-editor">react-simplemde-editor</a></b> (🥉26 ·  ⭐ 760 · 💀) - React wrapper for simplemde (easymde) markdown editor. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/kazzkiq/CodeFlask">CodeFlask</a></b> (🥉25 ·  ⭐ 1.1K · 💀) - A micro code-editor for awesome web pages. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/ckeditor/ckeditor4-react">ckeditor4-react</a></b> (🥉24 ·  ⭐ 94) - Official CKEditor 4 React component. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/leejaen/react-lz-editor">react-lz-editor</a></b> (🥉22 ·  ⭐ 950 · 💀) - A multilingual react rich-text editor component includes.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/RD17/react-trumbowyg">react-trumbowyg</a></b> (🥉17 ·  ⭐ 140 · 💀) - React wrapper for lightweight WYSIWYG editor Trumbowyg. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/fritx/react-editor">react-editor</a></b> (🥉14 ·  ⭐ 55 · 💀) - Pure Rich-text Editor with TS & React-hooks. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/jsmmth/react-avatar-generator">react-avatar-generator</a></b> (🥉12 ·  ⭐ 66 · 💀) - Generate fun kaleidoscope for user avatars. <code>❗Unlicensed</code>
</details>
<br>

## Drag & Drop

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/atlassian/react-beautiful-dnd">react-beautiful-dnd</a></b> (🥇39 ·  ⭐ 33K) - Beautiful and accessible drag and drop for lists with.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/atlassian/react-beautiful-dnd) (👨‍💻 130 · 🔀 2.5K · 📦 120K · 📋 1.7K - 37% open · ⏱️ 03.04.2024):

	```
	git clone https://github.com/atlassian/react-beautiful-dnd
	```
- [npm](https://www.npmjs.com/package/react-beautiful-dnd) (📥 7M / month · 📦 2.3K · ⏱️ 30.08.2022):
	```
	npm install react-beautiful-dnd
	```
</details>
<details><summary><b><a href="https://github.com/SortableJS/Sortable">Sortable</a></b> (🥈38 ·  ⭐ 29K) - Reorderable drag-and-drop lists for modern browsers and touch devices. No.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/SortableJS/Sortable) (👨‍💻 180 · 🔀 3.7K · 📦 3 · 📋 1.8K - 25% open · ⏱️ 22.03.2024):

	```
	git clone https://github.com/SortableJS/Sortable
	```
- [npm](https://www.npmjs.com/package/sortablejs) (📥 6.4M / month · 📦 3.7K · ⏱️ 14.01.2024):
	```
	npm install sortablejs
	```
</details>
<details><summary><b><a href="https://github.com/react-grid-layout/react-draggable">react-draggable</a></b> (🥈36 ·  ⭐ 8.9K · 💤) - React draggable component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-grid-layout/react-draggable) (👨‍💻 72 · 🔀 1K · 📦 150K · 📋 530 - 43% open · ⏱️ 27.09.2023):

	```
	git clone https://github.com/react-grid-layout/react-draggable
	```
- [npm](https://www.npmjs.com/package/react-draggable) (📥 9.5M / month · 📦 2.8K · ⏱️ 27.09.2023):
	```
	npm install react-draggable
	```
</details>
<details><summary><b><a href="https://github.com/bokuweb/react-rnd">react-rnd</a></b> (🥈34 ·  ⭐ 3.8K) - A resizable and draggable component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/bokuweb/react-rnd) (👨‍💻 46 · 🔀 320 · 📦 9.6K · 📋 340 - 46% open · ⏱️ 26.05.2024):

	```
	git clone https://github.com/bokuweb/react-rnd
	```
- [npm](https://www.npmjs.com/package/react-rnd) (📥 850K / month · 📦 570 · ⏱️ 26.05.2024):
	```
	npm install react-rnd
	```
</details>
<details><summary><b><a href="https://github.com/clauderic/dnd-kit">dnd-kit</a></b> (🥉33 ·  ⭐ 12K) - The modern, lightweight, performant, accessible and extensible drag & drop.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/clauderic/dnd-kit) (👨‍💻 41 · 🔀 600 · 📦 60K · 📋 880 - 47% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/clauderic/dnd-kit
	```
- [npm](https://www.npmjs.com/package/@dnd-kit/core) (📥 6.7M / month · 📦 930 · ⏱️ 06.11.2023):
	```
	npm install @dnd-kit/core
	```
</details>
<details><summary><b><a href="https://github.com/tajo/react-movable">react-movable</a></b> (🥉27 ·  ⭐ 1.4K) - Drag and drop for your React lists and tables. Accessible. Tiny. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/tajo/react-movable) (👨‍💻 15 · 🔀 48 · 📦 5K · 📋 63 - 33% open · ⏱️ 28.02.2024):

	```
	git clone https://github.com/tajo/react-movable
	```
- [npm](https://www.npmjs.com/package/react-movable) (📥 230K / month · 📦 30 · ⏱️ 28.02.2024):
	```
	npm install react-movable
	```
</details>
<details><summary>Show 6 hidden projects...</summary>

- <b><a href="https://github.com/react-dnd/react-dnd">react-dnd</a></b> (🥇40 ·  ⭐ 21K · 💀) - Drag and Drop for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/haltu/muuri">muuri</a></b> (🥉31 ·  ⭐ 11K · 💀) - Infinite responsive, sortable, filterable and draggable layouts. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/frontend-collective/react-sortable-tree">react-sortable-tree</a></b> (🥉30 ·  ⭐ 4.9K · 💀) - Drag-and-drop sortable component for nested data and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/danielstocks/react-sortable">react-sortable</a></b> (🥉25 ·  ⭐ 640 · 💀) - A sortable list component built with React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/bevacqua/react-dragula">react-dragula</a></b> (🥉22 ·  ⭐ 990 · 💀) - Drag and drop so simple it hurts. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/bokuweb/react-sortable-pane">react-sortable-pane</a></b> (🥉22 ·  ⭐ 650 · 💀) - A sortable and resizable pane component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Developer Tools

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Tools to help with React development._

<details><summary><b><a href="https://github.com/webpack/webpack">Webpack</a></b> (🥇54 ·  ⭐ 64K) - A bundler for javascript and friends. Packs many modules into a few.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/webpack/webpack) (👨‍💻 910 · 🔀 8.7K · 📦 19M · 📋 9.9K - 2% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/webpack/webpack
	```
- [npm](https://www.npmjs.com/package/webpack) (📥 110M / month · 📦 340K · ⏱️ 20.03.2024):
	```
	npm install webpack
	```
</details>
<details><summary><b><a href="https://github.com/storybookjs/storybook">Storybook</a></b> (🥇52 ·  ⭐ 83K) - Storybook is a frontend workshop for building UI components and pages.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/storybookjs/storybook) (👨‍💻 2.3K · 🔀 9.1K · 📦 280K · 📋 13K - 15% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/storybookjs/storybook
	```
- [npm](https://www.npmjs.com/package/@storybook/react) (📥 21M / month · 📦 56K · ⏱️ 03.06.2024):
	```
	npm install @storybook/react
	```
</details>
<details><summary><b><a href="https://github.com/vitejs/vite">vite</a></b> (🥇48 ·  ⭐ 65K) - Next generation frontend tooling. Its fast!. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/vitejs/vite) (👨‍💻 980 · 🔀 5.8K · 📦 4.8M · 📋 7.2K - 8% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/vitejs/vite
	```
- [npm](https://www.npmjs.com/package/vite) (📥 53M / month · 📦 95K · ⏱️ 04.06.2024):
	```
	npm install vite
	```
</details>
<details><summary><b><a href="https://github.com/jsx-eslint/eslint-plugin-react">eslint-plugin-react</a></b> (🥇46 ·  ⭐ 8.8K) - React-specific linting rules for ESLint. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jsx-eslint/eslint-plugin-react) (👨‍💻 560 · 🔀 2.8K · 📦 15M · 📋 2.4K - 10% open · ⏱️ 14.05.2024):

	```
	git clone https://github.com/yannickcr/eslint-plugin-react
	```
- [npm](https://www.npmjs.com/package/eslint-plugin-react) (📥 79M / month · 📦 180K · ⏱️ 28.05.2024):
	```
	npm install eslint-plugin-react
	```
</details>
<details><summary><b><a href="https://github.com/evanw/esbuild">esbuild</a></b> (🥈45 ·  ⭐ 37K) - An extremely fast bundler for the web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/evanw/esbuild) (👨‍💻 110 · 🔀 1.1K · 📦 5.5M · 📋 3.4K - 12% open · ⏱️ 25.05.2024):

	```
	git clone https://github.com/evanw/esbuild
	```
- [npm](https://www.npmjs.com/package/esbuild) (📥 120M / month · 📦 36K · ⏱️ 25.05.2024):
	```
	npm install esbuild
	```
- [Go](https://pkg.go.dev/github.com/evanw/esbuild) (📦 350 · ⏱️ 25.05.2024):
	```
	go install github.com/evanw/esbuild
	```
</details>
<details><summary><b><a href="https://github.com/parcel-bundler/parcel">parcel</a></b> (🥈43 ·  ⭐ 43K) - The zero configuration build tool for the web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/parcel-bundler/parcel) (👨‍💻 430 · 🔀 2.3K · 📦 260K · 📋 5.4K - 13% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/parcel-bundler/parcel
	```
- [Conda](https://anaconda.org/conda-forge/parceljs) (📥 78K · ⏱️ 28.02.2024):
	```
	conda install -c conda-forge parceljs
	```
- [npm](https://www.npmjs.com/package/parcel) (📥 880K / month · 📦 8.6K · ⏱️ 05.06.2024):
	```
	npm install parcel
	```
</details>
<details><summary><b><a href="https://github.com/lerna/lerna">lerna</a></b> (🥈43 ·  ⭐ 35K) - Lerna is a fast, modern build system for managing and publishing multiple.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/lerna/lerna) (👨‍💻 360 · 🔀 2.2K · 📦 170K · 📋 2.6K - 13% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/lerna/lerna
	```
- [npm](https://www.npmjs.com/package/lerna) (📥 5M / month · 📦 12K · ⏱️ 13.05.2024):
	```
	npm install lerna
	```
</details>
<details><summary><b><a href="https://github.com/facebook/create-react-app">create-react-app</a></b> (🥈40 ·  ⭐ 100K · 💤) - Set up a modern web app by running one command. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/facebook/create-react-app) (👨‍💻 940 · 🔀 27K · 📦 13M · 📋 8.7K - 25% open · ⏱️ 14.06.2023):

	```
	git clone https://github.com/facebook/create-react-app
	```
- [npm](https://www.npmjs.com/package/@gd-uikit/react-scripts) (📥 4 / month · 📦 5 · ⏱️ 21.07.2023):
	```
	npm install @gd-uikit/react-scripts
	```
</details>
<details><summary><b><a href="https://github.com/teambit/bit">Bit</a></b> (🥈36 ·  ⭐ 18K) - Build, distribute, and collaborate on components. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/teambit/bit) (👨‍💻 85 · 🔀 910 · 📥 8.8K · 📦 6 · 📋 1.9K - 2% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/teambit/bit
	```
- [npm](https://www.npmjs.com/package/bit-bin) (📥 23K / month · 📦 100 · ⏱️ 08.07.2021):
	```
	npm install bit-bin
	```
</details>
<details><summary><b><a href="https://github.com/thebuilder/react-intersection-observer">react-intersection-observer</a></b> (🥈36 ·  ⭐ 4.9K) - React implementation of the Intersection Observer API.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/thebuilder/react-intersection-observer) (👨‍💻 52 · 🔀 180 · 📦 170K · ⏱️ 05.06.2024):

	```
	git clone https://github.com/thebuilder/react-intersection-observer
	```
- [npm](https://www.npmjs.com/package/react-intersection-observer) (📥 7.9M / month · 📦 1.1K · ⏱️ 03.05.2024):
	```
	npm install react-intersection-observer
	```
</details>
<details><summary><b><a href="https://github.com/styleguidist/react-styleguidist">react-styleguidist</a></b> (🥈35 ·  ⭐ 11K) - Isolated React component development environment with a.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/styleguidist/react-styleguidist) (👨‍💻 250 · 🔀 1.4K · 📦 11K · 📋 1.3K - 18% open · ⏱️ 19.01.2024):

	```
	git clone https://github.com/styleguidist/react-styleguidist
	```
- [npm](https://www.npmjs.com/package/react-styleguidist) (📥 260K / month · 📦 3.3K · ⏱️ 19.01.2024):
	```
	npm install react-styleguidist
	```
</details>
<details><summary><b><a href="https://github.com/gregberge/loadable-components">loadable-components</a></b> (🥈34 ·  ⭐ 7.6K) - The recommended Code Splitting library for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/gregberge/loadable-components) (👨‍💻 110 · 🔀 380 · 📦 36K · 📋 620 - 5% open · ⏱️ 20.04.2024):

	```
	git clone https://github.com/gregberge/loadable-components
	```
- [npm](https://www.npmjs.com/package/@loadable/component) (📥 1.8M / month · 📦 1K · ⏱️ 20.04.2024):
	```
	npm install @loadable/component
	```
</details>
<details><summary><b><a href="https://github.com/yarnpkg/berry">yarn</a></b> (🥈34 ·  ⭐ 7.2K) - Active development trunk for Yarn. <code><a href="http://bit.ly/3rqEWVr">BSD-2</a></code></summary>

- [GitHub](https://github.com/yarnpkg/berry) (👨‍💻 400 · 🔀 1K · 📥 450 · 📦 3 · 📋 3K - 25% open · ⏱️ 01.06.2024):

	```
	git clone https://github.com/yarnpkg/berry
	```
- [npm](https://www.npmjs.com/package/@yarnpkg/pnpify) (📥 94K / month · 📦 550 · ⏱️ 08.05.2024):
	```
	npm install @yarnpkg/pnpify
	```
</details>
<details><summary><b><a href="https://github.com/react-cosmos/react-cosmos">react-cosmos</a></b> (🥉33 ·  ⭐ 8.2K) - Sandbox for developing and testing UI components in isolation. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-cosmos/react-cosmos) (👨‍💻 150 · 🔀 340 · 📦 1.9K · 📋 490 - 1% open · ⏱️ 19.05.2024):

	```
	git clone https://github.com/react-cosmos/react-cosmos
	```
- [npm](https://www.npmjs.com/package/react-cosmos) (📥 83K / month · 📦 240 · ⏱️ 19.05.2024):
	```
	npm install react-cosmos
	```
</details>
<details><summary><b><a href="https://github.com/jsx-eslint/jsx-ast-utils">jsx-ast-utils</a></b> (🥉33 ·  ⭐ 160 · 💤) - AST utility module for statically analyzing JSX. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jsx-eslint/jsx-ast-utils) (👨‍💻 15 · 🔀 32 · 📦 14M · 📋 57 - 19% open · ⏱️ 29.07.2023):

	```
	git clone https://github.com/jsx-eslint/jsx-ast-utils
	```
- [npm](https://www.npmjs.com/package/jsx-ast-utils) (📥 76M / month · 📦 1.6K · ⏱️ 29.07.2023):
	```
	npm install jsx-ast-utils
	```
</details>
<details><summary><b><a href="https://github.com/electron-react-boilerplate/electron-react-boilerplate">electron-react-boilerplate</a></b> (🥉32 ·  ⭐ 23K · 💤) - A Foundation for Scalable Cross-Platform Apps. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/electron-react-boilerplate/electron-react-boilerplate) (👨‍💻 170 · 🔀 3.7K · 📥 7.1M · 📦 6 · 📋 1.9K - 6% open · ⏱️ 16.09.2023):

	```
	git clone https://github.com/electron-react-boilerplate/electron-react-boilerplate
	```
- [npm](https://www.npmjs.com/package/mib-browser) (📥 5 / month · 📦 3 · ⏱️ 17.01.2022):
	```
	npm install mib-browser
	```
</details>
<details><summary><b><a href="https://github.com/infinitered/reactotron">Reactotron</a></b> (🥉32 ·  ⭐ 15K) - A desktop app for inspecting your React JS and React Native projects... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/infinitered/reactotron) (👨‍💻 150 · 🔀 940 · 📥 32K · 📦 420 · 📋 590 - 26% open · ⏱️ 15.05.2024):

	```
	git clone https://github.com/infinitered/reactotron
	```
- [npm](https://www.npmjs.com/package/reactotron) (📥 1.3K / month · 📦 13 · ⏱️ 09.08.2016):
	```
	npm install reactotron
	```
</details>
<details><summary><b><a href="https://github.com/vercel/ncc">ncc</a></b> (🥉32 ·  ⭐ 9K) - Compile a Node.js project into a single file. Supports TypeScript, binary.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/vercel/ncc) (👨‍💻 59 · 🔀 280 · 📦 5 · 📋 570 - 36% open · ⏱️ 12.02.2024):

	```
	git clone https://github.com/vercel/ncc
	```
- [npm](https://www.npmjs.com/package/@vercel/ncc) (📥 1.6M / month · 📦 1.9K · ⏱️ 18.10.2023):
	```
	npm install @vercel/ncc
	```
</details>
<details><summary><b><a href="https://github.com/jsx-eslint/eslint-plugin-jsx-a11y">eslint-plugin-jsx-a11y</a></b> (🥉31 ·  ⭐ 3.3K) - Static AST checker for a11y rules on JSX elements. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jsx-eslint/eslint-plugin-jsx-a11y) (👨‍💻 130 · 🔀 630 · 📦 12M · 📋 480 - 22% open · ⏱️ 30.01.2024):

	```
	git clone https://github.com/jsx-eslint/eslint-plugin-jsx-a11y
	```
- [npm](https://www.npmjs.com/package/canglang-cli) (📥 5 / month · 📦 3 · ⏱️ 12.07.2021):
	```
	npm install canglang-cli
	```
</details>
<details><summary><b><a href="https://github.com/welldone-software/why-did-you-render">why-did-you-render</a></b> (🥉29 ·  ⭐ 11K) - why-did-you-render by Welldone Software monkey patches React.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/welldone-software/why-did-you-render) (👨‍💻 36 · 🔀 190 · 📦 11K · 📋 220 - 18% open · ⏱️ 28.04.2024):

	```
	git clone https://github.com/welldone-software/why-did-you-render
	```
- [npm](https://www.npmjs.com/package/why-did-you-render) (📥 1K / month · 📦 1 · ⏱️ 17.05.2020):
	```
	npm install why-did-you-render
	```
</details>
<details><summary><b><a href="https://github.com/dequelabs/axe-core-npm">axe-core-npm</a></b> (🥉27 ·  ⭐ 570) - Provides a method to inject and analyze web pages using axe. <code><a href="http://bit.ly/3postzC">MPL-2.0</a></code></summary>

- [GitHub](https://github.com/dequelabs/axe-core-npm) (👨‍💻 32 · 🔀 65 · 📦 92 · 📋 320 - 18% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/dequelabs/axe-core-npm
	```
- [npm](https://www.npmjs.com/package/@axe-core/webdriverjs) (📥 73K / month · 📦 28 · ⏱️ 04.06.2024):
	```
	npm install @axe-core/webdriverjs
	```
</details>
<details><summary><b><a href="https://github.com/Blazity/next-enterprise">next-enterprise</a></b> (🥉16 ·  ⭐ 5.7K) - An enterprise-grade Next.js boilerplate for high-performance,.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/Blazity/next-enterprise) (👨‍💻 11 · 🔀 1.3K · 📋 27 - 7% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/Blazity/next-enterprise
	```
</details>
<details><summary><b><a href="https://github.com/dataformsjs/dataformsjs">dataformsjs</a></b> (🥉16 ·  ⭐ 180 · 💤) - DataFormsJS A minimal JavaScript Framework, standalone React and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/dataformsjs/dataformsjs) (👨‍💻 6 · 🔀 22 · 📦 6 · ⏱️ 11.06.2023):

	```
	git clone https://github.com/dataformsjs/dataformsjs
	```
- [npm](https://www.npmjs.com/package/dataformsjs) (📥 250 / month · 📦 2 · ⏱️ 19.04.2023):
	```
	npm install dataformsjs
	```
</details>
<details><summary>Show 8 hidden projects...</summary>

- <b><a href="https://github.com/gaearon/react-hot-loader">react-hot-loader</a></b> (🥈38 ·  ⭐ 12K · 💀) - Tweak React components in real time. (Deprecated: use Fast.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/doczjs/docz">docz</a></b> (🥈34 ·  ⭐ 24K · 💀) - It has never been so easy to document your things!. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/jamiebuilds/react-loadable">react-loadable</a></b> (🥉32 ·  ⭐ 17K · 💀) - A higher order component for loading components with promises. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-boilerplate/react-boilerplate">react-boilerplate</a></b> (🥉27 ·  ⭐ 29K · 💀) - A highly scalable, offline-first foundation with the best.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/react-theming/storybook-addon-material-ui">Storybook Addon Material-UI</a></b> (🥉26 ·  ⭐ 570 · 💀) - Addon for storybook wich wrap material-ui components.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code>
- <b><a href="https://github.com/moroshko/react-scanner">react-scanner</a></b> (🥉21 ·  ⭐ 560 · 💀) - Extract React components and props usage from code. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/rvpanoz/luna">Luna</a></b> (🥉15 ·  ⭐ 1K · 💀) - Manage npm dependencies through a modern UI. <code><a href="http://bit.ly/2M0xdwT">❗️GPL-3.0</a></code>
- <b><a href="https://github.com/bareynol/mui-theme-creator">Material-UI Theme Creator</a></b> (🥉8 ·  ⭐ 440 · 💀) - A tool to help design and customize themes for the.. <code><a href="https://tldrlegal.com/search?q=0BSD">❗️0BSD</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code>
</details>
<br>

## Desktop Applications

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Tools to build web-app based desktop applications._

<details><summary><b><a href="https://github.com/tauri-apps/tauri">Tauri</a></b> (🥇39 ·  ⭐ 79K) - Build smaller, faster, and more secure desktop applications with a web.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/tauri-apps/tauri) (👨‍💻 370 · 🔀 2.3K · 📥 110K · 📦 630 · 📋 4.1K - 20% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/tauri-apps/tauri
	```
- [npm](https://www.npmjs.com/package/tauri) (📥 1.8K / month · 📦 12 · ⏱️ 24.05.2023):
	```
	npm install tauri
	```
- [Cargo](https://crates.io/crates/tauri-utils) (📥 150K / month · 📦 20 · ⏱️ 29.05.2024):
	```
	cargo install tauri-utils
	```
</details>
<details><summary><b><a href="https://github.com/electron/electron">Electron</a></b> (🥉34 ·  ⭐ 110K · 📉) - Build cross-platform desktop apps with JavaScript, HTML, and CSS. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/electron/electron) (👨‍💻 1.3K · 🔀 15K):

	```
	git clone https://github.com/electron/electron
	```
- [npm](https://www.npmjs.com/package/electron) (📥 2.9M / month · 📦 8.2K · ⏱️ 05.06.2024):
	```
	npm install electron
	```
</details>
<br>

## Utilities

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/axios/axios">axios</a></b> (🥇51 ·  ⭐ 100K) - Promise based HTTP client for the browser and node.js. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/axios/axios) (👨‍💻 460 · 🔀 11K · 📦 13M · 📋 4.7K - 15% open · ⏱️ 21.05.2024):

	```
	git clone https://github.com/axios/axios
	```
- [npm](https://www.npmjs.com/package/axios) (📥 210M / month · 📦 170K · ⏱️ 21.05.2024):
	```
	npm install axios
	```
</details>
<details><summary><b><a href="https://github.com/date-fns/date-fns">date-fns</a></b> (🥈47 ·  ⭐ 34K) - Modern JavaScript date utility library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/date-fns/date-fns) (👨‍💻 410 · 🔀 1.7K · 📦 3.1M · 📋 2K - 34% open · ⏱️ 13.05.2024):

	```
	git clone https://github.com/date-fns/date-fns
	```
- [npm](https://www.npmjs.com/package/date-fns) (📥 84M / month · 📦 20K · ⏱️ 18.03.2024):
	```
	npm install date-fns
	```
</details>
<details><summary><b><a href="https://github.com/lodash/lodash">lodash</a></b> (🥈45 ·  ⭐ 59K) - A modern JavaScript utility library delivering modularity, performance, &.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/lodash/lodash) (👨‍💻 330 · 🔀 7K · 📦 29M · 📋 4.3K - 1% open · ⏱️ 16.04.2024):

	```
	git clone https://github.com/lodash/lodash
	```
- [npm](https://www.npmjs.com/package/lodash) (📥 220M / month · 📦 100K · ⏱️ 20.02.2021):
	```
	npm install lodash
	```
</details>
<details><summary><b><a href="https://github.com/winstonjs/winston">winston</a></b> (🥉44 ·  ⭐ 22K) - A logger for just about everything. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/winstonjs/winston) (👨‍💻 400 · 🔀 1.8K · 📦 910K · 📋 1.5K - 33% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/winstonjs/winston
	```
- [npm](https://www.npmjs.com/package/winston) (📥 45M / month · 📦 29K · ⏱️ 24.03.2024):
	```
	npm install winston
	```
</details>
<details><summary><b><a href="https://github.com/jquense/yup">yup</a></b> (🥉40 ·  ⭐ 22K) - Dead simple Object schema validation. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jquense/yup) (👨‍💻 170 · 🔀 900 · 📦 800K · 📋 1.8K - 12% open · ⏱️ 15.03.2024):

	```
	git clone https://github.com/jquense/yup
	```
- [npm](https://www.npmjs.com/package/yup) (📥 24M / month · 📦 7K · ⏱️ 06.03.2024):
	```
	npm install yup
	```
</details>
<details><summary><b><a href="https://github.com/i18next/i18next">i18next</a></b> (🥉40 ·  ⭐ 7.5K) - i18next: learn once - translate everywhere. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/i18next/i18next) (👨‍💻 240 · 🔀 620 · 📦 280K · 📋 1.4K - 1% open · ⏱️ 20.05.2024):

	```
	git clone https://github.com/i18next/i18next
	```
- [npm](https://www.npmjs.com/package/i18next) (📥 23M / month · 📦 7.4K · ⏱️ 10.05.2024):
	```
	npm install i18next
	```
</details>
<details><summary><b><a href="https://github.com/pimterry/loglevel">loglevel</a></b> (🥉38 ·  ⭐ 2.6K) - Minimal lightweight logging for JavaScript, adding reliable log level.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/pimterry/loglevel) (👨‍💻 32 · 🔀 170 · 📦 7.8M · 📋 130 - 11% open · ⏱️ 31.01.2024):

	```
	git clone https://github.com/pimterry/loglevel
	```
- [npm](https://www.npmjs.com/package/loglevel) (📥 35M / month · 📦 1.7K · ⏱️ 26.01.2024):
	```
	npm install loglevel
	```
</details>
<details><summary><b><a href="https://github.com/log4js-node/log4js-node">log4js-node</a></b> (🥉35 ·  ⭐ 5.8K) - A port of log4js to node.js. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/log4js-node/log4js-node) (👨‍💻 180 · 🔀 780 · 📦 3 · 📋 850 - 10% open · ⏱️ 05.04.2024):

	```
	git clone https://github.com/log4js-node/log4js-node
	```
- [npm](https://www.npmjs.com/package/log4js) (📥 17M / month · 📦 6.6K · ⏱️ 08.03.2023):
	```
	npm install log4js
	```
</details>
<br>

## Testing

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/jestjs/jest">jest</a></b> (🥇48 ·  ⭐ 44K) - Delightful JavaScript Testing. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jestjs/jest) (👨‍💻 1.7K · 🔀 6.4K · 📦 13M · 📋 7.8K - 3% open · ⏱️ 30.05.2024):

	```
	git clone https://github.com/facebook/jest
	```
- [npm](https://www.npmjs.com/package/jest) (📥 99M / month · 📦 430K · ⏱️ 30.05.2024):
	```
	npm install jest
	```
</details>
<details><summary><b><a href="https://github.com/cypress-io/cypress">cypress</a></b> (🥈47 ·  ⭐ 46K) - Fast, easy and reliable testing for anything that runs in a browser. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/cypress-io/cypress) (👨‍💻 500 · 🔀 3.1K · 📥 700 · 📦 1.3M · 📋 14K - 10% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/cypress-io/cypress
	```
- [npm](https://www.npmjs.com/package/cypress) (📥 23M / month · 📦 10K · ⏱️ 04.06.2024):
	```
	npm install cypress
	```
</details>
<details><summary><b><a href="https://github.com/enzymejs/enzyme">enzyme</a></b> (🥈41 ·  ⭐ 20K) - JavaScript Testing utilities for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/enzymejs/enzyme) (👨‍💻 400 · 🔀 2K · 📦 560K · 📋 1.8K - 15% open · ⏱️ 23.02.2024):

	```
	git clone https://github.com/enzymejs/enzyme
	```
- [npm](https://www.npmjs.com/package/enzyme) (📥 7.6M / month · 📦 46K · ⏱️ 20.12.2019):
	```
	npm install enzyme
	```
</details>
<details><summary><b><a href="https://github.com/testing-library/react-testing-library">react-testing-library</a></b> (🥉36 ·  ⭐ 19K) - Simple and complete React DOM testing utilities that.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/testing-library/react-testing-library) (👨‍💻 180 · 🔀 1.1K · 📦 27K · 📋 780 - 5% open · ⏱️ 03.06.2024):

	```
	git clone https://github.com/testing-library/react-testing-library
	```
- [npm](https://www.npmjs.com/package/react-testing-library) (📥 210K / month · 📦 3.4K · ⏱️ 30.05.2019):
	```
	npm install react-testing-library
	```
</details>
<details><summary>Show 2 hidden projects...</summary>

- <b><a href="https://github.com/testing-library/react-hooks-testing-library">react-hooks-testing-library</a></b> (🥉33 ·  ⭐ 5.2K · 💀) - Simple and complete React hooks testing utilities.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/Raathigesh/majestic">majestic</a></b> (🥉27 ·  ⭐ 7.5K · 💀) - Zero config GUI for Jest. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Admin Dashboards

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Admin frontend frameworks, dashboards and templates._

<details><summary><b><a href="https://github.com/marmelab/react-admin">React Admin</a></b> (🥇42 ·  ⭐ 24K) - A frontend Framework for building data-driven applications.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/marmelab/react-admin) (👨‍💻 690 · 🔀 5.2K · 📦 20K · 📋 4.5K - 2% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/marmelab/react-admin
	```
- [npm](https://www.npmjs.com/package/react-admin) (📥 260K / month · 📦 400 · ⏱️ 03.06.2024):
	```
	npm install react-admin
	```
</details>
<details><summary><b><a href="https://github.com/ant-design/ant-design-pro">Ant Design Pro</a></b> (🥇35 ·  ⭐ 36K) - Use Ant Design like a Pro!. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://gw.alipayobjects.com/zos/rmsportal/KDpgvguMpGfqaHPjicRK.svg" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/ant-design/ant-design-pro) (👨‍💻 340 · 🔀 8.1K · 📦 2.7K · 📋 9.6K - 0% open · ⏱️ 04.06.2024):

	```
	git clone https://github.com/ant-design/ant-design-pro
	```
- [npm](https://www.npmjs.com/package/ant-design-pro) (📥 12K / month · 📦 100 · ⏱️ 08.05.2019):
	```
	npm install ant-design-pro
	```
</details>
<details><summary><b><a href="https://github.com/coreui/coreui-free-bootstrap-admin-template">coreui-free-bootstrap-admin-template</a></b> (🥈27 ·  ⭐ 12K) - Free Bootstrap Admin & Dashboard Template. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/coreui/coreui-free-bootstrap-admin-template) (👨‍💻 26 · 🔀 3.1K · 📥 1.4K · 📦 32 · 📋 490 - 1% open · ⏱️ 28.03.2024):

	```
	git clone https://github.com/coreui/coreui-free-bootstrap-admin-template
	```
- [npm](https://www.npmjs.com/package/@coreui/ajax) (📥 190 / month · 📦 10 · ⏱️ 28.02.2018):
	```
	npm install @coreui/ajax
	```
</details>
<details><summary><b><a href="https://github.com/devias-io/material-kit-react">Material Kit React</a></b> (🥈23 ·  ⭐ 5.2K) - React Dashboard made with Material UIs components. Our.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/devias-io/material-kit-react) (👨‍💻 12 · 🔀 2.3K · 📦 380 · 📋 54 - 7% open · ⏱️ 08.03.2024):

	```
	git clone https://github.com/devias-io/material-kit-react
	```
</details>
<details><summary><b><a href="https://github.com/flatlogic/react-dashboard">React Dashboard</a></b> (🥈17 ·  ⭐ 1.6K · 📉) - React Dashboard - isomorphic admin dashboard template.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/flatlogic/react-dashboard) (👨‍💻 150 · 🔀 370 · 📋 50 - 80% open · ⏱️ 25.03.2024):

	```
	git clone https://github.com/flatlogic/react-dashboard
	```
</details>
<details><summary><b><a href="https://github.com/flatlogic/react-material-admin">React Material Admin</a></b> (🥉14 ·  ⭐ 1.6K) - React Material Admin is a React template built with.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/flatlogic/react-material-admin) (👨‍💻 10 · 🔀 550 · 📋 47 - 59% open · ⏱️ 25.03.2024):

	```
	git clone https://github.com/flatlogic/react-material-admin
	```
</details>
<details><summary><b><a href="https://github.com/themesberg/volt-react-dashboard">Volt React Dashboard</a></b> (🥉14 ·  ⭐ 900 · 💤) - Free and open source React.js admin dashboard.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://getbootstrap.com/docs/5.0/assets/img/favicons/favicon-32x32.png" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/themesberg/volt-react-dashboard) (👨‍💻 4 · 🔀 370 · 📦 4 · 📋 23 - 69% open · ⏱️ 08.07.2023):

	```
	git clone https://github.com/themesberg/volt-react-dashboard
	```
- [npm](https://www.npmjs.com/package/@themesberg/volt-react-dashboard) (📥 59 / month · 📦 2 · ⏱️ 26.01.2021):
	```
	npm install @themesberg/volt-react-dashboard
	```
</details>
<details><summary><b><a href="https://github.com/uilibrary/matx-react">matx-react</a></b> (🥉13 ·  ⭐ 910) - Matx -Free and open-source React Material UI Admin Dashboard Template. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/uilibrary/matx-react) (👨‍💻 6 · 🔀 380 · 📋 37 - 21% open · ⏱️ 06.03.2024):

	```
	git clone https://github.com/uilibrary/matx-react
	```
</details>
<details><summary><b><a href="https://github.com/PlainAdmin/plain-free-bootstrap-admin-template">plain-free-bootstrap-admin-template</a></b> (🥉10 ·  ⭐ 340 · 💤) - Free Vanilla JavaScript Bootstrap 5 Admin and.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/PlainAdmin/plain-free-bootstrap-admin-template) (👨‍💻 4 · 🔀 43 · ⏱️ 01.09.2023):

	```
	git clone https://github.com/PlainAdmin/plain-free-bootstrap-admin-template
	```
</details>
<details><summary>Show 2 hidden projects...</summary>

- <b><a href="https://github.com/dunky11/react-saas-template">React SaaS Template</a></b> (🥉16 ·  ⭐ 1.9K · 💀) - Template for building an SaaS / admin website using.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/creativetimofficial/notus-react">Notus React</a></b> (🥉14 ·  ⭐ 760 · 💀) - Notus React: Free Tailwind CSS UI Kit and Admin. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Other Components

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

_Collection of other components._

<details><summary><b><a href="https://github.com/sweetalert2/sweetalert2">sweetalert2</a></b> (🥇42 ·  ⭐ 17K) - A beautiful, responsive, highly customizable and accessible (WAI-.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/sweetalert2/sweetalert2) (👨‍💻 130 · 🔀 1.6K · 📥 1.3M · 📦 450K · 📋 1.6K - 0% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/sweetalert2/sweetalert2
	```
- [npm](https://www.npmjs.com/package/sweetalert2) (📥 2.5M / month · 📦 2.4K · ⏱️ 05.06.2024):
	```
	npm install sweetalert2
	```
</details>
<details><summary><b><a href="https://github.com/akiran/react-slick">react-slick</a></b> (🥇41 ·  ⭐ 12K) - React carousel component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/akiran/react-slick) (👨‍💻 160 · 🔀 2.1K · 📦 410K · 📋 1.8K - 26% open · ⏱️ 11.04.2024):

	```
	git clone https://github.com/akiran/react-slick
	```
- [npm](https://www.npmjs.com/package/react-slick) (📥 4.6M / month · 📦 2.2K · ⏱️ 17.02.2024):
	```
	npm install react-slick
	```
</details>
<details><summary><b><a href="https://github.com/xyflow/xyflow">React Flow</a></b> (🥇40 ·  ⭐ 22K) - React Flow |Svelte Flow - Powerful open source libraries for building.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/xyflow/xyflow) (👨‍💻 100 · 🔀 1.5K · 📥 52 · 📦 5.2K · 📋 1.8K - 8% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/wbkd/react-flow
	```
- [npm](https://www.npmjs.com/package/react-flow-renderer) (📥 500K / month · 📦 190 · ⏱️ 14.09.2022):
	```
	npm install react-flow-renderer
	```
</details>
<details><summary><b><a href="https://github.com/wojtekmaj/react-pdf">react-pdf</a></b> (🥇39 ·  ⭐ 8.8K) - Display PDFs in your React app as easily as if they were images. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/wojtekmaj/react-pdf) (👨‍💻 56 · 🔀 840 · 📦 61K · 📋 1.1K - 4% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/wojtekmaj/react-pdf
	```
- [npm](https://www.npmjs.com/package/react-pdf) (📥 4M / month · 📦 780 · ⏱️ 29.05.2024):
	```
	npm install react-pdf
	```
</details>
<details><summary><b><a href="https://github.com/gpbl/react-day-picker">react-day-picker</a></b> (🥇39 ·  ⭐ 5.8K) - DayPicker is a customizable date picker component for React... <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/gpbl/react-day-picker) (👨‍💻 160 · 🔀 700 · 📦 69K · 📋 840 - 1% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/gpbl/react-day-picker
	```
- [npm](https://www.npmjs.com/package/react-day-picker) (📥 5.9M / month · 📦 1.6K · ⏱️ 03.06.2024):
	```
	npm install react-day-picker
	```
</details>
<details><summary><b><a href="https://github.com/ReactTooltip/react-tooltip">react-tooltip</a></b> (🥇39 ·  ⭐ 3.5K) - React Tooltip Component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/ReactTooltip/react-tooltip) (👨‍💻 150 · 🔀 520 · 📦 98K · 📋 770 - 1% open · ⏱️ 08.05.2024):

	```
	git clone https://github.com/wwayne/react-tooltip
	```
- [npm](https://www.npmjs.com/package/react-tooltip) (📥 4.9M / month · 📦 2.2K · ⏱️ 09.05.2024):
	```
	npm install react-tooltip
	```
</details>
<details><summary><b><a href="https://github.com/jquense/react-big-calendar">react-big-calendar</a></b> (🥈38 ·  ⭐ 7.5K) - gcal/outlook like calendar component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/jquense/react-big-calendar) (👨‍💻 240 · 🔀 2.2K · 📦 39K · 📋 1.8K - 18% open · ⏱️ 14.05.2024):

	```
	git clone https://github.com/jquense/react-big-calendar
	```
- [npm](https://www.npmjs.com/package/react-big-calendar) (📥 1.2M / month · 📦 290 · ⏱️ 14.05.2024):
	```
	npm install react-big-calendar
	```
</details>
<details><summary><b><a href="https://github.com/wojtekmaj/react-calendar">react-calendar</a></b> (🥈37 ·  ⭐ 3.4K) - Ultimate calendar for your React app. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/wojtekmaj/react-calendar) (👨‍💻 40 · 🔀 490 · 📦 84K · 📋 550 - 6% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/wojtekmaj/react-calendar
	```
- [npm](https://www.npmjs.com/package/react-calendar) (📥 2.4M / month · 📦 540 · ⏱️ 29.04.2024):
	```
	npm install react-calendar
	```
</details>
<details><summary><b><a href="https://github.com/visgl/react-map-gl">react-map-gl</a></b> (🥈36 ·  ⭐ 7.6K) - React friendly API wrapper around MapboxGL JS. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/visgl/react-map-gl) (👨‍💻 180 · 🔀 1.3K · 📦 50K · 📋 1.1K - 7% open · ⏱️ 23.05.2024):

	```
	git clone https://github.com/visgl/react-map-gl
	```
- [npm](https://www.npmjs.com/package/react-map-gl) (📥 1.6M / month · 📦 520 · ⏱️ 18.12.2023):
	```
	npm install react-map-gl
	```
</details>
<details><summary><b><a href="https://github.com/reactjs/react-modal">react-modal</a></b> (🥈36 ·  ⭐ 7.3K) - Accessible modal dialog component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reactjs/react-modal) (👨‍💻 170 · 🔀 810 · 📦 400K · 📋 640 - 30% open · ⏱️ 12.02.2024):

	```
	git clone https://github.com/reactjs/react-modal
	```
- [npm](https://www.npmjs.com/package/react-modal) (📥 6.7M / month · 📦 3.4K · ⏱️ 18.10.2022):
	```
	npm install react-modal
	```
</details>
<details><summary><b><a href="https://github.com/reactjs/react-tabs">react-tabs</a></b> (🥈36 ·  ⭐ 3.1K) - An accessible and easy tab component for ReactJS. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/reactjs/react-tabs) (👨‍💻 71 · 🔀 440 · 📦 56K · 📋 280 - 21% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/reactjs/react-tabs
	```
- [npm](https://www.npmjs.com/package/react-tabs) (📥 3.9M / month · 📦 840 · ⏱️ 17.07.2023):
	```
	npm install react-tabs
	```
</details>
<details><summary><b><a href="https://github.com/sachinchoolur/lightGallery">lightGallery</a></b> (🥈35 ·  ⭐ 6.3K) - A customizable, modular, responsive, lightbox gallery plugin. <code><a href="http://bit.ly/2M0xdwT">❗️GPL-3.0</a></code></summary>

- [GitHub](https://github.com/sachinchoolur/lightGallery) (👨‍💻 73 · 🔀 1.3K · 📥 590 · 📦 11K · 📋 1.3K - 3% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/sachinchoolur/lightGallery
	```
- [npm](https://www.npmjs.com/package/lightgallery) (📥 270K / month · 📦 80 · ⏱️ 25.04.2024):
	```
	npm install lightgallery
	```
</details>
<details><summary><b><a href="https://github.com/remarkjs/react-markdown">react-markdown</a></b> (🥈34 ·  ⭐ 12K) - Markdown component for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/remarkjs/react-markdown) (👨‍💻 68 · 🔀 850 · 📦 270K · 📋 650 - 0% open · ⏱️ 25.03.2024):

	```
	git clone https://github.com/remarkjs/react-markdown
	```
- [npm](https://www.npmjs.com/package/react-markdown) (📥 12M / month · 📦 4.4K · ⏱️ 13.11.2023):
	```
	npm install react-markdown
	```
</details>
<details><summary><b><a href="https://github.com/FortAwesome/react-fontawesome">react-fontawesome</a></b> (🥈34 ·  ⭐ 3.7K) - Font Awesome React component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/FortAwesome/react-fontawesome) (👨‍💻 48 · 🔀 260 · 📋 350 - 32% open · ⏱️ 22.05.2024):

	```
	git clone https://github.com/FortAwesome/react-fontawesome
	```
- [npm](https://www.npmjs.com/package/@fortawesome/react-fontawesome) (📥 4.5M / month · 📦 6.7K · ⏱️ 22.05.2024):
	```
	npm install @fortawesome/react-fontawesome
	```
</details>
<details><summary><b><a href="https://github.com/danilowoz/react-content-loader">react-content-loader</a></b> (🥉33 ·  ⭐ 13K) - SVG-Powered component to easily create skeleton loadings. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/danilowoz/react-content-loader) (👨‍💻 49 · 🔀 410 · 📦 48K · 📋 140 - 10% open · ⏱️ 08.03.2024):

	```
	git clone https://github.com/danilowoz/react-content-loader
	```
- [npm](https://www.npmjs.com/package/react-content-loader) (📥 2.4M / month · 📦 620 · ⏱️ 08.03.2024):
	```
	npm install react-content-loader
	```
</details>
<details><summary><b><a href="https://github.com/xiaolin/react-image-gallery">react-image-gallery</a></b> (🥉33 ·  ⭐ 3.7K) - React carousel image gallery component with thumbnail.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/xiaolin/react-image-gallery) (👨‍💻 88 · 🔀 700 · 📦 31K · 📋 590 - 5% open · ⏱️ 27.02.2024):

	```
	git clone https://github.com/xiaolin/react-image-gallery
	```
- [npm](https://www.npmjs.com/package/react-image-gallery) (📥 730K / month · 📦 180 · ⏱️ 30.07.2023):
	```
	npm install react-image-gallery
	```
</details>
<details><summary><b><a href="https://github.com/fullcalendar/fullcalendar-react">fullcalendar-react</a></b> (🥉32 ·  ⭐ 1.9K · 📈) - The official React Component for FullCalendar. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/fullcalendar/fullcalendar-react) (👨‍💻 4 · 🔀 100 · 📦 42K · 📋 180 - 1% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/fullcalendar/fullcalendar-react
	```
- [npm](https://www.npmjs.com/package/@fullcalendar/react) (📥 1.5M / month · 📦 240 · ⏱️ 05.06.2024):
	```
	npm install @fullcalendar/react
	```
</details>
<details><summary><b><a href="https://github.com/appbaseio/reactivesearch">Reactive Search</a></b> (🥉31 ·  ⭐ 4.9K) - Search UI components for React and Vue. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/appbaseio/reactivesearch) (👨‍💻 73 · 🔀 470 · 📦 1.5K · 📋 1.1K - 15% open · ⏱️ 05.04.2024):

	```
	git clone https://github.com/appbaseio/reactivesearch
	```
- [npm](https://www.npmjs.com/package/@appbaseio/reactivesearch) (📥 18K / month · 📦 29 · ⏱️ 27.11.2023):
	```
	npm install @appbaseio/reactivesearch
	```
</details>
<details><summary><b><a href="https://github.com/video-react/video-react">video-react</a></b> (🥉31 ·  ⭐ 2.6K) - A web video player built for the HTML5 world using React library. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/video-react/video-react) (👨‍💻 33 · 🔀 390 · 📦 39K · 📋 350 - 38% open · ⏱️ 16.04.2024):

	```
	git clone https://github.com/video-react/video-react
	```
- [npm](https://www.npmjs.com/package/video-react) (📥 380K / month · 📦 280 · ⏱️ 09.11.2022):
	```
	npm install video-react
	```
</details>
<details><summary><b><a href="https://github.com/mosch/react-avatar-editor">react-avatar-editor</a></b> (🥉31 ·  ⭐ 2.3K) - Small avatar & profile picture component. Resize and crop.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/mosch/react-avatar-editor) (👨‍💻 71 · 🔀 370 · 📦 8.3K · 📋 250 - 8% open · ⏱️ 04.12.2023):

	```
	git clone https://github.com/mosch/react-avatar-editor
	```
- [npm](https://www.npmjs.com/package/react-avatar-editor) (📥 860K / month · 📦 180 · ⏱️ 20.12.2023):
	```
	npm install react-avatar-editor
	```
</details>
<details><summary><b><a href="https://github.com/searchkit/searchkit">searchkit</a></b> (🥉30 ·  ⭐ 4.7K) - Search UI for Elasticsearch & Opensearch. Compatible with.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/searchkit/searchkit) (👨‍💻 63 · 🔀 440 · 📦 770 · 📋 640 - 4% open · ⏱️ 08.05.2024):

	```
	git clone https://github.com/searchkit/searchkit
	```
- [npm](https://www.npmjs.com/package/searchkit) (📥 42K / month · 📦 31 · ⏱️ 04.05.2024):
	```
	npm install searchkit
	```
</details>
<details><summary><b><a href="https://github.com/siriwatknp/mui-treasury">Material-UI Treasury</a></b> (🥉26 ·  ⭐ 2.3K) - A collection of ready-to-use components based on.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code></summary>

- [GitHub](https://github.com/siriwatknp/mui-treasury) (👨‍💻 19 · 🔀 150 · 📦 680 · 📋 300 - 15% open · ⏱️ 28.04.2024):

	```
	git clone https://github.com/siriwatknp/mui-treasury
	```
- [npm](https://www.npmjs.com/package/@mui-treasury/components) (📥 6.2K / month · 📦 36 · ⏱️ 18.06.2021):
	```
	npm install @mui-treasury/components
	```
</details>
<details><summary><b><a href="https://github.com/dapi-labs/react-nice-avatar">react-nice-avatar</a></b> (🥉21 ·  ⭐ 1K) - react library for generating avatar. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/dapi-labs/react-nice-avatar) (👨‍💻 10 · 🔀 82 · 📦 600 · 📋 25 - 8% open · ⏱️ 21.12.2023):

	```
	git clone https://github.com/dapilab/react-nice-avatar
	```
- [npm](https://www.npmjs.com/package/react-nice-avatar) (📥 7.9K / month · 📦 2 · ⏱️ 28.11.2023):
	```
	npm install react-nice-avatar
	```
</details>
<details><summary>Show 15 hidden projects...</summary>

- <b><a href="https://github.com/DevExpress/DevExtreme">DevExtreme</a></b> (🥈38 ·  ⭐ 1.8K) - HTML5 JavaScript Component Suite for Responsive Web Development. <code><a href="https://tldrlegal.com/search?q=Aladdin">❗️Aladdin</a></code>
- <b><a href="https://github.com/algolia/react-instantsearch">react-instantsearch</a></b> (🥈34 ·  ⭐ 3.6K · 💀) - Lightning-fast search for React and React Native.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/leandrowd/react-responsive-carousel">react-responsive-carousel</a></b> (🥈34 ·  ⭐ 2.6K · 💀) - React.js Responsive Carousel (with Swipe). <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/google-map-react/google-map-react">google-map-react</a></b> (🥉33 ·  ⭐ 6.3K · 💀) - Google map library for react that allows rendering.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/PaulLeCam/react-leaflet">react-leaflet</a></b> (🥉33 ·  ⭐ 5K) - React components for Leaflet maps. <code><a href="https://tldrlegal.com/search?q=Hippocratic-2.1">❗️Hippocratic-2.1</a></code>
- <b><a href="https://github.com/AdeleD/react-paginate">react-paginate</a></b> (🥉33 ·  ⭐ 2.7K · 💀) - A ReactJS component that creates a pagination. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/moroshko/react-autosuggest">react-autosuggest</a></b> (🥉32 ·  ⭐ 6K · 💀) - WAI-ARIA compliant React autosuggest component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/tomkp/react-split-pane">react-split-pane</a></b> (🥉32 ·  ⭐ 3.2K · 💀) - React split-pane component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/tjallingt/react-youtube">react-youtube</a></b> (🥉31 ·  ⭐ 1.8K · 💀) - react.js powered YouTube player component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/nkbt/react-copy-to-clipboard">react-copy-to-clipboard</a></b> (🥉30 ·  ⭐ 2.3K · 💀) - Copy-to-clipboard React component. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/lovasoa/react-contenteditable">react-contenteditable</a></b> (🥉29 ·  ⭐ 1.6K · 💀) - React component for a div with editable contents. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code>
- <b><a href="https://github.com/TeamWertarbyte/material-ui-chip-input">material-ui-chip-input</a></b> (🥉28 ·  ⭐ 740 · 💀) - A chip input field using Material-UI. <code><a href="http://bit.ly/34MBwT8">MIT</a></code> <code><img src="https://mui.com/static/favicon.ico" style="display:inline;" width="13" height="13"></code>
- <b><a href="https://github.com/MrBlenny/react-flow-chart">React Flow Chart</a></b> (🥉27 ·  ⭐ 1.5K · 💀) - A flexible, stateless, declarative flow chart library for.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/mozilla-frontend-infra/react-lazylog">React Lazylog</a></b> (🥉23 ·  ⭐ 290 · 💀) - React Lazy Logviewer. <code><a href="http://bit.ly/3postzC">MPL-2.0</a></code>
- <b><a href="https://github.com/RaoHai/react-ansi">React Ansi</a></b> (🥉13 ·  ⭐ 42 · 💀) - A foldable and searchable ansi log viewer for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
</details>
<br>

## Others

<a href="#contents"><img align="right" width="15" height="15" src="https://git.io/JtehR" alt="Back to top"></a>

<details><summary><b><a href="https://github.com/preactjs/preact">preact</a></b> (🥇45 ·  ⭐ 36K) - Fast 3kB React alternative with the same modern API. Components & Virtual.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/preactjs/preact) (👨‍💻 330 · 🔀 1.9K · 📥 1.6K · 📦 550K · 📋 1.9K - 11% open · ⏱️ 02.06.2024):

	```
	git clone https://github.com/preactjs/preact
	```
- [npm](https://www.npmjs.com/package/preact) (📥 16M / month · 📦 5.8K · ⏱️ 15.05.2024):
	```
	npm install preact
	```
</details>
<details><summary><b><a href="https://github.com/streamich/react-use">react-use</a></b> (🥇41 ·  ⭐ 41K) - React Hooks. <code><a href="http://bit.ly/3rvuUlR">Unlicense</a></code></summary>

- [GitHub](https://github.com/streamich/react-use) (👨‍💻 190 · 🔀 3.1K · 📦 90K · 📋 820 - 70% open · ⏱️ 22.01.2024):

	```
	git clone https://github.com/streamich/react-use
	```
- [npm](https://www.npmjs.com/package/react-use) (📥 7.3M / month · 📦 3.4K · ⏱️ 22.01.2024):
	```
	npm install react-use
	```
</details>
<details><summary><b><a href="https://github.com/react-icons/react-icons">react-icons</a></b> (🥈40 ·  ⭐ 11K) - svg react icons of popular icon packs. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-icons/react-icons) (👨‍💻 99 · 🔀 720 · 📥 260K · 📦 2.6M · 📋 600 - 31% open · ⏱️ 07.05.2024):

	```
	git clone https://github.com/react-icons/react-icons
	```
- [npm](https://www.npmjs.com/package/react-icons) (📥 9.1M / month · 📦 10K · ⏱️ 07.05.2024):
	```
	npm install react-icons
	```
</details>
<details><summary><b><a href="https://github.com/microsoft/FluidFramework">FluidFramework</a></b> (🥈35 ·  ⭐ 4.6K) - Library for building distributed, real-time collaborative web.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/microsoft/FluidFramework) (👨‍💻 260 · 🔀 520 · 📥 1.5K · 📦 440 · 📋 3.4K - 4% open · ⏱️ 06.06.2024):

	```
	git clone https://github.com/microsoft/FluidFramework
	```
- [npm](https://www.npmjs.com/package/@fluidframework/eslint-config-fluid) (📥 6.1K / month · 📦 180 · ⏱️ 27.04.2024):
	```
	npm install @fluidframework/eslint-config-fluid
	```
</details>
<details><summary><b><a href="https://github.com/react-syntax-highlighter/react-syntax-highlighter">react-syntax-highlighter</a></b> (🥈34 ·  ⭐ 3.9K · 💤) - syntax highlighting component for react with prismjs.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/react-syntax-highlighter/react-syntax-highlighter) (👨‍💻 63 · 🔀 270 · 📦 190K · 📋 320 - 39% open · ⏱️ 20.10.2023):

	```
	git clone https://github.com/react-syntax-highlighter/react-syntax-highlighter
	```
- [npm](https://www.npmjs.com/package/react-syntax-highlighter) (📥 9.7M / month · 📦 3.3K · ⏱️ 14.03.2022):
	```
	npm install react-syntax-highlighter
	```
</details>
<details><summary><b><a href="https://github.com/diegomura/react-pdf">diegomura/react-pdf</a></b> (🥉33 ·  ⭐ 14K) - Create PDF files using React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/diegomura/react-pdf) (👨‍💻 120 · 🔀 1.1K · 📦 7 · 📋 1.8K - 27% open · ⏱️ 17.05.2024):

	```
	git clone https://github.com/diegomura/react-pdf
	```
- [npm](https://www.npmjs.com/package/@react-pdf/png-js) (📥 2.3M / month · 📦 45 · ⏱️ 06.02.2024):
	```
	npm install @react-pdf/png-js
	```
</details>
<details><summary><b><a href="https://github.com/sql-js/sql.js">sql.js</a></b> (🥉33 ·  ⭐ 12K) - A javascript library to run SQLite on the web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/sql-js/sql.js) (👨‍💻 51 · 🔀 1K · 📥 34K · 📦 7.7K · 📋 440 - 28% open · ⏱️ 14.04.2024):

	```
	git clone https://github.com/sql-js/sql.js
	```
- [npm](https://www.npmjs.com/package/sql.js) (📥 190K / month · 📦 720 · ⏱️ 14.04.2024):
	```
	npm install sql.js
	```
</details>
<details><summary><b><a href="https://github.com/liveblocks/liveblocks">liveblocks</a></b> (🥉33 ·  ⭐ 3.1K) - Liveblocks is a platform to ship collaborative features like.. <code><a href="http://bit.ly/3nYMfla">Apache-2</a></code></summary>

- [GitHub](https://github.com/liveblocks/liveblocks) (👨‍💻 29 · 🔀 240 · 📦 2.5K · 📋 260 - 29% open · ⏱️ 05.06.2024):

	```
	git clone https://github.com/liveblocks/liveblocks
	```
- [npm](https://www.npmjs.com/package/@liveblocks/react) (📥 120K / month · 📦 13 · ⏱️ 05.06.2024):
	```
	npm install @liveblocks/react
	```
</details>
<details><summary><b><a href="https://github.com/iconify/iconify">iconify</a></b> (🥉32 ·  ⭐ 4K) - Universal icon framework. One syntax for FontAwesome, Material Design.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/iconify/iconify) (👨‍💻 22 · 🔀 110 · 📦 57K · 📋 240 - 4% open · ⏱️ 31.05.2024):

	```
	git clone https://github.com/iconify/iconify
	```
- [npm](https://www.npmjs.com/package/iconify) (📥 8.7K / month · 📦 25 · ⏱️ 13.01.2022):
	```
	npm install iconify
	```
</details>
<details><summary><b><a href="https://github.com/FirebaseExtended/reactfire">reactfire</a></b> (🥉30 ·  ⭐ 3.5K · 💤) - Hooks, Context Providers, and Components that make it easy to.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/FirebaseExtended/reactfire) (👨‍💻 67 · 🔀 420 · 📥 1K · 📦 6.7K · 📋 250 - 23% open · ⏱️ 03.08.2023):

	```
	git clone https://github.com/FirebaseExtended/reactfire
	```
- [npm](https://www.npmjs.com/package/reactfire) (📥 44K / month · 📦 28 · ⏱️ 03.08.2023):
	```
	npm install reactfire
	```
</details>
<details><summary><b><a href="https://github.com/alan2207/bulletproof-react">bulletproof-react</a></b> (🥉22 ·  ⭐ 25K) - A simple, scalable, and powerful architecture for building.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code></summary>

- [GitHub](https://github.com/alan2207/bulletproof-react) (👨‍💻 39 · 🔀 2.3K · 📦 1 · 📋 91 - 27% open · ⏱️ 23.05.2024):

	```
	git clone https://github.com/alan2207/bulletproof-react
	```
</details>
<details><summary><b><a href="https://github.com/DoneDeal0/alright-react-app">alright react app</a></b> (🥉12 ·  ⭐ 140) - Professional React app generator. Comes with an exposed,.. <code><a href="http://bit.ly/3hkKRql">ISC</a></code></summary>

- [GitHub](https://github.com/DoneDeal0/alright-react-app) (👨‍💻 5 · 🔀 8 · 📦 3 · 📋 3 - 33% open · ⏱️ 06.02.2024):

	```
	git clone https://github.com/DoneDeal0/alright-react-app
	```
- [npm](https://www.npmjs.com/package/alright-react-app) (📥 100 / month · 📦 3 · ⏱️ 06.02.2024):
	```
	npm install alright-react-app
	```
</details>
<details><summary>Show 5 hidden projects...</summary>

- <b><a href="https://github.com/remotion-dev/remotion">Remotion</a></b> (🥈39 ·  ⭐ 19K) - Make videos programmatically with React. <code><a href="https://tldrlegal.com/search?q=ICU">❗️ICU</a></code>
- <b><a href="https://github.com/nfl/react-helmet">react-helmet</a></b> (🥈36 ·  ⭐ 17K · 💀) - A document head manager for React. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/ngokevin/aframe">aframe</a></b> (🥉29 ·  ⭐ 16K · 💀) - Building Blocks for the VR Web. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/plouc/mozaik">mozaik</a></b> (🥉22 ·  ⭐ 3.6K · 💀) - Mozak is a tool based on nodejs / react / redux / nivo / d3 to easily.. <code><a href="http://bit.ly/34MBwT8">MIT</a></code>
- <b><a href="https://github.com/xobserve/xo">datav</a></b> (🥉20 ·  ⭐ 3.7K) - Observe any stack, any service and any data, using any UI.. <code>❗Unlicensed</code>
</details>

---

## Related Resources

- [**Best-of lists**](https://best-of.org): Discover other best-of lists with awesome open-source projects on all kinds of topics.
- [**Front-End-Checklist**](https://github.com/thedaviddias/Front-End-Checklist): The perfect Front-End Checklist for modern websites and meticulous developers.
- [**Awesome React**](https://github.com/enaqx/awesome-react): A collection of awesome things regarding React ecosystem.

## Contribution

Contributions are encouraged and always welcome! If you like to add or update projects, choose one of the following ways:

- Open an issue by selecting one of the provided categories from the [issue page](https://github.com/LukasMasuch/best-of-react/issues/new/choose) and fill in the requested information.
- Modify the [projects.yaml](https://github.com/LukasMasuch/best-of-react/blob/main/projects.yaml) with your additions or changes, and submit a pull request. This can also be done directly via the [Github UI](https://github.com/LukasMasuch/best-of-react/edit/main/projects.yaml).

If you like to contribute to or share suggestions regarding the project metadata collection or markdown generation, please refer to the [best-of-generator](https://github.com/best-of-lists/best-of-generator) repository. If you like to create your own best-of list, we recommend to follow [this guide](https://github.com/best-of-lists/best-of/blob/main/create-best-of-list.md).

For more information on how to add or update projects, please read the [contribution guidelines](https://github.com/LukasMasuch/best-of-react/blob/main/CONTRIBUTING.md). By participating in this project, you agree to abide by its [Code of Conduct](https://github.com/LukasMasuch/best-of-react/blob/main/.github/CODE_OF_CONDUCT.md).

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/by-sa.svg)](https://creativecommons.org/licenses/by-sa/4.0/)
