---
id: lwrcv
title: Shell Script Architecture
file_version: 1.1.1
app_version: 1.0.15
---

The Shell script is a lightweight command-line interface for interacting with [SonarQube](https://www.sonarqube.org/) _Community Edition_ and analysing your source code with SonarScanner (_CLI_) in a Docker environment.

The Localhost SonarQube codebase is under the `📄 bin` directory. There are additional folders related to the shell script in additional locations, as described below.

### `📄 bin/bootstrap/app.sh`

The `📄 bin/bootstrap/app.sh` is located under this folder which triggers the Localhost SonarQube `console`.

### `📄 bin/config`

The global variables are located under this folder - for example `📄 bin/config/app.sh`.

### `📄 bin/lib`

The majority of the codebase is located under this folder. This includes CLI commands, console message outputs, and Docker CLI interactions.

### `📄 bin/packages`

All third-party vendor packages are located under this folder. Currently, there is no package manager in place to manage third-party dependencies.

### `📄 docker`

The `📄 docker/compose.yaml` file is located under this folder which defines the SonarQube and PostgreSQL services.

### `📄 sonarscanner-templates`

All SonarScanner configuration templates (sonar-project.properties) are located under this folder.

## Bootstrap the App

<br/>

The entry point to the Shell Script is here. This will trigger the `main`<swm-token data-swm-token=":bin/sonarqube:60:0:0:`main &quot;$@&quot;`"/> function, which is located in `📄 bin/bootstrap/app.sh`. There is an alias shell script for this file in the root directory of the project, called `📄` `📄 sonarqube`
<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->
### 📄 bin/sonarqube
```
53     #######################################
54     # Run The Application
55     #
56     # Finally, we execute the Localhost
57     # SonarQube application main function.
58     #######################################
59     
60     main "$@"
```

<br/>

<br/>

## Dependencies Manager

<br/>

Files prefixed with an underscore will source Shell files. Consider these files as Shell file importers. The `📄 bin/lib/_lib.sh` will source third-party dependencies and other Shell file importers. Importers include a read-only array of dependencies within their domain e.g. the commands importer which is located in `📄 bin/lib/commands/_commands.sh`
<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->
### 📄 bin/lib/_lib.sh
```shell
32     readonly DEPENDENCIES=(
33       "commands"
34       "console"
35       "core"
36       "filesystem"
37       "services"
38       "support"
39       "utils"
40     )
41     
42     #######################################
43     # Load Dependencies
44     #######################################
45     
46     for DEPENDENCY in "${DEPENDENCIES[@]}"; do
47       # shellcheck source=/dev/null
48       source "${LIB_DIR}/${DEPENDENCY}/_${DEPENDENCY}.sh"
49     done
```

<br/>

<br/>

## Trigger CLI command

<br/>

The `sonarqube::console` function will trigger the Localhost SonarQube commands by transforming the first argument from the user input and dynamically constructing the command function following the command naming convention.
<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->
### 📄 bin/lib/core/sonarqube.sh
```shell
30       for argument in "$@"; do
31         shift
32         case "${argument}" in
33           -v|--version)
34             command::version
35             break;;
36           -h|--help)
37             command::usage
38             break;;
39           *)
40             local sonarqube_command="command::${argument//-/_}"
41     
42             if [[ $( type -t "${sonarqube_command}" ) != function ]]; then
43               console::error --margin-top --margin-bottom \
44                 "Command $(ansi --bold --white "${argument}" ) is not supported."
45     
46               console::output \
47                 "To view a list of all available commands use the following:" \
48                 "$(ansi --bold --white "${APP_COMMAND} --help")"
49     
50               exit 1
51             fi
52     
53             if [[ "${exclude_commands[*]}" != *"${argument}"* ]]; then
54               message::supportUkraine
55             fi
56     
57             # Execute the Localhost SonarQube command.
58             "${sonarqube_command}" "$@"
59     
60             break;;
61         esac
62       done
```

<br/>

This file was generated by Swimm. [Click here to view it in the app](https://app.swimm.io/repos/Z2l0aHViJTNBJTNBbG9jYWxob3N0LXNvbmFycXViZSUzQSUzQWx1aXNhdmVpcm8=/docs/lwrcv).
