# Localhost SonarQube Contributing Guide

Thanks for your interest in contributing to ***Localhost SonarQube***! Before submitting your contribution, please 
make sure to take a moment and read through the following guidelines:

- [Code of Conduct](#coc)
- [Got a Question or Problem](#question)
- [Submitting an Issue](#issue)
- [Submitting a Pull Request (PR)](#pr)

## <a name="coc"></a> Code of Conduct

Help us keep development for ***Localhost SonarQube*** open and inclusive. Please read and follow our 
[Code of Conduct](CODE_OF_CONDUCT.md).

## <a name="question"></a> Got a Question or Problem?

Do not open issues for general support questions as we want to keep GitHub issues for bug reports and feature requests. 
Instead, we recommend using the [GitHub Discussions](https://github.com/luisaveiro/localhost-sonarqube/discussions) space.

## <a name="issue"></a> Submitting an Issue

Before you submit an issue, please search the issue tracker or 
[GitHub Discussions](https://github.com/luisaveiro/localhost-sonarqube/discussions) space, maybe an issue for your 
problem already exists and the discussion might inform you of workarounds readily available.

You can file new issues by selecting from our 
[new issue templates](https://github.com/luisaveiro/localhost-sonarqube/issues/new/choose) and filling out the issue 
template.

## <a name="pr"></a> Submitting a Pull Request (PR)

**Please ask first before starting work on any significant new features.**

It's never a fun experience to have your pull request declined after investing a lot of time and effort into a new 
feature. To avoid this from happening, we request that contributors create an 
[issue](https://github.com/luisaveiro/localhost-sonarqube/issues/new/choose) to first discuss any significant new 
features. This includes things like adding new CLI commands, SonarScanner Configuration Templates, etc.
