# verto.sh
> Your Gateway to Open-Source Collaboration.

<p align="center">
  <img src="/public/meta.png" width="100%"/>
</p>

---

Step into the world of open-source with **verto.sh**! We carefully pick out popular projects with easy-to-tackle issues, making it simple for developers to find a new or first project to contribute to. **verto.sh** is more than just a list — it's a platform. It's where beginners can make their first contribution, founders can build a solid team, and maintainers can find new contributors.

The open-source community is always welcoming new talent, but getting started can feel tough. **verto.sh** makes it easier. By showing newcomers the ropes and connecting them with projects that need a hand, we're helping not just individuals, but the whole open-source movement.

With **verto.sh**, take the first step into collaborative coding, and be part of something bigger. Your code today could be the start of something amazing in the open-source community.

## Adding a New Project

You're welcome to add a new project in **verto.sh**, just follow these steps:

- To maintain the quality of projects in **verto.sh**, please make sure the repository you want to add meets the following criteria:

  - For **GitHub** repositories: it has at least three issues with the `good first issue` label or other labels defined in [config.json](config.json) (see `labels` and the end of the `GitHub` provider).

  - For **GitLab** repositories: it has at least three issues with the `quick win` label or other labels defined in [config.json](config.json) (see `labels` and the end of the `GitLab` provider).

  - It has at least 10 contributors.

  - It has at least 1000 stars.

  - It contains a README.md with detailed setup instructions for the project, and a CONTRIBUTING.md with guidelines for new contributors.

  - It is actively maintained (last update less than 1 month ago).

- For **GitHub** repositories: add your repository's path (in the format `owner/name` and lexicographic order) to [config.json](config.json) inside the `GitHub` provider.

- For **GitLab** repositories: add your repository's id (in the format `<project path>|<project id>`) to [config.json](config.json) inside the `GitLab` provider.

- Create a new pull-request. Please add the link to the issues page of the repository in the PR description. Once the pull request is merged, the changes will be live on [verto.sh](https://verto.sh/).

## How Does It Work?

**verto.sh** uses Next.js, React and Typescript. The data shown on the website is loaded from the [data.json](data/data.json) file, which is generated by a function in [data/utils.ts](data/utils.ts). It queries the GitHub and GitLab APIs to fetch issues from the repositories listed in [config.json](config.json). The labels defined in [config.json](config.json) are used to filter issues for the repositories.

## How to Setup The Project Locally

To contribute new features and changes to the website, you would want to run the app locally. Please follow these steps:

1. Fork the repository, clone it locally, create a new branch to work on a specific feature or bug fix without affecting the main branch of the repository. Make sure you have a recent version of Node.js installed on your computer.
2. You can use the included [data.json](data/data.json) as dummy data or you can run `npm run prebuild` to fetch the latest data from GitHub yourself: for this, you will need to set the `GH_PAT` environment variable to a valid GitHub Personal Access Token (PAT). Notice: repositories not maching the criteria listed above (see rules in [data.json](data/data.json)are automatically removed from [config.json](config.json) when the [data.json]data/data.json) script runs.
3. Start the development server and open the app in your browser.

```bash
# install the dependencies
$ npm install
# start the development server
$ npm run dev
```

Good to know when you commit: the project contains a `pre-commit` hook that runs linters automatically to ensure code quality!
