"""New stock prices table

Revision ID: 7bfdef0682d4
Revises: aeee2aa4ad8f
Create Date: 2019-04-24 05:06:43.720260

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '7bfdef0682d4'
down_revision = 'aeee2aa4ad8f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('prices',
                    sa.Column('isin', sa.String(), nullable=False),
                    sa.Column('market_date', sa.Date(), nullable=False),
                    sa.Column('price', sa.Float(), nullable=True),
                    sa.Column('target_median_price', sa.Float(), nullable=True),
                    sa.Column('recommendation', sa.Float(), nullable=True),
                    sa.Column('number_of_analyst_opinions', sa.Float(), nullable=True),
                    sa.Column('ebitda', sa.Float(), nullable=True),
                    sa.Column('market_cap', sa.Float(), nullable=True),
                    sa.Column('trailing_pe', sa.Float(), nullable=True),
                    sa.Column('forward_pe', sa.Float(), nullable=True),
                    sa.Column('ev_ebitda_ratio', sa.Float(), nullable=True),
                    sa.Column('dw_created', sa.DateTime(), nullable=True),
                    sa.Column('dw_modified', sa.DateTime(), nullable=True),
                    sa.PrimaryKeyConstraint('isin', 'market_date')
                    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('prices')
    # ### end Alembic commands ###
