"""stock financial tables

Revision ID: 00b80735370b
Revises: 7bfdef0682d4
Create Date: 2019-04-28 17:20:58.775476

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '00b80735370b'
down_revision = '7bfdef0682d4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('balance_sheet_statements',
                    sa.Column('isin', sa.String(), nullable=False),
                    sa.Column('report_date', sa.Date(), nullable=False),
                    sa.Column('cash', sa.Float(), nullable=True),
                    sa.Column('short_term_investments', sa.Float(), nullable=True),
                    sa.Column('net_receivables', sa.Float(), nullable=True),
                    sa.Column('total_current_assets', sa.Float(), nullable=True),
                    sa.Column('property_plant_equipment', sa.Float(), nullable=True),
                    sa.Column('intangible_assets', sa.Float(), nullable=True),
                    sa.Column('other_assets', sa.Float(), nullable=True),
                    sa.Column('deferred_long_term_asset_charges', sa.Float(), nullable=True),
                    sa.Column('total_assets', sa.Float(), nullable=True),
                    sa.Column('accounts_payable', sa.Float(), nullable=True),
                    sa.Column('short_long_term_debt', sa.Float(), nullable=True),
                    sa.Column('other_current_liab', sa.Float(), nullable=True),
                    sa.Column('long_term_debt', sa.Float(), nullable=True),
                    sa.Column('other_liab', sa.Float(), nullable=True),
                    sa.Column('deferred_long_term_liab', sa.Float(), nullable=True),
                    sa.Column('total_current_liabilities', sa.Float(), nullable=True),
                    sa.Column('total_liab', sa.Float(), nullable=True),
                    sa.Column('common_stock', sa.Float(), nullable=True),
                    sa.Column('retained_earnings', sa.Float(), nullable=True),
                    sa.Column('treasury_stock', sa.Float(), nullable=True),
                    sa.Column('other_stockholder_equity', sa.Float(), nullable=True),
                    sa.Column('total_stockholder_equity', sa.Float(), nullable=True),
                    sa.Column('net_tangible_assets', sa.Float(), nullable=True),
                    sa.Column('dw_created', sa.DateTime(), nullable=True),
                    sa.Column('dw_modified', sa.DateTime(), nullable=True),
                    sa.PrimaryKeyConstraint('isin', 'report_date')
                    )
    op.create_table('cash_flow_statements',
                    sa.Column('isin', sa.String(), nullable=False),
                    sa.Column('report_date', sa.Date(), nullable=False),
                    sa.Column('net_income', sa.Float(), nullable=True),
                    sa.Column('change_to_netincome', sa.Float(), nullable=True),
                    sa.Column('change_to_account_receivables', sa.Float(), nullable=True),
                    sa.Column('change_to_liabilities', sa.Float(), nullable=True),
                    sa.Column('total_cash_from_operating_activities', sa.Float(), nullable=True),
                    sa.Column('capital_expenditures', sa.Float(), nullable=True),
                    sa.Column('other_cashflows_from_investing_activities', sa.Float(), nullable=True),
                    sa.Column('total_cashflows_from_investing_activities', sa.Float(), nullable=True),
                    sa.Column('dividends_paid', sa.Float(), nullable=True),
                    sa.Column('net_borrowings', sa.Float(), nullable=True),
                    sa.Column('other_cashflows_from_financing_activities', sa.Float(), nullable=True),
                    sa.Column('total_cash_from_financing_activities', sa.Float(), nullable=True),
                    sa.Column('effect_of_exchange_rate', sa.Float(), nullable=True),
                    sa.Column('change_in_cash', sa.Float(), nullable=True),
                    sa.Column('repurchase_of_stock', sa.Float(), nullable=True),
                    sa.Column('issuance_of_stock', sa.Float(), nullable=True),
                    sa.Column('dw_created', sa.DateTime(), nullable=True),
                    sa.Column('dw_modified', sa.DateTime(), nullable=True),
                    sa.PrimaryKeyConstraint('isin', 'report_date')
                    )
    op.create_table('income_statements',
                    sa.Column('isin', sa.String(), nullable=False),
                    sa.Column('report_date', sa.Date(), nullable=False),
                    sa.Column('total_revenue', sa.Float(), nullable=True),
                    sa.Column('cost_of_revenue', sa.Float(), nullable=True),
                    sa.Column('gross_profit', sa.Float(), nullable=True),
                    sa.Column('research_development', sa.Float(), nullable=True),
                    sa.Column('selling_general_administrative', sa.Float(), nullable=True),
                    sa.Column('non_recurring', sa.Float(), nullable=True),
                    sa.Column('other_operating_expenses', sa.Float(), nullable=True),
                    sa.Column('total_operating_expenses', sa.Float(), nullable=True),
                    sa.Column('operating_income', sa.Float(), nullable=True),
                    sa.Column('total_other_income_expense_net', sa.Float(), nullable=True),
                    sa.Column('ebit', sa.Float(), nullable=True),
                    sa.Column('interest_expense', sa.Float(), nullable=True),
                    sa.Column('income_before_tax', sa.Float(), nullable=True),
                    sa.Column('income_tax_expense', sa.Float(), nullable=True),
                    sa.Column('minority_interest', sa.Float(), nullable=True),
                    sa.Column('net_income_from_continuing_ops', sa.Float(), nullable=True),
                    sa.Column('discontinued_operations', sa.Float(), nullable=True),
                    sa.Column('extraordinary_items', sa.Float(), nullable=True),
                    sa.Column('effect_of_accounting_charges', sa.Float(), nullable=True),
                    sa.Column('other_items', sa.Float(), nullable=True),
                    sa.Column('net_income', sa.Float(), nullable=True),
                    sa.Column('net_income_applicable_to_common_shares', sa.Float(), nullable=True),
                    sa.Column('dw_created', sa.DateTime(), nullable=True),
                    sa.Column('dw_modified', sa.DateTime(), nullable=True),
                    sa.PrimaryKeyConstraint('isin', 'report_date')
                    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('income_statements')
    op.drop_table('cash_flow_statements')
    op.drop_table('balance_sheet_statements')
    # ### end Alembic commands ###
