import sys
sys.path.insert(0, '../')
import soynlp
from soynlp.lemmatizer import _conjugate_stem

"""
푸르 -> {'푸르', '푸릅', '푸릈', '푸를', '풀', '푸른'}
하 -> {'한', '했', '하', '할', '핬', '해', '합'}
낫 -> {'낫', '나'}
아름답 -> {'아름답', '아름다'}
아니하 -> {'아니합', '아니핬', '아니한', '아니할', '아니하', '아니해', '아니했'}
시퍼렇 -> {'시퍼러', '시퍼럴', '시퍼렀', '시퍼랬', '시퍼런', '시퍼렇'}
주 -> {'줘', '줐', '준', '줄', '줍', '줬', '주'}
구르 -> {'구르', '굴', '구른', '구릅', '구릈', '구를'}
가 -> {'갑', '가', '갈', '갔', '간'}
좋 -> {'좋'}
푸 -> {'풌', '풉', '푼', '푸', '풀'}
감미롭 -> {'감미로', '감미롭'}
긋 -> {'긋', '그'}
줍 -> {'줍', '주'}
오 -> {'옸', '올', '온', '왔', '와', '오', '옵'}
동그랗 -> {'동그라', '동그랬', '동그랐', '동그란', '동그랄', '동그랗'}
파랗 -> {'파랗', '파라', '파랄', '파랐', '파랬', '파란'}
이르 -> {'이르', '일', '이릈', '이릅', '이른', '이를'}
들 -> {'들'}
이 -> {'이', '있', '입', '일', '인'}
덥 -> {'덥', '더'}
삼가 -> {'삼간', '삼갈', '삼갑', '삼갔', '삼가'}
깨닫 -> {'깨달', '깨닫'}
사오 -> {'사온', '사올', '사와', '사왔', '사오', '사옵', '사옸'}
곱 -> {'곱', '고'}
끄 -> {'끕', '끌', '끈', '껐', '꺼', '끘', '끄'}
그렇 -> {'그렇', '그럴', '그렀', '그랬', '그러', '그런'}
아니꼽 -> {'아니꼽', '아니꼬'}
트 -> {'트', '틉', '터', '텄', '틀', '튼', '틌'}
아깝 -> {'아까', '아깝'}
영원하 -> {'영원하', '영원핬', '영원했', '영원한', '영원할', '영원합', '영원해'}
돌아오 -> {'돌아옵', '돌아오', '돌아온', '돌아와', '돌아왔', '돌아옸', '돌아올'}
벗 -> {'벗'}
"""

def main():
    testset = {'가', '감미롭', '곱', '구르', '그렇',
        '긋', '깨닫', '끄', '낫', '덥',
        '돌아오', '동그랗', '들', '벗', '사오',
        '삼가', '시퍼렇', '아깝', '아니꼽', '아니하',
        '아름답', '영원하', '오', '이', '이르',
        '좋', '주', '줍', '트', '파랗',
        '푸', '푸르', '하'
    }
    
    for stem in testset:
        print('{} -> {}'.format(stem, _conjugate_stem(stem)))

if __name__ == '__main__':
    main()