# Start with Large Language Models (LLMs) - Become an expert for free!

## A complete guide to start and improve your LLM skills in 2024 without an advanced background in the field and stay up-to-date with the latest news and state-of-the-art techniques!

[<img src="https://imgur.com/la4Sfu4.png" width="512"/>](https://www.louisbouchard.ai/from-zero-to-hero-with-llms/)

First, if you have 0 programming or AI knowledge, please follow [this guide](https://github.com/louisfb01/start-machine-learning) I made for this exact purpose and come back here!

This guide is intended for anyone with a small background in programming and machine learning. There is no specific order to follow, but a classic path would be from top to bottom. If you don't like reading books, skip them. If you don't want to follow an online course, you can also skip it. There is not a single way to become a machine learning expert, and with motivation, you can absolutely achieve it.

All resources listed here are free, except some online courses and books, which are certainly recommended for a better understanding, but it is definitely possible to become an expert without them, with a little more time spent on online readings, videos, and practice. When it comes to paying courses, the links in this guide are affiliated links. Please use them if you feel like following a course, as it will support me. Thank you, and have fun learning! Remember, this is completely up to you and not necessary. I felt like it was useful to me and maybe useful to others as well.

Don't be afraid to repeat videos or learn from multiple sources. Repetition is the key of success to learning!

Maintainer: [louisfb01](https://github.com/louisfb01), also active on [YouTube](https://www.youtube.com/@whatsai) and as a [Podcaster](https://open.spotify.com/show/4rKRJXaXlClkDyInjHkxq3) if you want to see/hear more about AI & LLMs! You can also learn more twice a week in [my personal newsletter](https://louisbouchard.substack.com/)!

[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/cloudposse.svg?style=social&label=Follow%20%40whats_ai)](https://twitter.com/Whats_AI)

Feel free to submit an issue for any great resources to add to this repository.


***Tag me on Twitter [@Whats_AI](https://twitter.com/Whats_AI) or LinkedIn [@Louis Bouchard](https://www.linkedin.com/in/whats-ai/)  if you share the list!***

### Want to know what this guide is about? Watch this video:

[<img src="https://imgur.com/rS1d89V.png" width="512"/>](https://youtu.be/58XmJxb1x_o)


## Table of Contents
- [Prerequesites](#prerequesites)
- [Start with short YouTube video introductions as a first step](#youtubevideos)
- [LLM Books and articles (for readers)](#readers)
- [Follow online courses](#courses)
- [Practice, practice, and practice!](#practice)
- [Prompting](#prompting)
- [Retrieval Augmented Generation (RAG)](#rag)
- [More resources (Communities, cheat sheets, news, and more!)](#moreresources)
- [How to find a machine learning job](#findajob)
- [AI Ethics](#aiethics)
- [Learn more and do more... with LLMs](#domore)

## Prerequesites<a name="prerequesites"></a>

If you have 0 programming or AI knowledge, please follow [this guide](https://github.com/louisfb01/start-machine-learning) I made for this exact purpose. Check out the python section mostly and then you will have a strong enough background to come back here!

If you are somewhat familiar with Python and AI, then I wish you happy learning!


## Start with short YouTube video introductions as a first step<a name="youtubevideos"></a>
### Start with short YouTube videos introductions
This is the best way to start from nothing. Here, I list a few of the best videos I found that will give you a great first introduction to the terms you need to know to get started in the LLM field.
    
* Understanding the terminology
    * [Mastering AI Jargon - Your Guide to OpenAI & LLM Terms - Louis Bouchard](https://youtu.be/q4G6X09NEu4) - A quick introduction to the most used terms in the LLM (or GPT) world.
* Understanding Transformers and LLMs (i.e. models behind ChatGPT)!
    * [Intro to Large Language Models](https://youtu.be/zjkBMFhNj_g) - An amazing 1-hour talk from [Andrej Karpathy](https://twitter.com/karpathy).
    * [Natural Language Processing and Large Language Models](https://www.youtube.com/playlist?list=PLs8w1Cdi-zvYskDS2icIItfZgxclApVLv) - amazing video introductions to the attention mechanism, tokens, embeddings and more to better understand everything behind large language models like GPT by [Luis Serrano](https://twitter.com/SerranoAcademy).
    * [What are Transformer Models and how do they work?](https://youtu.be/qaWMOYf4ri8) - [Luis Serrano](https://twitter.com/SerranoAcademy)
    * [The Illustrated Word2vec - A Gentle Intro to Word Embeddings in Machine Learning](https://youtu.be/ISPId9Lhc1g) - A clear explanation of word embeddings in machine learning by [Jay Alammar](https://twitter.com/JayAlammar).
    * [A Hackers' Guide to Language Models](https://www.youtube.com/watch?v=jkrNMKz9pWU) - by [Jeremy Howard (fast.ai)](https://twitter.com/jeremyphoward).
    * [Let's build GPT: from scratch, in code, spelled out.](https://www.youtube.com/watch?v=kCc8FmEb1nY) - by [Andrej Karpathy](https://twitter.com/karpathy).

Another easy **way to get started and keep learning is by listening to podcasts** in your spare time. Driving to work, on the bus, or having trouble falling asleep? Listen to some AI podcasts to get used to the terms and patterns, and learn about the field through inspiring stories! I invite you to follow a few of the best I personally prefer, like [Lex Fridman](https://open.spotify.com/show/2MAi0BvDc6GTFvKFPXnkCL), [Machine Learning Street Talk](https://open.spotify.com/show/02e6PZeIOdpmBGT9THuzwR), and obviously, my podcast: [Louis Bouchard Podcast](https://open.spotify.com/show/4rKRJXaXlClkDyInjHkxq3), where you will learn about incredibly talented people in the field with inspiring stories sharing the knowledge they worked so hard to gather. A new one I really enjoy listening to that keeps me up to date is the [ThursdAI podcast](https://thursdai.news/) by my friend [Alex Volkov](https://twitter.com/altryne).

## Here is a list of awesome courses available on YouTube that you should definitely follow and are 100% free.

* Louis Bouchard's LLM free course videos "[Train & Fine-Tune LLMs for Production Course by Activeloop, Towards AI & Intel Disruptor](https://youtube.com/playlist?list=PLO4GrDnQanVcPlQUBuMd_pwRkILfc463G&si=QbXeHeDs5RSKH3nY)". "A playlist for our LLM course: Gen AI 360: Foundational Model Certification!"
* [Create a Large Language Model from Scratch with Python – Tutorial](https://youtu.be/UU1WVnMk4E8) - by [freeCodeCamp](https://twitter.com/freeCodeCamp). "Learn how to build your own large language model, from scratch. This course goes into the data handling, math, and transformers behind large language models. You will use Python."
* [LLM University (LLMU) from Cohere](https://www.youtube.com/watch?v=uV1H6E8y_Sg&list=PLLalUvky4CLIpL4PkbTyf9DeXxJaZzEgU) - by [Cohere](https://twitter.com/cohere). LLM University (LLMU) is a set of comprehensive learning resources for anyone interested in natural language processing (NLP), from beginners to advanced learners.
* [The Attention Mechanism in Large Language Models](https://www.youtube.com/watch?v=OxCpWwDCDFQ&list=PLs8w1Cdi-zva4fwKkl9EK13siFvL9Wewf) - by Luis Serrano. In this video series, Luis explains the Transformer architecture going increasingly in depth. It is a very good overview and explanation of Transformers and the attention mechanism that I believe should be watched by all AI professionals.


## LLM Books and articles (for readers)<a name="readers"></a>
If you prefer the article and reading path, here are some suggestions:

* [Building LLMs for Production: Enhancing LLM Abilities and Reliability with Prompting, Fine-Tuning, and RAG](https://amzn.to/4bqYU9b) - by Towards AI. "Discover the key tech stacks for adapting Large Language Models to real-world applications, including Prompt Engineering, Fine-tuning, and Retrieval Augment Generation." (Or get the e-book [here](https://academy.towardsai.net/courses/buildingllmsforproduction?ref=1f9b29). You can DM me for a nice discount!)
* [The Illustrated Transformer](https://jalammar.github.io/illustrated-transformer/) - by Jay Alammar. This is a famous article providing an amazing explanation to how current language models work.
* [A Practical Introduction to LLMs](https://towardsdatascience.com/a-practical-introduction-to-llms-65194dda1148) - by [Shawhin Talebi](https://shawhin.medium.com/). 
* [Medium](https://whats-ai.medium.com/membership) is pretty much the best place to find great explanations, either on [Towards AI](https://pub.towardsai.net/) or [Towards Data Science](https://towardsdatascience.com/) publications. I also share my own articles there and I love using the platform. You can subscribe to Medium using my affiliated link [here](https://whats-ai.medium.com/membership) if this sounds interesting to you and if you'd like to support me at the same time!
* [Reading lists for new MILA students](https://docs.google.com/document/d/1IXF3h0RU5zz4ukmTrVKVotPQypChscNGf5k6E25HGvA/edit#) - Anonymous
* [A complete roadmap to master NLP in 2022](https://www.analyticsvidhya.com/blog/2022/01/roadmap-to-master-nlp-in-2022/)
* NLTK Book is the free resource to learn about fundamental theories behind NLP: https://www.nltk.org/book/
* [The Annotated Transformer](https://nlp.seas.harvard.edu/2018/04/03/attention.html) - Harvard


## Follow online courses<a name="courses"></a>
If you like some more guidance, I can advise checking out (optional) online courses, such as...
* [Generative AI with Large Language Models](https://imp.i384100.net/R5WzQR) - Paid
* [Become an NLP pro with Coursera's Natural Language Processing Specialization by deeplearning.ai](https://coursera.pxf.io/P0vO9e) - Paid
* [Gradio Course - Create User Interfaces for Machine Learning Models - freeCodeCamp](https://youtu.be/RiCQzBluTxU) - Free
* [Train & Fine-Tune LLMs for Production Course by Activeloop, Towards AI & Intel Disruptor](https://learn.activeloop.ai/courses/llms/?utm_source=social&utm_medium=youtube&utm_campaign=llmcourse) - Free
* [The LLM University by Cohere](https://docs.cohere.com/docs/llmu?ref=txt.cohere.com) - Free
* [From Beginners to Advanced LLM Developer](https://academy.towardsai.net/courses/beginner-to-advanced-llm-dev?ref=1f9b29) - by Towards AI. "Build Your First Scalable Product with LLMs, Prompting, RAG, Fine-Tuning, and Agents! Master the skills top companies need and build your own advanced LLM MVP with real-world applications."
* [Become an NLP pro with Coursera's Natural Language Processing Specialization by deeplearning.ai](https://coursera.pxf.io/P0vO9e) - Paid
 _"Break into the NLP space. Master cutting-edge NLP techniques through four hands-on courses!"_
* [An NLP Nano Degree!](https://imp.i115008.net/jW4K60) — Paid
_"Learn cutting-edge natural language processing techniques to process speech and analyze text. Build probabilistic and deep learning models, such as hidden Markov models and recurrent neural networks, to teach the computer to do tasks such as speech recognition, machine translation, and more!"_
* [Introduction to Large Language Models with Google Cloud](https://imp.i115008.net/eKbDLD) - Paid
* [Learn to train, fine-tune and use LLMs in your applications.](https://www.wandb.courses/pages/w-b-courses) - Free by Weights & Biases
* [Large Language Models with Semantic Search](https://www.deeplearning.ai/short-courses/large-language-models-semantic-search/) - Free, Deeplearning.ai and Cohere

You can easily google for more, but after reading and watching those, I believe you already have a good enough understanding of LLMs to get into the real deal: practice.


## Practice, practice, and practice!<a name="practice"></a>
### Practice is key

The most important thing in programming is practice. This applies to machine learning too. It can be hard to find a personal project to practice. I strongly advise you to try to build something by yourself, but I understand it may be intimidating. What I would then suggest is to follow one or two **extremely** applied courses and use the resource to build your own project based on the code examples they provide you, and ChatGPT or GitHub Copilot to [work for you](#domore) as a code assistant for the rest of the work.

Here are a few of the most applied courses I could find for LLMs:

* Looking to build a quick text classification model or word vectorizer, [fasttext](https://fasttext.cc/docs/en/supervised-tutorial.html) is a good library to quickly train up a model.
* [Huggingface](https://huggingface.co/course/chapter1/1) is THE place to get modern day NLP models, and they also include a whole [course](https://huggingface.co/course/chapter1/1) about it.
* [LangChain & Vector Databases in Production](https://learn.activeloop.ai/courses/langchain/) - An amazing free resource we built at Towards AI in partnership with Activeloop and the Intel Disruptor Initiative to learn about LangChain & Vector Databases in Production. "Whether you are an experienced developer who's a newcomer to the AI realm or an experienced machine learning enthusiast, this course is designed for you. Our goal is to make AI accessible and practical, transforming how you approach your daily tasks and the overall impact of your work."
* [Training & Fine-Tuning LLMs for Production](https://learn.activeloop.ai/courses/llms/) - An amazing free resource we built at Towards AI in partnership with Activeloop and the Intel Disruptor Initiative to learn about Training & Fine-Tuning LLMs for Production. "If you want to learn how to train and fine-tune LLMs from scratch and have intermediate Python knowledge as well as access to moderate compute resources (for some cases, just a Google Colab will suffice!), you should be all set to take and complete the course. This course is designed with a wide audience in mind, including beginners in AI, current machine learning engineers, students, and professionals considering a career transition to AI. We aim to provide you with the necessary tools to apply and tailor Large Language Models across a wide range of industries to make AI more accessible and practical."
* [The Real-World ML Tutorial & Community](https://realworldmachinelearning.carrd.co/) - Paid

A reminder. The best way to learn is to build something! I really prone to learn by doing. Those courses are all great but optional. You can do it on your own, and most companies providing resources for working with LLMs (OpenAI, LangChain, Activeloop, Cohere, W&B...) have great tutorials to get you started and build something. Then, you can [ask ChatGPT](#domore) to help you finish it!


## Prompting<a name="prompting"></a>
Prompting is an important new skill to learn for both using the models and building NLP-related apps.

* [What is Prompting? Talking with AI Models...](https://youtu.be/pZsJbYIFCCw) - Free
* [ChatGPT Prompt Engineering for Developers](https://imp.i384100.net/rQBVMy) - Paid
* [Learn Prompting](https://learnprompting.org/) - This is a great **free** course intending to teach prompting and give tips for specific models. It is **all you need** for prompting!
* [Techniques to improve reliability](https://github.com/openai/openai-cookbook/blob/main/articles/techniques_to_improve_reliability.md#techniques-to-improve-reliability) - OpenAI Cookbook on prompting techniques.

## More on Retrieval Augmented Generation (RAG) and fine-tuning<a name="rag"></a>
Most people build RAG-based apps currently. Here are a few resources that I loved to get you started and have a good understanding of it...

* [A Survey of Techniques for Maximizing LLM Performance](https://youtu.be/ahnGLM-RC1Y) - Amazing video by OpenAI covering when to use prompt engineering, RAG or fine-tuning. This is a must-see for everyone in the field!
* [RAG vs Fine-Tuning vs Deep Memory vs training LLM from Scratch: when to do what with LLMs](https://youtu.be/pHv9SsE4Mb4) - Simlarly, this is a short video covering when you should use RAG, fine-tuning or prompt engineering in your applications.
* [Building a Q&A Chatbot using GPT and embeddings](https://youtu.be/LB5g-AhfPG8) - Applied YouTube Tutorial by [Jeremy Pinto](https://twitter.com/jerpint).
* [How to build an AI that can answer questions about your website](https://platform.openai.com/docs/tutorials/web-qa-embeddings/how-to-build-an-ai-that-can-answer-questions-about-your-website) - Free OpenAI tutorial.
* [From Beginners to Advanced LLM Developer](https://academy.towardsai.net/courses/beginner-to-advanced-llm-dev?ref=1f9b29) - by Towards AI. "Build Your First Scalable Product with LLMs, Prompting, RAG, Fine-Tuning, and Agents! Master the skills top companies need and build your own advanced LLM MVP with real-world applications."
* [How to Build a RAG-based ChatGPT Web App: Meet Our new AI Tutor](https://youtu.be/7ytyK6u3aAk) - YouTube introduction on how I built a RAG-based chatbot (and how you can, too).
* [Training & Fine-Tuning LLMs for Production](https://learn.activeloop.ai/courses/llms/) - Learn how to train and fine-tune LLMs from scratch.
* [Train and Deploy a Real-Time Financial Advisor](https://github.com/iusztinpaul/hands-on-llms) - Hands-on LLMs Course by [Paul Iusztin](https://github.com/iusztinpaul), [Pau Labarta Bajo](https://github.com/Paulescu) and [Alexandru Razvant](https://github.com/Joywalker).
* [Retrieval Augmented Generation for Production with LangChain & LlamaIndex](https://learn.activeloop.ai/courses/rag) - Whether planning to build a chat with data application for your organization or just learning how to leverage Generative AI in various industries, this course is for you. The course addresses critical issues such as increasing retrieval accuracy, reducing hallucinations in AI outputs, enhancing explainability, addressing copyright concerns, and offering more tailored, up-to-date data inputs. We go beyond basic RAG applications, equipping you with the skills to create more complex, reliable products with tools like LangChain, LlamaIndex, and Deep Memory. Emphasizing hands-on learning, this course is a gateway to mastering advanced RAG techniques and applications in real-world scenarios.
* [Building LLMs for Production: Enhancing LLM Abilities and Reliability with Prompting, Fine-Tuning, and RAG](https://amzn.to/4bqYU9b) - by Towards AI. "Discover the key tech stacks for adapting Large Language Models to real-world applications, including Prompt Engineering, Fine-tuning, and Retrieval Augment Generation." (Or get the e-book [here](https://academy.towardsai.net/courses/buildingllmsforproduction?ref=1f9b29). You can DM me for a nice discount!)


[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/cloudposse.svg?style=social&label=Follow%20%40whats_ai)](https://twitter.com/Whats_AI)


## More Resources<a name="moreresources"></a>
### Join communities!

* [A Discord server with many AI enthusiasts](https://discord.gg/learnaitogether) - Learn together, ask questions, find kaggle teammates, share your projects, and more.
* [A Discord server where you can stay up-to-date with the latest AI news](https://ws.towardsai.net/discord) - Stay up-to-date with the latest AI news, ask questions, share your projects, and much more.
* [Learn Prompting Discord community](https://discord.gg/learn-prompting-1046228027434086460) - Chat with fellow prompt engineers.

* Follow reddit communities - Ask questions, share your projects, follow news, and more.
    * [artificial](https://www.reddit.com/r/artificial/) - Artificial Intelligence
    * [MachineLearning](https://www.reddit.com/r/MachineLearning/) - Machine Learning (Biggest subreddit of the field)
    * [DeepLearningPapers](https://www.reddit.com/r/DeepLearningPapers/) - Deep Learning Papers
    * [ComputerVision](https://www.reddit.com/r/computervision/) - Extracting useful information from images and videos
    * [learnmachinelearning](https://www.reddit.com/r/learnmachinelearning/) - Learn Machine Learning
    * [ArtificialInteligence](https://www.reddit.com/r/ArtificialInteligence/) - AI
    * [LatsestInML](https://www.reddit.com/r/LatestInML/) - Game-changing developments in machine learning you shouldn't miss


### Follow the news in the field!

* Subscribe to YouTube channels that share new papers - Stay up to date with the news in the field!
    * [Louis Bouchard](https://www.youtube.com/channel/UCUzGQrN-lyyc0BWTYoJM_Sg) - Weekly videos covering new papers
    * [Two Minutes Papers](https://www.youtube.com/user/keeroyz) - Bi-weekly videos covering new papers
    * [Bycloud](https://www.youtube.com/channel/UCgfe2ooZD3VJPB6aJAnuQng) - Weekly videos covering new papers
    
* LinkedIn Groups
    * [Artificial Intelligence, Machine Learning and Deep Learning News](https://www.linkedin.com/groups/8942343/) - News of the field shared by everyone in the group
    * [Artificial Intelligence | Deep Learning  | Machine Learning](https://www.linkedin.com/groups/45655/)
    * [Applied Artificial Intelligence](https://www.linkedin.com/groups/127447/)
    
* Facebook Groups
    * [Artificial Intelligence & Deep Learning](https://www.facebook.com/groups/DeepNetGroup) - The definitive and most active FB Group on A.I., Neural Networks and Deep Learning. All things new and interesting on the frontier of A.I. and Deep Learning. Neural networks will redefine what it means to be a smart machine in the years to come.
    * [Deep learning](https://www.facebook.com/groups/DeepLearnng/) - Nowadays society tends to be soft and automated evolving into the 4th industrial revolution, which consequently drives the constituents into the swirl of societal upheaval. To survive or take a lead one is supposed to be equipped with associated tools. Machine is becoming smarter and more intelligent. Machine learning is inescapable skill and it requires people to be familiar with. This group is for these people who are interest in the development of their talents to fit in.

* Newsletters
   * [Synced AI TECHNOLOGY & INDUSTRY REVIEW](https://syncedreview.com/) - China's leading media & information provider for AI & Machine Learning.
   * [Inside AI](https://inside.com/ai) - A daily roundup of stories and commentary on Artificial Intelligence, Robotics, and Neurotechnology.
   * [AI Weekly](http://aiweekly.co/) - A weekly collection of AI News and resources on Artificial Intelligence and Machine Learning.
   * [AI Ethics Weekly](https://lighthouse3.com/newsletter/) - The latest updates in AI Ethics delivered to your inbox every week.
   * [Louis Bouchard Weekly](https://louisbouchard.substack.com/) - One and only one paper clearly explained weekly with an article, video demo, demo, code, etc.
   * [ThursdAI](https://sub.thursdai.news/) - Recaps of the most high-signal AI weekly spaces!
   * [Toward's AI newsletter](https://towardsai.net/ai/newsletter) - Summarizing the most interesting news and learning resources weekly as well as community updates from the Learn AI Together Discord community. Perfect for ML professionals and enthusiasts.
   * [The Batch](https://www.deeplearning.ai/the-batch/) - Andrew Ng / Deeplearning.ai
    
* Follow Medium publications
    * [Towards Data Science](https://towardsdatascience.com/) - "Sharing concepts, ideas, and codes"
    * [Towards AI](https://medium.com/towards-artificial-intelligence) - "The Best of Tech, Science, and Engineering."
    * [OneZero](https://onezero.medium.com/) - "The undercurrents of the future. A Medium publication about tech and science."
    
## Find a machine learning job<a name="findajob"></a>

* Read [this section from the article](https://www.louisbouchard.ai/learnai/#how-to-find-a-job) full of interview tips and **how to prepare for them**.
* Learn how the interview process goes and getting better at preparing for them by watching how others did it, like the [interview series](https://youtube.com/playlist?list=PLO4GrDnQanVfrRIuIT_1rlLLTgQJdfXmS) I ran with experts from NVIDIA, Zoox (Self-driving company), D-ID (Generative AI Startup), etc.

## AI Ethics<a name="aiethics"></a>
* [What are Ethics and Why do they Matter? Machine Learning Edition](https://www.youtube.com/watch?v=F0cxzESR7ec&list=PLtmWHNX-gukIU6V33Bc8eP8OD41I4GywR&ab_channel=RachelThomas) - by Rachel Thomas, founder of fast.ai
* [AI4People—An Ethical Framework for a Good AI Society: Opportunities, Risks, Principles, and Recommendations](https://link.springer.com/content/pdf/10.1007/s11023-018-9482-5.pdf) - Floridi et al., 2018, AI4People AI for a good society
* [Ethics guidelines for trustworthy AI](https://wayback.archive-it.org/12090/20210728013426/https://digital-strategy.ec.europa.eu/en/library/ethics-guidelines-trustworthy-ai) - European Commission high-level expert group 7 points for a trustworthy AI.
* [An Introduction to Ethics in Robotics and AI](https://link.springer.com/book/10.1007/978-3-030-51110-4) - a free e-book by Christoph Bartneck, Christoph Lütge, Alan Wagner, and Sean Welsh.


## Learn more and do more... with LLMs<a name="domore"></a>
ChatGPT, Bing, Claude... are incredible. Of course, they have limitations. Yet, you can leverage those to learn anything you want. I use it for coding or asking lots of questions in general. You need to double-check when you ask for important questions.
Still, it is a powerful **tool**. Yes, it is a tool, not a human replacement. Use it as a _dumb_ assistant that knows about pretty much everything.

Here's [a clear example](https://chat.openai.com/share/883389c9-f0f8-4a3e-a3af-ee9860d448a8) of how I used it for a project to better understand a function from a project I was not familiar with. This is for python, but those models are extremely powerful for coding in general, understanding new platforms (like AWS, GCP, working with a virtual machine, a server, SSH connections, etc.... anything you are not familiar with that is useful in the LLM space).

_p.s. I didn't mention Bing and Claude for fun. Don't be overly dependent on a single company like OpenAI. There are (and will always be) other companies in the fight for the best LLM. I wanted to create an example for the guide this morning when..._

[<img src="https://imgur.com/RDdL7el.png" width="512"/>](https://twitter.com/satourian/status/1722257478115811421)

---


***Tag me on Twitter [@Whats_AI](https://twitter.com/Whats_AI) or LinkedIn [@Louis Bouchard](https://www.linkedin.com/in/whats-ai/)  if you share the list!***

👀 **If you'd like to support my work**, you can check to [Sponsor](https://github.com/sponsors/louisfb01) this repository or support me on [Patreon](https://www.patreon.com/whatsai).

This guide is still regularly updated.
