/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractor;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFiles;
import com.teamdev.jxbrowser.chromium.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcessFactory;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Sender;
import com.teamdev.jxbrowser.chromium.internal.ipc.Server;
import com.teamdev.jxbrowser.chromium.internal.ipc.c;
import com.teamdev.jxbrowser.chromium.internal.ipc.d;
import com.teamdev.jxbrowser.chromium.internal.ipc.e;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.g;
import com.teamdev.jxbrowser.chromium.internal.ipc.h;
import com.teamdev.jxbrowser.chromium.internal.ipc.i;
import com.teamdev.jxbrowser.chromium.internal.ipc.j;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ShutdownMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class IPC
implements Sender {
    public static final String EXTERNAL_IPC_PROPERTY = "jxbrowser.ipc.external";
    private static final Logger a = LoggerProvider.getIPCLogger();
    private static final List<Browser> b = Collections.synchronizedList(new ArrayList());
    private final Server c;
    private final ChromiumProcess d;
    private final List<Channel> e;
    private final ServerListener f;
    private final AtomicInteger g;
    private final List<IPCChannelListener> h;
    private Channel i;
    private boolean j;

    /*
     * WARNING - void declaration
     */
    public IPC(Server server, ChromiumProcess process) {
        void var2_2;
        void var1_1;
        com.teamdev.jxbrowser.chromium.internal.ipc.j.a().b();
        Environment.traceEnvironment();
        Environment.checkEnvironment();
        ChromiumExtractor chromiumExtractor = new ChromiumExtractor(BrowserPreferences.getChromiumDir(), ChromiumArchiveName.get(), ChromiumFiles.get(), new ChromiumVerifier());
        chromiumExtractor.extractChromiumBinariesIfNecessary();
        this.c = var1_1;
        this.d = var2_2;
        this.f = new b(this, 0);
        this.e = new CopyOnWriteArrayList<Channel>();
        this.h = new CopyOnWriteArrayList<IPCChannelListener>();
        this.g = new AtomicInteger();
        if (!Environment.isMac() || Boolean.getBoolean(EXTERNAL_IPC_PROPERTY)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new com.teamdev.jxbrowser.chromium.internal.ipc.b(this)));
        }
    }

    public static synchronized IPC getDefault() {
        return com.teamdev.jxbrowser.chromium.internal.ipc.IPC$a.a;
    }

    public static synchronized IPC create() {
        Server server = new Server();
        String string = BrowserPreferences.getChromiumDir();
        return new IPC(server, ChromiumProcessFactory.create(string));
    }

    public static synchronized void addBrowser(Browser browser) {
        Browser browser2;
        b.add(browser2);
    }

    public static synchronized void removeBrowser(Browser browser) {
        Browser browser2;
        b.remove(browser2);
    }

    public static synchronized List<Browser> getBrowsers() {
        return new ArrayList<Browser>(b);
    }

    public synchronized Channel getMainChannel() {
        return this.i;
    }

    public synchronized boolean isStarted() {
        return this.c.isStarted();
    }

    public synchronized void start() {
        this.g.incrementAndGet();
        a.info("Starting IPC...");
        if (this.j) {
            String string = this.c.isStarted() ? "IPC cannot be started, because shutting down process has been initiated." : "IPC cannot be started, because it has been already shut down.";
            throw new IPCException(string);
        }
        if (this.c.isStarted()) {
            a.info("IPC is already started.");
            if (!this.d.isStarted()) {
                a.info("Chromium process is dead. Restarting IPC...");
                this.i = this.a(false);
                return;
            }
            return;
        }
        this.i = this.a(true);
        this.c.addServerListener(this.f);
        a.info("IPC is started.");
    }

    private Channel a(boolean n2) {
        Object object;
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch object22 = new CountDownLatch(1);
        AtomicReference<IPCException> atomicReference2 = new AtomicReference<IPCException>();
        c c2 = new c(this, atomicReference, object22);
        this.c.addServerListener(c2);
        if (n2 != 0) {
            AtomicReference<IPCException> atomicReference3 = atomicReference2;
            object = object22;
            Object object3 = this;
            a.info("Starting IPC Server...");
            AtomicInteger atomicInteger = new AtomicInteger(-1);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            object3 = new Thread(new e((IPC)object3, atomicInteger, countDownLatch, atomicReference3, (CountDownLatch)object));
            ((Thread)object3).setName("IPC Server Thread");
            ((Thread)object3).setDaemon(true);
            ((Thread)object3).start();
            LatchUtil.await(countDownLatch, new RuntimeException(new TimeoutException()), 15);
            n2 = atomicInteger.get();
            if (n2 != -1) {
                this.a(object22, atomicReference2, n2);
            }
        } else {
            this.a(object22, atomicReference2, this.c.getPort());
        }
        try {
            LatchUtil.await(object22, new IPCException("Failed to initialize IPC. Remote process doesn't respond."));
        }
        finally {
            this.c.removeServerListener(c2);
        }
        Object object4 = atomicReference2;
        object = ((AtomicReference)object4).get();
        if (object != null) {
            throw object;
        }
        object4 = (Channel)atomicReference.get();
        for (IPCChannelListener iPCChannelListener : this.getIPCChannelListeners()) {
            iPCChannelListener.onMainChannelAdded((Channel)object4);
        }
        return object4;
    }

    private void a(CountDownLatch object, AtomicReference<IPCException> atomicReference, int n2) {
        a.info("Starting IPC Process...");
        object = new Thread(new d(this, n2, atomicReference, (CountDownLatch)object));
        ((Thread)object).setName("IPC Process Thread");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    public synchronized void initiateShutdown() {
        this.j = true;
    }

    public synchronized void shutdown() {
        if (this.c.isStarted()) {
            this.b();
            this.c.removeServerListener(this.f);
            this.c.stop();
            this.c();
        }
    }

    public synchronized void stop() {
        if (this.g.decrementAndGet() > 0) {
            return;
        }
        if (Environment.isMac() && !Boolean.getBoolean(EXTERNAL_IPC_PROPERTY)) {
            return;
        }
        a.info("Stopping IPC...");
        if (!this.c.isStarted()) {
            a.info("IPC is already stopped.");
            return;
        }
        this.b();
        this.c.stop();
        this.d();
        this.c.removeServerListener(this.f);
        this.c();
        a.info("IPC is stopped.");
    }

    private void b() {
        if (this.i == null || this.i.isClosed()) {
            return;
        }
        a.info("Stopping main channel...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        long l2 = this.i.getChannelId();
        g object2 = new g(this, l2, countDownLatch);
        this.c.addServerListener(object2);
        this.send(new ShutdownMessage());
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to execute shutdown post message."));
        }
        finally {
            this.c.removeServerListener(object2);
        }
        try {
            for (IPCChannelListener iPCChannelListener : this.getIPCChannelListeners()) {
                iPCChannelListener.onMainChannelRemoved(this.i);
            }
            return;
        }
        finally {
            this.i = null;
        }
    }

    private void c() {
        a.info("Waiting process exit...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        h h2 = new h(this, countDownLatch);
        this.d.addChromiumProcessListener(h2);
        try {
            if (this.d.isStarted()) {
                LatchUtil.await(countDownLatch, new IPCException("Chromium process hasn't been exited because of timeout."));
            }
            return;
        }
        finally {
            this.d.removeChromiumProcessListener(h2);
        }
    }

    private synchronized void d() {
        while (!this.e.isEmpty()) {
            a.info("Waiting for channels disconnection...");
            for (Channel channel : this.getChannels()) {
                a.info("\tWaiting for channel: " + channel);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addIPCChannelListener(IPCChannelListener listener) {
        if (!this.h.contains(listener)) {
            void var1_1;
            this.h.add((IPCChannelListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeIPCChannelListener(IPCChannelListener listener) {
        void var1_1;
        this.h.remove(var1_1);
    }

    public List<IPCChannelListener> getIPCChannelListeners() {
        return new ArrayList<IPCChannelListener>(this.h);
    }

    public Channel getChannel(long channelId, ChannelType channelType) {
        for (Channel channel : this.getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == channelId;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    public boolean hasChannel(long channelId, ChannelType channelType) {
        for (Channel channel : this.getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == channelId;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void waitChannel(long channelId, ChannelType channelType) {
        void var3_3;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        i i2 = new i(this, channelId, channelType, countDownLatch);
        this.addIPCChannelListener(i2);
        if (this.hasChannel(channelId, (ChannelType)var3_3)) {
            return;
        }
        try {
            void var1_1;
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + (long)var1_1));
            return;
        }
        finally {
            this.removeIPCChannelListener(i2);
        }
    }

    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.e);
    }

    public Channel findRenderChannel(Channel browserChannel) {
        for (Channel channel : this.getChannels()) {
            boolean bl;
            boolean bl2 = channel.getType() == ChannelType.Render;
            boolean bl3 = bl = channel.getBrowserId() == browserChannel.getBrowserId();
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void send(Message message) {
        void var1_1;
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        this.i.send((Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized <T extends Message> T post(T message) {
        void var1_1;
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        return this.i.post(var1_1);
    }

    public ChromiumProcess getProcess() {
        return this.d;
    }

    static /* synthetic */ ChromiumProcess a(IPC iPC) {
        return iPC.d;
    }

    static /* synthetic */ Server b(IPC iPC) {
        return iPC.c;
    }

    final class b
    extends ServerAdapter {
        private /* synthetic */ IPC a;

        private b(IPC iPC) {
            this.a = iPC;
        }

        @Override
        public final void onChannelConnected(Channel channel) {
            if (!this.a.hasChannel(channel.getChannelId(), channel.getType())) {
                this.a.e.add(channel);
                a.info("Channel is connected: " + channel);
                for (IPCChannelListener iPCChannelListener : this.a.getIPCChannelListeners()) {
                    iPCChannelListener.onChannelAdded(channel);
                }
            }
        }

        @Override
        public final void onChannelDisconnected(Channel channel) {
            if (this.a.e.remove(channel)) {
                a.info("Channel is disconnected: " + channel);
                for (IPCChannelListener iPCChannelListener : this.a.getIPCChannelListeners()) {
                    iPCChannelListener.onChannelRemoved(channel);
                }
            }
        }

        /* synthetic */ b(IPC iPC, byte by) {
            this(iPC);
        }
    }

    static final class a {
        private static final IPC a = IPC.create();
    }
}

