/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.ProductInfo;
import com.teamdev.jxbrowser.chromium.internal.EnvironmentException;
import com.teamdev.jxbrowser.chromium.internal.JavaVersion;
import com.teamdev.jxbrowser.chromium.internal.Version;
import java.util.logging.Logger;

public final class Environment {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private static final Version b = new Version(1, 6);
    private static final Version c = new Version(6, 1);
    private static final Version d = new Version(10, 9);

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isJRE6() {
        return JavaVersion.getVersion().startsWith("1.6");
    }

    public static boolean isJRE9() {
        return JavaVersion.getVersion().startsWith("9");
    }

    public static boolean is64Bit() {
        String string = System.getProperty("os.arch");
        return "amd64".equals(string) || "x86_64".equals(string);
    }

    public static boolean is32Bit() {
        String string = System.getProperty("os.arch");
        return "x86".equals(string) || "i386".equals(string);
    }

    public static String getWin32UserAppDataLocalDir() {
        if (!Environment.isWindows()) {
            throw new IllegalStateException("Unsupported operating system.");
        }
        return System.getenv("LOCALAPPDATA");
    }

    public static boolean isJavaFX() {
        return !System.getProperty("javafx.version", "0").equals("0");
    }

    public static void checkEnvironment() {
        if (!Environment.a()) {
            throw new EnvironmentException("Unsupported operating system. Supported OS: Windows 7 and higher, Windows Server 2008 R2 and higher, macOS 10.9 and higher, Linux. Current OS: " + System.getProperty("os.name") + ", version: " + System.getProperty("os.version"));
        }
        if (!Environment.b()) {
            throw new EnvironmentException("Unsupported JRE version. Supported versions: JRE 1.6 and higher Current version: " + JavaVersion.getVersion());
        }
        if (Environment.isLinux() && Environment.is32Bit()) {
            throw new EnvironmentException("Unsupported operating system. Linux 32-bit isn't supported. Only Linux 64-bit is supported.");
        }
    }

    public static boolean isSupported() {
        return Environment.a() && Environment.b();
    }

    public static void traceEnvironment() {
        a.info("OS name: " + System.getProperty("os.name"));
        a.info("OS version: " + System.getProperty("os.version"));
        a.info("JRE version: " + JavaVersion.getVersion() + (Environment.is64Bit() ? " 64-bit" : " 32-bit"));
        a.info("JxBrowser version: " + ProductInfo.getVersion());
        a.info("User temp dir: " + Environment.getUserTempDir());
        if (Environment.isWindows()) {
            a.info("User AppData dir: " + Environment.getWin32UserAppDataLocalDir());
        }
    }

    public static String getUserTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    private static boolean a() {
        if (Environment.isWindows()) {
            return Version.parse(System.getProperty("os.version")).compareTo(c) >= 0;
        }
        if (Environment.isMac()) {
            return Version.parse(System.getProperty("os.version")).compareTo(d) >= 0;
        }
        return Environment.isLinux();
    }

    private static boolean b() {
        return Version.parse(JavaVersion.getSimpleVersion()).compareTo(b) >= 0;
    }
}

