/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.WebRTCIPHandlingPolicy;
import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BrowserPreferences {
    public static final String USER_AGENT_PROPERTY = "jxbrowser.chromium.user-agent";
    public static final String CHROMIUM_DIR_PROPERTY = "jxbrowser.chromium.dir";
    public static final String TEMP_DIR_PROPERTY = "jxbrowser.tmp.dir";
    private static final Set<String> d = new LinkedHashSet<String>();
    private static final Map<String, String> e = new HashMap<String, String>();
    private String f;
    private boolean g;
    private boolean h;
    private boolean i;
    private boolean j;
    private boolean k;
    private boolean l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    private boolean q;
    private boolean r;
    private boolean s;
    private boolean t;
    private boolean u;
    private WebRTCIPHandlingPolicy v;
    boolean a;
    boolean b;
    boolean c;

    public static String getChromiumDir() {
        return System.getProperty(CHROMIUM_DIR_PROPERTY, BrowserPreferences.getDefaultChromiumDir());
    }

    public static void setChromiumDir(String chromiumDir) {
        String string;
        if (chromiumDir == null) {
            throw new IllegalArgumentException("The chromiumDir parameter cannot be null.");
        }
        if (chromiumDir.isEmpty()) {
            throw new IllegalArgumentException("The chromiumDir string cannot be empty.");
        }
        System.setProperty(CHROMIUM_DIR_PROPERTY, string);
    }

    public static String getUserAgent() {
        return System.getProperty(USER_AGENT_PROPERTY);
    }

    public static void setUserAgent(String userAgent) {
        String string;
        if (userAgent == null) {
            throw new IllegalArgumentException("The userAgent parameter cannot be null.");
        }
        if (userAgent.isEmpty()) {
            throw new IllegalArgumentException("The userAgent string cannot be empty.");
        }
        System.setProperty(USER_AGENT_PROPERTY, string);
    }

    public static String getDefaultChromiumDir() {
        String string;
        Object object = ChromiumBuild.version();
        String string2 = Environment.getUserTempDir();
        if (Environment.isWindows() && (string = Environment.getWin32UserAppDataLocalDir()) != null && !string.isEmpty()) {
            string2 = string + "\\JxBrowser";
        }
        string = "browsercore-" + (String)object;
        object = new File(string2, string);
        return ((File)object).getAbsolutePath();
    }

    public static String getDefaultDataDir() {
        File file = new File(BrowserPreferences.getDefaultChromiumDir(), "data");
        return file.getAbsolutePath();
    }

    public static String getDefaultCacheDir() {
        return BrowserPreferences.getDefaultDataDir() + File.separator + "Cache";
    }

    public static String getDefaultMemoryDir() {
        return BrowserPreferences.getDefaultDataDir() + File.separator + "Memory";
    }

    public static String getTempDir() {
        return System.getProperty(TEMP_DIR_PROPERTY, BrowserPreferences.getDefaultDataDir() + File.separator + "Temp");
    }

    public static String getDefaultAcceptLanguage() {
        Object object = Locale.getDefault();
        String string = ((Locale)object).getCountry();
        object = ((Locale)object).getLanguage();
        object = new StringBuilder(((String)object).toLowerCase());
        if (!string.isEmpty()) {
            ((StringBuilder)object).append('-');
            ((StringBuilder)object).append(string.toLowerCase());
        }
        return ((StringBuilder)object).toString();
    }

    public static List<String> getChromiumSwitches() {
        return new ArrayList<String>(d);
    }

    public static void setChromiumSwitches(String ... switches) {
        String[] stringArray;
        if (switches == null) {
            throw new IllegalArgumentException("The switches parameter cannot be null.");
        }
        d.clear();
        Collections.addAll(d, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void setChromiumVariable(String name, String value) {
        void var1_1;
        String string;
        if (name == null) {
            throw new IllegalArgumentException("The name parameter cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value parameter cannot be null.");
        }
        e.put(string, (String)var1_1);
    }

    public static Map<String, String> getChromiumVariables() {
        return new HashMap<String, String>(e);
    }

    public String getDefaultEncoding() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setDefaultEncoding(String defaultEncoding) {
        void var1_1;
        this.f = var1_1;
    }

    public boolean isJavaScriptEnabled() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public void setJavaScriptEnabled(boolean javascriptEnabled) {
        void var1_1;
        this.g = var1_1;
    }

    public boolean isJavaScriptCanOpenWindowsAutomatically() {
        return this.h;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setJavaScriptCanOpenWindowsAutomatically(boolean javaScriptCanOpenWindowsAutomatically) {
        void var1_1;
        this.h = var1_1;
    }

    public boolean isLoadsImagesAutomatically() {
        return this.j;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadsImagesAutomatically(boolean loadsImagesAutomatically) {
        void var1_1;
        this.j = var1_1;
    }

    public boolean isImagesEnabled() {
        return this.k;
    }

    /*
     * WARNING - void declaration
     */
    public void setImagesEnabled(boolean imagesEnabled) {
        void var1_1;
        this.k = var1_1;
    }

    public boolean isPluginsEnabled() {
        return this.l;
    }

    /*
     * WARNING - void declaration
     */
    public void setPluginsEnabled(boolean pluginsEnabled) {
        void var1_1;
        this.l = var1_1;
    }

    public boolean isAllowScriptsToCloseWindows() {
        return this.m;
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowScriptsToCloseWindows(boolean allowScriptsToCloseWindows) {
        void var1_1;
        this.m = var1_1;
    }

    public boolean isJavaScriptCanAccessClipboard() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public void setJavaScriptCanAccessClipboard(boolean javaScriptCanAccessClipboard) {
        void var1_1;
        this.i = var1_1;
    }

    public boolean isLocalStorageEnabled() {
        return this.n;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalStorageEnabled(boolean localStorageEnabled) {
        void var1_1;
        this.n = var1_1;
    }

    public boolean isDatabasesEnabled() {
        return this.o;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatabasesEnabled(boolean databasesEnabled) {
        void var1_1;
        this.o = var1_1;
    }

    @Deprecated
    public boolean isWebAudioEnabled() {
        return this.p;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setWebAudioEnabled(boolean webAudioEnabled) {
        void var1_1;
        this.p = var1_1;
    }

    public boolean isApplicationCacheEnabled() {
        return this.q;
    }

    /*
     * WARNING - void declaration
     */
    public void setApplicationCacheEnabled(boolean applicationCacheEnabled) {
        void var1_1;
        this.q = var1_1;
    }

    @Deprecated
    public boolean isAllowDisplayingInsecureContent() {
        return this.r;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAllowDisplayingInsecureContent(boolean allowDisplayingInsecureContent) {
        void var1_1;
        this.r = var1_1;
    }

    public boolean isAllowRunningInsecureContent() {
        return this.s;
    }

    /*
     * WARNING - void declaration
     */
    public void setAllowRunningInsecureContent(boolean allowRunningInsecureContent) {
        void var1_1;
        this.s = var1_1;
    }

    @Deprecated
    public boolean isUnifiedTextcheckerEnabled() {
        return this.t;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setUnifiedTextcheckerEnabled(boolean unifiedTextcheckerEnabled) {
        void var1_1;
        this.t = var1_1;
    }

    public boolean isTransparentBackground() {
        return this.u;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparentBackground(boolean transparentBackground) {
        void var1_1;
        this.u = var1_1;
    }

    public WebRTCIPHandlingPolicy getWebRTCIPHandlingPolicy() {
        return this.v;
    }

    /*
     * WARNING - void declaration
     */
    public void setWebRTCIPHandlingPolicy(WebRTCIPHandlingPolicy webRTCIPHandlingPolicy) {
        void var1_1;
        this.v = var1_1;
    }
}

