/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.AutofillService;
import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.NetworkService;
import com.teamdev.jxbrowser.chromium.NotificationService;
import com.teamdev.jxbrowser.chromium.ProtocolService;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.ProxySerivce;
import com.teamdev.jxbrowser.chromium.SpellCheckerService;
import com.teamdev.jxbrowser.chromium.StorageType;
import com.teamdev.jxbrowser.chromium.ZoomService;
import com.teamdev.jxbrowser.chromium.internal.BrowserContextIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetAcceptLanguageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetAcceptLanguageMessage;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public final class BrowserContext {
    private static final BrowserContext b = new BrowserContext(new BrowserContextParams(BrowserPreferences.getDefaultDataDir()), -1);
    private final int c;
    private final IPC d;
    private final String e;
    private final String f;
    private final String g;
    private final StorageType h;
    private final ProxyConfig i;
    private final ZoomService j;
    private final NotificationService k;
    private final NetworkService l;
    private final SpellCheckerService m;
    private final ProtocolService n;
    private final ProxySerivce o;
    private final AutofillService p;
    private final AtomicInteger q;
    String a;

    /*
     * WARNING - void declaration
     */
    public BrowserContext(BrowserContextParams params) {
        this((BrowserContextParams)var1_1, BrowserContextIDGenerator.generate());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BrowserContext(BrowserContextParams params, int id) {
        this((BrowserContextParams)var1_1, (int)var2_2, IPC.getDefault());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BrowserContext(BrowserContextParams params, int id, IPC ipc) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.c = id;
        this.d = ipc;
        this.q = new AtomicInteger();
        this.e = params.getDataDir();
        this.f = params.getCacheDir();
        this.g = params.getMemoryDir();
        this.a = params.getAcceptLanguage();
        this.h = params.getStorageType();
        this.i = var1_1.getProxyConfig();
        this.j = new ZoomService(id, ipc);
        this.l = new NetworkService(id, ipc);
        this.m = new SpellCheckerService(id, ipc);
        this.k = new NotificationService(id, ipc);
        this.n = new ProtocolService(id, ipc);
        this.o = new ProxySerivce(id, ipc, this.i);
        this.p = new AutofillService((int)var2_2, (IPC)var3_3);
    }

    public static BrowserContext defaultContext() {
        return b;
    }

    public final String getDataDir() {
        boolean bl;
        boolean bl2 = bl = this.getStorageType() == StorageType.DISK;
        if (!new File(this.e).exists() && bl) {
            FileUtil.createDirs(this.e);
        }
        return this.e;
    }

    public final String getCacheDir() {
        boolean bl;
        boolean bl2 = bl = this.getStorageType() == StorageType.DISK;
        if (!new File(this.f).exists() && bl) {
            FileUtil.createDirs(this.f);
        }
        return this.f;
    }

    public final String getMemoryDir() {
        if (!new File(this.g).exists() && !Environment.isWindows()) {
            FileUtil.createDirs(this.g);
        }
        return this.g;
    }

    public final String getAcceptLanguage() {
        Object object = this.d.getMainChannel();
        if (object != null) {
            GetAcceptLanguageMessage getAcceptLanguageMessage = new GetAcceptLanguageMessage();
            new GetAcceptLanguageMessage().browserContextId = this.c;
            object = object.post(getAcceptLanguageMessage);
            return ((GetAcceptLanguageMessage)object).lang;
        }
        return this.a;
    }

    public final void setAcceptLanguage(String acceptLanguage) {
        BrowserContext browserContext;
        if (acceptLanguage == null || acceptLanguage.trim().isEmpty()) {
            throw new IllegalArgumentException("The Accept-Language value cannot be null or empty");
        }
        this.a = browserContext;
        browserContext = this;
        Channel channel = browserContext.d.getMainChannel();
        if (channel != null && browserContext.a != null) {
            SetAcceptLanguageMessage setAcceptLanguageMessage = new SetAcceptLanguageMessage();
            new SetAcceptLanguageMessage().browserContextId = browserContext.c;
            setAcceptLanguageMessage.lang = browserContext.a;
            channel.send(setAcceptLanguageMessage);
        }
    }

    public final StorageType getStorageType() {
        return this.h;
    }

    public final ProxyConfig getProxyConfig() {
        return this.i;
    }

    public final NetworkService getNetworkService() {
        return this.l;
    }

    public final ZoomService getZoomService() {
        return this.j;
    }

    public final SpellCheckerService getSpellCheckerService() {
        return this.m;
    }

    public final AutofillService getAutofillService() {
        return this.p;
    }

    public final ProtocolService getProtocolService() {
        return this.n;
    }

    public final ProxySerivce getProxyService() {
        return this.o;
    }

    public final int getIdentifier() {
        return this.c;
    }

    public final NotificationService getNotificationService() {
        return this.k;
    }

    final IPC a() {
        return this.d;
    }

    final boolean b() {
        return this.q.intValue() > 0;
    }

    final void c() {
        this.q.incrementAndGet();
    }

    final void d() {
        this.j.a();
        this.l.a();
        this.m.a();
        this.n.a();
        this.o.a();
        this.p.a();
        this.k.a();
    }

    final void e() {
        this.q.decrementAndGet();
    }

    final void f() {
        this.j.b();
        this.l.b();
        this.m.b();
        this.n.b();
        this.o.b();
        this.p.b();
        this.k.b();
    }
}

