# [Office UI Fabric Core](https://developer.microsoft.com/en-us/fabric)

##### The front-end framework for building experiences for Office and Office 365.

Fabric is a responsive, mobile-first collection of styles and tools designed to make it quick and simple for you to create web experiences using the Office Design Language.

**Latest version:** 11.0.0

## Contents

* [What's included](#whats-included)
* [Get started](#get-started)
* [Learn more](#learn-more)
* [Contribute to Fabric](#contribute-to-fabric)
* [Licenses](#licenses)
* [Changelog](#changelog)

## What's included

This repository contains the core styles used across all aspects of Fabric including icons, type, fonts, colors, the grid, etc. This is a separate project from [Office UI Fabric React](https://github.com/OfficeDev/office-ui-fabric-react), which contains the React components.

## Get started

For a quick start, reference the latest release of Fabric from a CDN or add a copy to your project. See [get started](https://developer.microsoft.com/en-us/fabric#/get-started) on the [Office UI Fabric site](https://developer.microsoft.com/en-us/fabric) for full details on the most common ways to get started with the core along with a description of what's included.

If you'd like to get Fabric through a package manager such as Bower, npm, or NuGet, check out the [package manager docs](https://github.com/OfficeDev/office-ui-fabric-core/blob/master/ghdocs/PACKAGES.md).

Want to customize Fabric for your project? See [building Fabric](https://github.com/OfficeDev/Office-UI-Fabric/blob/master/ghdocs/BUILDING.md) to learn about the build process.

## Learn more

New to Fabric? Start with [the project's site](https://developer.microsoft.com/en-us/fabric) to understand its purpose and explore the full set of styles and components from [Office UI Fabric React](https://github.com/OfficeDev/office-ui-fabric-react).

When you're ready to create an Office Add-in with Fabric, take a look at the [Use Office UI Fabric with Office Add-ins on MSDN](https://msdn.microsoft.com/EN-US/library/office/mt450443.aspx) article.

## Contribute to Fabric

Bug reports, feature requests, and questions are posted on the [issue tracker](https://github.com/OfficeDev/Office-UI-Fabric-core/issues). For details on our contribution process and how we label issues, see our [contributing](https://github.com/OfficeDev/Office-UI-Fabric/blob/master/ghdocs/CONTRIBUTING.md) page.

## Licenses

All files in this GitHub repository are subject to the [MIT license](https://github.com/OfficeDev/office-ui-fabric-core/blob/master/LICENSE). This project also references fonts and icons from a CDN, which are subject to a separate [asset license](https://static2.sharepointonline.com/files/fabric/assets/license.txt).

## Changelog

We use [GitHub Releases](https://github.com/blog/1547-release-your-software) to manage our releases, including the changelog between every release. View a complete list of additions, fixes, and changes since 1.0 on the [releases](https://github.com/OfficeDev/Office-UI-Fabric/releases) page.

---

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/). For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.
