// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/loft-sh/api/v4/pkg/apis/storage/v1"
	scheme "github.com/loft-sh/api/v4/pkg/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// VirtualClusterInstancesGetter has a method to return a VirtualClusterInstanceInterface.
// A group's client should implement this interface.
type VirtualClusterInstancesGetter interface {
	VirtualClusterInstances(namespace string) VirtualClusterInstanceInterface
}

// VirtualClusterInstanceInterface has methods to work with VirtualClusterInstance resources.
type VirtualClusterInstanceInterface interface {
	Create(ctx context.Context, virtualClusterInstance *v1.VirtualClusterInstance, opts metav1.CreateOptions) (*v1.VirtualClusterInstance, error)
	Update(ctx context.Context, virtualClusterInstance *v1.VirtualClusterInstance, opts metav1.UpdateOptions) (*v1.VirtualClusterInstance, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.VirtualClusterInstance, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.VirtualClusterInstanceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VirtualClusterInstance, err error)
	VirtualClusterInstanceExpansion
}

// virtualClusterInstances implements VirtualClusterInstanceInterface
type virtualClusterInstances struct {
	client rest.Interface
	ns     string
}

// newVirtualClusterInstances returns a VirtualClusterInstances
func newVirtualClusterInstances(c *StorageV1Client, namespace string) *virtualClusterInstances {
	return &virtualClusterInstances{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the virtualClusterInstance, and returns the corresponding virtualClusterInstance object, and an error if there is any.
func (c *virtualClusterInstances) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.VirtualClusterInstance, err error) {
	result = &v1.VirtualClusterInstance{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VirtualClusterInstances that match those selectors.
func (c *virtualClusterInstances) List(ctx context.Context, opts metav1.ListOptions) (result *v1.VirtualClusterInstanceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.VirtualClusterInstanceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested virtualClusterInstances.
func (c *virtualClusterInstances) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a virtualClusterInstance and creates it.  Returns the server's representation of the virtualClusterInstance, and an error, if there is any.
func (c *virtualClusterInstances) Create(ctx context.Context, virtualClusterInstance *v1.VirtualClusterInstance, opts metav1.CreateOptions) (result *v1.VirtualClusterInstance, err error) {
	result = &v1.VirtualClusterInstance{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualClusterInstance).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a virtualClusterInstance and updates it. Returns the server's representation of the virtualClusterInstance, and an error, if there is any.
func (c *virtualClusterInstances) Update(ctx context.Context, virtualClusterInstance *v1.VirtualClusterInstance, opts metav1.UpdateOptions) (result *v1.VirtualClusterInstance, err error) {
	result = &v1.VirtualClusterInstance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		Name(virtualClusterInstance.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualClusterInstance).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the virtualClusterInstance and deletes it. Returns an error if one occurs.
func (c *virtualClusterInstances) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *virtualClusterInstances) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched virtualClusterInstance.
func (c *virtualClusterInstances) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VirtualClusterInstance, err error) {
	result = &v1.VirtualClusterInstance{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("virtualclusterinstances").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
